/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist;

import ai.h2o.javassist.CtClass;
import ai.h2o.javassist.bytecode.Descriptor;
import java.util.HashMap;

public class ClassMap
extends HashMap<String, String> {
    private static final long serialVersionUID = 1L;
    private ClassMap parent;

    public ClassMap() {
        this.parent = null;
    }

    ClassMap(ClassMap map) {
        this.parent = map;
    }

    @Override
    public void put(CtClass oldname, CtClass newname) {
        this.put(oldname.getName(), newname.getName());
    }

    @Override
    public String put(String oldname, String newname) {
        if (oldname == newname) {
            return oldname;
        }
        String string = ClassMap.toJvmName(oldname);
        String string2 = this.get(string);
        if (string2 == null || !string2.equals(string)) {
            return super.put(string, ClassMap.toJvmName(newname));
        }
        return string2;
    }

    public void putIfNone(String oldname, String newname) {
        if (oldname == newname) {
            return;
        }
        String string = ClassMap.toJvmName(oldname);
        String string2 = this.get(string);
        if (string2 == null) {
            super.put(string, ClassMap.toJvmName(newname));
        }
    }

    protected final String put0(String oldname, String newname) {
        return super.put(oldname, newname);
    }

    @Override
    public String get(Object jvmClassName) {
        String string = (String)super.get(jvmClassName);
        if (string == null && this.parent != null) {
            return this.parent.get(jvmClassName);
        }
        return string;
    }

    public void fix(CtClass clazz) {
        this.fix(clazz.getName());
    }

    public void fix(String name) {
        String string;
        String string2 = string = ClassMap.toJvmName(name);
        super.put(string2, string2);
    }

    public static String toJvmName(String classname) {
        return Descriptor.toJvmName(classname);
    }

    public static String toJavaName(String classname) {
        return Descriptor.toJavaName(classname);
    }
}

