/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist;

import ai.h2o.javassist.CannotCompileException;
import ai.h2o.javassist.ClassMap;
import ai.h2o.javassist.ClassPool;
import ai.h2o.javassist.CodeConverter;
import ai.h2o.javassist.CtBehavior;
import ai.h2o.javassist.CtClass;
import ai.h2o.javassist.CtConstructor;
import ai.h2o.javassist.CtField;
import ai.h2o.javassist.CtMember;
import ai.h2o.javassist.CtMethod;
import ai.h2o.javassist.FieldInitLink;
import ai.h2o.javassist.Modifier;
import ai.h2o.javassist.NotFoundException;
import ai.h2o.javassist.bytecode.AccessFlag;
import ai.h2o.javassist.bytecode.AnnotationsAttribute;
import ai.h2o.javassist.bytecode.AttributeInfo;
import ai.h2o.javassist.bytecode.BadBytecode;
import ai.h2o.javassist.bytecode.Bytecode;
import ai.h2o.javassist.bytecode.ClassFile;
import ai.h2o.javassist.bytecode.CodeAttribute;
import ai.h2o.javassist.bytecode.CodeIterator;
import ai.h2o.javassist.bytecode.ConstPool;
import ai.h2o.javassist.bytecode.ConstantAttribute;
import ai.h2o.javassist.bytecode.Descriptor;
import ai.h2o.javassist.bytecode.EnclosingMethodAttribute;
import ai.h2o.javassist.bytecode.FieldInfo;
import ai.h2o.javassist.bytecode.InnerClassesAttribute;
import ai.h2o.javassist.bytecode.MethodInfo;
import ai.h2o.javassist.bytecode.ParameterAnnotationsAttribute;
import ai.h2o.javassist.bytecode.SignatureAttribute;
import ai.h2o.javassist.bytecode.annotation.Annotation;
import ai.h2o.javassist.bytecode.annotation.AnnotationImpl;
import ai.h2o.javassist.compiler.AccessorMaker;
import ai.h2o.javassist.compiler.CompileError;
import ai.h2o.javassist.compiler.Javac;
import ai.h2o.javassist.expr.ExprEditor;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

class CtClassType
extends CtClass {
    ClassPool classPool;
    boolean wasChanged;
    private boolean wasFrozen;
    boolean wasPruned;
    boolean gcConstPool;
    ClassFile classfile;
    byte[] rawClassfile;
    private Reference<CtMember.Cache> memberCache;
    private AccessorMaker accessors;
    private FieldInitLink fieldInitializers;
    private Map<CtMethod, String> hiddenMethods;
    private int uniqueNumberSeed;
    private boolean doPruning = ClassPool.doPruning;
    private int getCount;
    private static final int GET_THRESHOLD = 2;

    CtClassType(String name, ClassPool cp) {
        super(name);
        this.classPool = cp;
        CtClassType ctClassType = this;
        CtClassType ctClassType2 = this;
        ctClassType2.gcConstPool = false;
        ctClassType2.wasPruned = false;
        ctClassType.wasFrozen = false;
        ctClassType.wasChanged = false;
        this.classfile = null;
        this.rawClassfile = null;
        this.memberCache = null;
        this.accessors = null;
        this.fieldInitializers = null;
        this.hiddenMethods = null;
        this.uniqueNumberSeed = 0;
        this.getCount = 0;
    }

    CtClassType(InputStream ins, ClassPool cp) throws IOException {
        this((String)null, cp);
        this.classfile = new ClassFile(new DataInputStream(ins));
        this.qualifiedName = this.classfile.getName();
    }

    CtClassType(ClassFile cf, ClassPool cp) {
        this((String)null, cp);
        this.classfile = cf;
        this.qualifiedName = this.classfile.getName();
    }

    @Override
    protected void extendToString(StringBuffer buffer) {
        Object object;
        if (this.wasChanged) {
            buffer.append("changed ");
        }
        if (this.wasFrozen) {
            buffer.append("frozen ");
        }
        if (this.wasPruned) {
            buffer.append("pruned ");
        }
        buffer.append(Modifier.toString(this.getModifiers()));
        buffer.append(" class ");
        buffer.append(this.getName());
        try {
            String string;
            object = this.getSuperclass();
            if (object != null && !(string = ((CtClass)object).getName()).equals("java.lang.Object")) {
                buffer.append(" extends " + ((CtClass)object).getName());
            }
        }
        catch (NotFoundException notFoundException) {
            buffer.append(" extends ??");
        }
        try {
            object = this.getInterfaces();
            if (((CtClass[])object).length > 0) {
                buffer.append(" implements ");
            }
            for (int i2 = 0; i2 < ((CtClass[])object).length; ++i2) {
                buffer.append(((CtClass)object[i2]).getName());
                buffer.append(", ");
            }
        }
        catch (NotFoundException notFoundException) {
            buffer.append(" extends ??");
        }
        object = this.getMembers();
        this.exToString(buffer, " fields=", ((CtMember.Cache)object).fieldHead(), ((CtMember.Cache)object).lastField());
        this.exToString(buffer, " constructors=", ((CtMember.Cache)object).consHead(), ((CtMember.Cache)object).lastCons());
        this.exToString(buffer, " methods=", ((CtMember.Cache)object).methodHead(), ((CtMember.Cache)object).lastMethod());
    }

    private void exToString(StringBuffer buffer, String msg, CtMember head, CtMember tail) {
        buffer.append(msg);
        while (head != tail) {
            head = head.next();
            buffer.append(head);
            buffer.append(", ");
        }
    }

    @Override
    public AccessorMaker getAccessorMaker() {
        if (this.accessors == null) {
            this.accessors = new AccessorMaker(this);
        }
        return this.accessors;
    }

    @Override
    public ClassFile getClassFile2() {
        return this.getClassFile3(true);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ClassFile getClassFile3(boolean doCompress) {
        ClassFile classFile;
        ClassFile classFile2 = this.classfile;
        if (classFile2 != null) {
            return classFile2;
        }
        if (doCompress) {
            this.classPool.compress();
        }
        if (this.rawClassfile != null) {
            try {
                ClassFile classFile3 = new ClassFile(new DataInputStream(new ByteArrayInputStream(this.rawClassfile)));
                this.rawClassfile = null;
                this.getCount = 2;
                return this.setClassFile(classFile3);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException.toString(), iOException);
            }
        }
        InputStream inputStream = null;
        try {
            inputStream = this.classPool.openClassfile(this.getName());
            if (inputStream == null) {
                throw new NotFoundException(this.getName());
            }
            ClassFile classFile4 = new ClassFile(new DataInputStream(inputStream = new BufferedInputStream(inputStream)));
            if (!classFile4.getName().equals(this.qualifiedName)) {
                throw new RuntimeException("cannot find " + this.qualifiedName + ": " + classFile4.getName() + " found in " + this.qualifiedName.replace('.', '/') + ".class");
            }
            classFile = this.setClassFile(classFile4);
        }
        catch (NotFoundException notFoundException) {
            try {
                throw new RuntimeException(notFoundException.toString(), notFoundException);
                catch (IOException iOException) {
                    throw new RuntimeException(iOException.toString(), iOException);
                }
            }
            catch (Throwable throwable) {
                if (inputStream == null) throw throwable;
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            inputStream.close();
            return classFile;
        }
        catch (IOException iOException) {}
        return classFile;
    }

    @Override
    final void incGetCounter() {
        ++this.getCount;
    }

    @Override
    void compress() {
        if (this.getCount < 2) {
            if (!this.isModified() && ClassPool.releaseUnmodifiedClassFile) {
                this.removeClassFile();
            } else if (this.isFrozen() && !this.wasPruned) {
                this.saveClassFile();
            }
        }
        this.getCount = 0;
    }

    private synchronized void saveClassFile() {
        if (this.classfile == null || this.hasMemberCache() != null) {
            return;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            this.classfile.write(dataOutputStream);
            byteArrayOutputStream.close();
            this.rawClassfile = byteArrayOutputStream.toByteArray();
            this.classfile = null;
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    private synchronized void removeClassFile() {
        if (this.classfile != null && !this.isModified() && this.hasMemberCache() == null) {
            this.classfile = null;
        }
    }

    private synchronized ClassFile setClassFile(ClassFile cf) {
        if (this.classfile == null) {
            this.classfile = cf;
        }
        return this.classfile;
    }

    @Override
    public ClassPool getClassPool() {
        return this.classPool;
    }

    void setClassPool(ClassPool cp) {
        this.classPool = cp;
    }

    @Override
    public URL getURL() throws NotFoundException {
        URL uRL = this.classPool.find(this.getName());
        if (uRL == null) {
            throw new NotFoundException(this.getName());
        }
        return uRL;
    }

    @Override
    public boolean isModified() {
        return this.wasChanged;
    }

    @Override
    public boolean isFrozen() {
        return this.wasFrozen;
    }

    @Override
    public void freeze() {
        this.wasFrozen = true;
    }

    @Override
    void checkModify() throws RuntimeException {
        if (this.isFrozen()) {
            String string = this.getName() + " class is frozen";
            if (this.wasPruned) {
                string = string + " and pruned";
            }
            throw new RuntimeException(string);
        }
        this.wasChanged = true;
    }

    @Override
    public void defrost() {
        this.checkPruned("defrost");
        this.wasFrozen = false;
    }

    @Override
    public boolean subtypeOf(CtClass clazz) throws NotFoundException {
        int n2;
        String string = clazz.getName();
        if (this == clazz || this.getName().equals(string)) {
            return true;
        }
        ClassFile classFile = this.getClassFile2();
        String string2 = classFile.getSuperclass();
        if (string2 != null && string2.equals(string)) {
            return true;
        }
        String[] stringArray = classFile.getInterfaces();
        int n3 = stringArray.length;
        for (n2 = 0; n2 < n3; ++n2) {
            if (!stringArray[n2].equals(string)) continue;
            return true;
        }
        if (string2 != null && this.classPool.get(string2).subtypeOf(clazz)) {
            return true;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            if (!this.classPool.get(stringArray[n2]).subtypeOf(clazz)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setName(String name) throws RuntimeException {
        String string = this.getName();
        if (name.equals(string)) {
            return;
        }
        this.classPool.checkNotFrozen(name);
        ClassFile classFile = this.getClassFile2();
        super.setName(name);
        classFile.setName(name);
        this.nameReplaced();
        this.classPool.classNameChanged(string, this);
    }

    @Override
    public String getGenericSignature() {
        SignatureAttribute signatureAttribute = (SignatureAttribute)this.getClassFile2().getAttribute("Signature");
        if (signatureAttribute == null) {
            return null;
        }
        return signatureAttribute.getSignature();
    }

    @Override
    public void setGenericSignature(String sig) {
        ClassFile classFile = this.getClassFile();
        SignatureAttribute signatureAttribute = new SignatureAttribute(classFile.getConstPool(), sig);
        classFile.addAttribute(signatureAttribute);
    }

    @Override
    public void replaceClassName(ClassMap classnames) throws RuntimeException {
        String string = this.getName();
        String string2 = classnames.get(Descriptor.toJvmName(string));
        if (string2 != null) {
            string2 = Descriptor.toJavaName(string2);
            this.classPool.checkNotFrozen(string2);
        }
        super.replaceClassName(classnames);
        ClassFile classFile = this.getClassFile2();
        classFile.renameClass(classnames);
        this.nameReplaced();
        if (string2 != null) {
            super.setName(string2);
            this.classPool.classNameChanged(string, this);
        }
    }

    @Override
    public void replaceClassName(String oldname, String newname) throws RuntimeException {
        String string = this.getName();
        if (string.equals(oldname)) {
            this.setName(newname);
            return;
        }
        super.replaceClassName(oldname, newname);
        this.getClassFile2().renameClass(oldname, newname);
        this.nameReplaced();
    }

    @Override
    public boolean isInterface() {
        return Modifier.isInterface(this.getModifiers());
    }

    @Override
    public boolean isAnnotation() {
        return Modifier.isAnnotation(this.getModifiers());
    }

    @Override
    public boolean isEnum() {
        return Modifier.isEnum(this.getModifiers());
    }

    @Override
    public int getModifiers() {
        ClassFile classFile = this.getClassFile2();
        int n2 = classFile.getAccessFlags();
        n2 = AccessFlag.clear(n2, 32);
        int n3 = classFile.getInnerAccessFlags();
        if (n3 != -1) {
            if ((n3 & 8) != 0) {
                n2 |= 8;
            }
            if ((n3 & 1) != 0) {
                n2 |= 1;
            } else {
                n2 &= 0xFFFFFFFE;
                if ((n3 & 4) != 0) {
                    n2 |= 4;
                } else if ((n3 & 2) != 0) {
                    n2 |= 2;
                }
            }
        }
        return AccessFlag.toModifier(n2);
    }

    @Override
    public CtClass[] getNestedClasses() throws NotFoundException {
        ClassFile classFile = this.getClassFile2();
        InnerClassesAttribute innerClassesAttribute = (InnerClassesAttribute)classFile.getAttribute("InnerClasses");
        if (innerClassesAttribute == null) {
            return new CtClass[0];
        }
        String string = classFile.getName() + "$";
        int n2 = innerClassesAttribute.tableLength();
        ArrayList<CtClass> arrayList = new ArrayList<CtClass>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            String string2 = innerClassesAttribute.innerClass(i2);
            if (string2 == null || !string2.startsWith(string) || string2.lastIndexOf(36) >= string.length()) continue;
            arrayList.add(this.classPool.get(string2));
        }
        ArrayList<CtClass> arrayList2 = arrayList;
        return arrayList2.toArray(new CtClass[arrayList2.size()]);
    }

    @Override
    public void setModifiers(int mod) {
        this.checkModify();
        CtClassType.updateInnerEntry(mod, this.getName(), this, true);
        ClassFile classFile = this.getClassFile2();
        classFile.setAccessFlags(AccessFlag.of(mod & 0xFFFFFFF7));
    }

    private static void updateInnerEntry(int newMod, String name, CtClass clazz, boolean outer) {
        ClassFile classFile = clazz.getClassFile2();
        InnerClassesAttribute innerClassesAttribute = (InnerClassesAttribute)classFile.getAttribute("InnerClasses");
        if (innerClassesAttribute != null) {
            int n2;
            int n3 = newMod & 0xFFFFFFF7;
            int n4 = innerClassesAttribute.find(name);
            if (!(n4 < 0 || (n2 = innerClassesAttribute.accessFlags(n4) & 8) == 0 && Modifier.isStatic(newMod))) {
                clazz.checkModify();
                innerClassesAttribute.setAccessFlags(n4, AccessFlag.of(n3) | n2);
                String string = innerClassesAttribute.outerClass(n4);
                if (string != null && outer) {
                    try {
                        CtClass ctClass = clazz.getClassPool().get(string);
                        CtClassType.updateInnerEntry(n3, name, ctClass, false);
                        return;
                    }
                    catch (NotFoundException notFoundException) {
                        throw new RuntimeException("cannot find the declaring class: " + string);
                    }
                }
                return;
            }
        }
        if (Modifier.isStatic(newMod)) {
            throw new RuntimeException("cannot change " + Descriptor.toJavaName(name) + " into a static class");
        }
    }

    @Override
    public boolean hasAnnotation(String annotationName) {
        ClassFile classFile = this.getClassFile2();
        AnnotationsAttribute annotationsAttribute = (AnnotationsAttribute)classFile.getAttribute("RuntimeInvisibleAnnotations");
        AnnotationsAttribute annotationsAttribute2 = (AnnotationsAttribute)classFile.getAttribute("RuntimeVisibleAnnotations");
        return CtClassType.hasAnnotationType(annotationName, this.getClassPool(), annotationsAttribute, annotationsAttribute2);
    }

    @Deprecated
    static boolean hasAnnotationType(Class<?> clz, ClassPool cp, AnnotationsAttribute a1, AnnotationsAttribute a2) {
        return CtClassType.hasAnnotationType(clz.getName(), cp, a1, a2);
    }

    static boolean hasAnnotationType(String annotationTypeName, ClassPool cp, AnnotationsAttribute a1, AnnotationsAttribute a2) {
        int n2;
        Annotation[] annotationArray = a1 == null ? null : a1.getAnnotations();
        Annotation[] annotationArray2 = a2 == null ? null : a2.getAnnotations();
        if (annotationArray != null) {
            for (n2 = 0; n2 < annotationArray.length; ++n2) {
                if (!annotationArray[n2].getTypeName().equals(annotationTypeName)) continue;
                return true;
            }
        }
        if (annotationArray2 != null) {
            for (n2 = 0; n2 < annotationArray2.length; ++n2) {
                if (!annotationArray2[n2].getTypeName().equals(annotationTypeName)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Object getAnnotation(Class<?> clz) throws ClassNotFoundException {
        ClassFile classFile = this.getClassFile2();
        AnnotationsAttribute annotationsAttribute = (AnnotationsAttribute)classFile.getAttribute("RuntimeInvisibleAnnotations");
        AnnotationsAttribute annotationsAttribute2 = (AnnotationsAttribute)classFile.getAttribute("RuntimeVisibleAnnotations");
        return CtClassType.getAnnotationType(clz, this.getClassPool(), annotationsAttribute, annotationsAttribute2);
    }

    static Object getAnnotationType(Class<?> clz, ClassPool cp, AnnotationsAttribute a1, AnnotationsAttribute a2) throws ClassNotFoundException {
        int n2;
        Annotation[] annotationArray = a1 == null ? null : a1.getAnnotations();
        Annotation[] annotationArray2 = a2 == null ? null : a2.getAnnotations();
        String string = clz.getName();
        if (annotationArray != null) {
            for (n2 = 0; n2 < annotationArray.length; ++n2) {
                if (!annotationArray[n2].getTypeName().equals(string)) continue;
                return CtClassType.toAnnoType(annotationArray[n2], cp);
            }
        }
        if (annotationArray2 != null) {
            for (n2 = 0; n2 < annotationArray2.length; ++n2) {
                if (!annotationArray2[n2].getTypeName().equals(string)) continue;
                return CtClassType.toAnnoType(annotationArray2[n2], cp);
            }
        }
        return null;
    }

    @Override
    public Object[] getAnnotations() throws ClassNotFoundException {
        return this.getAnnotations(false);
    }

    @Override
    public Object[] getAvailableAnnotations() {
        try {
            return this.getAnnotations(true);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("Unexpected exception ", classNotFoundException);
        }
    }

    private Object[] getAnnotations(boolean ignoreNotFound) throws ClassNotFoundException {
        ClassFile classFile = this.getClassFile2();
        AnnotationsAttribute annotationsAttribute = (AnnotationsAttribute)classFile.getAttribute("RuntimeInvisibleAnnotations");
        AnnotationsAttribute annotationsAttribute2 = (AnnotationsAttribute)classFile.getAttribute("RuntimeVisibleAnnotations");
        return CtClassType.toAnnotationType(ignoreNotFound, this.getClassPool(), annotationsAttribute, annotationsAttribute2);
    }

    static Object[] toAnnotationType(boolean ignoreNotFound, ClassPool cp, AnnotationsAttribute a1, AnnotationsAttribute a2) throws ClassNotFoundException {
        int n2;
        int n3;
        Annotation[] annotationArray;
        int n4;
        Annotation[] annotationArray2;
        if (a1 == null) {
            annotationArray2 = null;
            n4 = 0;
        } else {
            annotationArray2 = a1.getAnnotations();
            n4 = annotationArray2.length;
        }
        if (a2 == null) {
            annotationArray = null;
            n3 = 0;
        } else {
            annotationArray = a2.getAnnotations();
            n3 = annotationArray.length;
        }
        if (!ignoreNotFound) {
            int n5;
            Object[] objectArray = new Object[n4 + n3];
            for (n5 = 0; n5 < n4; ++n5) {
                objectArray[n5] = CtClassType.toAnnoType(annotationArray2[n5], cp);
            }
            for (n5 = 0; n5 < n3; ++n5) {
                objectArray[n5 + n4] = CtClassType.toAnnoType(annotationArray[n5], cp);
            }
            return objectArray;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (n2 = 0; n2 < n4; ++n2) {
            try {
                arrayList.add(CtClassType.toAnnoType(annotationArray2[n2], cp));
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        for (n2 = 0; n2 < n3; ++n2) {
            try {
                arrayList.add(CtClassType.toAnnoType(annotationArray[n2], cp));
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        return arrayList.toArray();
    }

    static Object[][] toAnnotationType(boolean ignoreNotFound, ClassPool cp, ParameterAnnotationsAttribute a1, ParameterAnnotationsAttribute a2, MethodInfo minfo) throws ClassNotFoundException {
        int numParameters = a1 != null ? a1.numParameters() : (a2 != null ? a2.numParameters() : Descriptor.numOfParameters(minfo.getDescriptor()));
        Object[][] objectArray = new Object[numParameters][];
        for (int i2 = 0; i2 < numParameters; ++i2) {
            int n2;
            int n3;
            Annotation[] annotationArray;
            int n4;
            Annotation[] annotationArray2;
            if (a1 == null) {
                annotationArray2 = null;
                n4 = 0;
            } else {
                annotationArray2 = a1.getAnnotations()[i2];
                n4 = annotationArray2.length;
            }
            if (a2 == null) {
                annotationArray = null;
                n3 = 0;
            } else {
                annotationArray = a2.getAnnotations()[i2];
                n3 = annotationArray.length;
            }
            if (!ignoreNotFound) {
                int n5;
                objectArray[i2] = new Object[n4 + n3];
                for (n5 = 0; n5 < n4; ++n5) {
                    objectArray[i2][n5] = CtClassType.toAnnoType(annotationArray2[n5], cp);
                }
                for (n5 = 0; n5 < n3; ++n5) {
                    objectArray[i2][n5 + n4] = CtClassType.toAnnoType(annotationArray[n5], cp);
                }
                continue;
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (n2 = 0; n2 < n4; ++n2) {
                try {
                    arrayList.add(CtClassType.toAnnoType(annotationArray2[n2], cp));
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
            for (n2 = 0; n2 < n3; ++n2) {
                try {
                    arrayList.add(CtClassType.toAnnoType(annotationArray[n2], cp));
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
            objectArray[i2] = arrayList.toArray();
        }
        return objectArray;
    }

    private static Object toAnnoType(Annotation anno, ClassPool cp) throws ClassNotFoundException {
        try {
            ClassLoader classLoader = cp.getClassLoader();
            return anno.toAnnotationType(classLoader, cp);
        }
        catch (ClassNotFoundException classNotFoundException) {
            ClassLoader classLoader = cp.getClass().getClassLoader();
            try {
                return anno.toAnnotationType(classLoader, cp);
            }
            catch (ClassNotFoundException classNotFoundException2) {
                try {
                    Class<?> clazz = cp.get(anno.getTypeName()).toClass();
                    return AnnotationImpl.make(clazz.getClassLoader(), clazz, cp, anno);
                }
                catch (Throwable throwable) {
                    throw new ClassNotFoundException(anno.getTypeName());
                }
            }
        }
    }

    @Override
    public boolean subclassOf(CtClass superclass) {
        if (superclass == null) {
            return false;
        }
        String string = superclass.getName();
        try {
            for (CtClass ctClass = this; ctClass != null; ctClass = ((CtClass)ctClass).getSuperclass()) {
                if (!ctClass.getName().equals(string)) continue;
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    @Override
    public CtClass getSuperclass() throws NotFoundException {
        String string = this.getClassFile2().getSuperclass();
        if (string == null) {
            return null;
        }
        return this.classPool.get(string);
    }

    @Override
    public void setSuperclass(CtClass clazz) throws CannotCompileException {
        this.checkModify();
        if (this.isInterface()) {
            this.addInterface(clazz);
            return;
        }
        this.getClassFile2().setSuperclass(clazz.getName());
    }

    @Override
    public CtClass[] getInterfaces() throws NotFoundException {
        String[] stringArray = this.getClassFile2().getInterfaces();
        int n2 = stringArray.length;
        CtClass[] ctClassArray = new CtClass[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            ctClassArray[i2] = this.classPool.get(stringArray[i2]);
        }
        return ctClassArray;
    }

    @Override
    public void setInterfaces(CtClass[] list) {
        String[] stringArray;
        this.checkModify();
        if (list == null) {
            stringArray = new String[]{};
        } else {
            int n2 = list.length;
            stringArray = new String[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                stringArray[i2] = list[i2].getName();
            }
        }
        this.getClassFile2().setInterfaces(stringArray);
    }

    @Override
    public void addInterface(CtClass anInterface) {
        this.checkModify();
        if (anInterface != null) {
            this.getClassFile2().addInterface(anInterface.getName());
        }
    }

    @Override
    public CtClass getDeclaringClass() throws NotFoundException {
        ClassFile classFile = this.getClassFile2();
        InnerClassesAttribute innerClassesAttribute = (InnerClassesAttribute)classFile.getAttribute("InnerClasses");
        if (innerClassesAttribute == null) {
            return null;
        }
        String string = this.getName();
        int n2 = innerClassesAttribute.tableLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!string.equals(innerClassesAttribute.innerClass(i2))) continue;
            String string2 = innerClassesAttribute.outerClass(i2);
            if (string2 != null) {
                return this.classPool.get(string2);
            }
            EnclosingMethodAttribute enclosingMethodAttribute = (EnclosingMethodAttribute)classFile.getAttribute("EnclosingMethod");
            if (enclosingMethodAttribute == null) continue;
            return this.classPool.get(enclosingMethodAttribute.className());
        }
        return null;
    }

    @Override
    public CtBehavior getEnclosingBehavior() throws NotFoundException {
        ClassFile classFile = this.getClassFile2();
        EnclosingMethodAttribute enclosingMethodAttribute = (EnclosingMethodAttribute)classFile.getAttribute("EnclosingMethod");
        if (enclosingMethodAttribute == null) {
            return null;
        }
        CtClass ctClass = this.classPool.get(enclosingMethodAttribute.className());
        String string = enclosingMethodAttribute.methodName();
        if ("<init>".equals(string)) {
            return ctClass.getConstructor(enclosingMethodAttribute.methodDescriptor());
        }
        if ("<clinit>".equals(string)) {
            return ctClass.getClassInitializer();
        }
        return ctClass.getMethod(string, enclosingMethodAttribute.methodDescriptor());
    }

    @Override
    public CtClass makeNestedClass(String name, boolean isStatic) {
        if (!isStatic) {
            throw new RuntimeException("sorry, only nested static class is supported");
        }
        this.checkModify();
        CtClass ctClass = this.classPool.makeNestedClass(this.getName() + "$" + name);
        ClassFile classFile = this.getClassFile2();
        ClassFile classFile2 = ctClass.getClassFile2();
        InnerClassesAttribute innerClassesAttribute = (InnerClassesAttribute)classFile.getAttribute("InnerClasses");
        if (innerClassesAttribute == null) {
            innerClassesAttribute = new InnerClassesAttribute(classFile.getConstPool());
            classFile.addAttribute(innerClassesAttribute);
        }
        innerClassesAttribute.append(ctClass.getName(), this.getName(), name, classFile2.getAccessFlags() & 0xFFFFFFDF | 8);
        classFile2.addAttribute(innerClassesAttribute.copy(classFile2.getConstPool(), null));
        return ctClass;
    }

    private void nameReplaced() {
        CtMember.Cache cache = this.hasMemberCache();
        if (cache != null) {
            CtMember ctMember = cache.lastMethod();
            for (CtMember ctMember2 = cache.methodHead(); ctMember2 != ctMember; ctMember2 = ctMember2.next()) {
                ctMember2.nameReplaced();
            }
        }
    }

    protected CtMember.Cache hasMemberCache() {
        if (this.memberCache != null) {
            return this.memberCache.get();
        }
        return null;
    }

    protected synchronized CtMember.Cache getMembers() {
        CtMember.Cache cache;
        if (this.memberCache == null || (cache = this.memberCache.get()) == null) {
            cache = new CtMember.Cache(this);
            this.makeFieldCache(cache);
            this.makeBehaviorCache(cache);
            this.memberCache = new WeakReference<CtMember.Cache>(cache);
        }
        return cache;
    }

    private void makeFieldCache(CtMember.Cache cache) {
        List<FieldInfo> list = this.getClassFile3(false).getFields();
        for (FieldInfo fieldInfo : list) {
            cache.addField(new CtField(fieldInfo, (CtClass)this));
        }
    }

    private void makeBehaviorCache(CtMember.Cache cache) {
        List<MethodInfo> list = this.getClassFile3(false).getMethods();
        for (MethodInfo methodInfo : list) {
            if (methodInfo.isMethod()) {
                cache.addMethod(new CtMethod(methodInfo, this));
                continue;
            }
            cache.addConstructor(new CtConstructor(methodInfo, (CtClass)this));
        }
    }

    @Override
    public CtField[] getFields() {
        ArrayList<CtMember> arrayList = new ArrayList<CtMember>();
        CtClassType.getFields(arrayList, this);
        ArrayList<CtMember> arrayList2 = arrayList;
        return arrayList2.toArray(new CtField[arrayList2.size()]);
    }

    private static void getFields(List<CtMember> alist, CtClass cc) {
        Object object;
        Object object2;
        if (cc == null) {
            return;
        }
        try {
            CtClassType.getFields(alist, cc.getSuperclass());
        }
        catch (NotFoundException notFoundException) {}
        try {
            object = object2 = cc.getInterfaces();
            int n2 = ((CtClass[])object2).length;
            for (int i2 = 0; i2 < n2; ++i2) {
                CtClass ctClass = object[i2];
                CtClassType.getFields(alist, ctClass);
            }
        }
        catch (NotFoundException notFoundException) {}
        object2 = ((CtClassType)cc).getMembers();
        object = ((CtMember.Cache)object2).fieldHead();
        CtMember ctMember = ((CtMember.Cache)object2).lastField();
        while (object != ctMember) {
            if (Modifier.isPrivate(((CtMember)(object = ((CtMember)object).next())).getModifiers())) continue;
            alist.add((CtMember)object);
        }
    }

    @Override
    public CtField getField(String name, String desc) throws NotFoundException {
        CtField ctField = this.getField2(name, desc);
        return this.checkGetField(ctField, name, desc);
    }

    private CtField checkGetField(CtField f2, String name, String desc) throws NotFoundException {
        if (f2 == null) {
            String string = "field: " + name;
            if (desc != null) {
                string = string + " type " + desc;
            }
            throw new NotFoundException(string + " in " + this.getName());
        }
        return f2;
    }

    @Override
    CtField getField2(String name, String desc) {
        CtField ctField = this.getDeclaredField2(name, desc);
        if (ctField != null) {
            return ctField;
        }
        try {
            CtClass[] ctClassArray = this.getInterfaces();
            Object object = ctClassArray;
            int n2 = ctClassArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                CtClass ctClass = object[i2];
                CtField ctField2 = ctClass.getField2(name, desc);
                if (ctField2 == null) continue;
                return ctField2;
            }
            object = this.getSuperclass();
            if (object != null) {
                return ((CtClass)object).getField2(name, desc);
            }
        }
        catch (NotFoundException notFoundException) {}
        return null;
    }

    @Override
    public CtField[] getDeclaredFields() {
        CtMember ctMember;
        CtMember.Cache cache = this.getMembers();
        CtMember ctMember2 = cache.lastField();
        int n2 = CtMember.Cache.count(ctMember, ctMember2);
        CtField[] ctFieldArray = new CtField[n2];
        int n3 = 0;
        for (ctMember = cache.fieldHead(); ctMember != ctMember2; ctMember = ctMember.next()) {
            ctFieldArray[n3++] = (CtField)ctMember;
        }
        return ctFieldArray;
    }

    @Override
    public CtField getDeclaredField(String name) throws NotFoundException {
        return this.getDeclaredField(name, null);
    }

    @Override
    public CtField getDeclaredField(String name, String desc) throws NotFoundException {
        CtField ctField = this.getDeclaredField2(name, desc);
        return this.checkGetField(ctField, name, desc);
    }

    private CtField getDeclaredField2(String name, String desc) {
        CtMember.Cache cache = this.getMembers();
        CtMember ctMember = cache.fieldHead();
        CtMember ctMember2 = cache.lastField();
        while (ctMember != ctMember2) {
            if (!(ctMember = ctMember.next()).getName().equals(name) || desc != null && !desc.equals(ctMember.getSignature())) continue;
            return (CtField)ctMember;
        }
        return null;
    }

    @Override
    public CtBehavior[] getDeclaredBehaviors() {
        CtMember ctMember;
        CtMember.Cache cache = this.getMembers();
        CtMember ctMember2 = cache.lastCons();
        int n2 = CtMember.Cache.count(ctMember, ctMember2);
        CtMember ctMember3 = cache.methodHead();
        CtMember ctMember4 = cache.lastMethod();
        int n3 = CtMember.Cache.count(ctMember3, ctMember4);
        CtBehavior[] ctBehaviorArray = new CtBehavior[n2 + n3];
        int n4 = 0;
        for (ctMember = cache.consHead(); ctMember != ctMember2; ctMember = ctMember.next()) {
            ctBehaviorArray[n4++] = (CtBehavior)ctMember;
        }
        while (ctMember3 != ctMember4) {
            ctMember3 = ctMember3.next();
            ctBehaviorArray[n4++] = (CtBehavior)ctMember3;
        }
        return ctBehaviorArray;
    }

    @Override
    public CtConstructor[] getConstructors() {
        CtMember.Cache cache = this.getMembers();
        CtMember ctMember = cache.consHead();
        CtMember ctMember2 = cache.lastCons();
        int n2 = 0;
        CtMember ctMember3 = ctMember;
        while (ctMember3 != ctMember2) {
            if (!CtClassType.isPubCons((CtConstructor)(ctMember3 = ctMember3.next()))) continue;
            ++n2;
        }
        CtConstructor[] ctConstructorArray = new CtConstructor[n2];
        int n3 = 0;
        ctMember3 = ctMember;
        while (ctMember3 != ctMember2) {
            CtConstructor ctConstructor = (CtConstructor)(ctMember3 = ctMember3.next());
            if (!CtClassType.isPubCons(ctConstructor)) continue;
            ctConstructorArray[n3++] = ctConstructor;
        }
        return ctConstructorArray;
    }

    private static boolean isPubCons(CtConstructor cons) {
        return !Modifier.isPrivate(cons.getModifiers()) && cons.isConstructor();
    }

    @Override
    public CtConstructor getConstructor(String desc) throws NotFoundException {
        CtMember.Cache cache = this.getMembers();
        CtMember ctMember = cache.consHead();
        CtMember ctMember2 = cache.lastCons();
        while (ctMember != ctMember2) {
            CtConstructor ctConstructor = (CtConstructor)(ctMember = ctMember.next());
            if (!ctConstructor.getMethodInfo2().getDescriptor().equals(desc) || !ctConstructor.isConstructor()) continue;
            return ctConstructor;
        }
        return super.getConstructor(desc);
    }

    @Override
    public CtConstructor[] getDeclaredConstructors() {
        Object object;
        CtMember.Cache cache = this.getMembers();
        CtMember ctMember = cache.consHead();
        CtMember ctMember2 = cache.lastCons();
        int n2 = 0;
        CtMember ctMember3 = ctMember;
        while (ctMember3 != ctMember2) {
            object = (CtConstructor)(ctMember3 = ctMember3.next());
            if (!object.isConstructor()) continue;
            ++n2;
        }
        object = new CtConstructor[n2];
        int n3 = 0;
        ctMember3 = ctMember;
        while (ctMember3 != ctMember2) {
            CtConstructor ctConstructor = (CtConstructor)(ctMember3 = ctMember3.next());
            if (!ctConstructor.isConstructor()) continue;
            object[n3++] = ctConstructor;
        }
        return object;
    }

    @Override
    public CtConstructor getClassInitializer() {
        CtMember.Cache cache = this.getMembers();
        CtMember ctMember = cache.consHead();
        CtMember ctMember2 = cache.lastCons();
        while (ctMember != ctMember2) {
            CtConstructor ctConstructor = (CtConstructor)(ctMember = ctMember.next());
            if (!ctConstructor.isClassInitializer()) continue;
            return ctConstructor;
        }
        return null;
    }

    @Override
    public CtMethod[] getMethods() {
        HashMap<String, CtMember> hashMap = new HashMap<String, CtMember>();
        CtClassType.getMethods0(hashMap, this);
        return hashMap.values().toArray(new CtMethod[hashMap.size()]);
    }

    private static void getMethods0(Map<String, CtMember> h2, CtClass cc) {
        Object object;
        Object object2;
        try {
            object = object2 = cc.getInterfaces();
            int n2 = ((CtClass[])object2).length;
            for (int i2 = 0; i2 < n2; ++i2) {
                CtClass ctClass = object[i2];
                CtClassType.getMethods0(h2, ctClass);
            }
        }
        catch (NotFoundException notFoundException) {}
        try {
            object2 = cc.getSuperclass();
            if (object2 != null) {
                CtClassType.getMethods0(h2, (CtClass)object2);
            }
        }
        catch (NotFoundException notFoundException) {}
        if (cc instanceof CtClassType) {
            object2 = ((CtClassType)cc).getMembers();
            object = ((CtMember.Cache)object2).methodHead();
            CtMember ctMember = ((CtMember.Cache)object2).lastMethod();
            while (object != ctMember) {
                if (Modifier.isPrivate(((CtMember)(object = ((CtMember)object).next())).getModifiers())) continue;
                h2.put(((CtMethod)object).getStringRep(), (CtMember)object);
            }
        }
    }

    @Override
    public CtMethod getMethod(String name, String desc) throws NotFoundException {
        CtMethod ctMethod = CtClassType.getMethod0(this, name, desc);
        if (ctMethod != null) {
            return ctMethod;
        }
        throw new NotFoundException(name + "(..) is not found in " + this.getName());
    }

    private static CtMethod getMethod0(CtClass cc, String name, String desc) {
        Object object;
        CtClass[] ctClassArray;
        if (cc instanceof CtClassType) {
            ctClassArray = ((CtClassType)cc).getMembers();
            object = ctClassArray.methodHead();
            CtMember ctMember = ctClassArray.lastMethod();
            while (object != ctMember) {
                if (!((CtMember)(object = ((CtMember)object).next())).getName().equals(name) || !((CtMethod)object).getMethodInfo2().getDescriptor().equals(desc)) continue;
                return (CtMethod)object;
            }
        }
        try {
            ctClassArray = cc.getSuperclass();
            if (ctClassArray != null && (object = CtClassType.getMethod0((CtClass)ctClassArray, name, desc)) != null) {
                return object;
            }
        }
        catch (NotFoundException notFoundException) {}
        try {
            ctClassArray = cc.getInterfaces();
            object = ctClassArray;
            int n2 = ctClassArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Object object2 = object[i2];
                CtMethod ctMethod = CtClassType.getMethod0((CtClass)object2, name, desc);
                if (ctMethod == null) continue;
                return ctMethod;
            }
        }
        catch (NotFoundException notFoundException) {}
        return null;
    }

    @Override
    public CtMethod[] getDeclaredMethods() {
        CtMember.Cache cache = this.getMembers();
        CtMember ctMember = cache.lastMethod();
        ArrayList<CtMember> arrayList = new ArrayList<CtMember>();
        for (CtMember ctMember2 = cache.methodHead(); ctMember2 != ctMember; ctMember2 = ctMember2.next()) {
            arrayList.add(ctMember2);
        }
        ArrayList<CtMember> arrayList2 = arrayList;
        return arrayList2.toArray(new CtMethod[arrayList2.size()]);
    }

    @Override
    public CtMethod[] getDeclaredMethods(String name) throws NotFoundException {
        CtMember.Cache cache = this.getMembers();
        CtMember ctMember = cache.methodHead();
        CtMember ctMember2 = cache.lastMethod();
        ArrayList<CtMember> arrayList = new ArrayList<CtMember>();
        while (ctMember != ctMember2) {
            if (!(ctMember = ctMember.next()).getName().equals(name)) continue;
            arrayList.add(ctMember);
        }
        ArrayList<CtMember> arrayList2 = arrayList;
        return arrayList2.toArray(new CtMethod[arrayList2.size()]);
    }

    @Override
    public CtMethod getDeclaredMethod(String name) throws NotFoundException {
        CtMember.Cache cache = this.getMembers();
        CtMember ctMember = cache.methodHead();
        CtMember ctMember2 = cache.lastMethod();
        while (ctMember != ctMember2) {
            if (!(ctMember = ctMember.next()).getName().equals(name)) continue;
            return (CtMethod)ctMember;
        }
        throw new NotFoundException(name + "(..) is not found in " + this.getName());
    }

    @Override
    public CtMethod getDeclaredMethod(String name, CtClass[] params) throws NotFoundException {
        String string = Descriptor.ofParameters(params);
        CtMember.Cache cache = this.getMembers();
        CtMember ctMember = cache.methodHead();
        CtMember ctMember2 = cache.lastMethod();
        while (ctMember != ctMember2) {
            if (!(ctMember = ctMember.next()).getName().equals(name) || !((CtMethod)ctMember).getMethodInfo2().getDescriptor().startsWith(string)) continue;
            return (CtMethod)ctMember;
        }
        throw new NotFoundException(name + "(..) is not found in " + this.getName());
    }

    @Override
    public void addField(CtField f2, String init) throws CannotCompileException {
        this.addField(f2, CtField.Initializer.byExpr(init));
    }

    @Override
    public void addField(CtField f2, CtField.Initializer init) throws CannotCompileException {
        Object object;
        this.checkModify();
        if (f2.getDeclaringClass() != this) {
            throw new CannotCompileException("cannot add");
        }
        if (init == null) {
            init = f2.getInit();
        }
        if (init != null) {
            init.check(f2.getSignature());
            int n2 = f2.getModifiers();
            if (Modifier.isStatic(n2) && Modifier.isFinal(n2)) {
                try {
                    object = this.getClassFile2().getConstPool();
                    int n3 = init.getConstantValue((ConstPool)object, f2.getType());
                    if (n3 != 0) {
                        f2.getFieldInfo2().addAttribute(new ConstantAttribute((ConstPool)object, n3));
                        init = null;
                    }
                }
                catch (NotFoundException notFoundException) {}
            }
        }
        this.getMembers().addField(f2);
        this.getClassFile2().addField(f2.getFieldInfo2());
        if (init != null) {
            FieldInitLink fieldInitLink = new FieldInitLink(f2, init);
            object = this.fieldInitializers;
            if (object == null) {
                this.fieldInitializers = fieldInitLink;
                return;
            }
            while (((FieldInitLink)object).next != null) {
                object = ((FieldInitLink)object).next;
            }
            ((FieldInitLink)object).next = fieldInitLink;
        }
    }

    @Override
    public void removeField(CtField f2) throws NotFoundException {
        this.checkModify();
        FieldInfo fieldInfo = f2.getFieldInfo2();
        ClassFile classFile = this.getClassFile2();
        if (classFile.getFields().remove(fieldInfo)) {
            this.getMembers().remove(f2);
            this.gcConstPool = true;
            return;
        }
        throw new NotFoundException(f2.toString());
    }

    @Override
    public CtConstructor makeClassInitializer() throws CannotCompileException {
        CtConstructor ctConstructor = this.getClassInitializer();
        if (ctConstructor != null) {
            return ctConstructor;
        }
        this.checkModify();
        ClassFile classFile = this.getClassFile2();
        Bytecode bytecode = new Bytecode(classFile.getConstPool(), 0, 0);
        this.modifyClassConstructor(classFile, bytecode, 0, 0);
        return this.getClassInitializer();
    }

    @Override
    public void addConstructor(CtConstructor c2) throws CannotCompileException {
        this.checkModify();
        if (c2.getDeclaringClass() != this) {
            throw new CannotCompileException("cannot add");
        }
        this.getMembers().addConstructor(c2);
        this.getClassFile2().addMethod(c2.getMethodInfo2());
    }

    @Override
    public void removeConstructor(CtConstructor m2) throws NotFoundException {
        this.checkModify();
        MethodInfo methodInfo = m2.getMethodInfo2();
        ClassFile classFile = this.getClassFile2();
        if (classFile.getMethods().remove(methodInfo)) {
            this.getMembers().remove(m2);
            this.gcConstPool = true;
            return;
        }
        throw new NotFoundException(m2.toString());
    }

    @Override
    public void addMethod(CtMethod m2) throws CannotCompileException {
        this.checkModify();
        if (m2.getDeclaringClass() != this) {
            throw new CannotCompileException("bad declaring class");
        }
        int n2 = m2.getModifiers();
        if ((this.getModifiers() & 0x200) != 0) {
            if (Modifier.isProtected(n2) || Modifier.isPrivate(n2)) {
                throw new CannotCompileException("an interface method must be public: " + m2.toString());
            }
            m2.setModifiers(n2 | 1);
        }
        this.getMembers().addMethod(m2);
        this.getClassFile2().addMethod(m2.getMethodInfo2());
        if ((n2 & 0x400) != 0) {
            CtClassType ctClassType = this;
            ctClassType.setModifiers(ctClassType.getModifiers() | 0x400);
        }
    }

    @Override
    public void removeMethod(CtMethod m2) throws NotFoundException {
        this.checkModify();
        MethodInfo methodInfo = m2.getMethodInfo2();
        ClassFile classFile = this.getClassFile2();
        if (classFile.getMethods().remove(methodInfo)) {
            this.getMembers().remove(m2);
            this.gcConstPool = true;
            return;
        }
        throw new NotFoundException(m2.toString());
    }

    @Override
    public byte[] getAttribute(String name) {
        AttributeInfo attributeInfo = this.getClassFile2().getAttribute(name);
        if (attributeInfo == null) {
            return null;
        }
        return attributeInfo.get();
    }

    @Override
    public void setAttribute(String name, byte[] data) {
        this.checkModify();
        ClassFile classFile = this.getClassFile2();
        classFile.addAttribute(new AttributeInfo(classFile.getConstPool(), name, data));
    }

    @Override
    public void instrument(CodeConverter converter) throws CannotCompileException {
        this.checkModify();
        ClassFile classFile = this.getClassFile2();
        ConstPool constPool = classFile.getConstPool();
        List<MethodInfo> list = classFile.getMethods();
        for (MethodInfo methodInfo : list.toArray(new MethodInfo[list.size()])) {
            converter.doit(this, methodInfo, constPool);
        }
    }

    @Override
    public void instrument(ExprEditor editor) throws CannotCompileException {
        this.checkModify();
        ClassFile classFile = this.getClassFile2();
        List<MethodInfo> list = classFile.getMethods();
        for (MethodInfo methodInfo : list.toArray(new MethodInfo[list.size()])) {
            editor.doit(this, methodInfo);
        }
    }

    @Override
    public void prune() {
        if (this.wasPruned) {
            return;
        }
        CtClassType ctClassType = this;
        ctClassType.wasFrozen = true;
        ctClassType.wasPruned = true;
        this.getClassFile2().prune();
    }

    @Override
    public void rebuildClassFile() {
        this.gcConstPool = true;
    }

    @Override
    public void toBytecode(DataOutputStream out) throws CannotCompileException, IOException {
        try {
            if (this.isModified()) {
                this.checkPruned("toBytecode");
                ClassFile classFile = this.getClassFile2();
                if (this.gcConstPool) {
                    classFile.compact();
                    this.gcConstPool = false;
                }
                this.modifyClassConstructor(classFile);
                this.modifyConstructors(classFile);
                if (debugDump != null) {
                    this.dumpClassFile(classFile);
                }
                classFile.write(out);
                out.flush();
                this.fieldInitializers = null;
                if (this.doPruning) {
                    classFile.prune();
                    this.wasPruned = true;
                }
            } else {
                this.classPool.writeClassfile(this.getName(), out);
            }
            this.getCount = 0;
            this.wasFrozen = true;
            return;
        }
        catch (NotFoundException notFoundException) {
            throw new CannotCompileException(notFoundException);
        }
        catch (IOException iOException) {
            throw new CannotCompileException(iOException);
        }
    }

    private void dumpClassFile(ClassFile cf) throws IOException {
        try (DataOutputStream dataOutputStream = this.makeFileOutput(debugDump);){
            cf.write(dataOutputStream);
            return;
        }
    }

    private void checkPruned(String method) {
        if (this.wasPruned) {
            throw new RuntimeException(method + "(): " + this.getName() + " was pruned.");
        }
    }

    @Override
    public boolean stopPruning(boolean stop) {
        boolean bl = !this.doPruning;
        this.doPruning = !stop;
        return bl;
    }

    private void modifyClassConstructor(ClassFile cf) throws CannotCompileException, NotFoundException {
        if (this.fieldInitializers == null) {
            return;
        }
        Bytecode bytecode = new Bytecode(cf.getConstPool(), 0, 0);
        Javac javac = new Javac(bytecode, this);
        int n2 = 0;
        boolean bl = false;
        FieldInitLink fieldInitLink = this.fieldInitializers;
        while (fieldInitLink != null) {
            CtField ctField = fieldInitLink.field;
            if (Modifier.isStatic(ctField.getModifiers())) {
                bl = true;
                int n3 = fieldInitLink.init.compileIfStatic(ctField.getType(), ctField.getName(), bytecode, javac);
                if (n2 < n3) {
                    n2 = n3;
                }
            }
            fieldInitLink = fieldInitLink.next;
        }
        if (bl) {
            this.modifyClassConstructor(cf, bytecode, n2, 0);
        }
    }

    private void modifyClassConstructor(ClassFile cf, Bytecode code, int stacksize, int localsize) throws CannotCompileException {
        Object object;
        MethodInfo methodInfo = cf.getStaticInitializer();
        if (methodInfo == null) {
            code.add(177);
            code.setMaxStack(stacksize);
            code.setMaxLocals(localsize);
            methodInfo = new MethodInfo(cf.getConstPool(), "<clinit>", "()V");
            methodInfo.setAccessFlags(8);
            methodInfo.setCodeAttribute(code.toCodeAttribute());
            cf.addMethod(methodInfo);
            object = this.hasMemberCache();
            if (object != null) {
                ((CtMember.Cache)object).addConstructor(new CtConstructor(methodInfo, (CtClass)this));
            }
        } else {
            object = methodInfo.getCodeAttribute();
            if (object == null) {
                throw new CannotCompileException("empty <clinit>");
            }
            try {
                int n2;
                CodeIterator codeIterator = ((CodeAttribute)object).iterator();
                int n3 = codeIterator.insertEx(code.get());
                codeIterator.insert(code.getExceptionTable(), n3);
                int n4 = ((CodeAttribute)object).getMaxStack();
                if (n4 < stacksize) {
                    ((CodeAttribute)object).setMaxStack(stacksize);
                }
                if ((n2 = ((CodeAttribute)object).getMaxLocals()) < localsize) {
                    ((CodeAttribute)object).setMaxLocals(localsize);
                }
            }
            catch (BadBytecode badBytecode) {
                throw new CannotCompileException(badBytecode);
            }
        }
        try {
            methodInfo.rebuildStackMapIf6(this.classPool, cf);
            return;
        }
        catch (BadBytecode badBytecode) {
            throw new CannotCompileException(badBytecode);
        }
    }

    private void modifyConstructors(ClassFile cf) throws CannotCompileException, NotFoundException {
        if (this.fieldInitializers == null) {
            return;
        }
        ConstPool constPool = cf.getConstPool();
        List<MethodInfo> list = cf.getMethods();
        for (MethodInfo methodInfo : list) {
            CodeAttribute codeAttribute;
            if (!methodInfo.isConstructor() || (codeAttribute = methodInfo.getCodeAttribute()) == null) continue;
            try {
                Bytecode bytecode = new Bytecode(constPool, 0, codeAttribute.getMaxLocals());
                CtClass[] ctClassArray = Descriptor.getParameterTypes(methodInfo.getDescriptor(), this.classPool);
                int n2 = this.makeFieldInitializer(bytecode, ctClassArray);
                CtClassType.insertAuxInitializer(codeAttribute, bytecode, n2);
                methodInfo.rebuildStackMapIf6(this.classPool, cf);
            }
            catch (BadBytecode badBytecode) {
                throw new CannotCompileException(badBytecode);
            }
        }
    }

    private static void insertAuxInitializer(CodeAttribute codeAttr, Bytecode initializer, int stacksize) throws BadBytecode {
        CodeIterator codeIterator = codeAttr.iterator();
        int n2 = codeIterator.skipSuperConstructor();
        if (n2 < 0 && (n2 = codeIterator.skipThisConstructor()) >= 0) {
            return;
        }
        int n3 = codeIterator.insertEx(initializer.get());
        codeIterator.insert(initializer.getExceptionTable(), n3);
        int n4 = codeAttr.getMaxStack();
        if (n4 < stacksize) {
            codeAttr.setMaxStack(stacksize);
        }
    }

    private int makeFieldInitializer(Bytecode code, CtClass[] parameters) throws CannotCompileException, NotFoundException {
        int n2 = 0;
        Javac javac = new Javac(code, this);
        try {
            javac.recordParams(parameters, false);
        }
        catch (CompileError compileError) {
            throw new CannotCompileException(compileError);
        }
        FieldInitLink fieldInitLink = this.fieldInitializers;
        while (fieldInitLink != null) {
            int n3;
            CtField ctField = fieldInitLink.field;
            if (!Modifier.isStatic(ctField.getModifiers()) && n2 < (n3 = fieldInitLink.init.compile(ctField.getType(), ctField.getName(), code, parameters, javac))) {
                n2 = n3;
            }
            fieldInitLink = fieldInitLink.next;
        }
        return n2;
    }

    Map<CtMethod, String> getHiddenMethods() {
        if (this.hiddenMethods == null) {
            this.hiddenMethods = new Hashtable<CtMethod, String>();
        }
        return this.hiddenMethods;
    }

    int getUniqueNumber() {
        return this.uniqueNumberSeed++;
    }

    @Override
    public String makeUniqueName(String prefix) {
        String string;
        HashMap<Object, CtClassType> hashMap = new HashMap<Object, CtClassType>();
        this.makeMemberList(hashMap);
        Set set = hashMap.keySet();
        String[] stringArray = new String[set.size()];
        set.toArray(stringArray);
        if (CtClassType.notFindInArray(prefix, stringArray)) {
            return prefix;
        }
        int n2 = 100;
        do {
            if (n2 <= 999) continue;
            throw new RuntimeException("too many unique name");
        } while (!CtClassType.notFindInArray(string = prefix + n2++, stringArray));
        return string;
    }

    private static boolean notFindInArray(String prefix, String[] values) {
        int n2 = values.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!values[i2].startsWith(prefix)) continue;
            return false;
        }
        return true;
    }

    private void makeMemberList(Map<Object, CtClassType> table) {
        Object object;
        Object object2;
        int n2 = this.getModifiers();
        if (Modifier.isAbstract(n2) || Modifier.isInterface(n2)) {
            try {
                object2 = this.getInterfaces();
                object = object2;
                int n3 = ((CtClass[])object2).length;
                for (int i2 = 0; i2 < n3; ++i2) {
                    Object object3 = object[i2];
                    if (object3 == null || !(object3 instanceof CtClassType)) continue;
                    ((CtClassType)object3).makeMemberList(table);
                }
            }
            catch (NotFoundException notFoundException) {}
        }
        try {
            object2 = this.getSuperclass();
            if (object2 != null && object2 instanceof CtClassType) {
                ((CtClassType)object2).makeMemberList(table);
            }
        }
        catch (NotFoundException notFoundException) {}
        object2 = this.getClassFile2().getMethods();
        for (MethodInfo methodInfo : object2) {
            table.put(methodInfo.getName(), this);
        }
        object = this.getClassFile2().getFields();
        Iterator<FieldInfo> iterator = object.iterator();
        while (iterator.hasNext()) {
            FieldInfo fieldInfo = iterator.next();
            table.put(fieldInfo.getName(), this);
        }
    }
}

