/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist;

import ai.h2o.javassist.CannotCompileException;
import ai.h2o.javassist.ClassPool;
import ai.h2o.javassist.CtClass;
import ai.h2o.javassist.CtClassType;
import ai.h2o.javassist.CtConstructor;
import ai.h2o.javassist.CtNewConstructor;
import ai.h2o.javassist.Modifier;
import ai.h2o.javassist.NotFoundException;
import ai.h2o.javassist.bytecode.ClassFile;
import java.io.DataOutputStream;
import java.io.IOException;

class CtNewClass
extends CtClassType {
    protected boolean hasConstructor;

    CtNewClass(String name, ClassPool cp, boolean isInterface, CtClass superclass) {
        super(name, cp);
        this.wasChanged = true;
        String string = isInterface || superclass == null ? null : superclass.getName();
        this.classfile = new ClassFile(isInterface, name, string);
        if (isInterface && superclass != null) {
            this.classfile.setInterfaces(new String[]{superclass.getName()});
        }
        CtNewClass ctNewClass = this;
        ctNewClass.setModifiers(Modifier.setPublic(ctNewClass.getModifiers()));
        this.hasConstructor = isInterface;
    }

    @Override
    protected void extendToString(StringBuffer buffer) {
        if (this.hasConstructor) {
            buffer.append("hasConstructor ");
        }
        super.extendToString(buffer);
    }

    @Override
    public void addConstructor(CtConstructor c2) throws CannotCompileException {
        this.hasConstructor = true;
        super.addConstructor(c2);
    }

    @Override
    public void toBytecode(DataOutputStream out) throws CannotCompileException, IOException {
        if (!this.hasConstructor) {
            try {
                this.inheritAllConstructors();
                this.hasConstructor = true;
            }
            catch (NotFoundException notFoundException) {
                throw new CannotCompileException(notFoundException);
            }
        }
        super.toBytecode(out);
    }

    public void inheritAllConstructors() throws CannotCompileException, NotFoundException {
        CtClass ctClass = this.getSuperclass();
        CtConstructor[] ctConstructorArray = ctClass.getDeclaredConstructors();
        int n2 = 0;
        for (int i2 = 0; i2 < ctConstructorArray.length; ++i2) {
            CtConstructor ctConstructor = ctConstructorArray[i2];
            int n3 = ctConstructor.getModifiers();
            if (!this.isInheritable(n3, ctClass)) continue;
            CtConstructor ctConstructor2 = CtNewConstructor.make(ctConstructor.getParameterTypes(), ctConstructor.getExceptionTypes(), this);
            ctConstructor2.setModifiers(n3 & 7);
            this.addConstructor(ctConstructor2);
            ++n2;
        }
        if (n2 <= 0) {
            throw new CannotCompileException("no inheritable constructor in " + ctClass.getName());
        }
    }

    private boolean isInheritable(int mod, CtClass superclazz) {
        if (Modifier.isPrivate(mod)) {
            return false;
        }
        if (Modifier.isPackage(mod)) {
            String string = this.getPackageName();
            String string2 = superclazz.getPackageName();
            if (string == null) {
                return string2 == null;
            }
            return string.equals(string2);
        }
        return true;
    }
}

