/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist;

import ai.h2o.javassist.CannotCompileException;
import ai.h2o.javassist.ClassMap;
import ai.h2o.javassist.CtClass;
import ai.h2o.javassist.CtConstructor;
import ai.h2o.javassist.CtMember;
import ai.h2o.javassist.CtMethod;
import ai.h2o.javassist.CtNewWrappedConstructor;
import ai.h2o.javassist.NotFoundException;
import ai.h2o.javassist.bytecode.Bytecode;
import ai.h2o.javassist.bytecode.ConstPool;
import ai.h2o.javassist.compiler.CompileError;
import ai.h2o.javassist.compiler.Javac;

public class CtNewConstructor {
    public static final int PASS_NONE = 0;
    public static final int PASS_ARRAY = 1;
    public static final int PASS_PARAMS = 2;

    public static CtConstructor make(String src, CtClass declaring) throws CannotCompileException {
        Javac javac = new Javac(declaring);
        try {
            CtMember ctMember = javac.compile(src);
            if (ctMember instanceof CtConstructor) {
                return (CtConstructor)ctMember;
            }
        }
        catch (CompileError compileError) {
            throw new CannotCompileException(compileError);
        }
        throw new CannotCompileException("not a constructor");
    }

    public static CtConstructor make(CtClass[] parameters, CtClass[] exceptions, String body, CtClass declaring) throws CannotCompileException {
        try {
            CtConstructor ctConstructor = new CtConstructor(parameters, declaring);
            ctConstructor.setExceptionTypes(exceptions);
            ctConstructor.setBody(body);
            return ctConstructor;
        }
        catch (NotFoundException notFoundException) {
            throw new CannotCompileException(notFoundException);
        }
    }

    public static CtConstructor copy(CtConstructor c2, CtClass declaring, ClassMap map) throws CannotCompileException {
        return new CtConstructor(c2, declaring, map);
    }

    public static CtConstructor defaultConstructor(CtClass declaring) throws CannotCompileException {
        CtConstructor ctConstructor = new CtConstructor(null, declaring);
        ConstPool constPool = declaring.getClassFile2().getConstPool();
        Bytecode bytecode = new Bytecode(constPool, 1, 1);
        bytecode.addAload(0);
        try {
            bytecode.addInvokespecial(declaring.getSuperclass(), "<init>", "()V");
        }
        catch (NotFoundException notFoundException) {
            throw new CannotCompileException(notFoundException);
        }
        bytecode.add(177);
        ctConstructor.getMethodInfo2().setCodeAttribute(bytecode.toCodeAttribute());
        return ctConstructor;
    }

    public static CtConstructor skeleton(CtClass[] parameters, CtClass[] exceptions, CtClass declaring) throws CannotCompileException {
        return CtNewConstructor.make(parameters, exceptions, 0, null, null, declaring);
    }

    public static CtConstructor make(CtClass[] parameters, CtClass[] exceptions, CtClass declaring) throws CannotCompileException {
        return CtNewConstructor.make(parameters, exceptions, 2, null, null, declaring);
    }

    public static CtConstructor make(CtClass[] parameters, CtClass[] exceptions, int howto, CtMethod body, CtMethod.ConstParameter cparam, CtClass declaring) throws CannotCompileException {
        return CtNewWrappedConstructor.wrapped(parameters, exceptions, howto, body, cparam, declaring);
    }
}

