/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist;

import ai.h2o.javassist.ClassPath;
import ai.h2o.javassist.NotFoundException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

final class JarClassPath
implements ClassPath {
    List<String> jarfileEntries;
    String jarfileURL;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    JarClassPath(String pathname) throws NotFoundException {
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(pathname);
            this.jarfileEntries = new ArrayList<String>();
            for (JarEntry jarEntry : Collections.list(jarFile.entries())) {
                if (!jarEntry.getName().endsWith(".class")) continue;
                this.jarfileEntries.add(jarEntry.getName());
            }
            this.jarfileURL = new File(pathname).getCanonicalFile().toURI().toURL().toString();
        }
        catch (IOException iOException) {
            if (jarFile == null) throw new NotFoundException(pathname);
            try {
                jarFile.close();
                throw new NotFoundException(pathname);
            }
            catch (IOException iOException2) {
                throw new NotFoundException(pathname);
            }
        }
        catch (Throwable throwable) {
            if (jarFile == null) throw throwable;
            try {
                jarFile.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            jarFile.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    @Override
    public final InputStream openClassfile(String classname) throws NotFoundException {
        URL uRL = this.find(classname);
        if (uRL != null) {
            try {
                URLConnection uRLConnection = uRL.openConnection();
                uRLConnection.setUseCaches(false);
                return uRLConnection.getInputStream();
            }
            catch (IOException iOException) {
                throw new NotFoundException("broken jar file?: " + classname);
            }
        }
        return null;
    }

    @Override
    public final URL find(String classname) {
        String string = classname.replace('.', '/') + ".class";
        if (this.jarfileEntries.contains(string)) {
            try {
                return new URL(String.format("jar:%s!/%s", this.jarfileURL, string));
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return null;
    }

    public final String toString() {
        if (this.jarfileURL == null) {
            return "<null>";
        }
        return this.jarfileURL.toString();
    }
}

