/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist;

import ai.h2o.javassist.ClassPath;
import ai.h2o.javassist.NotFoundException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URL;

public class LoaderClassPath
implements ClassPath {
    private Reference<ClassLoader> clref;

    public LoaderClassPath(ClassLoader cl) {
        this.clref = new WeakReference<ClassLoader>(cl);
    }

    public String toString() {
        if (this.clref.get() == null) {
            return "<null>";
        }
        return this.clref.get().toString();
    }

    @Override
    public InputStream openClassfile(String classname) throws NotFoundException {
        String string = classname.replace('.', '/') + ".class";
        ClassLoader classLoader = this.clref.get();
        if (classLoader == null) {
            return null;
        }
        InputStream inputStream = classLoader.getResourceAsStream(string);
        return inputStream;
    }

    @Override
    public URL find(String classname) {
        String string = classname.replace('.', '/') + ".class";
        ClassLoader classLoader = this.clref.get();
        if (classLoader == null) {
            return null;
        }
        URL uRL = classLoader.getResource(string);
        return uRL;
    }
}

