/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.bytecode;

import ai.h2o.javassist.Modifier;
import ai.h2o.javassist.bytecode.AccessFlag;
import ai.h2o.javassist.bytecode.AnnotationsAttribute;
import ai.h2o.javassist.bytecode.AttributeInfo;
import ai.h2o.javassist.bytecode.BadBytecode;
import ai.h2o.javassist.bytecode.ClassFile;
import ai.h2o.javassist.bytecode.CodeAttribute;
import ai.h2o.javassist.bytecode.FieldInfo;
import ai.h2o.javassist.bytecode.MethodInfo;
import ai.h2o.javassist.bytecode.ParameterAnnotationsAttribute;
import ai.h2o.javassist.bytecode.SignatureAttribute;
import ai.h2o.javassist.bytecode.StackMap;
import ai.h2o.javassist.bytecode.StackMapTable;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;

public class ClassFilePrinter {
    public static void print(ClassFile cf) {
        ClassFilePrinter.print(cf, new PrintWriter(System.out, true));
    }

    public static void print(ClassFile cf, PrintWriter out) {
        int n2 = AccessFlag.toModifier(cf.getAccessFlags() & 0xFFFFFFDF);
        out.println("major: " + cf.major + ", minor: " + cf.minor + " modifiers: " + Integer.toHexString(cf.getAccessFlags()));
        out.println(Modifier.toString(n2) + " class " + cf.getName() + " extends " + cf.getSuperclass());
        String[] stringArray = cf.getInterfaces();
        if (stringArray != null && stringArray.length > 0) {
            out.print("    implements ");
            out.print(stringArray[0]);
            for (int i2 = 1; i2 < stringArray.length; ++i2) {
                out.print(", " + stringArray[i2]);
            }
            out.println();
        }
        out.println();
        List<FieldInfo> list = cf.getFields();
        for (FieldInfo object2 : list) {
            int methodInfo = object2.getAccessFlags();
            out.println(Modifier.toString(AccessFlag.toModifier(methodInfo)) + " " + object2.getName() + "\t" + object2.getDescriptor());
            ClassFilePrinter.printAttributes(object2.getAttributes(), out, 'f');
        }
        out.println();
        List<MethodInfo> list2 = cf.getMethods();
        Iterator<MethodInfo> iterator = list2.iterator();
        while (iterator.hasNext()) {
            MethodInfo methodInfo = iterator.next();
            int n3 = methodInfo.getAccessFlags();
            out.println(Modifier.toString(AccessFlag.toModifier(n3)) + " " + methodInfo.getName() + "\t" + methodInfo.getDescriptor());
            ClassFilePrinter.printAttributes(methodInfo.getAttributes(), out, 'm');
            out.println();
        }
        out.println();
        ClassFilePrinter.printAttributes(cf.getAttributes(), out, 'c');
    }

    static void printAttributes(List<AttributeInfo> list, PrintWriter out, char kind) {
        if (list == null) {
            return;
        }
        for (AttributeInfo attributeInfo : list) {
            AttributeInfo attributeInfo2;
            if (attributeInfo instanceof CodeAttribute) {
                attributeInfo2 = (CodeAttribute)attributeInfo;
                out.println("attribute: " + attributeInfo.getName() + ": " + attributeInfo.getClass().getName());
                out.println("max stack " + ((CodeAttribute)attributeInfo2).getMaxStack() + ", max locals " + ((CodeAttribute)attributeInfo2).getMaxLocals() + ", " + ((CodeAttribute)attributeInfo2).getExceptionTable().size() + " catch blocks");
                out.println("<code attribute begin>");
                ClassFilePrinter.printAttributes(((CodeAttribute)attributeInfo2).getAttributes(), out, kind);
                out.println("<code attribute end>");
                continue;
            }
            if (attributeInfo instanceof AnnotationsAttribute) {
                out.println("annnotation: " + attributeInfo.toString());
                continue;
            }
            if (attributeInfo instanceof ParameterAnnotationsAttribute) {
                out.println("parameter annnotations: " + attributeInfo.toString());
                continue;
            }
            if (attributeInfo instanceof StackMapTable) {
                out.println("<stack map table begin>");
                StackMapTable.Printer.print((StackMapTable)attributeInfo, out);
                out.println("<stack map table end>");
                continue;
            }
            if (attributeInfo instanceof StackMap) {
                out.println("<stack map begin>");
                ((StackMap)attributeInfo).print(out);
                out.println("<stack map end>");
                continue;
            }
            if (attributeInfo instanceof SignatureAttribute) {
                attributeInfo2 = (SignatureAttribute)attributeInfo;
                String string = ((SignatureAttribute)attributeInfo2).getSignature();
                out.println("signature: " + string);
                try {
                    String string2 = kind == 'c' ? SignatureAttribute.toClassSignature(string).toString() : (kind == 'm' ? SignatureAttribute.toMethodSignature(string).toString() : SignatureAttribute.toFieldSignature(string).toString());
                    out.println("           " + string2);
                }
                catch (BadBytecode badBytecode) {
                    out.println("           syntax error");
                }
                continue;
            }
            out.println("attribute: " + attributeInfo.getName() + " (" + attributeInfo.get().length + " byte): " + attributeInfo.getClass().getName());
        }
    }
}

