/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.bytecode;

import ai.h2o.javassist.bytecode.ConstInfo;
import ai.h2o.javassist.bytecode.ConstPool;
import ai.h2o.javassist.bytecode.Descriptor;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;

class NameAndTypeInfo
extends ConstInfo {
    static final int tag = 12;
    int memberName;
    int typeDescriptor;

    public NameAndTypeInfo(int name, int type, int index) {
        super(index);
        this.memberName = name;
        this.typeDescriptor = type;
    }

    public NameAndTypeInfo(DataInputStream in, int index) throws IOException {
        super(index);
        this.memberName = in.readUnsignedShort();
        this.typeDescriptor = in.readUnsignedShort();
    }

    public int hashCode() {
        return this.memberName << 16 ^ this.typeDescriptor;
    }

    public boolean equals(Object obj) {
        if (obj instanceof NameAndTypeInfo) {
            NameAndTypeInfo nameAndTypeInfo = (NameAndTypeInfo)obj;
            return nameAndTypeInfo.memberName == this.memberName && nameAndTypeInfo.typeDescriptor == this.typeDescriptor;
        }
        return false;
    }

    @Override
    public int getTag() {
        return 12;
    }

    @Override
    public void renameClass(ConstPool cp, String oldName, String newName, Map<ConstInfo, ConstInfo> cache) {
        String string;
        String string2 = cp.getUtf8Info(this.typeDescriptor);
        if (string2 != (string = Descriptor.rename(string2, oldName, newName))) {
            if (cache == null) {
                this.typeDescriptor = cp.addUtf8Info(string);
                return;
            }
            cache.remove(this);
            this.typeDescriptor = cp.addUtf8Info(string);
            NameAndTypeInfo nameAndTypeInfo = this;
            cache.put(nameAndTypeInfo, nameAndTypeInfo);
        }
    }

    @Override
    public void renameClass(ConstPool cp, Map<String, String> map, Map<ConstInfo, ConstInfo> cache) {
        String string;
        String string2 = cp.getUtf8Info(this.typeDescriptor);
        if (string2 != (string = Descriptor.rename(string2, map))) {
            if (cache == null) {
                this.typeDescriptor = cp.addUtf8Info(string);
                return;
            }
            cache.remove(this);
            this.typeDescriptor = cp.addUtf8Info(string);
            NameAndTypeInfo nameAndTypeInfo = this;
            cache.put(nameAndTypeInfo, nameAndTypeInfo);
        }
    }

    @Override
    public int copy(ConstPool src, ConstPool dest, Map<String, String> map) {
        String string = src.getUtf8Info(this.memberName);
        String string2 = src.getUtf8Info(this.typeDescriptor);
        string2 = Descriptor.rename(string2, map);
        ConstPool constPool = dest;
        return constPool.addNameAndTypeInfo(constPool.addUtf8Info(string), dest.addUtf8Info(string2));
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        out.writeByte(12);
        out.writeShort(this.memberName);
        out.writeShort(this.typeDescriptor);
    }

    @Override
    public void print(PrintWriter out) {
        out.print("NameAndType #");
        out.print(this.memberName);
        out.print(", type #");
        out.println(this.typeDescriptor);
    }
}

