/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.bytecode;

import ai.h2o.javassist.CtClass;
import ai.h2o.javassist.bytecode.AttributeInfo;
import ai.h2o.javassist.bytecode.BadBytecode;
import ai.h2o.javassist.bytecode.ByteArray;
import ai.h2o.javassist.bytecode.ConstPool;
import ai.h2o.javassist.bytecode.Descriptor;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class SignatureAttribute
extends AttributeInfo {
    public static final String tag = "Signature";

    SignatureAttribute(ConstPool cp, int n2, DataInputStream in) throws IOException {
        super(cp, n2, in);
    }

    public SignatureAttribute(ConstPool cp, String signature) {
        super(cp, tag);
        int n2 = cp.addUtf8Info(signature);
        byte[] byArray = new byte[2];
        byte[] byArray2 = byArray;
        byArray[0] = (byte)(n2 >>> 8);
        byArray2[1] = (byte)n2;
        this.set(byArray2);
    }

    public String getSignature() {
        return this.getConstPool().getUtf8Info(ByteArray.readU16bit(this.get(), 0));
    }

    public void setSignature(String sig) {
        int n2 = this.getConstPool().addUtf8Info(sig);
        ByteArray.write16bit(n2, this.info, 0);
    }

    @Override
    public AttributeInfo copy(ConstPool newCp, Map<String, String> classnames) {
        return new SignatureAttribute(newCp, this.getSignature());
    }

    @Override
    void renameClass(String oldname, String newname) {
        String string = SignatureAttribute.renameClass(this.getSignature(), oldname, newname);
        this.setSignature(string);
    }

    @Override
    void renameClass(Map<String, String> classnames) {
        String string = SignatureAttribute.renameClass(this.getSignature(), classnames);
        this.setSignature(string);
    }

    static String renameClass(String desc, String oldname, String newname) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(oldname, newname);
        return SignatureAttribute.renameClass(desc, hashMap);
    }

    static String renameClass(String desc, Map<String, String> map) {
        int n2;
        if (map == null) {
            return desc;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = 0;
        int n4 = 0;
        while ((n2 = desc.indexOf(76, n4)) >= 0) {
            char c2;
            StringBuilder stringBuilder2 = new StringBuilder();
            int n5 = n2;
            try {
                while ((c2 = desc.charAt(++n5)) != ';') {
                    stringBuilder2.append(c2);
                    if (c2 != '<') continue;
                    while ((c2 = desc.charAt(++n5)) != '>') {
                        stringBuilder2.append(c2);
                    }
                    stringBuilder2.append(c2);
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                break;
            }
            n4 = n5 + 1;
            String string = stringBuilder2.toString();
            String string2 = map.get(string);
            if (string2 == null) continue;
            stringBuilder.append(desc.substring(n3, n2));
            stringBuilder.append('L');
            stringBuilder.append(string2);
            stringBuilder.append(c2);
            n3 = n4;
        }
        if (n3 == 0) {
            return desc;
        }
        n2 = desc.length();
        if (n3 < n2) {
            stringBuilder.append(desc.substring(n3, n2));
        }
        return stringBuilder.toString();
    }

    private static boolean isNamePart(int c2) {
        return c2 != 59 && c2 != 60;
    }

    public static ClassSignature toClassSignature(String sig) throws BadBytecode {
        try {
            return SignatureAttribute.parseSig(sig);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw SignatureAttribute.error(sig);
        }
    }

    public static MethodSignature toMethodSignature(String sig) throws BadBytecode {
        try {
            return SignatureAttribute.parseMethodSig(sig);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw SignatureAttribute.error(sig);
        }
    }

    public static ObjectType toFieldSignature(String sig) throws BadBytecode {
        try {
            return SignatureAttribute.parseObjectType(sig, new Cursor(), false);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw SignatureAttribute.error(sig);
        }
    }

    public static Type toTypeSignature(String sig) throws BadBytecode {
        try {
            return SignatureAttribute.parseType(sig, new Cursor());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw SignatureAttribute.error(sig);
        }
    }

    private static ClassSignature parseSig(String sig) throws BadBytecode, IndexOutOfBoundsException {
        Cursor cursor = new Cursor();
        TypeParameter[] typeParameterArray = SignatureAttribute.parseTypeParams(sig, cursor);
        ClassType classType = SignatureAttribute.parseClassType(sig, cursor);
        int n2 = sig.length();
        ArrayList<ClassType> arrayList = new ArrayList<ClassType>();
        while (cursor.position < n2 && sig.charAt(cursor.position) == 'L') {
            arrayList.add(SignatureAttribute.parseClassType(sig, cursor));
        }
        ArrayList<ClassType> arrayList2 = arrayList;
        ClassType[] classTypeArray = arrayList2.toArray(new ClassType[arrayList2.size()]);
        return new ClassSignature(typeParameterArray, classType, classTypeArray);
    }

    private static MethodSignature parseMethodSig(String sig) throws BadBytecode {
        Object object;
        Type type;
        Cursor cursor = new Cursor();
        TypeParameter[] typeParameterArray = SignatureAttribute.parseTypeParams(sig, cursor);
        if (sig.charAt(cursor.position++) != '(') {
            throw SignatureAttribute.error(sig);
        }
        ArrayList<Type> arrayList = new ArrayList<Type>();
        while (sig.charAt(cursor.position) != ')') {
            type = SignatureAttribute.parseType(sig, cursor);
            arrayList.add(type);
        }
        ++cursor.position;
        type = SignatureAttribute.parseType(sig, cursor);
        int n2 = sig.length();
        ArrayList<Type[]> arrayList2 = new ArrayList<Type[]>();
        while (cursor.position < n2 && sig.charAt(cursor.position) == '^') {
            ++cursor.position;
            object = SignatureAttribute.parseObjectType(sig, cursor, false);
            if (object instanceof ArrayType) {
                throw SignatureAttribute.error(sig);
            }
            arrayList2.add((Type[])object);
        }
        ArrayList<Type> arrayList3 = arrayList;
        object = arrayList3.toArray(new Type[arrayList3.size()]);
        ArrayList<Type[]> arrayList4 = arrayList2;
        ObjectType[] objectTypeArray = arrayList4.toArray(new ObjectType[arrayList4.size()]);
        return new MethodSignature(typeParameterArray, (Type[])object, type, objectTypeArray);
    }

    private static TypeParameter[] parseTypeParams(String sig, Cursor cur) throws BadBytecode {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (sig.charAt(cur.position) == '<') {
            ++cur.position;
            while (sig.charAt(cur.position) != '>') {
                Object object;
                int n2 = cur.position;
                int n3 = cur.indexOf(sig, 58);
                ObjectType objectType = SignatureAttribute.parseObjectType(sig, cur, true);
                ArrayList<ObjectType> arrayList2 = new ArrayList<ObjectType>();
                while (sig.charAt(cur.position) == ':') {
                    ++cur.position;
                    object = SignatureAttribute.parseObjectType(sig, cur, false);
                    arrayList2.add((ObjectType)object);
                }
                ArrayList<ObjectType> arrayList3 = arrayList2;
                object = new TypeParameter(sig, n2, n3, objectType, arrayList3.toArray(new ObjectType[arrayList3.size()]));
                arrayList.add(object);
            }
            ++cur.position;
        }
        ArrayList<Object> arrayList4 = arrayList;
        return arrayList4.toArray(new TypeParameter[arrayList4.size()]);
    }

    private static ObjectType parseObjectType(String sig, Cursor c2, boolean dontThrow) throws BadBytecode {
        int n2 = c2.position;
        switch (sig.charAt(n2)) {
            case 'L': {
                return SignatureAttribute.parseClassType2(sig, c2, null);
            }
            case 'T': {
                int n3 = c2.indexOf(sig, 59);
                return new TypeVariable(sig, n2 + 1, n3);
            }
            case '[': {
                return SignatureAttribute.parseArray(sig, c2);
            }
        }
        if (dontThrow) {
            return null;
        }
        throw SignatureAttribute.error(sig);
    }

    private static ClassType parseClassType(String sig, Cursor c2) throws BadBytecode {
        if (sig.charAt(c2.position) == 'L') {
            return SignatureAttribute.parseClassType2(sig, c2, null);
        }
        throw SignatureAttribute.error(sig);
    }

    private static ClassType parseClassType2(String sig, Cursor c2, ClassType parent) throws BadBytecode {
        ClassType classType;
        while (true) {
            TypeArgument[] typeArgumentArray;
            char c3;
            int n2 = ++c2.position;
            while ((c3 = sig.charAt(c2.position++)) != '$' && c3 != '<' && c3 != ';') {
            }
            int n3 = c2.position - 1;
            if (c3 == '<') {
                typeArgumentArray = SignatureAttribute.parseTypeArgs(sig, c2);
                c3 = sig.charAt(c2.position++);
            } else {
                typeArgumentArray = null;
            }
            classType = ClassType.make(sig, n2, n3, typeArgumentArray, parent);
            if (c3 != '$' && c3 != '.') break;
            --c2.position;
            parent = classType;
        }
        return classType;
    }

    private static TypeArgument[] parseTypeArgs(String sig, Cursor c2) throws BadBytecode {
        char c3;
        ArrayList<TypeArgument> arrayList = new ArrayList<TypeArgument>();
        while ((c3 = sig.charAt(c2.position++)) != '>') {
            TypeArgument typeArgument;
            if (c3 == '*') {
                typeArgument = new TypeArgument(null, '*');
            } else {
                if (c3 != '+' && c3 != '-') {
                    c3 = ' ';
                    --c2.position;
                }
                typeArgument = new TypeArgument(SignatureAttribute.parseObjectType(sig, c2, false), c3);
            }
            arrayList.add(typeArgument);
        }
        ArrayList<TypeArgument> arrayList2 = arrayList;
        return arrayList2.toArray(new TypeArgument[arrayList2.size()]);
    }

    private static ObjectType parseArray(String sig, Cursor c2) throws BadBytecode {
        int n2 = 1;
        while (sig.charAt(++c2.position) == '[') {
            ++n2;
        }
        return new ArrayType(n2, SignatureAttribute.parseType(sig, c2));
    }

    private static Type parseType(String sig, Cursor c2) throws BadBytecode {
        Type type = SignatureAttribute.parseObjectType(sig, c2, true);
        if (type == null) {
            type = new BaseType(sig.charAt(c2.position++));
        }
        return type;
    }

    private static BadBytecode error(String sig) {
        return new BadBytecode("bad signature: " + sig);
    }

    public static class TypeVariable
    extends ObjectType {
        String name;

        TypeVariable(String sig, int begin, int end) {
            this.name = sig.substring(begin, end);
        }

        public TypeVariable(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        @Override
        void encode(StringBuffer sb) {
            sb.append('T').append(this.name).append(';');
        }
    }

    public static class ArrayType
    extends ObjectType {
        int dim;
        Type componentType;

        public ArrayType(int d2, Type comp) {
            this.dim = d2;
            this.componentType = comp;
        }

        public int getDimension() {
            return this.dim;
        }

        public Type getComponentType() {
            return this.componentType;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(this.componentType.toString());
            for (int i2 = 0; i2 < this.dim; ++i2) {
                stringBuffer.append("[]");
            }
            return stringBuffer.toString();
        }

        @Override
        void encode(StringBuffer sb) {
            for (int i2 = 0; i2 < this.dim; ++i2) {
                sb.append('[');
            }
            this.componentType.encode(sb);
        }
    }

    public static class NestedClassType
    extends ClassType {
        ClassType parent;

        NestedClassType(String s2, int b2, int e2, TypeArgument[] targs, ClassType p2) {
            super(s2, b2, e2, targs);
            this.parent = p2;
        }

        public NestedClassType(ClassType parent, String className, TypeArgument[] args) {
            super(className, args);
            this.parent = parent;
        }

        @Override
        public ClassType getDeclaringClass() {
            return this.parent;
        }
    }

    public static class ClassType
    extends ObjectType {
        String name;
        TypeArgument[] arguments;
        public static ClassType OBJECT = new ClassType("java.lang.Object", null);

        static ClassType make(String s2, int b2, int e2, TypeArgument[] targs, ClassType parent) {
            if (parent == null) {
                return new ClassType(s2, b2, e2, targs);
            }
            return new NestedClassType(s2, b2, e2, targs, parent);
        }

        ClassType(String signature, int begin, int end, TypeArgument[] targs) {
            this.name = signature.substring(begin, end).replace('/', '.');
            this.arguments = targs;
        }

        public ClassType(String className, TypeArgument[] args) {
            this.name = className;
            this.arguments = args;
        }

        public ClassType(String className) {
            this(className, null);
        }

        public String getName() {
            return this.name;
        }

        public TypeArgument[] getTypeArguments() {
            return this.arguments;
        }

        public ClassType getDeclaringClass() {
            return null;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            ClassType classType = this.getDeclaringClass();
            if (classType != null) {
                stringBuffer.append(classType.toString()).append('.');
            }
            return this.toString2(stringBuffer);
        }

        private String toString2(StringBuffer sbuf) {
            sbuf.append(this.name);
            if (this.arguments != null) {
                sbuf.append('<');
                int n2 = this.arguments.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (i2 > 0) {
                        sbuf.append(", ");
                    }
                    sbuf.append(this.arguments[i2].toString());
                }
                sbuf.append('>');
            }
            return sbuf.toString();
        }

        @Override
        public String jvmTypeName() {
            StringBuffer stringBuffer = new StringBuffer();
            ClassType classType = this.getDeclaringClass();
            if (classType != null) {
                stringBuffer.append(classType.jvmTypeName()).append('$');
            }
            return this.toString2(stringBuffer);
        }

        @Override
        void encode(StringBuffer sb) {
            sb.append('L');
            this.encode2(sb);
            sb.append(';');
        }

        void encode2(StringBuffer sb) {
            ClassType classType = this.getDeclaringClass();
            if (classType != null) {
                classType.encode2(sb);
                sb.append('$');
            }
            sb.append(this.name.replace('.', '/'));
            if (this.arguments != null) {
                TypeArgument.encode(sb, this.arguments);
            }
        }
    }

    public static abstract class ObjectType
    extends Type {
        public String encode() {
            StringBuffer stringBuffer = new StringBuffer();
            this.encode(stringBuffer);
            return stringBuffer.toString();
        }
    }

    public static class BaseType
    extends Type {
        char descriptor;

        BaseType(char c2) {
            this.descriptor = c2;
        }

        public BaseType(String typeName) {
            this(Descriptor.of(typeName).charAt(0));
        }

        public char getDescriptor() {
            return this.descriptor;
        }

        public CtClass getCtlass() {
            return Descriptor.toPrimitiveClass(this.descriptor);
        }

        public String toString() {
            return Descriptor.toClassName(Character.toString(this.descriptor));
        }

        @Override
        void encode(StringBuffer sb) {
            sb.append(this.descriptor);
        }
    }

    public static abstract class Type {
        abstract void encode(StringBuffer var1);

        static void toString(StringBuffer sbuf, Type[] ts) {
            for (int i2 = 0; i2 < ts.length; ++i2) {
                if (i2 > 0) {
                    sbuf.append(", ");
                }
                sbuf.append(ts[i2]);
            }
        }

        public String jvmTypeName() {
            return this.toString();
        }
    }

    public static class TypeArgument {
        ObjectType arg;
        char wildcard;

        TypeArgument(ObjectType a2, char w2) {
            this.arg = a2;
            this.wildcard = w2;
        }

        public TypeArgument(ObjectType t2) {
            this(t2, ' ');
        }

        public TypeArgument() {
            this(null, '*');
        }

        public static TypeArgument subclassOf(ObjectType t2) {
            return new TypeArgument(t2, '+');
        }

        public static TypeArgument superOf(ObjectType t2) {
            return new TypeArgument(t2, '-');
        }

        public char getKind() {
            return this.wildcard;
        }

        public boolean isWildcard() {
            return this.wildcard != ' ';
        }

        public ObjectType getType() {
            return this.arg;
        }

        public String toString() {
            if (this.wildcard == '*') {
                return "?";
            }
            String string = this.arg.toString();
            if (this.wildcard == ' ') {
                return string;
            }
            if (this.wildcard == '+') {
                return "? extends " + string;
            }
            return "? super " + string;
        }

        static void encode(StringBuffer sb, TypeArgument[] args) {
            sb.append('<');
            for (int i2 = 0; i2 < args.length; ++i2) {
                TypeArgument typeArgument = args[i2];
                if (typeArgument.isWildcard()) {
                    sb.append(typeArgument.wildcard);
                }
                if (typeArgument.getType() == null) continue;
                typeArgument.getType().encode(sb);
            }
            sb.append('>');
        }
    }

    public static class TypeParameter {
        String name;
        ObjectType superClass;
        ObjectType[] superInterfaces;

        TypeParameter(String sig, int nb, int ne, ObjectType sc, ObjectType[] si) {
            this.name = sig.substring(nb, ne);
            this.superClass = sc;
            this.superInterfaces = si;
        }

        public TypeParameter(String name, ObjectType superClass, ObjectType[] superInterfaces) {
            this.name = name;
            this.superClass = superClass;
            if (superInterfaces == null) {
                this.superInterfaces = new ObjectType[0];
                return;
            }
            this.superInterfaces = superInterfaces;
        }

        public TypeParameter(String name) {
            this(name, null, null);
        }

        public String getName() {
            return this.name;
        }

        public ObjectType getClassBound() {
            return this.superClass;
        }

        public ObjectType[] getInterfaceBound() {
            return this.superInterfaces;
        }

        public String toString() {
            int n2;
            StringBuffer stringBuffer = new StringBuffer(this.getName());
            if (this.superClass != null) {
                stringBuffer.append(" extends ").append(this.superClass.toString());
            }
            if ((n2 = this.superInterfaces.length) > 0) {
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (i2 > 0 || this.superClass != null) {
                        stringBuffer.append(" & ");
                    } else {
                        stringBuffer.append(" extends ");
                    }
                    stringBuffer.append(this.superInterfaces[i2].toString());
                }
            }
            return stringBuffer.toString();
        }

        static void toString(StringBuffer sbuf, TypeParameter[] tp) {
            sbuf.append('<');
            for (int i2 = 0; i2 < tp.length; ++i2) {
                if (i2 > 0) {
                    sbuf.append(", ");
                }
                sbuf.append(tp[i2]);
            }
            sbuf.append('>');
        }

        void encode(StringBuffer sb) {
            sb.append(this.name);
            if (this.superClass == null) {
                sb.append(":Ljava/lang/Object;");
            } else {
                sb.append(':');
                this.superClass.encode(sb);
            }
            for (int i2 = 0; i2 < this.superInterfaces.length; ++i2) {
                sb.append(':');
                this.superInterfaces[i2].encode(sb);
            }
        }
    }

    public static class MethodSignature {
        TypeParameter[] typeParams;
        Type[] params;
        Type retType;
        ObjectType[] exceptions;

        public MethodSignature(TypeParameter[] tp, Type[] params, Type ret, ObjectType[] ex) {
            this.typeParams = tp == null ? new TypeParameter[]{} : tp;
            this.params = params == null ? new Type[]{} : params;
            this.retType = ret == null ? new BaseType("void") : ret;
            this.exceptions = ex == null ? new ObjectType[]{} : ex;
        }

        public TypeParameter[] getTypeParameters() {
            return this.typeParams;
        }

        public Type[] getParameterTypes() {
            return this.params;
        }

        public Type getReturnType() {
            return this.retType;
        }

        public ObjectType[] getExceptionTypes() {
            return this.exceptions;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            TypeParameter.toString(stringBuffer, this.typeParams);
            stringBuffer.append(" (");
            Type.toString(stringBuffer, this.params);
            stringBuffer.append(") ");
            stringBuffer.append(this.retType);
            if (this.exceptions.length > 0) {
                stringBuffer.append(" throws ");
                Type.toString(stringBuffer, this.exceptions);
            }
            return stringBuffer.toString();
        }

        public String encode() {
            int n2;
            StringBuffer stringBuffer = new StringBuffer();
            if (this.typeParams.length > 0) {
                stringBuffer.append('<');
                for (n2 = 0; n2 < this.typeParams.length; ++n2) {
                    this.typeParams[n2].encode(stringBuffer);
                }
                stringBuffer.append('>');
            }
            stringBuffer.append('(');
            for (n2 = 0; n2 < this.params.length; ++n2) {
                this.params[n2].encode(stringBuffer);
            }
            stringBuffer.append(')');
            this.retType.encode(stringBuffer);
            if (this.exceptions.length > 0) {
                for (n2 = 0; n2 < this.exceptions.length; ++n2) {
                    stringBuffer.append('^');
                    this.exceptions[n2].encode(stringBuffer);
                }
            }
            return stringBuffer.toString();
        }
    }

    public static class ClassSignature {
        TypeParameter[] params;
        ClassType superClass;
        ClassType[] interfaces;

        public ClassSignature(TypeParameter[] params, ClassType superClass, ClassType[] interfaces) {
            this.params = params == null ? new TypeParameter[]{} : params;
            this.superClass = superClass == null ? ClassType.OBJECT : superClass;
            this.interfaces = interfaces == null ? new ClassType[]{} : interfaces;
        }

        public ClassSignature(TypeParameter[] p2) {
            this(p2, null, null);
        }

        public TypeParameter[] getParameters() {
            return this.params;
        }

        public ClassType getSuperClass() {
            return this.superClass;
        }

        public ClassType[] getInterfaces() {
            return this.interfaces;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            TypeParameter.toString(stringBuffer, this.params);
            stringBuffer.append(" extends ").append(this.superClass);
            if (this.interfaces.length > 0) {
                stringBuffer.append(" implements ");
                Type.toString(stringBuffer, this.interfaces);
            }
            return stringBuffer.toString();
        }

        public String encode() {
            int n2;
            StringBuffer stringBuffer = new StringBuffer();
            if (this.params.length > 0) {
                stringBuffer.append('<');
                for (n2 = 0; n2 < this.params.length; ++n2) {
                    this.params[n2].encode(stringBuffer);
                }
                stringBuffer.append('>');
            }
            this.superClass.encode(stringBuffer);
            for (n2 = 0; n2 < this.interfaces.length; ++n2) {
                this.interfaces[n2].encode(stringBuffer);
            }
            return stringBuffer.toString();
        }
    }

    private static class Cursor {
        int position = 0;

        private Cursor() {
        }

        int indexOf(String s2, int ch) throws BadBytecode {
            int n2 = s2.indexOf(ch, this.position);
            if (n2 < 0) {
                throw SignatureAttribute.error(s2);
            }
            this.position = n2 + 1;
            return n2;
        }
    }
}

