/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.bytecode.analysis;

import ai.h2o.javassist.CtClass;
import ai.h2o.javassist.CtMethod;
import ai.h2o.javassist.bytecode.BadBytecode;
import ai.h2o.javassist.bytecode.MethodInfo;
import ai.h2o.javassist.bytecode.analysis.Analyzer;
import ai.h2o.javassist.bytecode.analysis.Frame;
import ai.h2o.javassist.bytecode.stackmap.BasicBlock;
import java.util.ArrayList;

public class ControlFlow {
    private CtClass clazz;
    private MethodInfo methodInfo;
    private Block[] basicBlocks;
    private Frame[] frames;

    public ControlFlow(CtMethod method) throws BadBytecode {
        this(method.getDeclaringClass(), method.getMethodInfo2());
    }

    public ControlFlow(CtClass ctclazz, MethodInfo minfo) throws BadBytecode {
        Block block;
        int n2;
        this.clazz = ctclazz;
        this.methodInfo = minfo;
        this.frames = null;
        this.basicBlocks = (Block[])new BasicBlock.Maker(){

            @Override
            protected BasicBlock makeBlock(int pos) {
                return new Block(pos, ControlFlow.this.methodInfo);
            }

            @Override
            protected BasicBlock[] makeArray(int size) {
                return new Block[size];
            }
        }.make(minfo);
        if (this.basicBlocks == null) {
            this.basicBlocks = new Block[0];
        }
        int n3 = this.basicBlocks.length;
        int[] nArray = new int[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            block = this.basicBlocks[n2];
            this.basicBlocks[n2].index = n2;
            block.entrances = new Block[block.incomings()];
            nArray[n2] = 0;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            block = this.basicBlocks[n2];
            for (int i2 = 0; i2 < block.exits(); ++i2) {
                Block block2 = block.exit(i2);
                int n4 = block2.index;
                int n5 = nArray[n4];
                nArray[n4] = n5 + 1;
                block2.entrances[n5] = block;
            }
            Catcher[] catcherArray = block.catchers();
            for (int i3 = 0; i3 < catcherArray.length; ++i3) {
                Block block3 = catcherArray[i3].node;
                int n6 = block3.index;
                int n7 = nArray[n6];
                nArray[n6] = n7 + 1;
                block3.entrances[n7] = block;
            }
        }
    }

    public Block[] basicBlocks() {
        return this.basicBlocks;
    }

    public Frame frameAt(int pos) throws BadBytecode {
        if (this.frames == null) {
            this.frames = new Analyzer().analyze(this.clazz, this.methodInfo);
        }
        return this.frames[pos];
    }

    public Node[] dominatorTree() {
        int n2 = this.basicBlocks.length;
        if (n2 == 0) {
            return null;
        }
        Node[] nodeArray = new Node[n2];
        boolean[] blArray = new boolean[n2];
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            nodeArray[i2] = new Node(this.basicBlocks[i2]);
            blArray[i2] = false;
        }
        Access access = new Access(nodeArray){

            @Override
            BasicBlock[] exits(Node n2) {
                return n2.block.getExit();
            }

            @Override
            BasicBlock[] entrances(Node n2) {
                return ((Node)n2).block.entrances;
            }
        };
        nodeArray[0].makeDepth1stTree(null, blArray, 0, nArray, access);
        do {
            for (int i3 = 0; i3 < n2; ++i3) {
                blArray[i3] = false;
            }
        } while (nodeArray[0].makeDominatorTree(blArray, nArray, access));
        Node.setChildren(nodeArray);
        return nodeArray;
    }

    public Node[] postDominatorTree() {
        int n2;
        int n3 = this.basicBlocks.length;
        if (n3 == 0) {
            return null;
        }
        Node[] nodeArray = new Node[n3];
        boolean[] blArray = new boolean[n3];
        int[] nArray = new int[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            nodeArray[i2] = new Node(this.basicBlocks[i2]);
            blArray[i2] = false;
        }
        Access access = new Access(nodeArray){

            @Override
            BasicBlock[] exits(Node n2) {
                return ((Node)n2).block.entrances;
            }

            @Override
            BasicBlock[] entrances(Node n2) {
                return n2.block.getExit();
            }
        };
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            if (nodeArray[n2].block.exits() != 0) continue;
            n4 = nodeArray[n2].makeDepth1stTree(null, blArray, n4, nArray, access);
        }
        do {
            int n5;
            for (n5 = 0; n5 < n3; ++n5) {
                blArray[n5] = false;
            }
            n2 = 0;
            for (n5 = 0; n5 < n3; ++n5) {
                if (nodeArray[n5].block.exits() != 0 || !nodeArray[n5].makeDominatorTree(blArray, nArray, access)) continue;
                n2 = 1;
            }
        } while (n2 != 0);
        Node.setChildren(nodeArray);
        return nodeArray;
    }

    public static class Catcher {
        private Block node;
        private int typeIndex;

        Catcher(BasicBlock.Catch c2) {
            this.node = (Block)c2.body;
            this.typeIndex = c2.typeIndex;
        }

        public Block block() {
            return this.node;
        }

        public String type() {
            if (this.typeIndex == 0) {
                return "java.lang.Throwable";
            }
            return this.node.method.getConstPool().getClassInfo(this.typeIndex);
        }
    }

    public static class Node {
        private Block block;
        private Node parent;
        private Node[] children;

        Node(Block b2) {
            this.block = b2;
            this.parent = null;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Node[pos=").append(this.block().position());
            stringBuffer.append(", parent=");
            stringBuffer.append(this.parent == null ? "*" : Integer.toString(this.parent.block().position()));
            stringBuffer.append(", children{");
            for (int i2 = 0; i2 < this.children.length; ++i2) {
                stringBuffer.append(this.children[i2].block().position()).append(", ");
            }
            stringBuffer.append("}]");
            return stringBuffer.toString();
        }

        public Block block() {
            return this.block;
        }

        public Node parent() {
            return this.parent;
        }

        public int children() {
            return this.children.length;
        }

        public Node child(int n2) {
            return this.children[n2];
        }

        int makeDepth1stTree(Node caller, boolean[] visited, int counter, int[] distance, Access access) {
            int n2 = this.block.index;
            if (visited[n2]) {
                return counter;
            }
            visited[n2] = true;
            this.parent = caller;
            BasicBlock[] basicBlockArray = access.exits(this);
            if (basicBlockArray != null) {
                for (int i2 = 0; i2 < basicBlockArray.length; ++i2) {
                    Node node = access.node(basicBlockArray[i2]);
                    counter = node.makeDepth1stTree(this, visited, counter, distance, access);
                }
            }
            distance[n2] = counter++;
            return counter;
        }

        boolean makeDominatorTree(boolean[] visited, int[] distance, Access access) {
            BasicBlock[] basicBlockArray;
            int n2 = this.block.index;
            if (visited[n2]) {
                return false;
            }
            visited[n2] = true;
            boolean bl = false;
            BasicBlock[] basicBlockArray2 = access.exits(this);
            if (basicBlockArray2 != null) {
                for (int i2 = 0; i2 < basicBlockArray2.length; ++i2) {
                    Node node = access.node(basicBlockArray2[i2]);
                    if (!node.makeDominatorTree(visited, distance, access)) continue;
                    bl = true;
                }
            }
            if ((basicBlockArray = access.entrances(this)) != null) {
                for (int i3 = 0; i3 < basicBlockArray.length; ++i3) {
                    Node node;
                    if (this.parent == null || (node = Node.getAncestor(this.parent, access.node(basicBlockArray[i3]), distance)) == this.parent) continue;
                    this.parent = node;
                    bl = true;
                }
            }
            return bl;
        }

        private static Node getAncestor(Node n1, Node n2, int[] distance) {
            while (n1 != n2) {
                if (distance[n1.block.index] < distance[n2.block.index]) {
                    n1 = n1.parent;
                } else {
                    n2 = n2.parent;
                }
                if (n1 != null && n2 != null) continue;
                return null;
            }
            return n1;
        }

        private static void setChildren(Node[] all) {
            Node node;
            int n2;
            int n3 = all.length;
            int[] nArray = new int[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                nArray[n2] = 0;
            }
            for (n2 = 0; n2 < n3; ++n2) {
                node = all[n2].parent;
                if (node == null) continue;
                int n4 = node.block.index;
                nArray[n4] = nArray[n4] + 1;
            }
            for (n2 = 0; n2 < n3; ++n2) {
                all[n2].children = new Node[nArray[n2]];
            }
            for (n2 = 0; n2 < n3; ++n2) {
                nArray[n2] = 0;
            }
            for (n2 = 0; n2 < n3; ++n2) {
                node = all[n2];
                Node node2 = node.parent;
                if (node2 == null) continue;
                int n5 = node2.block.index;
                int n6 = nArray[n5];
                nArray[n5] = n6 + 1;
                node2.children[n6] = node;
            }
        }
    }

    static abstract class Access {
        Node[] all;

        Access(Node[] nodes) {
            this.all = nodes;
        }

        Node node(BasicBlock b2) {
            return this.all[((Block)b2).index];
        }

        abstract BasicBlock[] exits(Node var1);

        abstract BasicBlock[] entrances(Node var1);
    }

    public static class Block
    extends BasicBlock {
        public Object clientData = null;
        int index;
        MethodInfo method;
        Block[] entrances;

        Block(int pos, MethodInfo minfo) {
            super(pos);
            this.method = minfo;
        }

        @Override
        protected void toString2(StringBuffer sbuf) {
            super.toString2(sbuf);
            sbuf.append(", incoming{");
            for (int i2 = 0; i2 < this.entrances.length; ++i2) {
                sbuf.append(this.entrances[i2].position).append(", ");
            }
            sbuf.append("}");
        }

        BasicBlock[] getExit() {
            return this.exit;
        }

        public int index() {
            return this.index;
        }

        public int position() {
            return this.position;
        }

        public int length() {
            return this.length;
        }

        public int incomings() {
            return this.incoming;
        }

        public Block incoming(int n2) {
            return this.entrances[n2];
        }

        public int exits() {
            if (this.exit == null) {
                return 0;
            }
            return this.exit.length;
        }

        public Block exit(int n2) {
            return (Block)this.exit[n2];
        }

        public Catcher[] catchers() {
            ArrayList<Catcher> arrayList = new ArrayList<Catcher>();
            BasicBlock.Catch catch_ = this.toCatch;
            while (catch_ != null) {
                arrayList.add(new Catcher(catch_));
                catch_ = catch_.next;
            }
            ArrayList<Catcher> arrayList2 = arrayList;
            return arrayList2.toArray(new Catcher[arrayList2.size()]);
        }
    }
}

