/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.bytecode.analysis;

import ai.h2o.javassist.ClassPool;
import ai.h2o.javassist.CtClass;
import ai.h2o.javassist.NotFoundException;
import ai.h2o.javassist.bytecode.BadBytecode;
import ai.h2o.javassist.bytecode.CodeIterator;
import ai.h2o.javassist.bytecode.ConstPool;
import ai.h2o.javassist.bytecode.Descriptor;
import ai.h2o.javassist.bytecode.MethodInfo;
import ai.h2o.javassist.bytecode.Opcode;
import ai.h2o.javassist.bytecode.analysis.Frame;
import ai.h2o.javassist.bytecode.analysis.Subroutine;
import ai.h2o.javassist.bytecode.analysis.Type;

public class Executor
implements Opcode {
    private final ConstPool constPool;
    private final ClassPool classPool;
    private final Type STRING_TYPE;
    private final Type CLASS_TYPE;
    private final Type THROWABLE_TYPE;
    private int lastPos;

    public Executor(ClassPool classPool, ConstPool constPool) {
        this.constPool = constPool;
        this.classPool = classPool;
        try {
            this.STRING_TYPE = this.getType("java.lang.String");
            this.CLASS_TYPE = this.getType("java.lang.Class");
            this.THROWABLE_TYPE = this.getType("java.lang.Throwable");
            return;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void execute(MethodInfo method, int pos, CodeIterator iter, Frame frame, Subroutine subroutine) throws BadBytecode {
        this.lastPos = pos;
        int n2 = iter.byteAt(pos);
        switch (n2) {
            case 0: {
                return;
            }
            case 1: {
                frame.push(Type.UNINIT);
                return;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                frame.push(Type.INTEGER);
                return;
            }
            case 9: 
            case 10: {
                frame.push(Type.LONG);
                frame.push(Type.TOP);
                return;
            }
            case 11: 
            case 12: 
            case 13: {
                frame.push(Type.FLOAT);
                return;
            }
            case 14: 
            case 15: {
                frame.push(Type.DOUBLE);
                frame.push(Type.TOP);
                return;
            }
            case 16: 
            case 17: {
                frame.push(Type.INTEGER);
                return;
            }
            case 18: {
                this.evalLDC(iter.byteAt(pos + 1), frame);
                return;
            }
            case 19: 
            case 20: {
                this.evalLDC(iter.u16bitAt(pos + 1), frame);
                return;
            }
            case 21: {
                this.evalLoad(Type.INTEGER, iter.byteAt(pos + 1), frame, subroutine);
                return;
            }
            case 22: {
                this.evalLoad(Type.LONG, iter.byteAt(pos + 1), frame, subroutine);
                return;
            }
            case 23: {
                this.evalLoad(Type.FLOAT, iter.byteAt(pos + 1), frame, subroutine);
                return;
            }
            case 24: {
                this.evalLoad(Type.DOUBLE, iter.byteAt(pos + 1), frame, subroutine);
                return;
            }
            case 25: {
                this.evalLoad(Type.OBJECT, iter.byteAt(pos + 1), frame, subroutine);
                return;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                this.evalLoad(Type.INTEGER, n2 - 26, frame, subroutine);
                return;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                this.evalLoad(Type.LONG, n2 - 30, frame, subroutine);
                return;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                this.evalLoad(Type.FLOAT, n2 - 34, frame, subroutine);
                return;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                this.evalLoad(Type.DOUBLE, n2 - 38, frame, subroutine);
                return;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                this.evalLoad(Type.OBJECT, n2 - 42, frame, subroutine);
                return;
            }
            case 46: {
                this.evalArrayLoad(Type.INTEGER, frame);
                return;
            }
            case 47: {
                this.evalArrayLoad(Type.LONG, frame);
                return;
            }
            case 48: {
                this.evalArrayLoad(Type.FLOAT, frame);
                return;
            }
            case 49: {
                this.evalArrayLoad(Type.DOUBLE, frame);
                return;
            }
            case 50: {
                this.evalArrayLoad(Type.OBJECT, frame);
                return;
            }
            case 51: 
            case 52: 
            case 53: {
                this.evalArrayLoad(Type.INTEGER, frame);
                return;
            }
            case 54: {
                this.evalStore(Type.INTEGER, iter.byteAt(pos + 1), frame, subroutine);
                return;
            }
            case 55: {
                this.evalStore(Type.LONG, iter.byteAt(pos + 1), frame, subroutine);
                return;
            }
            case 56: {
                this.evalStore(Type.FLOAT, iter.byteAt(pos + 1), frame, subroutine);
                return;
            }
            case 57: {
                this.evalStore(Type.DOUBLE, iter.byteAt(pos + 1), frame, subroutine);
                return;
            }
            case 58: {
                this.evalStore(Type.OBJECT, iter.byteAt(pos + 1), frame, subroutine);
                return;
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                this.evalStore(Type.INTEGER, n2 - 59, frame, subroutine);
                return;
            }
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                this.evalStore(Type.LONG, n2 - 63, frame, subroutine);
                return;
            }
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                this.evalStore(Type.FLOAT, n2 - 67, frame, subroutine);
                return;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                this.evalStore(Type.DOUBLE, n2 - 71, frame, subroutine);
                return;
            }
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                this.evalStore(Type.OBJECT, n2 - 75, frame, subroutine);
                return;
            }
            case 79: {
                this.evalArrayStore(Type.INTEGER, frame);
                return;
            }
            case 80: {
                this.evalArrayStore(Type.LONG, frame);
                return;
            }
            case 81: {
                this.evalArrayStore(Type.FLOAT, frame);
                return;
            }
            case 82: {
                this.evalArrayStore(Type.DOUBLE, frame);
                return;
            }
            case 83: {
                this.evalArrayStore(Type.OBJECT, frame);
                return;
            }
            case 84: 
            case 85: 
            case 86: {
                this.evalArrayStore(Type.INTEGER, frame);
                return;
            }
            case 87: {
                if (frame.pop() != Type.TOP) break;
                throw new BadBytecode("POP can not be used with a category 2 value, pos = " + pos);
            }
            case 88: {
                frame.pop();
                frame.pop();
                return;
            }
            case 89: {
                Type type = frame.peek();
                if (type == Type.TOP) {
                    throw new BadBytecode("DUP can not be used with a category 2 value, pos = " + pos);
                }
                Frame frame2 = frame;
                frame2.push(frame2.peek());
                return;
            }
            case 90: 
            case 91: {
                int n3;
                Type type = frame.peek();
                if (type == Type.TOP) {
                    throw new BadBytecode("DUP can not be used with a category 2 value, pos = " + pos);
                }
                int n4 = n3 - (n2 - 90) - 1;
                frame.push(type);
                for (n3 = frame.getTopIndex(); n3 > n4; --n3) {
                    frame.setStack(n3, frame.getStack(n3 - 1));
                }
                frame.setStack(n4, type);
                return;
            }
            case 92: {
                Frame frame3 = frame;
                frame3.push(frame3.getStack(frame.getTopIndex() - 1));
                Frame frame4 = frame;
                frame4.push(frame4.getStack(frame.getTopIndex() - 1));
                return;
            }
            case 93: 
            case 94: {
                int n5;
                int n6 = n5 - (n2 - 93) - 1;
                Frame frame5 = frame;
                Type type = frame5.getStack(frame5.getTopIndex() - 1);
                Type type2 = frame.peek();
                frame.push(type);
                frame.push(type2);
                for (n5 = frame.getTopIndex(); n5 > n6; --n5) {
                    frame.setStack(n5, frame.getStack(n5 - 2));
                }
                frame.setStack(n6, type2);
                frame.setStack(n6 - 1, type);
                return;
            }
            case 95: {
                Type type = frame.pop();
                Type type3 = frame.pop();
                if (type.getSize() == 2 || type3.getSize() == 2) {
                    throw new BadBytecode("Swap can not be used with category 2 values, pos = " + pos);
                }
                frame.push(type);
                frame.push(type3);
                return;
            }
            case 96: {
                this.evalBinaryMath(Type.INTEGER, frame);
                return;
            }
            case 97: {
                this.evalBinaryMath(Type.LONG, frame);
                return;
            }
            case 98: {
                this.evalBinaryMath(Type.FLOAT, frame);
                return;
            }
            case 99: {
                this.evalBinaryMath(Type.DOUBLE, frame);
                return;
            }
            case 100: {
                this.evalBinaryMath(Type.INTEGER, frame);
                return;
            }
            case 101: {
                this.evalBinaryMath(Type.LONG, frame);
                return;
            }
            case 102: {
                this.evalBinaryMath(Type.FLOAT, frame);
                return;
            }
            case 103: {
                this.evalBinaryMath(Type.DOUBLE, frame);
                return;
            }
            case 104: {
                this.evalBinaryMath(Type.INTEGER, frame);
                return;
            }
            case 105: {
                this.evalBinaryMath(Type.LONG, frame);
                return;
            }
            case 106: {
                this.evalBinaryMath(Type.FLOAT, frame);
                return;
            }
            case 107: {
                this.evalBinaryMath(Type.DOUBLE, frame);
                return;
            }
            case 108: {
                this.evalBinaryMath(Type.INTEGER, frame);
                return;
            }
            case 109: {
                this.evalBinaryMath(Type.LONG, frame);
                return;
            }
            case 110: {
                this.evalBinaryMath(Type.FLOAT, frame);
                return;
            }
            case 111: {
                this.evalBinaryMath(Type.DOUBLE, frame);
                return;
            }
            case 112: {
                this.evalBinaryMath(Type.INTEGER, frame);
                return;
            }
            case 113: {
                this.evalBinaryMath(Type.LONG, frame);
                return;
            }
            case 114: {
                this.evalBinaryMath(Type.FLOAT, frame);
                return;
            }
            case 115: {
                this.evalBinaryMath(Type.DOUBLE, frame);
                return;
            }
            case 116: {
                this.verifyAssignable(Type.INTEGER, this.simplePeek(frame));
                return;
            }
            case 117: {
                this.verifyAssignable(Type.LONG, this.simplePeek(frame));
                return;
            }
            case 118: {
                this.verifyAssignable(Type.FLOAT, this.simplePeek(frame));
                return;
            }
            case 119: {
                this.verifyAssignable(Type.DOUBLE, this.simplePeek(frame));
                return;
            }
            case 120: {
                this.evalShift(Type.INTEGER, frame);
                return;
            }
            case 121: {
                this.evalShift(Type.LONG, frame);
                return;
            }
            case 122: {
                this.evalShift(Type.INTEGER, frame);
                return;
            }
            case 123: {
                this.evalShift(Type.LONG, frame);
                return;
            }
            case 124: {
                this.evalShift(Type.INTEGER, frame);
                return;
            }
            case 125: {
                this.evalShift(Type.LONG, frame);
                return;
            }
            case 126: {
                this.evalBinaryMath(Type.INTEGER, frame);
                return;
            }
            case 127: {
                this.evalBinaryMath(Type.LONG, frame);
                return;
            }
            case 128: {
                this.evalBinaryMath(Type.INTEGER, frame);
                return;
            }
            case 129: {
                this.evalBinaryMath(Type.LONG, frame);
                return;
            }
            case 130: {
                this.evalBinaryMath(Type.INTEGER, frame);
                return;
            }
            case 131: {
                this.evalBinaryMath(Type.LONG, frame);
                return;
            }
            case 132: {
                int n7 = iter.byteAt(pos + 1);
                this.verifyAssignable(Type.INTEGER, frame.getLocal(n7));
                this.access(n7, Type.INTEGER, subroutine);
                return;
            }
            case 133: {
                this.verifyAssignable(Type.INTEGER, this.simplePop(frame));
                this.simplePush(Type.LONG, frame);
                return;
            }
            case 134: {
                this.verifyAssignable(Type.INTEGER, this.simplePop(frame));
                this.simplePush(Type.FLOAT, frame);
                return;
            }
            case 135: {
                this.verifyAssignable(Type.INTEGER, this.simplePop(frame));
                this.simplePush(Type.DOUBLE, frame);
                return;
            }
            case 136: {
                this.verifyAssignable(Type.LONG, this.simplePop(frame));
                this.simplePush(Type.INTEGER, frame);
                return;
            }
            case 137: {
                this.verifyAssignable(Type.LONG, this.simplePop(frame));
                this.simplePush(Type.FLOAT, frame);
                return;
            }
            case 138: {
                this.verifyAssignable(Type.LONG, this.simplePop(frame));
                this.simplePush(Type.DOUBLE, frame);
                return;
            }
            case 139: {
                this.verifyAssignable(Type.FLOAT, this.simplePop(frame));
                this.simplePush(Type.INTEGER, frame);
                return;
            }
            case 140: {
                this.verifyAssignable(Type.FLOAT, this.simplePop(frame));
                this.simplePush(Type.LONG, frame);
                return;
            }
            case 141: {
                this.verifyAssignable(Type.FLOAT, this.simplePop(frame));
                this.simplePush(Type.DOUBLE, frame);
                return;
            }
            case 142: {
                this.verifyAssignable(Type.DOUBLE, this.simplePop(frame));
                this.simplePush(Type.INTEGER, frame);
                return;
            }
            case 143: {
                this.verifyAssignable(Type.DOUBLE, this.simplePop(frame));
                this.simplePush(Type.LONG, frame);
                return;
            }
            case 144: {
                this.verifyAssignable(Type.DOUBLE, this.simplePop(frame));
                this.simplePush(Type.FLOAT, frame);
                return;
            }
            case 145: 
            case 146: 
            case 147: {
                this.verifyAssignable(Type.INTEGER, frame.peek());
                return;
            }
            case 148: {
                this.verifyAssignable(Type.LONG, this.simplePop(frame));
                this.verifyAssignable(Type.LONG, this.simplePop(frame));
                frame.push(Type.INTEGER);
                return;
            }
            case 149: 
            case 150: {
                this.verifyAssignable(Type.FLOAT, this.simplePop(frame));
                this.verifyAssignable(Type.FLOAT, this.simplePop(frame));
                frame.push(Type.INTEGER);
                return;
            }
            case 151: 
            case 152: {
                this.verifyAssignable(Type.DOUBLE, this.simplePop(frame));
                this.verifyAssignable(Type.DOUBLE, this.simplePop(frame));
                frame.push(Type.INTEGER);
                return;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: {
                this.verifyAssignable(Type.INTEGER, this.simplePop(frame));
                return;
            }
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: {
                this.verifyAssignable(Type.INTEGER, this.simplePop(frame));
                this.verifyAssignable(Type.INTEGER, this.simplePop(frame));
                return;
            }
            case 165: 
            case 166: {
                this.verifyAssignable(Type.OBJECT, this.simplePop(frame));
                this.verifyAssignable(Type.OBJECT, this.simplePop(frame));
                return;
            }
            case 167: {
                return;
            }
            case 168: {
                frame.push(Type.RETURN_ADDRESS);
                return;
            }
            case 169: {
                this.verifyAssignable(Type.RETURN_ADDRESS, frame.getLocal(iter.byteAt(pos + 1)));
                return;
            }
            case 170: 
            case 171: 
            case 172: {
                this.verifyAssignable(Type.INTEGER, this.simplePop(frame));
                return;
            }
            case 173: {
                this.verifyAssignable(Type.LONG, this.simplePop(frame));
                return;
            }
            case 174: {
                this.verifyAssignable(Type.FLOAT, this.simplePop(frame));
                return;
            }
            case 175: {
                this.verifyAssignable(Type.DOUBLE, this.simplePop(frame));
                return;
            }
            case 176: {
                try {
                    CtClass ctClass = Descriptor.getReturnType(method.getDescriptor(), this.classPool);
                    this.verifyAssignable(Type.get(ctClass), this.simplePop(frame));
                    return;
                }
                catch (NotFoundException notFoundException) {
                    throw new RuntimeException(notFoundException);
                }
            }
            case 177: {
                return;
            }
            case 178: {
                this.evalGetField(n2, iter.u16bitAt(pos + 1), frame);
                return;
            }
            case 179: {
                this.evalPutField(n2, iter.u16bitAt(pos + 1), frame);
                return;
            }
            case 180: {
                this.evalGetField(n2, iter.u16bitAt(pos + 1), frame);
                return;
            }
            case 181: {
                this.evalPutField(n2, iter.u16bitAt(pos + 1), frame);
                return;
            }
            case 182: 
            case 183: 
            case 184: {
                this.evalInvokeMethod(n2, iter.u16bitAt(pos + 1), frame);
                return;
            }
            case 185: {
                this.evalInvokeIntfMethod(n2, iter.u16bitAt(pos + 1), frame);
                return;
            }
            case 186: {
                this.evalInvokeDynamic(n2, iter.u16bitAt(pos + 1), frame);
                return;
            }
            case 187: {
                Executor executor = this;
                frame.push(executor.resolveClassInfo(executor.constPool.getClassInfo(iter.u16bitAt(pos + 1))));
                return;
            }
            case 188: {
                this.evalNewArray(pos, iter, frame);
                return;
            }
            case 189: {
                this.evalNewObjectArray(pos, iter, frame);
                return;
            }
            case 190: {
                Type type = this.simplePop(frame);
                if (!type.isArray() && type != Type.UNINIT) {
                    throw new BadBytecode("Array length passed a non-array [pos = " + pos + "]: " + type);
                }
                frame.push(Type.INTEGER);
                return;
            }
            case 191: {
                Executor executor = this;
                executor.verifyAssignable(executor.THROWABLE_TYPE, this.simplePop(frame));
                return;
            }
            case 192: {
                this.verifyAssignable(Type.OBJECT, this.simplePop(frame));
                Executor executor = this;
                frame.push(executor.typeFromDesc(executor.constPool.getClassInfoByDescriptor(iter.u16bitAt(pos + 1))));
                return;
            }
            case 193: {
                this.verifyAssignable(Type.OBJECT, this.simplePop(frame));
                frame.push(Type.INTEGER);
                return;
            }
            case 194: 
            case 195: {
                this.verifyAssignable(Type.OBJECT, this.simplePop(frame));
                return;
            }
            case 196: {
                this.evalWide(pos, iter, frame, subroutine);
                return;
            }
            case 197: {
                this.evalNewObjectArray(pos, iter, frame);
                return;
            }
            case 198: 
            case 199: {
                this.verifyAssignable(Type.OBJECT, this.simplePop(frame));
                return;
            }
            case 200: {
                return;
            }
            case 201: {
                frame.push(Type.RETURN_ADDRESS);
            }
        }
    }

    private Type zeroExtend(Type type) {
        if (type == Type.SHORT || type == Type.BYTE || type == Type.CHAR || type == Type.BOOLEAN) {
            return Type.INTEGER;
        }
        return type;
    }

    private void evalArrayLoad(Type expectedComponent, Frame frame) throws BadBytecode {
        Type type = frame.pop();
        Type type2 = frame.pop();
        if (type2 == Type.UNINIT) {
            this.verifyAssignable(Type.INTEGER, type);
            if (expectedComponent == Type.OBJECT) {
                this.simplePush(Type.UNINIT, frame);
                return;
            }
            this.simplePush(expectedComponent, frame);
            return;
        }
        Type type3 = type2.getComponent();
        if (type3 == null) {
            throw new BadBytecode("Not an array! [pos = " + this.lastPos + "]: " + type3);
        }
        type3 = this.zeroExtend(type3);
        this.verifyAssignable(expectedComponent, type3);
        this.verifyAssignable(Type.INTEGER, type);
        this.simplePush(type3, frame);
    }

    private void evalArrayStore(Type expectedComponent, Frame frame) throws BadBytecode {
        Type type = this.simplePop(frame);
        Type type2 = frame.pop();
        Type type3 = frame.pop();
        if (type3 == Type.UNINIT) {
            this.verifyAssignable(Type.INTEGER, type2);
            return;
        }
        Type type4 = type3.getComponent();
        if (type4 == null) {
            throw new BadBytecode("Not an array! [pos = " + this.lastPos + "]: " + type4);
        }
        type4 = this.zeroExtend(type4);
        this.verifyAssignable(expectedComponent, type4);
        this.verifyAssignable(Type.INTEGER, type2);
        if (expectedComponent == Type.OBJECT) {
            this.verifyAssignable(expectedComponent, type);
            return;
        }
        this.verifyAssignable(type4, type);
    }

    private void evalBinaryMath(Type expected, Frame frame) throws BadBytecode {
        Type type = this.simplePop(frame);
        Type type2 = this.simplePop(frame);
        this.verifyAssignable(expected, type);
        this.verifyAssignable(expected, type2);
        this.simplePush(type2, frame);
    }

    private void evalGetField(int opcode, int index, Frame frame) throws BadBytecode {
        String string = this.constPool.getFieldrefType(index);
        Executor executor = this;
        Type type = executor.zeroExtend(executor.typeFromDesc(string));
        if (opcode == 180) {
            Executor executor2 = this;
            Type type2 = executor2.resolveClassInfo(executor2.constPool.getFieldrefClassName(index));
            this.verifyAssignable(type2, this.simplePop(frame));
        }
        this.simplePush(type, frame);
    }

    private void evalInvokeIntfMethod(int opcode, int index, Frame frame) throws BadBytecode {
        String string = this.constPool.getInterfaceMethodrefType(index);
        Type[] typeArray = this.paramTypesFromDesc(string);
        int n2 = typeArray.length;
        while (n2 > 0) {
            Executor executor = this;
            executor.verifyAssignable(executor.zeroExtend(typeArray[--n2]), this.simplePop(frame));
        }
        String string2 = this.constPool.getInterfaceMethodrefClassName(index);
        Type type = this.resolveClassInfo(string2);
        this.verifyAssignable(type, this.simplePop(frame));
        Type type2 = this.returnTypeFromDesc(string);
        if (type2 != Type.VOID) {
            Executor executor = this;
            executor.simplePush(executor.zeroExtend(type2), frame);
        }
    }

    private void evalInvokeMethod(int opcode, int index, Frame frame) throws BadBytecode {
        Type type;
        String string = this.constPool.getMethodrefType(index);
        Type[] typeArray = this.paramTypesFromDesc(string);
        int n2 = typeArray.length;
        while (n2 > 0) {
            Executor executor = this;
            executor.verifyAssignable(executor.zeroExtend(typeArray[--n2]), this.simplePop(frame));
        }
        if (opcode != 184) {
            Executor executor = this;
            type = executor.resolveClassInfo(executor.constPool.getMethodrefClassName(index));
            this.verifyAssignable(type, this.simplePop(frame));
        }
        if ((type = this.returnTypeFromDesc(string)) != Type.VOID) {
            Executor executor = this;
            executor.simplePush(executor.zeroExtend(type), frame);
        }
    }

    private void evalInvokeDynamic(int opcode, int index, Frame frame) throws BadBytecode {
        String string = this.constPool.getInvokeDynamicType(index);
        Type[] typeArray = this.paramTypesFromDesc(string);
        int n2 = typeArray.length;
        while (n2 > 0) {
            Executor executor = this;
            executor.verifyAssignable(executor.zeroExtend(typeArray[--n2]), this.simplePop(frame));
        }
        Type type = this.returnTypeFromDesc(string);
        if (type != Type.VOID) {
            Executor executor = this;
            executor.simplePush(executor.zeroExtend(type), frame);
        }
    }

    private void evalLDC(int index, Frame frame) throws BadBytecode {
        Type type;
        int n2 = this.constPool.getTag(index);
        switch (n2) {
            case 8: {
                type = this.STRING_TYPE;
                break;
            }
            case 3: {
                type = Type.INTEGER;
                break;
            }
            case 4: {
                type = Type.FLOAT;
                break;
            }
            case 5: {
                type = Type.LONG;
                break;
            }
            case 6: {
                type = Type.DOUBLE;
                break;
            }
            case 7: {
                type = this.CLASS_TYPE;
                break;
            }
            default: {
                throw new BadBytecode("bad LDC [pos = " + this.lastPos + "]: " + n2);
            }
        }
        this.simplePush(type, frame);
    }

    private void evalLoad(Type expected, int index, Frame frame, Subroutine subroutine) throws BadBytecode {
        Type type = frame.getLocal(index);
        this.verifyAssignable(expected, type);
        this.simplePush(type, frame);
        this.access(index, type, subroutine);
    }

    private void evalNewArray(int pos, CodeIterator iter, Frame frame) throws BadBytecode {
        Type type;
        this.verifyAssignable(Type.INTEGER, this.simplePop(frame));
        int n2 = iter.byteAt(pos + 1);
        switch (n2) {
            case 4: {
                type = this.getType("boolean[]");
                break;
            }
            case 5: {
                type = this.getType("char[]");
                break;
            }
            case 8: {
                type = this.getType("byte[]");
                break;
            }
            case 9: {
                type = this.getType("short[]");
                break;
            }
            case 10: {
                type = this.getType("int[]");
                break;
            }
            case 11: {
                type = this.getType("long[]");
                break;
            }
            case 6: {
                type = this.getType("float[]");
                break;
            }
            case 7: {
                type = this.getType("double[]");
                break;
            }
            default: {
                throw new BadBytecode("Invalid array type [pos = " + pos + "]: " + n2);
            }
        }
        frame.push(type);
    }

    private void evalNewObjectArray(int pos, CodeIterator iter, Frame frame) throws BadBytecode {
        int n2;
        Executor executor = this;
        Type type = executor.resolveClassInfo(executor.constPool.getClassInfo(iter.u16bitAt(pos + 1)));
        String string = type.getCtClass().getName();
        int n3 = iter.byteAt(pos);
        if (n3 == 197) {
            n2 = iter.byteAt(pos + 3);
        } else {
            string = string + "[]";
            n2 = 1;
        }
        while (n2-- > 0) {
            this.verifyAssignable(Type.INTEGER, this.simplePop(frame));
        }
        Executor executor2 = this;
        executor2.simplePush(executor2.getType(string), frame);
    }

    private void evalPutField(int opcode, int index, Frame frame) throws BadBytecode {
        String string = this.constPool.getFieldrefType(index);
        Executor executor = this;
        Type type = executor.zeroExtend(executor.typeFromDesc(string));
        this.verifyAssignable(type, this.simplePop(frame));
        if (opcode == 181) {
            Executor executor2 = this;
            Type type2 = executor2.resolveClassInfo(executor2.constPool.getFieldrefClassName(index));
            this.verifyAssignable(type2, this.simplePop(frame));
        }
    }

    private void evalShift(Type expected, Frame frame) throws BadBytecode {
        Type type = this.simplePop(frame);
        Type type2 = this.simplePop(frame);
        this.verifyAssignable(Type.INTEGER, type);
        this.verifyAssignable(expected, type2);
        this.simplePush(type2, frame);
    }

    private void evalStore(Type expected, int index, Frame frame, Subroutine subroutine) throws BadBytecode {
        Type type = this.simplePop(frame);
        if (expected != Type.OBJECT || type != Type.RETURN_ADDRESS) {
            this.verifyAssignable(expected, type);
        }
        this.simpleSetLocal(index, type, frame);
        this.access(index, type, subroutine);
    }

    private void evalWide(int pos, CodeIterator iter, Frame frame, Subroutine subroutine) throws BadBytecode {
        int n2 = iter.byteAt(pos + 1);
        int n3 = iter.u16bitAt(pos + 2);
        switch (n2) {
            case 21: {
                this.evalLoad(Type.INTEGER, n3, frame, subroutine);
                return;
            }
            case 22: {
                this.evalLoad(Type.LONG, n3, frame, subroutine);
                return;
            }
            case 23: {
                this.evalLoad(Type.FLOAT, n3, frame, subroutine);
                return;
            }
            case 24: {
                this.evalLoad(Type.DOUBLE, n3, frame, subroutine);
                return;
            }
            case 25: {
                this.evalLoad(Type.OBJECT, n3, frame, subroutine);
                return;
            }
            case 54: {
                this.evalStore(Type.INTEGER, n3, frame, subroutine);
                return;
            }
            case 55: {
                this.evalStore(Type.LONG, n3, frame, subroutine);
                return;
            }
            case 56: {
                this.evalStore(Type.FLOAT, n3, frame, subroutine);
                return;
            }
            case 57: {
                this.evalStore(Type.DOUBLE, n3, frame, subroutine);
                return;
            }
            case 58: {
                this.evalStore(Type.OBJECT, n3, frame, subroutine);
                return;
            }
            case 132: {
                this.verifyAssignable(Type.INTEGER, frame.getLocal(n3));
                return;
            }
            case 169: {
                this.verifyAssignable(Type.RETURN_ADDRESS, frame.getLocal(n3));
                return;
            }
        }
        throw new BadBytecode("Invalid WIDE operand [pos = " + pos + "]: " + n2);
    }

    private Type getType(String name) throws BadBytecode {
        try {
            return Type.get(this.classPool.get(name));
        }
        catch (NotFoundException notFoundException) {
            throw new BadBytecode("Could not find class [pos = " + this.lastPos + "]: " + name);
        }
    }

    private Type[] paramTypesFromDesc(String desc) throws BadBytecode {
        CtClass[] classes;
        try {
            classes = Descriptor.getParameterTypes(desc, this.classPool);
        }
        catch (NotFoundException notFoundException) {
            throw new BadBytecode("Could not find class in descriptor [pos = " + this.lastPos + "]: " + notFoundException.getMessage());
        }
        if (classes == null) {
            throw new BadBytecode("Could not obtain parameters for descriptor [pos = " + this.lastPos + "]: " + desc);
        }
        Type[] typeArray = new Type[classes.length];
        for (int i2 = 0; i2 < typeArray.length; ++i2) {
            typeArray[i2] = Type.get(classes[i2]);
        }
        return typeArray;
    }

    private Type returnTypeFromDesc(String desc) throws BadBytecode {
        CtClass clazz;
        try {
            clazz = Descriptor.getReturnType(desc, this.classPool);
        }
        catch (NotFoundException notFoundException) {
            throw new BadBytecode("Could not find class in descriptor [pos = " + this.lastPos + "]: " + notFoundException.getMessage());
        }
        if (clazz == null) {
            throw new BadBytecode("Could not obtain return type for descriptor [pos = " + this.lastPos + "]: " + desc);
        }
        return Type.get(clazz);
    }

    private Type simplePeek(Frame frame) {
        Type type = frame.peek();
        if (type == Type.TOP) {
            Frame frame2 = frame;
            return frame2.getStack(frame2.getTopIndex() - 1);
        }
        return type;
    }

    private Type simplePop(Frame frame) {
        Type type = frame.pop();
        if (type == Type.TOP) {
            return frame.pop();
        }
        return type;
    }

    private void simplePush(Type type, Frame frame) {
        frame.push(type);
        if (type.getSize() == 2) {
            frame.push(Type.TOP);
        }
    }

    private void access(int index, Type type, Subroutine subroutine) {
        if (subroutine == null) {
            return;
        }
        subroutine.access(index);
        if (type.getSize() == 2) {
            subroutine.access(index + 1);
        }
    }

    private void simpleSetLocal(int index, Type type, Frame frame) {
        frame.setLocal(index, type);
        if (type.getSize() == 2) {
            frame.setLocal(index + 1, Type.TOP);
        }
    }

    private Type resolveClassInfo(String info) throws BadBytecode {
        CtClass clazz;
        try {
            clazz = info.charAt(0) == '[' ? Descriptor.toCtClass(info, this.classPool) : this.classPool.get(info);
        }
        catch (NotFoundException notFoundException) {
            throw new BadBytecode("Could not find class in descriptor [pos = " + this.lastPos + "]: " + notFoundException.getMessage());
        }
        if (clazz == null) {
            throw new BadBytecode("Could not obtain type for descriptor [pos = " + this.lastPos + "]: " + info);
        }
        return Type.get(clazz);
    }

    private Type typeFromDesc(String desc) throws BadBytecode {
        CtClass clazz;
        try {
            clazz = Descriptor.toCtClass(desc, this.classPool);
        }
        catch (NotFoundException notFoundException) {
            throw new BadBytecode("Could not find class in descriptor [pos = " + this.lastPos + "]: " + notFoundException.getMessage());
        }
        if (clazz == null) {
            throw new BadBytecode("Could not obtain type for descriptor [pos = " + this.lastPos + "]: " + desc);
        }
        return Type.get(clazz);
    }

    private void verifyAssignable(Type expected, Type type) throws BadBytecode {
        if (!expected.isAssignableFrom(type)) {
            throw new BadBytecode("Expected type: " + expected + " Got: " + type + " [pos = " + this.lastPos + "]");
        }
    }
}

