/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.bytecode.analysis;

import ai.h2o.javassist.bytecode.analysis.Type;

public class Frame {
    private Type[] locals;
    private Type[] stack;
    private int top;
    private boolean jsrMerged;
    private boolean retMerged;

    public Frame(int locals, int stack) {
        this.locals = new Type[locals];
        this.stack = new Type[stack];
    }

    public Type getLocal(int index) {
        return this.locals[index];
    }

    public void setLocal(int index, Type type) {
        this.locals[index] = type;
    }

    public Type getStack(int index) {
        return this.stack[index];
    }

    public void setStack(int index, Type type) {
        this.stack[index] = type;
    }

    public void clearStack() {
        this.top = 0;
    }

    public int getTopIndex() {
        return this.top - 1;
    }

    public int localsLength() {
        return this.locals.length;
    }

    public Type peek() {
        if (this.top <= 0) {
            throw new IndexOutOfBoundsException("Stack is empty");
        }
        return this.stack[this.top - 1];
    }

    public Type pop() {
        if (this.top <= 0) {
            throw new IndexOutOfBoundsException("Stack is empty");
        }
        return this.stack[--this.top];
    }

    public void push(Type type) {
        this.stack[this.top++] = type;
    }

    public Frame copy() {
        Frame frame = new Frame(this.locals.length, this.stack.length);
        System.arraycopy(this.locals, 0, frame.locals, 0, this.locals.length);
        System.arraycopy(this.stack, 0, frame.stack, 0, this.stack.length);
        frame.top = this.top;
        return frame;
    }

    public Frame copyStack() {
        Frame frame = new Frame(this.locals.length, this.stack.length);
        System.arraycopy(this.stack, 0, frame.stack, 0, this.stack.length);
        frame.top = this.top;
        return frame;
    }

    public boolean mergeStack(Frame frame) {
        boolean bl = false;
        if (this.top != frame.top) {
            throw new RuntimeException("Operand stacks could not be merged, they are different sizes!");
        }
        for (int i2 = 0; i2 < this.top; ++i2) {
            if (this.stack[i2] == null) continue;
            Type type = this.stack[i2];
            Type type2 = type.merge(frame.stack[i2]);
            if (type2 == Type.BOGUS) {
                throw new RuntimeException("Operand stacks could not be merged due to differing primitive types: pos = " + i2);
            }
            this.stack[i2] = type2;
            if (type2.equals(type) && !type2.popChanged()) continue;
            bl = true;
        }
        return bl;
    }

    public boolean merge(Frame frame) {
        boolean bl = false;
        for (int i2 = 0; i2 < this.locals.length; ++i2) {
            if (this.locals[i2] != null) {
                Type type;
                Type type2 = this.locals[i2];
                this.locals[i2] = type = type2.merge(frame.locals[i2]);
                if (type.equals(type2) && !type.popChanged()) continue;
                bl = true;
                continue;
            }
            if (frame.locals[i2] == null) continue;
            this.locals[i2] = frame.locals[i2];
            bl = true;
        }
        return bl |= this.mergeStack(frame);
    }

    public String toString() {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("locals = [");
        for (n2 = 0; n2 < this.locals.length; ++n2) {
            stringBuffer.append(this.locals[n2] == null ? "empty" : this.locals[n2].toString());
            if (n2 >= this.locals.length - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("] stack = [");
        for (n2 = 0; n2 < this.top; ++n2) {
            stringBuffer.append(this.stack[n2]);
            if (n2 >= this.top - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    boolean isJsrMerged() {
        return this.jsrMerged;
    }

    void setJsrMerged(boolean jsrMerged) {
        this.jsrMerged = jsrMerged;
    }

    boolean isRetMerged() {
        return this.retMerged;
    }

    void setRetMerged(boolean retMerged) {
        this.retMerged = retMerged;
    }
}

