/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.bytecode.analysis;

import ai.h2o.javassist.ClassPool;
import ai.h2o.javassist.CtClass;
import ai.h2o.javassist.NotFoundException;
import ai.h2o.javassist.bytecode.analysis.MultiArrayType;
import ai.h2o.javassist.bytecode.analysis.MultiType;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;

public class Type {
    private final CtClass clazz;
    private final boolean special;
    private static final Map<CtClass, Type> prims = new IdentityHashMap<CtClass, Type>();
    public static final Type DOUBLE = new Type(CtClass.doubleType);
    public static final Type BOOLEAN = new Type(CtClass.booleanType);
    public static final Type LONG = new Type(CtClass.longType);
    public static final Type CHAR = new Type(CtClass.charType);
    public static final Type BYTE = new Type(CtClass.byteType);
    public static final Type SHORT = new Type(CtClass.shortType);
    public static final Type INTEGER = new Type(CtClass.intType);
    public static final Type FLOAT = new Type(CtClass.floatType);
    public static final Type VOID = new Type(CtClass.voidType);
    public static final Type UNINIT = new Type(null);
    public static final Type RETURN_ADDRESS = new Type(null, true);
    public static final Type TOP = new Type(null, true);
    public static final Type BOGUS = new Type(null, true);
    public static final Type OBJECT = Type.lookupType("java.lang.Object");
    public static final Type SERIALIZABLE = Type.lookupType("java.io.Serializable");
    public static final Type CLONEABLE = Type.lookupType("java.lang.Cloneable");
    public static final Type THROWABLE = Type.lookupType("java.lang.Throwable");

    public static Type get(CtClass clazz) {
        Type type = prims.get(clazz);
        if (type != null) {
            return type;
        }
        return new Type(clazz);
    }

    private static Type lookupType(String name) {
        try {
            return new Type(ClassPool.getDefault().get(name));
        }
        catch (NotFoundException notFoundException) {
            throw new RuntimeException(notFoundException);
        }
    }

    Type(CtClass clazz) {
        this(clazz, false);
    }

    private Type(CtClass clazz, boolean special) {
        this.clazz = clazz;
        this.special = special;
    }

    boolean popChanged() {
        return false;
    }

    public int getSize() {
        if (this.clazz == CtClass.doubleType || this.clazz == CtClass.longType || this == TOP) {
            return 2;
        }
        return 1;
    }

    public CtClass getCtClass() {
        return this.clazz;
    }

    public boolean isReference() {
        return !this.special && (this.clazz == null || !this.clazz.isPrimitive());
    }

    public boolean isSpecial() {
        return this.special;
    }

    public boolean isArray() {
        return this.clazz != null && this.clazz.isArray();
    }

    public int getDimensions() {
        if (!this.isArray()) {
            return 0;
        }
        String string = this.clazz.getName();
        int n2 = string.length() - 1;
        int n3 = 0;
        while (string.charAt(n2) == ']') {
            n2 -= 2;
            ++n3;
        }
        return n3;
    }

    public Type getComponent() {
        CtClass ctClass;
        if (this.clazz == null || !this.clazz.isArray()) {
            return null;
        }
        try {
            ctClass = this.clazz.getComponentType();
        }
        catch (NotFoundException notFoundException) {
            throw new RuntimeException(notFoundException);
        }
        Type type = prims.get(ctClass);
        if (type != null) {
            return type;
        }
        return new Type(ctClass);
    }

    public boolean isAssignableFrom(Type type) {
        if (this == type) {
            return true;
        }
        if (type == UNINIT && this.isReference() || this == UNINIT && type.isReference()) {
            return true;
        }
        if (type instanceof MultiType) {
            return ((MultiType)type).isAssignableTo(this);
        }
        if (type instanceof MultiArrayType) {
            return ((MultiArrayType)type).isAssignableTo(this);
        }
        if (this.clazz == null || this.clazz.isPrimitive()) {
            return false;
        }
        try {
            return type.clazz.subtypeOf(this.clazz);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public Type merge(Type type) {
        if (type == this) {
            return this;
        }
        if (type == null) {
            return this;
        }
        if (type == UNINIT) {
            return this;
        }
        if (this == UNINIT) {
            return type;
        }
        if (!type.isReference() || !this.isReference()) {
            return BOGUS;
        }
        if (type instanceof MultiType) {
            return type.merge(this);
        }
        if (type.isArray() && this.isArray()) {
            return this.mergeArray(type);
        }
        try {
            return this.mergeClasses(type);
        }
        catch (NotFoundException notFoundException) {
            throw new RuntimeException(notFoundException);
        }
    }

    Type getRootComponent(Type type) {
        while (type.isArray()) {
            type = type.getComponent();
        }
        return type;
    }

    private Type createArray(Type rootComponent, int dims) {
        Type type;
        if (rootComponent instanceof MultiType) {
            return new MultiArrayType((MultiType)rootComponent, dims);
        }
        String string = this.arrayName(rootComponent.clazz.getName(), dims);
        try {
            type = Type.get(this.getClassPool(rootComponent).get(string));
        }
        catch (NotFoundException notFoundException) {
            throw new RuntimeException(notFoundException);
        }
        return type;
    }

    String arrayName(String component, int dims) {
        int n2 = component.length();
        int n3 = n2 + (dims << 1);
        char[] cArray = new char[n3];
        component.getChars(0, n2, cArray, 0);
        while (n2 < n3) {
            cArray[n2++] = 91;
            cArray[n2++] = 93;
        }
        component = new String(cArray);
        return component;
    }

    private ClassPool getClassPool(Type rootComponent) {
        ClassPool classPool = rootComponent.clazz.getClassPool();
        if (classPool != null) {
            return classPool;
        }
        return ClassPool.getDefault();
    }

    private Type mergeArray(Type type) {
        int n2;
        Type type2;
        int n3;
        Type type3 = this.getRootComponent(type);
        Type type4 = this;
        Type type5 = type4.getRootComponent(type4);
        int n4 = type.getDimensions();
        if (n4 == (n3 = this.getDimensions())) {
            Type type6 = type5.merge(type3);
            if (type6 == BOGUS) {
                return OBJECT;
            }
            return this.createArray(type6, n3);
        }
        if (n4 < n3) {
            type2 = type3;
            n2 = n4;
        } else {
            type2 = type5;
            n2 = n3;
        }
        if (Type.eq(Type.CLONEABLE.clazz, type2.clazz) || Type.eq(Type.SERIALIZABLE.clazz, type2.clazz)) {
            return this.createArray(type2, n2);
        }
        return this.createArray(OBJECT, n2);
    }

    private static CtClass findCommonSuperClass(CtClass one, CtClass two) throws NotFoundException {
        CtClass ctClass;
        CtClass ctClass2 = one;
        CtClass ctClass3 = ctClass = two;
        CtClass ctClass4 = ctClass2;
        while (true) {
            if (Type.eq(ctClass2, ctClass) && ctClass2.getSuperclass() != null) {
                return ctClass2;
            }
            CtClass ctClass5 = ctClass2.getSuperclass();
            CtClass ctClass6 = ctClass.getSuperclass();
            if (ctClass6 == null) {
                ctClass = ctClass3;
                break;
            }
            if (ctClass5 == null) {
                ctClass2 = ctClass4;
                ctClass4 = ctClass3;
                ctClass3 = ctClass2;
                ctClass2 = ctClass;
                ctClass = ctClass3;
                break;
            }
            ctClass2 = ctClass5;
            ctClass = ctClass6;
        }
        while ((ctClass2 = ctClass2.getSuperclass()) != null) {
            ctClass4 = ctClass4.getSuperclass();
        }
        ctClass2 = ctClass4;
        while (!Type.eq(ctClass2, ctClass)) {
            ctClass2 = ctClass2.getSuperclass();
            ctClass = ctClass.getSuperclass();
        }
        return ctClass2;
    }

    private Type mergeClasses(Type type) throws NotFoundException {
        CtClass ctClass = Type.findCommonSuperClass(this.clazz, type.clazz);
        if (ctClass.getSuperclass() == null) {
            Map<String, CtClass> map = this.findCommonInterfaces(type);
            if (map.size() == 1) {
                return new Type(map.values().iterator().next());
            }
            if (map.size() > 1) {
                return new MultiType(map);
            }
            return new Type(ctClass);
        }
        Map<String, CtClass> map = this.findExclusiveDeclaredInterfaces(type, ctClass);
        if (map.size() > 0) {
            return new MultiType(map, new Type(ctClass));
        }
        return new Type(ctClass);
    }

    private Map<String, CtClass> findCommonInterfaces(Type type) {
        Map<String, CtClass> map = this.getAllInterfaces(type.clazz, null);
        Type type2 = this;
        Map<String, CtClass> map2 = type2.getAllInterfaces(type2.clazz, null);
        return this.findCommonInterfaces(map, map2);
    }

    private Map<String, CtClass> findExclusiveDeclaredInterfaces(Type type, CtClass exclude) {
        Map<String, CtClass> map = this.getDeclaredInterfaces(type.clazz, null);
        Type type2 = this;
        Map<String, CtClass> map2 = type2.getDeclaredInterfaces(type2.clazz, null);
        Map<String, CtClass> map3 = this.getAllInterfaces(exclude, null);
        for (String string : map3.keySet()) {
            map.remove(string);
            map2.remove(string);
        }
        return this.findCommonInterfaces(map, map2);
    }

    Map<String, CtClass> findCommonInterfaces(Map<String, CtClass> typeMap, Map<String, CtClass> alterMap) {
        if (alterMap == null) {
            alterMap = new HashMap<String, CtClass>();
        }
        if (typeMap == null || typeMap.isEmpty()) {
            alterMap.clear();
        }
        for (String object : alterMap.keySet()) {
            if (typeMap.containsKey(object)) continue;
            alterMap.remove(object);
        }
        for (CtClass ctClass : alterMap.values()) {
            CtClass[] ctClassArray;
            try {
                ctClassArray = ctClass.getInterfaces();
            }
            catch (NotFoundException notFoundException) {
                throw new RuntimeException(notFoundException);
            }
            CtClass[] ctClassArray2 = ctClassArray;
            int n2 = ctClassArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                CtClass ctClass2 = ctClassArray2[i2];
                alterMap.remove(ctClass2.getName());
            }
        }
        return alterMap;
    }

    Map<String, CtClass> getAllInterfaces(CtClass clazz, Map<String, CtClass> map) {
        if (map == null) {
            map = new HashMap<String, CtClass>();
        }
        if (clazz.isInterface()) {
            map.put(clazz.getName(), clazz);
        }
        do {
            try {
                CtClass[] ctClassArray;
                CtClass[] ctClassArray2 = ctClassArray = clazz.getInterfaces();
                int n2 = ctClassArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    CtClass ctClass = ctClassArray2[i2];
                    map.put(ctClass.getName(), ctClass);
                    this.getAllInterfaces(ctClass, map);
                }
                clazz = clazz.getSuperclass();
            }
            catch (NotFoundException notFoundException) {
                throw new RuntimeException(notFoundException);
            }
        } while (clazz != null);
        return map;
    }

    Map<String, CtClass> getDeclaredInterfaces(CtClass clazz, Map<String, CtClass> map) {
        CtClass[] ctClassArray;
        if (map == null) {
            map = new HashMap<String, CtClass>();
        }
        if (clazz.isInterface()) {
            map.put(clazz.getName(), clazz);
        }
        try {
            ctClassArray = clazz.getInterfaces();
        }
        catch (NotFoundException notFoundException) {
            throw new RuntimeException(notFoundException);
        }
        CtClass[] ctClassArray2 = ctClassArray;
        int n2 = ctClassArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            CtClass ctClass = ctClassArray2[i2];
            map.put(ctClass.getName(), ctClass);
            this.getDeclaredInterfaces(ctClass, map);
        }
        return map;
    }

    public int hashCode() {
        return this.getClass().hashCode() + this.clazz.hashCode();
    }

    public boolean equals(Object o2) {
        if (!(o2 instanceof Type)) {
            return false;
        }
        return o2.getClass() == this.getClass() && Type.eq(this.clazz, ((Type)o2).clazz);
    }

    static boolean eq(CtClass one, CtClass two) {
        return one == two || one != null && two != null && one.getName().equals(two.getName());
    }

    public String toString() {
        if (this == BOGUS) {
            return "BOGUS";
        }
        if (this == UNINIT) {
            return "UNINIT";
        }
        if (this == RETURN_ADDRESS) {
            return "RETURN ADDRESS";
        }
        if (this == TOP) {
            return "TOP";
        }
        if (this.clazz == null) {
            return "null";
        }
        return this.clazz.getName();
    }

    static {
        prims.put(CtClass.doubleType, DOUBLE);
        prims.put(CtClass.longType, LONG);
        prims.put(CtClass.charType, CHAR);
        prims.put(CtClass.shortType, SHORT);
        prims.put(CtClass.intType, INTEGER);
        prims.put(CtClass.floatType, FLOAT);
        prims.put(CtClass.byteType, BYTE);
        prims.put(CtClass.booleanType, BOOLEAN);
        prims.put(CtClass.voidType, VOID);
    }
}

