/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.compiler;

import ai.h2o.javassist.compiler.CodeGen;
import ai.h2o.javassist.compiler.CompileError;
import ai.h2o.javassist.compiler.Lex;
import ai.h2o.javassist.compiler.SymbolTable;
import ai.h2o.javassist.compiler.SyntaxError;
import ai.h2o.javassist.compiler.TokenId;
import ai.h2o.javassist.compiler.ast.ASTList;
import ai.h2o.javassist.compiler.ast.ASTree;
import ai.h2o.javassist.compiler.ast.ArrayInit;
import ai.h2o.javassist.compiler.ast.AssignExpr;
import ai.h2o.javassist.compiler.ast.BinExpr;
import ai.h2o.javassist.compiler.ast.CallExpr;
import ai.h2o.javassist.compiler.ast.CastExpr;
import ai.h2o.javassist.compiler.ast.CondExpr;
import ai.h2o.javassist.compiler.ast.Declarator;
import ai.h2o.javassist.compiler.ast.DoubleConst;
import ai.h2o.javassist.compiler.ast.Expr;
import ai.h2o.javassist.compiler.ast.FieldDecl;
import ai.h2o.javassist.compiler.ast.InstanceOfExpr;
import ai.h2o.javassist.compiler.ast.IntConst;
import ai.h2o.javassist.compiler.ast.Keyword;
import ai.h2o.javassist.compiler.ast.Member;
import ai.h2o.javassist.compiler.ast.MethodDecl;
import ai.h2o.javassist.compiler.ast.NewExpr;
import ai.h2o.javassist.compiler.ast.Pair;
import ai.h2o.javassist.compiler.ast.Stmnt;
import ai.h2o.javassist.compiler.ast.StringL;
import ai.h2o.javassist.compiler.ast.Symbol;
import ai.h2o.javassist.compiler.ast.Variable;
import java.io.Serializable;

public final class Parser
implements TokenId {
    private Lex lex;
    private static final int[] binaryOpPrecedence = new int[]{0, 0, 0, 0, 1, 6, 0, 0, 0, 1, 2, 0, 2, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 4, 0};

    public Parser(Lex lex) {
        this.lex = lex;
    }

    public final boolean hasMore() {
        return this.lex.lookAhead() >= 0;
    }

    public final ASTList parseMember(SymbolTable tbl) throws CompileError {
        ASTList aSTList = this.parseMember1(tbl);
        if (aSTList instanceof MethodDecl) {
            return this.parseMethod2(tbl, (MethodDecl)aSTList);
        }
        return aSTList;
    }

    public final ASTList parseMember1(SymbolTable tbl) throws CompileError {
        Declarator declarator;
        ASTList aSTList = this.parseMemberMods();
        boolean bl = false;
        if (this.lex.lookAhead() == 400 && this.lex.lookAhead(1) == 40) {
            declarator = new Declarator(344, 0);
            bl = true;
        } else {
            declarator = this.parseFormalType(tbl);
        }
        if (this.lex.get() != 400) {
            throw new SyntaxError(this.lex);
        }
        String string = bl ? "<init>" : this.lex.getString();
        declarator.setVariable(new Symbol(string));
        if (bl || this.lex.lookAhead() == 40) {
            return this.parseMethod1(tbl, bl, aSTList, declarator);
        }
        return this.parseField(tbl, aSTList, declarator);
    }

    private FieldDecl parseField(SymbolTable tbl, ASTList mods, Declarator d2) throws CompileError {
        int n2;
        ASTree aSTree = null;
        if (this.lex.lookAhead() == 61) {
            this.lex.get();
            aSTree = this.parseExpression(tbl);
        }
        if ((n2 = this.lex.get()) == 59) {
            return new FieldDecl(mods, new ASTList(d2, new ASTList(aSTree)));
        }
        if (n2 == 44) {
            throw new CompileError("only one field can be declared in one declaration", this.lex);
        }
        throw new SyntaxError(this.lex);
    }

    private MethodDecl parseMethod1(SymbolTable tbl, boolean isConstructor, ASTList mods, Declarator d2) throws CompileError {
        if (this.lex.get() != 40) {
            throw new SyntaxError(this.lex);
        }
        ASTList aSTList = null;
        if (this.lex.lookAhead() != 41) {
            while (true) {
                aSTList = ASTList.append(aSTList, this.parseFormalParam(tbl));
                int n2 = this.lex.lookAhead();
                if (n2 == 44) {
                    this.lex.get();
                    continue;
                }
                if (n2 == 41) break;
            }
        }
        this.lex.get();
        d2.addArrayDim(this.parseArrayDimension());
        if (isConstructor && d2.getArrayDim() > 0) {
            throw new SyntaxError(this.lex);
        }
        ASTList aSTList2 = null;
        if (this.lex.lookAhead() == 341) {
            this.lex.get();
            while (true) {
                aSTList2 = ASTList.append(aSTList2, this.parseClassType(tbl));
                if (this.lex.lookAhead() != 44) break;
                this.lex.get();
            }
        }
        return new MethodDecl(mods, new ASTList(d2, ASTList.make(aSTList, aSTList2, null)));
    }

    public final MethodDecl parseMethod2(SymbolTable tbl, MethodDecl md) throws CompileError {
        Stmnt stmnt = null;
        if (this.lex.lookAhead() == 59) {
            this.lex.get();
        } else {
            stmnt = this.parseBlock(tbl);
            if (stmnt == null) {
                stmnt = new Stmnt(66);
            }
        }
        md.sublist(4).setHead(stmnt);
        return md;
    }

    private ASTList parseMemberMods() {
        int n2;
        ASTList aSTList = null;
        while ((n2 = this.lex.lookAhead()) == 300 || n2 == 315 || n2 == 332 || n2 == 331 || n2 == 330 || n2 == 338 || n2 == 335 || n2 == 345 || n2 == 342 || n2 == 347) {
            aSTList = new ASTList(new Keyword(this.lex.get()), aSTList);
        }
        return aSTList;
    }

    private Declarator parseFormalType(SymbolTable tbl) throws CompileError {
        int n2 = this.lex.lookAhead();
        if (Parser.isBuiltinType(n2) || n2 == 344) {
            this.lex.get();
            int n3 = this.parseArrayDimension();
            return new Declarator(n2, n3);
        }
        ASTList aSTList = this.parseClassType(tbl);
        int n4 = this.parseArrayDimension();
        return new Declarator(aSTList, n4);
    }

    private static boolean isBuiltinType(int t2) {
        return t2 == 301 || t2 == 303 || t2 == 306 || t2 == 334 || t2 == 324 || t2 == 326 || t2 == 317 || t2 == 312;
    }

    private Declarator parseFormalParam(SymbolTable tbl) throws CompileError {
        Declarator declarator = this.parseFormalType(tbl);
        if (this.lex.get() != 400) {
            throw new SyntaxError(this.lex);
        }
        String string = this.lex.getString();
        declarator.setVariable(new Symbol(string));
        declarator.addArrayDim(this.parseArrayDimension());
        tbl.append(string, declarator);
        return declarator;
    }

    public final Stmnt parseStatement(SymbolTable tbl) throws CompileError {
        int n2 = this.lex.lookAhead();
        if (n2 == 123) {
            return this.parseBlock(tbl);
        }
        if (n2 == 59) {
            this.lex.get();
            return new Stmnt(66);
        }
        if (n2 == 400 && this.lex.lookAhead(1) == 58) {
            this.lex.get();
            String string = this.lex.getString();
            this.lex.get();
            return Stmnt.make(76, (ASTree)new Symbol(string), (ASTree)this.parseStatement(tbl));
        }
        if (n2 == 320) {
            return this.parseIf(tbl);
        }
        if (n2 == 346) {
            return this.parseWhile(tbl);
        }
        if (n2 == 311) {
            return this.parseDo(tbl);
        }
        if (n2 == 318) {
            return this.parseFor(tbl);
        }
        if (n2 == 343) {
            return this.parseTry(tbl);
        }
        if (n2 == 337) {
            return this.parseSwitch(tbl);
        }
        if (n2 == 338) {
            return this.parseSynchronized(tbl);
        }
        if (n2 == 333) {
            return this.parseReturn(tbl);
        }
        if (n2 == 340) {
            return this.parseThrow(tbl);
        }
        if (n2 == 302) {
            return this.parseBreak(tbl);
        }
        if (n2 == 309) {
            return this.parseContinue(tbl);
        }
        return this.parseDeclarationOrExpression(tbl, false);
    }

    private Stmnt parseBlock(SymbolTable tbl) throws CompileError {
        if (this.lex.get() != 123) {
            throw new SyntaxError(this.lex);
        }
        Stmnt stmnt = null;
        SymbolTable symbolTable = new SymbolTable(tbl);
        while (this.lex.lookAhead() != 125) {
            Stmnt stmnt2 = this.parseStatement(symbolTable);
            if (stmnt2 == null) continue;
            stmnt = (Stmnt)ASTList.concat(stmnt, new Stmnt(66, (ASTree)stmnt2));
        }
        this.lex.get();
        if (stmnt == null) {
            return new Stmnt(66);
        }
        return stmnt;
    }

    private Stmnt parseIf(SymbolTable tbl) throws CompileError {
        Stmnt stmnt;
        int n2 = this.lex.get();
        ASTree aSTree = this.parseParExpression(tbl);
        Stmnt stmnt2 = this.parseStatement(tbl);
        if (this.lex.lookAhead() == 313) {
            this.lex.get();
            stmnt = this.parseStatement(tbl);
        } else {
            stmnt = null;
        }
        return new Stmnt(n2, aSTree, new ASTList(stmnt2, new ASTList(stmnt)));
    }

    private Stmnt parseWhile(SymbolTable tbl) throws CompileError {
        int n2 = this.lex.get();
        ASTree aSTree = this.parseParExpression(tbl);
        Stmnt stmnt = this.parseStatement(tbl);
        return new Stmnt(n2, aSTree, stmnt);
    }

    private Stmnt parseDo(SymbolTable tbl) throws CompileError {
        int n2 = this.lex.get();
        Stmnt stmnt = this.parseStatement(tbl);
        if (this.lex.get() != 346 || this.lex.get() != 40) {
            throw new SyntaxError(this.lex);
        }
        ASTree aSTree = this.parseExpression(tbl);
        if (this.lex.get() != 41 || this.lex.get() != 59) {
            throw new SyntaxError(this.lex);
        }
        return new Stmnt(n2, aSTree, stmnt);
    }

    private Stmnt parseFor(SymbolTable tbl) throws CompileError {
        Stmnt stmnt;
        int n2 = this.lex.get();
        SymbolTable symbolTable = new SymbolTable(tbl);
        if (this.lex.get() != 40) {
            throw new SyntaxError(this.lex);
        }
        if (this.lex.lookAhead() == 59) {
            this.lex.get();
            stmnt = null;
        } else {
            stmnt = this.parseDeclarationOrExpression(symbolTable, true);
        }
        ASTree aSTree = this.lex.lookAhead() == 59 ? null : this.parseExpression(symbolTable);
        if (this.lex.get() != 59) {
            throw new CompileError("; is missing", this.lex);
        }
        Stmnt stmnt2 = this.lex.lookAhead() == 41 ? null : this.parseExprList(symbolTable);
        if (this.lex.get() != 41) {
            throw new CompileError(") is missing", this.lex);
        }
        Stmnt stmnt3 = this.parseStatement(symbolTable);
        return new Stmnt(n2, stmnt, new ASTList(aSTree, new ASTList(stmnt2, stmnt3)));
    }

    private Stmnt parseSwitch(SymbolTable tbl) throws CompileError {
        int n2 = this.lex.get();
        ASTree aSTree = this.parseParExpression(tbl);
        Stmnt stmnt = this.parseSwitchBlock(tbl);
        return new Stmnt(n2, aSTree, stmnt);
    }

    private Stmnt parseSwitchBlock(SymbolTable tbl) throws CompileError {
        if (this.lex.get() != 123) {
            throw new SyntaxError(this.lex);
        }
        SymbolTable symbolTable = new SymbolTable(tbl);
        Stmnt stmnt = this.parseStmntOrCase(symbolTable);
        if (stmnt == null) {
            throw new CompileError("empty switch block", this.lex);
        }
        int n2 = stmnt.getOperator();
        if (n2 != 304 && n2 != 310) {
            throw new CompileError("no case or default in a switch block", this.lex);
        }
        Stmnt stmnt2 = new Stmnt(66, (ASTree)stmnt);
        while (this.lex.lookAhead() != 125) {
            Stmnt stmnt3 = this.parseStmntOrCase(symbolTable);
            if (stmnt3 == null) continue;
            int n3 = stmnt3.getOperator();
            if (n3 == 304 || n3 == 310) {
                stmnt2 = (Stmnt)ASTList.concat(stmnt2, new Stmnt(66, (ASTree)stmnt3));
                stmnt = stmnt3;
                continue;
            }
            stmnt = (Stmnt)ASTList.concat(stmnt, new Stmnt(66, (ASTree)stmnt3));
        }
        this.lex.get();
        return stmnt2;
    }

    private Stmnt parseStmntOrCase(SymbolTable tbl) throws CompileError {
        int n2 = this.lex.lookAhead();
        if (n2 != 304 && n2 != 310) {
            return this.parseStatement(tbl);
        }
        this.lex.get();
        Stmnt stmnt = n2 == 304 ? new Stmnt(n2, this.parseExpression(tbl)) : new Stmnt(310);
        if (this.lex.get() != 58) {
            throw new CompileError(": is missing", this.lex);
        }
        return stmnt;
    }

    private Stmnt parseSynchronized(SymbolTable tbl) throws CompileError {
        int n2 = this.lex.get();
        if (this.lex.get() != 40) {
            throw new SyntaxError(this.lex);
        }
        ASTree aSTree = this.parseExpression(tbl);
        if (this.lex.get() != 41) {
            throw new SyntaxError(this.lex);
        }
        Stmnt stmnt = this.parseBlock(tbl);
        return new Stmnt(n2, aSTree, stmnt);
    }

    private Stmnt parseTry(SymbolTable tbl) throws CompileError {
        Serializable serializable;
        this.lex.get();
        Stmnt stmnt = this.parseBlock(tbl);
        ASTList aSTList = null;
        while (this.lex.lookAhead() == 305) {
            this.lex.get();
            if (this.lex.get() != 40) {
                throw new SyntaxError(this.lex);
            }
            serializable = new SymbolTable(tbl);
            Declarator declarator = this.parseFormalParam((SymbolTable)serializable);
            if (declarator.getArrayDim() > 0 || declarator.getType() != 307) {
                throw new SyntaxError(this.lex);
            }
            if (this.lex.get() != 41) {
                throw new SyntaxError(this.lex);
            }
            Stmnt stmnt2 = this.parseBlock((SymbolTable)serializable);
            aSTList = ASTList.append(aSTList, new Pair(declarator, stmnt2));
        }
        serializable = null;
        if (this.lex.lookAhead() == 316) {
            this.lex.get();
            serializable = this.parseBlock(tbl);
        }
        return Stmnt.make(343, stmnt, aSTList, serializable);
    }

    private Stmnt parseReturn(SymbolTable tbl) throws CompileError {
        int n2 = this.lex.get();
        Stmnt stmnt = new Stmnt(n2);
        if (this.lex.lookAhead() != 59) {
            stmnt.setLeft(this.parseExpression(tbl));
        }
        if (this.lex.get() != 59) {
            throw new CompileError("; is missing", this.lex);
        }
        return stmnt;
    }

    private Stmnt parseThrow(SymbolTable tbl) throws CompileError {
        int n2 = this.lex.get();
        ASTree aSTree = this.parseExpression(tbl);
        if (this.lex.get() != 59) {
            throw new CompileError("; is missing", this.lex);
        }
        return new Stmnt(n2, aSTree);
    }

    private Stmnt parseBreak(SymbolTable tbl) throws CompileError {
        return this.parseContinue(tbl);
    }

    private Stmnt parseContinue(SymbolTable tbl) throws CompileError {
        int n2 = this.lex.get();
        Stmnt stmnt = new Stmnt(n2);
        int n3 = this.lex.get();
        if (n3 == 400) {
            stmnt.setLeft(new Symbol(this.lex.getString()));
            n3 = this.lex.get();
        }
        if (n3 != 59) {
            throw new CompileError("; is missing", this.lex);
        }
        return stmnt;
    }

    private Stmnt parseDeclarationOrExpression(SymbolTable tbl, boolean exprList) throws CompileError {
        int n2;
        int n3 = this.lex.lookAhead();
        while (n3 == 315) {
            this.lex.get();
            n3 = this.lex.lookAhead();
        }
        if (Parser.isBuiltinType(n3)) {
            n3 = this.lex.get();
            int n4 = this.parseArrayDimension();
            return this.parseDeclarators(tbl, new Declarator(n3, n4));
        }
        if (n3 == 400 && (n2 = this.nextIsClassType(0)) >= 0 && this.lex.lookAhead(n2) == 400) {
            ASTList aSTList = this.parseClassType(tbl);
            int n5 = this.parseArrayDimension();
            return this.parseDeclarators(tbl, new Declarator(aSTList, n5));
        }
        Stmnt stmnt = exprList ? this.parseExprList(tbl) : new Stmnt(69, this.parseExpression(tbl));
        if (this.lex.get() != 59) {
            throw new CompileError("; is missing", this.lex);
        }
        return stmnt;
    }

    private Stmnt parseExprList(SymbolTable tbl) throws CompileError {
        Stmnt stmnt = null;
        while (true) {
            Stmnt stmnt2 = new Stmnt(69, this.parseExpression(tbl));
            stmnt = (Stmnt)ASTList.concat(stmnt, new Stmnt(66, (ASTree)stmnt2));
            if (this.lex.lookAhead() != 44) break;
            this.lex.get();
        }
        return stmnt;
    }

    private Stmnt parseDeclarators(SymbolTable tbl, Declarator d2) throws CompileError {
        int n2;
        Stmnt stmnt = null;
        do {
            stmnt = (Stmnt)ASTList.concat(stmnt, new Stmnt(68, (ASTree)this.parseDeclarator(tbl, d2)));
            n2 = this.lex.get();
            if (n2 != 59) continue;
            return stmnt;
        } while (n2 == 44);
        throw new CompileError("; is missing", this.lex);
    }

    private Declarator parseDeclarator(SymbolTable tbl, Declarator d2) throws CompileError {
        if (this.lex.get() != 400 || d2.getType() == 344) {
            throw new SyntaxError(this.lex);
        }
        String string = this.lex.getString();
        Symbol symbol = new Symbol(string);
        int n2 = this.parseArrayDimension();
        ASTree aSTree = null;
        if (this.lex.lookAhead() == 61) {
            this.lex.get();
            aSTree = this.parseInitializer(tbl);
        }
        Declarator declarator = d2.make(symbol, n2, aSTree);
        tbl.append(string, declarator);
        return declarator;
    }

    private ASTree parseInitializer(SymbolTable tbl) throws CompileError {
        if (this.lex.lookAhead() == 123) {
            return this.parseArrayInitializer(tbl);
        }
        return this.parseExpression(tbl);
    }

    private ArrayInit parseArrayInitializer(SymbolTable tbl) throws CompileError {
        this.lex.get();
        ASTree aSTree = this.parseExpression(tbl);
        ArrayInit arrayInit = new ArrayInit(aSTree);
        while (this.lex.lookAhead() == 44) {
            this.lex.get();
            aSTree = this.parseExpression(tbl);
            ASTList.append(arrayInit, aSTree);
        }
        if (this.lex.get() != 125) {
            throw new SyntaxError(this.lex);
        }
        return arrayInit;
    }

    private ASTree parseParExpression(SymbolTable tbl) throws CompileError {
        if (this.lex.get() != 40) {
            throw new SyntaxError(this.lex);
        }
        ASTree aSTree = this.parseExpression(tbl);
        if (this.lex.get() != 41) {
            throw new SyntaxError(this.lex);
        }
        return aSTree;
    }

    public final ASTree parseExpression(SymbolTable tbl) throws CompileError {
        ASTree aSTree = this.parseConditionalExpr(tbl);
        if (!Parser.isAssignOp(this.lex.lookAhead())) {
            return aSTree;
        }
        int n2 = this.lex.get();
        ASTree aSTree2 = this.parseExpression(tbl);
        return AssignExpr.makeAssign(n2, aSTree, aSTree2);
    }

    private static boolean isAssignOp(int t2) {
        return t2 == 61 || t2 == 351 || t2 == 352 || t2 == 353 || t2 == 354 || t2 == 355 || t2 == 356 || t2 == 360 || t2 == 361 || t2 == 365 || t2 == 367 || t2 == 371;
    }

    private ASTree parseConditionalExpr(SymbolTable tbl) throws CompileError {
        ASTree aSTree = this.parseBinaryExpr(tbl);
        if (this.lex.lookAhead() == 63) {
            this.lex.get();
            ASTree aSTree2 = this.parseExpression(tbl);
            if (this.lex.get() != 58) {
                throw new CompileError(": is missing", this.lex);
            }
            ASTree aSTree3 = this.parseExpression(tbl);
            return new CondExpr(aSTree, aSTree2, aSTree3);
        }
        return aSTree;
    }

    private ASTree parseBinaryExpr(SymbolTable tbl) throws CompileError {
        ASTree aSTree = this.parseUnaryExpr(tbl);
        int n2;
        int n3;
        while ((n3 = this.getOpPrecedence(n2 = this.lex.lookAhead())) != 0) {
            aSTree = this.binaryExpr2(tbl, aSTree, n3);
        }
        return aSTree;
    }

    private ASTree parseInstanceOf(SymbolTable tbl, ASTree expr) throws CompileError {
        int n2 = this.lex.lookAhead();
        if (Parser.isBuiltinType(n2)) {
            this.lex.get();
            int n3 = this.parseArrayDimension();
            return new InstanceOfExpr(n2, n3, expr);
        }
        ASTList aSTList = this.parseClassType(tbl);
        int n4 = this.parseArrayDimension();
        return new InstanceOfExpr(aSTList, n4, expr);
    }

    private ASTree binaryExpr2(SymbolTable tbl, ASTree expr, int prec) throws CompileError {
        int n2;
        int n3;
        int n4 = this.lex.get();
        if (n4 == 323) {
            return this.parseInstanceOf(tbl, expr);
        }
        ASTree aSTree = this.parseUnaryExpr(tbl);
        while ((n3 = this.getOpPrecedence(n2 = this.lex.lookAhead())) != 0 && prec > n3) {
            aSTree = this.binaryExpr2(tbl, aSTree, n3);
        }
        return BinExpr.makeBin(n4, expr, aSTree);
    }

    private int getOpPrecedence(int c2) {
        if (33 <= c2 && c2 <= 63) {
            return binaryOpPrecedence[c2 - 33];
        }
        if (c2 == 94) {
            return 7;
        }
        if (c2 == 124) {
            return 8;
        }
        if (c2 == 369) {
            return 9;
        }
        if (c2 == 368) {
            return 10;
        }
        if (c2 == 358 || c2 == 350) {
            return 5;
        }
        if (c2 == 357 || c2 == 359 || c2 == 323) {
            return 4;
        }
        if (c2 == 364 || c2 == 366 || c2 == 370) {
            return 3;
        }
        return 0;
    }

    private ASTree parseUnaryExpr(SymbolTable tbl) throws CompileError {
        switch (this.lex.lookAhead()) {
            case 33: 
            case 43: 
            case 45: 
            case 126: 
            case 362: 
            case 363: {
                int n2 = this.lex.get();
                if (n2 == 45) {
                    int n3 = this.lex.lookAhead();
                    switch (n3) {
                        case 401: 
                        case 402: 
                        case 403: {
                            this.lex.get();
                            return new IntConst(-this.lex.getLong(), n3);
                        }
                        case 404: 
                        case 405: {
                            this.lex.get();
                            return new DoubleConst(-this.lex.getDouble(), n3);
                        }
                    }
                }
                return Expr.make(n2, this.parseUnaryExpr(tbl));
            }
            case 40: {
                return this.parseCast(tbl);
            }
        }
        return this.parsePostfix(tbl);
    }

    private ASTree parseCast(SymbolTable tbl) throws CompileError {
        int n2 = this.lex.lookAhead(1);
        if (Parser.isBuiltinType(n2) && this.nextIsBuiltinCast()) {
            this.lex.get();
            this.lex.get();
            int n3 = this.parseArrayDimension();
            if (this.lex.get() != 41) {
                throw new CompileError(") is missing", this.lex);
            }
            return new CastExpr(n2, n3, this.parseUnaryExpr(tbl));
        }
        if (n2 == 400 && this.nextIsClassCast()) {
            this.lex.get();
            ASTList aSTList = this.parseClassType(tbl);
            int n4 = this.parseArrayDimension();
            if (this.lex.get() != 41) {
                throw new CompileError(") is missing", this.lex);
            }
            return new CastExpr(aSTList, n4, this.parseUnaryExpr(tbl));
        }
        return this.parsePostfix(tbl);
    }

    private boolean nextIsBuiltinCast() {
        int n2 = 2;
        while (this.lex.lookAhead(n2++) == 91) {
            if (this.lex.lookAhead(n2++) == 93) continue;
            return false;
        }
        return this.lex.lookAhead(n2 - 1) == 41;
    }

    private boolean nextIsClassCast() {
        int n2 = this.nextIsClassType(1);
        if (n2 < 0) {
            return false;
        }
        int n3 = this.lex.lookAhead(n2);
        if (n3 != 41) {
            return false;
        }
        n3 = this.lex.lookAhead(n2 + 1);
        return n3 == 40 || n3 == 412 || n3 == 406 || n3 == 400 || n3 == 339 || n3 == 336 || n3 == 328 || n3 == 410 || n3 == 411 || n3 == 403 || n3 == 402 || n3 == 401 || n3 == 405 || n3 == 404;
    }

    private int nextIsClassType(int i2) {
        while (this.lex.lookAhead(++i2) == 46) {
            if (this.lex.lookAhead(++i2) == 400) continue;
            return -1;
        }
        while (this.lex.lookAhead(i2++) == 91) {
            if (this.lex.lookAhead(i2++) == 93) continue;
            return -1;
        }
        return i2 - 1;
    }

    private int parseArrayDimension() throws CompileError {
        int n2 = 0;
        while (this.lex.lookAhead() == 91) {
            ++n2;
            this.lex.get();
            if (this.lex.get() == 93) continue;
            throw new CompileError("] is missing", this.lex);
        }
        return n2;
    }

    private ASTList parseClassType(SymbolTable tbl) throws CompileError {
        ASTList aSTList = null;
        while (true) {
            if (this.lex.get() != 400) {
                throw new SyntaxError(this.lex);
            }
            aSTList = ASTList.append(aSTList, new Symbol(this.lex.getString()));
            if (this.lex.lookAhead() != 46) break;
            this.lex.get();
        }
        return aSTList;
    }

    private ASTree parsePostfix(SymbolTable tbl) throws CompileError {
        int n2 = this.lex.lookAhead();
        switch (n2) {
            case 401: 
            case 402: 
            case 403: {
                this.lex.get();
                return new IntConst(this.lex.getLong(), n2);
            }
            case 404: 
            case 405: {
                this.lex.get();
                return new DoubleConst(this.lex.getDouble(), n2);
            }
        }
        ASTree aSTree = this.parsePrimaryExpr(tbl);
        block11: while (true) {
            switch (this.lex.lookAhead()) {
                case 40: {
                    aSTree = this.parseMethodCall(tbl, aSTree);
                    continue block11;
                }
                case 91: {
                    if (this.lex.lookAhead(1) == 93) {
                        int n3 = this.parseArrayDimension();
                        if (this.lex.get() != 46 || this.lex.get() != 307) {
                            throw new SyntaxError(this.lex);
                        }
                        aSTree = this.parseDotClass(aSTree, n3);
                        continue block11;
                    }
                    ASTree aSTree2 = this.parseArrayIndex(tbl);
                    if (aSTree2 == null) {
                        throw new SyntaxError(this.lex);
                    }
                    aSTree = Expr.make(65, aSTree, aSTree2);
                    continue block11;
                }
                case 362: 
                case 363: {
                    int n4 = this.lex.get();
                    aSTree = Expr.make(n4, null, aSTree);
                    continue block11;
                }
                case 46: {
                    String string;
                    this.lex.get();
                    int n4 = this.lex.get();
                    if (n4 == 307) {
                        aSTree = this.parseDotClass(aSTree, 0);
                        continue block11;
                    }
                    if (n4 == 336) {
                        aSTree = Expr.make(46, (ASTree)new Symbol(this.toClassName(aSTree)), (ASTree)new Keyword(n4));
                        continue block11;
                    }
                    if (n4 == 400) {
                        string = this.lex.getString();
                        aSTree = Expr.make(46, aSTree, (ASTree)new Member(string));
                        continue block11;
                    }
                    throw new CompileError("missing member name", this.lex);
                }
                case 35: {
                    this.lex.get();
                    int n4 = this.lex.get();
                    if (n4 != 400) {
                        throw new CompileError("missing static member name", this.lex);
                    }
                    String string = this.lex.getString();
                    aSTree = Expr.make(35, (ASTree)new Symbol(this.toClassName(aSTree)), (ASTree)new Member(string));
                    continue block11;
                }
            }
            break;
        }
        return aSTree;
    }

    private ASTree parseDotClass(ASTree className, int dim) throws CompileError {
        String string = this.toClassName(className);
        if (dim > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            while (dim-- > 0) {
                stringBuffer.append('[');
            }
            stringBuffer.append('L').append(string.replace('.', '/')).append(';');
            string = stringBuffer.toString();
        }
        return Expr.make(46, (ASTree)new Symbol(string), (ASTree)new Member("class"));
    }

    private ASTree parseDotClass(int builtinType, int dim) throws CompileError {
        String string;
        if (dim > 0) {
            String string2 = CodeGen.toJvmTypeName(builtinType, dim);
            return Expr.make(46, (ASTree)new Symbol(string2), (ASTree)new Member("class"));
        }
        switch (builtinType) {
            case 301: {
                string = "java.lang.Boolean";
                break;
            }
            case 303: {
                string = "java.lang.Byte";
                break;
            }
            case 306: {
                string = "java.lang.Character";
                break;
            }
            case 334: {
                string = "java.lang.Short";
                break;
            }
            case 324: {
                string = "java.lang.Integer";
                break;
            }
            case 326: {
                string = "java.lang.Long";
                break;
            }
            case 317: {
                string = "java.lang.Float";
                break;
            }
            case 312: {
                string = "java.lang.Double";
                break;
            }
            case 344: {
                string = "java.lang.Void";
                break;
            }
            default: {
                throw new CompileError("invalid builtin type: " + builtinType);
            }
        }
        return Expr.make(35, (ASTree)new Symbol(string), (ASTree)new Member("TYPE"));
    }

    private ASTree parseMethodCall(SymbolTable tbl, ASTree expr) throws CompileError {
        int n2;
        int n3;
        if (expr instanceof Keyword ? (n3 = ((Keyword)expr).get()) != 339 && n3 != 336 : !(expr instanceof Symbol) && expr instanceof Expr && (n2 = ((Expr)expr).getOperator()) != 46 && n2 != 35) {
            throw new SyntaxError(this.lex);
        }
        return CallExpr.makeCall(expr, this.parseArgumentList(tbl));
    }

    private String toClassName(ASTree name) throws CompileError {
        StringBuffer stringBuffer = new StringBuffer();
        this.toClassName(name, stringBuffer);
        return stringBuffer.toString();
    }

    private void toClassName(ASTree name, StringBuffer sbuf) throws CompileError {
        while (true) {
            Expr expr;
            if (name instanceof Symbol) {
                sbuf.append(((Symbol)name).get());
                return;
            }
            if (!(name instanceof Expr) || (expr = (Expr)name).getOperator() != 46) break;
            this.toClassName(expr.oprand1(), sbuf);
            sbuf.append('.');
            name = expr.oprand2();
        }
        throw new CompileError("bad static member access", this.lex);
    }

    private ASTree parsePrimaryExpr(SymbolTable tbl) throws CompileError {
        int n2 = this.lex.get();
        switch (n2) {
            case 336: 
            case 339: 
            case 410: 
            case 411: 
            case 412: {
                return new Keyword(n2);
            }
            case 400: {
                String string = this.lex.getString();
                Declarator declarator = tbl.lookup(string);
                if (declarator == null) {
                    return new Member(string);
                }
                return new Variable(string, declarator);
            }
            case 406: {
                return new StringL(this.lex.getString());
            }
            case 328: {
                return this.parseNew(tbl);
            }
            case 40: {
                ASTree aSTree = this.parseExpression(tbl);
                if (this.lex.get() == 41) {
                    return aSTree;
                }
                throw new CompileError(") is missing", this.lex);
            }
        }
        if (Parser.isBuiltinType(n2) || n2 == 344) {
            int n3 = this.parseArrayDimension();
            if (this.lex.get() == 46 && this.lex.get() == 307) {
                return this.parseDotClass(n2, n3);
            }
        }
        throw new SyntaxError(this.lex);
    }

    private NewExpr parseNew(SymbolTable tbl) throws CompileError {
        ArrayInit arrayInit = null;
        int n2 = this.lex.lookAhead();
        if (Parser.isBuiltinType(n2)) {
            this.lex.get();
            ASTList aSTList = this.parseArraySize(tbl);
            if (this.lex.lookAhead() == 123) {
                arrayInit = this.parseArrayInitializer(tbl);
            }
            return new NewExpr(n2, aSTList, arrayInit);
        }
        if (n2 == 400) {
            ASTList aSTList = this.parseClassType(tbl);
            n2 = this.lex.lookAhead();
            if (n2 == 40) {
                ASTList aSTList2 = this.parseArgumentList(tbl);
                return new NewExpr(aSTList, aSTList2);
            }
            if (n2 == 91) {
                ASTList aSTList3 = this.parseArraySize(tbl);
                if (this.lex.lookAhead() == 123) {
                    arrayInit = this.parseArrayInitializer(tbl);
                }
                return NewExpr.makeObjectArray(aSTList, aSTList3, arrayInit);
            }
        }
        throw new SyntaxError(this.lex);
    }

    private ASTList parseArraySize(SymbolTable tbl) throws CompileError {
        ASTList aSTList = null;
        while (this.lex.lookAhead() == 91) {
            aSTList = ASTList.append(aSTList, this.parseArrayIndex(tbl));
        }
        return aSTList;
    }

    private ASTree parseArrayIndex(SymbolTable tbl) throws CompileError {
        this.lex.get();
        if (this.lex.lookAhead() == 93) {
            this.lex.get();
            return null;
        }
        ASTree aSTree = this.parseExpression(tbl);
        if (this.lex.get() != 93) {
            throw new CompileError("] is missing", this.lex);
        }
        return aSTree;
    }

    private ASTList parseArgumentList(SymbolTable tbl) throws CompileError {
        if (this.lex.get() != 40) {
            throw new CompileError("( is missing", this.lex);
        }
        ASTList aSTList = null;
        if (this.lex.lookAhead() != 41) {
            while (true) {
                aSTList = ASTList.append(aSTList, this.parseExpression(tbl));
                if (this.lex.lookAhead() != 44) break;
                this.lex.get();
            }
        }
        if (this.lex.get() != 41) {
            throw new CompileError(") is missing", this.lex);
        }
        return aSTList;
    }
}

