/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.compiler.ast;

import ai.h2o.javassist.compiler.CompileError;
import ai.h2o.javassist.compiler.ast.ASTree;
import ai.h2o.javassist.compiler.ast.Visitor;

public class ASTList
extends ASTree {
    private static final long serialVersionUID = 1L;
    private ASTree left;
    private ASTList right;

    public ASTList(ASTree _head, ASTList _tail) {
        this.left = _head;
        this.right = _tail;
    }

    public ASTList(ASTree _head) {
        this.left = _head;
        this.right = null;
    }

    public static ASTList make(ASTree e1, ASTree e2, ASTree e3) {
        return new ASTList(e1, new ASTList(e2, new ASTList(e3)));
    }

    @Override
    public ASTree getLeft() {
        return this.left;
    }

    @Override
    public ASTree getRight() {
        return this.right;
    }

    @Override
    public void setLeft(ASTree _left) {
        this.left = _left;
    }

    @Override
    public void setRight(ASTree _right) {
        this.right = (ASTList)_right;
    }

    public ASTree head() {
        return this.left;
    }

    public void setHead(ASTree _head) {
        this.left = _head;
    }

    public ASTList tail() {
        return this.right;
    }

    public void setTail(ASTList _tail) {
        this.right = _tail;
    }

    @Override
    public void accept(Visitor v2) throws CompileError {
        v2.atASTList(this);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(<");
        stringBuffer.append(this.getTag());
        stringBuffer.append('>');
        ASTList aSTList = this;
        while (aSTList != null) {
            stringBuffer.append(' ');
            ASTree aSTree = aSTList.left;
            stringBuffer.append(aSTree == null ? "<null>" : aSTree.toString());
            aSTList = aSTList.right;
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public int length() {
        return ASTList.length(this);
    }

    public static int length(ASTList list) {
        if (list == null) {
            return 0;
        }
        int n2 = 0;
        while (list != null) {
            list = list.right;
            ++n2;
        }
        return n2;
    }

    public ASTList sublist(int nth) {
        ASTList aSTList = this;
        while (nth-- > 0) {
            aSTList = aSTList.right;
        }
        return aSTList;
    }

    public boolean subst(ASTree newObj, ASTree oldObj) {
        ASTList aSTList = this;
        while (aSTList != null) {
            if (aSTList.left == oldObj) {
                aSTList.left = newObj;
                return true;
            }
            aSTList = aSTList.right;
        }
        return false;
    }

    public static ASTList append(ASTList a2, ASTree b2) {
        return ASTList.concat(a2, new ASTList(b2));
    }

    public static ASTList concat(ASTList a2, ASTList b2) {
        if (a2 == null) {
            return b2;
        }
        ASTList aSTList = a2;
        while (aSTList.right != null) {
            aSTList = aSTList.right;
        }
        aSTList.right = b2;
        return a2;
    }
}

