/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.compiler.ast;

import ai.h2o.javassist.compiler.CompileError;
import ai.h2o.javassist.compiler.TokenId;
import ai.h2o.javassist.compiler.ast.ASTList;
import ai.h2o.javassist.compiler.ast.ASTree;
import ai.h2o.javassist.compiler.ast.Symbol;
import ai.h2o.javassist.compiler.ast.Visitor;

public class Declarator
extends ASTList
implements TokenId {
    private static final long serialVersionUID = 1L;
    protected int varType;
    protected int arrayDim;
    protected int localVar;
    protected String qualifiedClass;

    public Declarator(int type, int dim) {
        super(null);
        this.varType = type;
        this.arrayDim = dim;
        this.localVar = -1;
        this.qualifiedClass = null;
    }

    public Declarator(ASTList className, int dim) {
        super(null);
        this.varType = 307;
        this.arrayDim = dim;
        this.localVar = -1;
        this.qualifiedClass = Declarator.astToClassName(className, '/');
    }

    public Declarator(int type, String jvmClassName, int dim, int var, Symbol sym) {
        super(null);
        this.varType = type;
        this.arrayDim = dim;
        this.localVar = var;
        this.qualifiedClass = jvmClassName;
        this.setLeft(sym);
        Declarator.append(this, null);
    }

    public Declarator make(Symbol sym, int dim, ASTree init) {
        Declarator declarator = new Declarator(this.varType, this.arrayDim + dim);
        new Declarator(this.varType, this.arrayDim + dim).qualifiedClass = this.qualifiedClass;
        declarator.setLeft(sym);
        Declarator.append(declarator, init);
        return declarator;
    }

    public int getType() {
        return this.varType;
    }

    public int getArrayDim() {
        return this.arrayDim;
    }

    public void addArrayDim(int d2) {
        this.arrayDim += d2;
    }

    public String getClassName() {
        return this.qualifiedClass;
    }

    public void setClassName(String s2) {
        this.qualifiedClass = s2;
    }

    public Symbol getVariable() {
        return (Symbol)this.getLeft();
    }

    public void setVariable(Symbol sym) {
        this.setLeft(sym);
    }

    public ASTree getInitializer() {
        ASTList aSTList = this.tail();
        if (aSTList != null) {
            return aSTList.head();
        }
        return null;
    }

    public void setLocalVar(int n2) {
        this.localVar = n2;
    }

    public int getLocalVar() {
        return this.localVar;
    }

    @Override
    public String getTag() {
        return "decl";
    }

    @Override
    public void accept(Visitor v2) throws CompileError {
        v2.atDeclarator(this);
    }

    public static String astToClassName(ASTList name, char sep) {
        if (name == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        Declarator.astToClassName(stringBuffer, name, sep);
        return stringBuffer.toString();
    }

    private static void astToClassName(StringBuffer sbuf, ASTList name, char sep) {
        while (true) {
            ASTree aSTree;
            if ((aSTree = name.head()) instanceof Symbol) {
                sbuf.append(((Symbol)aSTree).get());
            } else if (aSTree instanceof ASTList) {
                Declarator.astToClassName(sbuf, (ASTList)aSTree, sep);
            }
            name = name.tail();
            if (name == null) break;
            sbuf.append(sep);
        }
    }
}

