/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.compiler.ast;

import ai.h2o.javassist.compiler.CompileError;
import ai.h2o.javassist.compiler.ast.ASTree;
import ai.h2o.javassist.compiler.ast.DoubleConst;
import ai.h2o.javassist.compiler.ast.Visitor;

public class IntConst
extends ASTree {
    private static final long serialVersionUID = 1L;
    protected long value;
    protected int type;

    public IntConst(long v2, int tokenId) {
        this.value = v2;
        this.type = tokenId;
    }

    public long get() {
        return this.value;
    }

    public void set(long v2) {
        this.value = v2;
    }

    public int getType() {
        return this.type;
    }

    @Override
    public String toString() {
        return Long.toString(this.value);
    }

    @Override
    public void accept(Visitor v2) throws CompileError {
        v2.atIntConst(this);
    }

    public ASTree compute(int op, ASTree right) {
        if (right instanceof IntConst) {
            return this.compute0(op, (IntConst)right);
        }
        if (right instanceof DoubleConst) {
            return this.compute0(op, (DoubleConst)right);
        }
        return null;
    }

    private IntConst compute0(int op, IntConst right) {
        long l2;
        int n2 = this.type;
        int n3 = right.type;
        int n4 = n2 == 403 || n3 == 403 ? 403 : (n2 == 401 && n3 == 401 ? 401 : 402);
        long l3 = this.value;
        long l4 = right.value;
        switch (op) {
            case 43: {
                l2 = l3 + l4;
                break;
            }
            case 45: {
                l2 = l3 - l4;
                break;
            }
            case 42: {
                l2 = l3 * l4;
                break;
            }
            case 47: {
                l2 = l3 / l4;
                break;
            }
            case 37: {
                l2 = l3 % l4;
                break;
            }
            case 124: {
                l2 = l3 | l4;
                break;
            }
            case 94: {
                l2 = l3 ^ l4;
                break;
            }
            case 38: {
                l2 = l3 & l4;
                break;
            }
            case 364: {
                l2 = this.value << (int)l4;
                n4 = n2;
                break;
            }
            case 366: {
                l2 = this.value >> (int)l4;
                n4 = n2;
                break;
            }
            case 370: {
                l2 = this.value >>> (int)l4;
                n4 = n2;
                break;
            }
            default: {
                return null;
            }
        }
        return new IntConst(l2, n4);
    }

    private DoubleConst compute0(int op, DoubleConst right) {
        double d2;
        double d3 = this.value;
        double d4 = right.value;
        switch (op) {
            case 43: {
                d2 = d3 + d4;
                break;
            }
            case 45: {
                d2 = d3 - d4;
                break;
            }
            case 42: {
                d2 = d3 * d4;
                break;
            }
            case 47: {
                d2 = d3 / d4;
                break;
            }
            case 37: {
                d2 = d3 % d4;
                break;
            }
            default: {
                return null;
            }
        }
        return new DoubleConst(d2, right.type);
    }
}

