/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.tools.reflect;

import ai.h2o.javassist.ClassPool;
import ai.h2o.javassist.CtClass;
import ai.h2o.javassist.tools.reflect.CompiledClass;
import ai.h2o.javassist.tools.reflect.Reflection;
import java.io.PrintStream;

public class Compiler {
    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            Compiler.help(System.err);
            return;
        }
        CompiledClass[] compiledClassArray = new CompiledClass[args.length];
        int n2 = Compiler.parse(args, compiledClassArray);
        if (n2 <= 0) {
            System.err.println("bad parameter.");
            return;
        }
        Compiler.processClasses(compiledClassArray, n2);
    }

    private static void processClasses(CompiledClass[] entries, int n2) throws Exception {
        int n3;
        Reflection reflection = new Reflection();
        ClassPool classPool = ClassPool.getDefault();
        reflection.start(classPool);
        for (n3 = 0; n3 < n2; ++n3) {
            CtClass ctClass = classPool.get(entries[n3].classname);
            if (entries[n3].metaobject != null || entries[n3].classobject != null) {
                String string = entries[n3].metaobject == null ? "ai.h2o.javassist.tools.reflect.Metaobject" : entries[n3].metaobject;
                String string2 = entries[n3].classobject == null ? "ai.h2o.javassist.tools.reflect.ClassMetaobject" : entries[n3].classobject;
                if (!reflection.makeReflective(ctClass, classPool.get(string), classPool.get(string2))) {
                    System.err.println("Warning: " + ctClass.getName() + " is reflective.  It was not changed.");
                }
                System.err.println(ctClass.getName() + ": " + string + ", " + string2);
                continue;
            }
            System.err.println(ctClass.getName() + ": not reflective");
        }
        for (n3 = 0; n3 < n2; ++n3) {
            reflection.onLoad(classPool, entries[n3].classname);
            classPool.get(entries[n3].classname).writeFile();
        }
    }

    private static int parse(String[] args, CompiledClass[] result) {
        int n2 = -1;
        for (int i2 = 0; i2 < args.length; ++i2) {
            String string = args[i2];
            if (string.equals("-m")) {
                if (n2 < 0 || i2 + 1 > args.length) {
                    return -1;
                }
                result[n2].metaobject = args[++i2];
                continue;
            }
            if (string.equals("-c")) {
                if (n2 < 0 || i2 + 1 > args.length) {
                    return -1;
                }
                result[n2].classobject = args[++i2];
                continue;
            }
            if (string.charAt(0) == '-') {
                return -1;
            }
            CompiledClass compiledClass = new CompiledClass();
            new CompiledClass().classname = string;
            compiledClass.metaobject = null;
            compiledClass.classobject = null;
            result[++n2] = compiledClass;
        }
        return n2 + 1;
    }

    private static void help(PrintStream out) {
        out.println("Usage: java javassist.tools.reflect.Compiler");
        out.println("            (<class> [-m <metaobject>] [-c <class metaobject>])+");
    }
}

