/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.tools.rmi;

import ai.h2o.javassist.tools.rmi.ObjectNotFoundException;
import ai.h2o.javassist.tools.rmi.Proxy;
import ai.h2o.javassist.tools.rmi.RemoteException;
import ai.h2o.javassist.tools.rmi.RemoteRef;
import java.applet.Applet;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.net.Socket;
import java.net.URL;

public class ObjectImporter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final byte[] endofline = new byte[]{13, 10};
    private String servername;
    private String orgServername;
    private int port;
    private int orgPort;
    protected byte[] lookupCommand = "POST /lookup HTTP/1.0".getBytes();
    protected byte[] rmiCommand = "POST /rmi HTTP/1.0".getBytes();
    private static final Class<?>[] proxyConstructorParamTypes = new Class[]{ObjectImporter.class, Integer.TYPE};

    public ObjectImporter(Applet applet) {
        URL uRL = applet.getCodeBase();
        ObjectImporter objectImporter = this;
        objectImporter.orgServername = objectImporter.servername = uRL.getHost();
        ObjectImporter objectImporter2 = this;
        objectImporter2.orgPort = objectImporter2.port = uRL.getPort();
    }

    public ObjectImporter(String servername, int port) {
        ObjectImporter objectImporter = this;
        objectImporter.orgServername = objectImporter.servername = servername;
        ObjectImporter objectImporter2 = this;
        objectImporter2.orgPort = objectImporter2.port = port;
    }

    public Object getObject(String name) {
        try {
            return this.lookupObject(name);
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            return null;
        }
    }

    public void setHttpProxy(String host, int port) {
        String string = "POST http://" + this.orgServername + ":" + this.orgPort;
        String string2 = string + "/lookup HTTP/1.0";
        this.lookupCommand = string2.getBytes();
        string2 = string + "/rmi HTTP/1.0";
        this.rmiCommand = string2.getBytes();
        this.servername = host;
        this.port = port;
    }

    public Object lookupObject(String name) throws ObjectNotFoundException {
        try {
            Socket socket = new Socket(this.servername, this.port);
            OutputStream outputStream = socket.getOutputStream();
            outputStream.write(this.lookupCommand);
            outputStream.write(this.endofline);
            outputStream.write(this.endofline);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeUTF(name);
            objectOutputStream.flush();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(socket.getInputStream());
            this.skipHeader(bufferedInputStream);
            ObjectInputStream objectInputStream = new ObjectInputStream(bufferedInputStream);
            int n2 = objectInputStream.readInt();
            String string = objectInputStream.readUTF();
            objectInputStream.close();
            objectOutputStream.close();
            socket.close();
            if (n2 >= 0) {
                return this.createProxy(n2, string);
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            throw new ObjectNotFoundException(name, exception2);
        }
        throw new ObjectNotFoundException(name);
    }

    private Object createProxy(int oid, String classname) throws Exception {
        Class<?> clazz = Class.forName(classname);
        Constructor<?> constructor = clazz.getConstructor(proxyConstructorParamTypes);
        return constructor.newInstance(this, oid);
    }

    public Object call(int objectid, int methodid, Object[] args) throws RemoteException {
        String string;
        Object object;
        boolean bl;
        try {
            Socket socket = new Socket(this.servername, this.port);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(socket.getOutputStream());
            ((OutputStream)bufferedOutputStream).write(this.rmiCommand);
            ((OutputStream)bufferedOutputStream).write(this.endofline);
            ((OutputStream)bufferedOutputStream).write(this.endofline);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(bufferedOutputStream);
            objectOutputStream.writeInt(objectid);
            objectOutputStream.writeInt(methodid);
            this.writeParameters(objectOutputStream, args);
            objectOutputStream.flush();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(socket.getInputStream());
            this.skipHeader(bufferedInputStream);
            ObjectInputStream objectInputStream = new ObjectInputStream(bufferedInputStream);
            bl = objectInputStream.readBoolean();
            object = null;
            string = null;
            if (bl) {
                object = objectInputStream.readObject();
            } else {
                string = objectInputStream.readUTF();
            }
            objectInputStream.close();
            objectOutputStream.close();
            socket.close();
            if (object instanceof RemoteRef) {
                RemoteRef remoteRef = (RemoteRef)object;
                object = this.createProxy(remoteRef.oid, remoteRef.classname);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RemoteException(classNotFoundException);
        }
        catch (IOException iOException) {
            throw new RemoteException(iOException);
        }
        catch (Exception exception) {
            throw new RemoteException(exception);
        }
        if (bl) {
            return object;
        }
        throw new RemoteException(string);
    }

    private void skipHeader(InputStream in) throws IOException {
        int n2;
        do {
            int n3;
            n2 = 0;
            while ((n3 = in.read()) >= 0 && n3 != 13) {
                ++n2;
            }
            in.read();
        } while (n2 > 0);
    }

    private void writeParameters(ObjectOutputStream dout, Object[] params) throws IOException {
        int n2 = params.length;
        dout.writeInt(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (params[i2] instanceof Proxy) {
                Proxy proxy = (Proxy)params[i2];
                dout.writeObject(new RemoteRef(proxy._getObjectId()));
                continue;
            }
            dout.writeObject(params[i2]);
        }
    }
}

