/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.tools.web;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLConnection;

public class Viewer
extends ClassLoader {
    private String server;
    private int port;

    public static void main(String[] args) throws Throwable {
        if (args.length >= 3) {
            Viewer viewer = new Viewer(args[0], Integer.parseInt(args[1]));
            String[] stringArray = new String[args.length - 3];
            System.arraycopy(args, 3, stringArray, 0, args.length - 3);
            viewer.run(args[2], stringArray);
            return;
        }
        System.err.println("Usage: java javassist.tools.web.Viewer <host> <port> class [args ...]");
    }

    public Viewer(String host, int p2) {
        this.server = host;
        this.port = p2;
    }

    public String getServer() {
        return this.server;
    }

    public int getPort() {
        return this.port;
    }

    public void run(String classname, String[] args) throws Throwable {
        Class<?> clazz = this.loadClass(classname);
        try {
            clazz.getDeclaredMethod("main", String[].class).invoke(null, new Object[]{args});
            return;
        }
        catch (InvocationTargetException invocationTargetException) {
            InvocationTargetException invocationTargetException2 = invocationTargetException;
            throw invocationTargetException.getTargetException();
        }
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz = this.findLoadedClass(name);
        if (clazz == null) {
            clazz = this.findClass(name);
        }
        if (clazz == null) {
            throw new ClassNotFoundException(name);
        }
        if (resolve) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> clazz = null;
        if (name.startsWith("java.") || name.startsWith("javax.") || name.equals("ai.h2o.javassist.tools.web.Viewer")) {
            clazz = this.findSystemClass(name);
        }
        if (clazz == null) {
            try {
                byte[] byArray = this.fetchClass(name);
                if (byArray != null) {
                    clazz = this.defineClass(name, byArray, 0, byArray.length);
                }
            }
            catch (Exception exception) {}
        }
        return clazz;
    }

    protected byte[] fetchClass(String classname) throws Exception {
        byte[] byArray;
        URL uRL = new URL("http", this.server, this.port, "/" + classname.replace('.', '/') + ".class");
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.connect();
        int n2 = uRLConnection.getContentLength();
        InputStream inputStream = uRLConnection.getInputStream();
        if (n2 <= 0) {
            byArray = this.readStream(inputStream);
        } else {
            int n3;
            byArray = new byte[n2];
            int n4 = 0;
            do {
                if ((n3 = inputStream.read(byArray, n4, n2 - n4)) >= 0) continue;
                inputStream.close();
                throw new IOException("the stream was closed: " + classname);
            } while ((n4 += n3) < n2);
        }
        inputStream.close();
        return byArray;
    }

    private byte[] readStream(InputStream fin) throws IOException {
        byte[] byArray;
        byte[] byArray2 = new byte[4096];
        int n2 = 0;
        int n3 = 0;
        do {
            if (byArray2.length - (n2 += n3) > 0) continue;
            byArray = new byte[byArray2.length << 1];
            System.arraycopy(byArray2, 0, byArray, 0, n2);
            byArray2 = byArray;
        } while ((n3 = fin.read(byArray2, n2, byArray2.length - n2)) >= 0);
        byArray = new byte[n2];
        System.arraycopy(byArray2, 0, byArray, 0, n2);
        return byArray;
    }
}

