/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.util.proxy;

import ai.h2o.javassist.CannotCompileException;
import ai.h2o.javassist.bytecode.ClassFile;
import ai.h2o.javassist.util.proxy.SecurityActions;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;
import java.util.List;

public class DefineClassHelper {
    private static final Helper privileged = ClassFile.MAJOR_VERSION > 54 ? new Java11() : (ClassFile.MAJOR_VERSION >= 53 ? new Java9() : (ClassFile.MAJOR_VERSION >= 51 ? new Java7() : new JavaOther()));

    public static Class<?> toClass(String className, Class<?> neighbor, ClassLoader loader, ProtectionDomain domain, byte[] bcode) throws CannotCompileException {
        try {
            return privileged.defineClass(className, bcode, 0, bcode.length, neighbor, loader, domain);
        }
        catch (RuntimeException runtimeException) {
            RuntimeException runtimeException2 = runtimeException;
            throw runtimeException;
        }
        catch (CannotCompileException cannotCompileException) {
            CannotCompileException cannotCompileException2 = cannotCompileException;
            throw cannotCompileException;
        }
        catch (ClassFormatError classFormatError) {
            ClassFormatError classFormatError2 = classFormatError;
            Throwable throwable = classFormatError.getCause();
            throw new CannotCompileException(throwable == null ? classFormatError2 : throwable);
        }
        catch (Exception exception) {
            throw new CannotCompileException(exception);
        }
    }

    public static Class<?> toClass(Class<?> neighbor, byte[] bcode) throws CannotCompileException {
        try {
            DefineClassHelper.class.getModule().addReads(neighbor.getModule());
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            MethodHandles.Lookup lookup2 = MethodHandles.privateLookupIn(neighbor, lookup);
            return lookup2.defineClass(bcode);
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            throw new CannotCompileException(exception.getMessage() + ": " + neighbor.getName() + " has no permission to define the class");
        }
    }

    public static Class<?> toClass(MethodHandles.Lookup lookup, byte[] bcode) throws CannotCompileException {
        try {
            return lookup.defineClass(bcode);
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            throw new CannotCompileException(exception.getMessage());
        }
    }

    static Class<?> toPublicClass(String className, byte[] bcode) throws CannotCompileException {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            lookup = lookup.dropLookupMode(2);
            return lookup.defineClass(bcode);
        }
        catch (Throwable throwable) {
            throw new CannotCompileException(throwable);
        }
    }

    private DefineClassHelper() {
    }

    private static class JavaOther
    extends Helper {
        private final Method defineClass = this.getDefineClassMethod();
        private final SecurityActions stack = SecurityActions.stack;

        private JavaOther() {
        }

        private final Method getDefineClassMethod() {
            if (privileged != null && this.stack.getCallerClass() != this.getClass()) {
                throw new IllegalAccessError("Access denied for caller.");
            }
            try {
                return SecurityActions.getDeclaredMethod(ClassLoader.class, "defineClass", new Class[]{String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class});
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new RuntimeException("cannot initialize", noSuchMethodException);
            }
        }

        @Override
        Class<?> defineClass(String name, byte[] b2, int off, int len, Class<?> neighbor, ClassLoader loader, ProtectionDomain protectionDomain) throws ClassFormatError, CannotCompileException {
            Class<?> clazz = this.stack.getCallerClass();
            if (clazz != DefineClassHelper.class && clazz != this.getClass()) {
                throw new IllegalAccessError("Access denied for caller.");
            }
            try {
                SecurityActions.setAccessible(this.defineClass, true);
                return (Class)this.defineClass.invoke((Object)loader, name, b2, off, len, protectionDomain);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable instanceof ClassFormatError) {
                    throw (ClassFormatError)throwable2;
                }
                if (throwable2 instanceof RuntimeException) {
                    throw (RuntimeException)throwable2;
                }
                throw new CannotCompileException(throwable2);
            }
        }
    }

    private static class Java7
    extends Helper {
        private final SecurityActions stack = SecurityActions.stack;
        private final MethodHandle defineClass = this.getDefineClassMethodHandle();

        private Java7() {
        }

        private final MethodHandle getDefineClassMethodHandle() {
            if (privileged != null && this.stack.getCallerClass() != this.getClass()) {
                throw new IllegalAccessError("Access denied for caller.");
            }
            try {
                return SecurityActions.getMethodHandle(ClassLoader.class, "defineClass", new Class[]{String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class});
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new RuntimeException("cannot initialize", noSuchMethodException);
            }
        }

        @Override
        Class<?> defineClass(String name, byte[] b2, int off, int len, Class<?> neighbor, ClassLoader loader, ProtectionDomain protectionDomain) throws ClassFormatError {
            if (this.stack.getCallerClass() != DefineClassHelper.class) {
                throw new IllegalAccessError("Access denied for caller.");
            }
            try {
                return (Class)this.defineClass.invokeWithArguments(loader, name, b2, off, len, protectionDomain);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable2;
                }
                if (throwable2 instanceof ClassFormatError) {
                    throw (ClassFormatError)throwable2;
                }
                throw new ClassFormatError(throwable2.getMessage());
            }
        }
    }

    private static class Java9
    extends Helper {
        private final Object stack;
        private final Method getCallerClass;
        private final ReferencedUnsafe sunMiscUnsafe = this.getReferencedUnsafe();

        Java9() {
            Class<?> clazz = null;
            try {
                clazz = Class.forName("java.lang.StackWalker");
            }
            catch (ClassNotFoundException classNotFoundException) {}
            if (clazz != null) {
                try {
                    Class<?> clazz2 = Class.forName("java.lang.StackWalker$Option");
                    this.stack = clazz.getMethod("getInstance", clazz2).invoke(null, clazz2.getEnumConstants()[0]);
                    this.getCallerClass = clazz.getMethod("getCallerClass", new Class[0]);
                    return;
                }
                catch (Throwable throwable) {
                    throw new RuntimeException("cannot initialize", throwable);
                }
            }
            this.stack = null;
            this.getCallerClass = null;
        }

        private final ReferencedUnsafe getReferencedUnsafe() {
            try {
                if (privileged != null && this.getCallerClass.invoke(this.stack, new Object[0]) != this.getClass()) {
                    throw new IllegalAccessError("Access denied for caller.");
                }
            }
            catch (Exception exception) {
                throw new RuntimeException("cannot initialize", exception);
            }
            try {
                SecurityActions.TheUnsafe theUnsafe = SecurityActions.getSunMiscUnsafeAnonymously();
                List<Method> list = theUnsafe.methods.get("defineClass");
                if (list == null) {
                    return null;
                }
                MethodHandle methodHandle = MethodHandles.lookup().unreflect(list.get(0));
                return new ReferencedUnsafe(theUnsafe, methodHandle);
            }
            catch (Throwable throwable) {
                throw new RuntimeException("cannot initialize", throwable);
            }
        }

        @Override
        Class<?> defineClass(String name, byte[] b2, int off, int len, Class<?> neighbor, ClassLoader loader, ProtectionDomain protectionDomain) throws ClassFormatError {
            try {
                if (this.getCallerClass.invoke(this.stack, new Object[0]) != DefineClassHelper.class) {
                    throw new IllegalAccessError("Access denied for caller.");
                }
            }
            catch (Exception exception) {
                throw new RuntimeException("cannot initialize", exception);
            }
            return this.sunMiscUnsafe.defineClass(name, b2, off, len, loader, protectionDomain);
        }

        final class ReferencedUnsafe {
            private final SecurityActions.TheUnsafe sunMiscUnsafeTheUnsafe;
            private final MethodHandle defineClass;

            ReferencedUnsafe(SecurityActions.TheUnsafe usf, MethodHandle meth) {
                this.sunMiscUnsafeTheUnsafe = usf;
                this.defineClass = meth;
            }

            final Class<?> defineClass(String name, byte[] b2, int off, int len, ClassLoader loader, ProtectionDomain protectionDomain) throws ClassFormatError {
                try {
                    if (Java9.this.getCallerClass.invoke(Java9.this.stack, new Object[0]) != Java9.class) {
                        throw new IllegalAccessError("Access denied for caller.");
                    }
                }
                catch (Exception exception) {
                    throw new RuntimeException("cannot initialize", exception);
                }
                try {
                    return (Class)this.defineClass.invokeWithArguments(this.sunMiscUnsafeTheUnsafe.theUnsafe, name, b2, off, len, loader, protectionDomain);
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (throwable instanceof RuntimeException) {
                        throw (RuntimeException)throwable2;
                    }
                    if (throwable2 instanceof ClassFormatError) {
                        throw (ClassFormatError)throwable2;
                    }
                    throw new ClassFormatError(throwable2.getMessage());
                }
            }
        }
    }

    private static class Java11
    extends JavaOther {
        private Java11() {
        }

        @Override
        Class<?> defineClass(String name, byte[] bcode, int off, int len, Class<?> neighbor, ClassLoader loader, ProtectionDomain protectionDomain) throws ClassFormatError, CannotCompileException {
            if (neighbor != null) {
                return DefineClassHelper.toClass(neighbor, bcode);
            }
            return super.defineClass(name, bcode, off, len, neighbor, loader, protectionDomain);
        }
    }

    private static abstract class Helper {
        private Helper() {
        }

        abstract Class<?> defineClass(String var1, byte[] var2, int var3, int var4, Class<?> var5, ClassLoader var6, ProtectionDomain var7) throws ClassFormatError, CannotCompileException;
    }
}

