/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.util.proxy;

import ai.h2o.javassist.CannotCompileException;
import ai.h2o.javassist.bytecode.ClassFile;
import ai.h2o.javassist.util.proxy.DefineClassHelper;
import ai.h2o.javassist.util.proxy.ProxyFactory;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.security.ProtectionDomain;

public class FactoryHelper {
    public static final Class<?>[] primitiveTypes = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Void.TYPE};
    public static final String[] wrapperTypes = new String[]{"java.lang.Boolean", "java.lang.Byte", "java.lang.Character", "java.lang.Short", "java.lang.Integer", "java.lang.Long", "java.lang.Float", "java.lang.Double", "java.lang.Void"};
    public static final String[] wrapperDesc = new String[]{"(Z)V", "(B)V", "(C)V", "(S)V", "(I)V", "(J)V", "(F)V", "(D)V"};
    public static final String[] unwarpMethods = new String[]{"booleanValue", "byteValue", "charValue", "shortValue", "intValue", "longValue", "floatValue", "doubleValue"};
    public static final String[] unwrapDesc = new String[]{"()Z", "()B", "()C", "()S", "()I", "()J", "()F", "()D"};
    public static final int[] dataSize = new int[]{1, 1, 1, 1, 1, 2, 1, 2};

    public static final int typeIndex(Class<?> type) {
        for (int i2 = 0; i2 < primitiveTypes.length; ++i2) {
            if (primitiveTypes[i2] != type) continue;
            return i2;
        }
        throw new RuntimeException("bad type:" + type.getName());
    }

    public static Class<?> toClass(ClassFile cf, ClassLoader loader) throws CannotCompileException {
        return FactoryHelper.toClass(cf, null, loader, null);
    }

    public static Class<?> toClass(ClassFile cf, ClassLoader loader, ProtectionDomain domain) throws CannotCompileException {
        return FactoryHelper.toClass(cf, null, loader, domain);
    }

    public static Class<?> toClass(ClassFile cf, Class<?> neighbor, ClassLoader loader, ProtectionDomain domain) throws CannotCompileException {
        try {
            byte[] byArray = FactoryHelper.toBytecode(cf);
            if (ProxyFactory.onlyPublicMethods) {
                return DefineClassHelper.toPublicClass(cf.getName(), byArray);
            }
            return DefineClassHelper.toClass(cf.getName(), neighbor, loader, domain, byArray);
        }
        catch (IOException iOException) {
            throw new CannotCompileException(iOException);
        }
    }

    public static Class<?> toClass(ClassFile cf, MethodHandles.Lookup lookup) throws CannotCompileException {
        try {
            byte[] byArray = FactoryHelper.toBytecode(cf);
            return DefineClassHelper.toClass(lookup, byArray);
        }
        catch (IOException iOException) {
            throw new CannotCompileException(iOException);
        }
    }

    private static byte[] toBytecode(ClassFile cf) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);){
            cf.write(dataOutputStream);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static void writeFile(ClassFile cf, String directoryName) throws CannotCompileException {
        try {
            FactoryHelper.writeFile0(cf, directoryName);
            return;
        }
        catch (IOException iOException) {
            throw new CannotCompileException(iOException);
        }
    }

    private static void writeFile0(ClassFile cf, String directoryName) throws CannotCompileException, IOException {
        Object object;
        String string = cf.getName();
        String string2 = directoryName + File.separatorChar + string.replace('.', File.separatorChar) + ".class";
        int n2 = string2.lastIndexOf(File.separatorChar);
        if (n2 > 0 && !((String)(object = string2.substring(0, n2))).equals(".")) {
            new File((String)object).mkdirs();
        }
        object = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(string2)));
        try {
            cf.write((DataOutputStream)object);
            return;
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            throw iOException;
        }
        finally {
            ((FilterOutputStream)object).close();
        }
    }
}

