/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.util.proxy;

import ai.h2o.javassist.bytecode.ClassFile;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

class SecurityActions
extends SecurityManager {
    public static final SecurityActions stack = new SecurityActions();

    SecurityActions() {
    }

    public Class<?> getCallerClass() {
        return this.getClassContext()[2];
    }

    static Method[] getDeclaredMethods(final Class<?> clazz) {
        if (System.getSecurityManager() == null) {
            return clazz.getDeclaredMethods();
        }
        return AccessController.doPrivileged(new PrivilegedAction<Method[]>(){

            @Override
            public Method[] run() {
                return clazz.getDeclaredMethods();
            }
        });
    }

    static Constructor<?>[] getDeclaredConstructors(final Class<?> clazz) {
        if (System.getSecurityManager() == null) {
            return clazz.getDeclaredConstructors();
        }
        return AccessController.doPrivileged(new PrivilegedAction<Constructor<?>[]>(){

            @Override
            public Constructor<?>[] run() {
                return clazz.getDeclaredConstructors();
            }
        });
    }

    static MethodHandle getMethodHandle(final Class<?> clazz, final String name, final Class<?>[] params) throws NoSuchMethodException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<MethodHandle>(){

                @Override
                public MethodHandle run() throws IllegalAccessException, NoSuchMethodException, SecurityException {
                    Method method = clazz.getDeclaredMethod(name, params);
                    method.setAccessible(true);
                    MethodHandle methodHandle = MethodHandles.lookup().unreflect(method);
                    method.setAccessible(false);
                    return methodHandle;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            PrivilegedActionException privilegedActionException2 = privilegedActionException;
            if (privilegedActionException.getCause() instanceof NoSuchMethodException) {
                throw (NoSuchMethodException)privilegedActionException2.getCause();
            }
            throw new RuntimeException(privilegedActionException2.getCause());
        }
    }

    static Method getDeclaredMethod(final Class<?> clazz, final String name, final Class<?>[] types) throws NoSuchMethodException {
        if (System.getSecurityManager() == null) {
            return clazz.getDeclaredMethod(name, types);
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

                @Override
                public Method run() throws Exception {
                    return clazz.getDeclaredMethod(name, types);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            PrivilegedActionException privilegedActionException2 = privilegedActionException;
            if (privilegedActionException.getCause() instanceof NoSuchMethodException) {
                throw (NoSuchMethodException)privilegedActionException2.getCause();
            }
            throw new RuntimeException(privilegedActionException2.getCause());
        }
    }

    static Constructor<?> getDeclaredConstructor(final Class<?> clazz, final Class<?>[] types) throws NoSuchMethodException {
        if (System.getSecurityManager() == null) {
            return clazz.getDeclaredConstructor(types);
        }
        try {
            return (Constructor)AccessController.doPrivileged(new PrivilegedExceptionAction<Constructor<?>>(){

                @Override
                public Constructor<?> run() throws Exception {
                    return clazz.getDeclaredConstructor(types);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            PrivilegedActionException privilegedActionException2 = privilegedActionException;
            if (privilegedActionException.getCause() instanceof NoSuchMethodException) {
                throw (NoSuchMethodException)privilegedActionException2.getCause();
            }
            throw new RuntimeException(privilegedActionException2.getCause());
        }
    }

    static void setAccessible(final AccessibleObject ao, final boolean accessible) {
        if (System.getSecurityManager() == null) {
            ao.setAccessible(accessible);
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                ao.setAccessible(accessible);
                return null;
            }
        });
    }

    static void set(final Field fld, final Object target, final Object value) throws IllegalAccessException {
        if (System.getSecurityManager() == null) {
            fld.set(target, value);
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    fld.set(target, value);
                    return null;
                }
            });
            return;
        }
        catch (PrivilegedActionException privilegedActionException) {
            PrivilegedActionException privilegedActionException2 = privilegedActionException;
            if (privilegedActionException.getCause() instanceof NoSuchMethodException) {
                throw (IllegalAccessException)privilegedActionException2.getCause();
            }
            throw new RuntimeException(privilegedActionException2.getCause());
        }
    }

    static TheUnsafe getSunMiscUnsafeAnonymously() throws ClassNotFoundException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<TheUnsafe>(){

                @Override
                public TheUnsafe run() throws ClassNotFoundException, NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
                    Class<?> clazz = Class.forName("sun.misc.Unsafe");
                    Field field = clazz.getDeclaredField("theUnsafe");
                    field.setAccessible(true);
                    SecurityActions securityActions = stack;
                    Objects.requireNonNull(securityActions);
                    TheUnsafe theUnsafe = securityActions.new TheUnsafe(clazz, field.get(null));
                    field.setAccessible(false);
                    SecurityActions.disableWarning(theUnsafe);
                    return theUnsafe;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            PrivilegedActionException privilegedActionException2 = privilegedActionException;
            if (privilegedActionException.getCause() instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)privilegedActionException2.getCause();
            }
            if (privilegedActionException2.getCause() instanceof NoSuchFieldException) {
                throw new ClassNotFoundException("No such instance.", privilegedActionException2.getCause());
            }
            if (privilegedActionException2.getCause() instanceof IllegalAccessException || privilegedActionException2.getCause() instanceof IllegalAccessException || privilegedActionException2.getCause() instanceof SecurityException) {
                throw new ClassNotFoundException("Security denied access.", privilegedActionException2.getCause());
            }
            throw new RuntimeException(privilegedActionException2.getCause());
        }
    }

    static void disableWarning(TheUnsafe tu) {
        try {
            if (ClassFile.MAJOR_VERSION < 53) {
                return;
            }
            Class<?> clazz = Class.forName("jdk.internal.module.IllegalAccessLogger");
            Field field = clazz.getDeclaredField("logger");
            tu.call("putObjectVolatile", clazz, tu.call("staticFieldOffset", field), null);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    class TheUnsafe {
        final Class<?> unsafe;
        final Object theUnsafe;
        final Map<String, List<Method>> methods = new HashMap<String, List<Method>>();

        TheUnsafe(Class<?> c2, Object o2) {
            this.unsafe = c2;
            this.theUnsafe = o2;
            for (Method method : this.unsafe.getDeclaredMethods()) {
                if (!this.methods.containsKey(method.getName())) {
                    this.methods.put(method.getName(), Collections.singletonList(method));
                    continue;
                }
                if (this.methods.get(method.getName()).size() == 1) {
                    this.methods.put(method.getName(), new ArrayList(this.methods.get(method.getName())));
                }
                this.methods.get(method.getName()).add(method);
            }
        }

        private Method getM(String name, Object[] o2) {
            return this.methods.get(name).get(0);
        }

        public Object call(String name, Object ... args) {
            try {
                return this.getM(name, args).invoke(this.theUnsafe, args);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                throwable.printStackTrace();
                return null;
            }
        }
    }
}

