/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime;

import ai.h2o.mojos.runtime.MojoPipeline;
import ai.h2o.mojos.runtime.PipelineWiring;
import ai.h2o.mojos.runtime.ShapBlender;
import ai.h2o.mojos.runtime.api.BasePipelineListener;
import ai.h2o.mojos.runtime.api.MojoColumnMeta;
import ai.h2o.mojos.runtime.frame.MojoColumn;
import ai.h2o.mojos.runtime.frame.MojoColumnFactoryImpl;
import ai.h2o.mojos.runtime.frame.MojoFrame;
import ai.h2o.mojos.runtime.frame.MojoFrameBuilder;
import ai.h2o.mojos.runtime.frame.MojoFrameMeta;
import ai.h2o.mojos.runtime.frame.StringConverter;
import ai.h2o.mojos.runtime.frame.StringToDateConverter;
import ai.h2o.mojos.runtime.transforms.MojoTransform;
import ai.h2o.mojos.runtime.transforms.MojoTransformExecPipeBuilder;
import ai.h2o.mojos.runtime.transforms.a;
import ai.h2o.mojos.runtime.utils.ArrayReaderUtils;
import ai.h2o.mojos.runtime.utils.DateParser;
import ai.h2o.mojos.runtime.utils.MojoDateTimeParserFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MojoPipelineProtoImpl
extends MojoPipeline {
    private static final Logger log = LoggerFactory.getLogger(MojoPipelineProtoImpl.class);
    private final List<MojoColumnMeta> globalColumns;
    private final MojoTransformExecPipeBuilder root;
    private BasePipelineListener listener = BasePipelineListener.NOOP;
    private final Map<String, StringConverter> dateTimeConverters = new HashMap<String, StringConverter>(0);
    private boolean shapEnabled = false;
    private AllocatedBuffers allocatedBuffers;
    private boolean shapOriginal;

    public MojoPipelineProtoImpl(List<MojoColumnMeta> globalColumns, MojoTransformExecPipeBuilder root) {
        super(root.pipelineMeta.uuid, root.pipelineMeta.creationTime, root.pipelineMeta.license);
        this.root = root;
        this.globalColumns = globalColumns;
        if (root.pipelineMeta.datetimeStringFormats != null) {
            for (Map.Entry<String, String> entry : root.pipelineMeta.datetimeStringFormats.entrySet()) {
                DateParser dateParser = new DateParser(MojoDateTimeParserFactory.forPattern(entry.getValue(), false));
                this.dateTimeConverters.put(entry.getKey(), new StringToDateConverter(dateParser));
            }
        }
    }

    @Override
    protected MojoFrameBuilder getFrameBuilder(MojoColumn.Kind kind) {
        return new MojoFrameBuilder(this.getMeta(kind), Arrays.asList(this.root.pipelineMeta.missingValues), this.dateTimeConverters);
    }

    @Override
    protected MojoFrameMeta getMeta(MojoColumn.Kind kind) {
        switch (kind) {
            case Feature: {
                return this.buffers().inputFrameMeta;
            }
            case Output: {
                return this.buffers().outputFrameMeta;
            }
        }
        throw new UnsupportedOperationException("Cannot generate meta for interim frame");
    }

    MojoFrame constructGlobalFrame(MojoFrame inputFrame, MojoFrame outputFrame) {
        ArrayList<MojoColumn> arrayList = new ArrayList<MojoColumn>();
        MojoFrameMeta mojoFrameMeta = inputFrame.getMeta();
        MojoFrameMeta mojoFrameMeta2 = outputFrame.getMeta();
        ArrayList<MojoColumnMeta> arrayList2 = new ArrayList<MojoColumnMeta>(this.globalColumns);
        int n2 = inputFrame.getNrows();
        MojoColumnFactoryImpl mojoColumnFactoryImpl = new MojoColumnFactoryImpl();
        for (MojoColumnMeta mojoColumnMeta : arrayList2) {
            Integer n3 = mojoFrameMeta.indexOf(mojoColumnMeta);
            if (n3 != null) {
                arrayList.add(inputFrame.getColumn(n3));
                continue;
            }
            Integer n4 = mojoFrameMeta2.indexOf(mojoColumnMeta);
            if (n4 != null) {
                arrayList.add(outputFrame.getColumn(n4));
                continue;
            }
            MojoColumn mojoColumn = mojoColumnFactoryImpl.create(mojoColumnMeta.getColumnType(), n2);
            arrayList.add(mojoColumn);
        }
        return MojoFrameBuilder.fromColumns(this.buffers().globalMeta, arrayList.toArray(new MojoColumn[0]));
    }

    @Override
    public MojoFrame transform(MojoFrame inputFrame, MojoFrame outputFrame) {
        assert (outputFrame.getNcols() > 0);
        MojoFrame mojoFrame = this.constructGlobalFrame(inputFrame, outputFrame);
        this.listener.onBatchStart(mojoFrame, this.root.iindices);
        AllocatedBuffers allocatedBuffers = this.buffers();
        for (MojoTransform mojoTransform : allocatedBuffers.wiring.transformsFlattened) {
            this.listener.onTransformHead(mojoTransform);
            mojoTransform.transform(mojoFrame);
            this.listener.onTransformResult(mojoTransform);
        }
        if (this.shapEnabled) {
            for (MojoTransform mojoTransform : allocatedBuffers.wiring.shapTransforms) {
                allocatedBuffers.shapBlender.computeShap(mojoFrame, mojoTransform);
            }
        }
        this.listener.onBatchEnd();
        return outputFrame;
    }

    @Override
    public void setShapPredictContrib(boolean enable) {
        if (enable == this.shapEnabled) {
            return;
        }
        if (this.allocatedBuffers != null) {
            throw new IllegalStateException("Cannot change SHAP flag after internal buffers have been allocated");
        }
        this.shapEnabled = enable;
    }

    @Override
    public void setShapPredictContribOriginal(boolean enable) {
        this.setShapPredictContrib(true);
        if (enable == this.shapOriginal) {
            return;
        }
        this.shapOriginal = true;
    }

    @Override
    public void setListener(BasePipelineListener listener) {
        this.listener = listener;
    }

    private synchronized AllocatedBuffers buffers() {
        if (this.allocatedBuffers == null) {
            log.trace("Allocating buffers");
            this.allocatedBuffers = new AllocatedBuffers();
        }
        return this.allocatedBuffers;
    }

    private class AllocatedBuffers {
        final MojoFrameMeta globalMeta;
        final PipelineWiring wiring;
        final MojoFrameMeta inputFrameMeta;
        final MojoFrameMeta outputFrameMeta;
        final ShapBlender shapBlender;

        public AllocatedBuffers() {
            int[] nArray;
            this.wiring = new PipelineWiring(MojoPipelineProtoImpl.this.globalColumns, MojoPipelineProtoImpl.this.root);
            this.wiring.reportPrematureTraversals();
            if (!MojoPipelineProtoImpl.this.shapEnabled) {
                nArray = ((MojoPipelineProtoImpl)MojoPipelineProtoImpl.this).root.oindices;
                this.shapBlender = null;
            } else {
                if (this.wiring.isTreeMetalearner()) {
                    throw new UnsupportedOperationException("Computing SHAP contributions is not supported for pipelines with tree metalearner");
                }
                this.shapBlender = new ShapBlender(MojoPipelineProtoImpl.this.globalColumns, MojoPipelineProtoImpl.this.root, MojoPipelineProtoImpl.this.shapOriginal);
                Set<Integer> set = this.shapBlender.prepareShapColumns(this.wiring);
                nArray = ArrayReaderUtils.fromIntegerListToArray(set);
            }
            this.globalMeta = new MojoFrameMeta(MojoPipelineProtoImpl.this.globalColumns);
            this.outputFrameMeta = this.globalMeta.subFrame(nArray);
            if (this.outputFrameMeta.size() == 0) {
                throw new IllegalStateException("No columns in output frame");
            }
            this.inputFrameMeta = this.globalMeta.subFrame(((MojoPipelineProtoImpl)MojoPipelineProtoImpl.this).root.iindices);
            ((MojoPipelineProtoImpl)MojoPipelineProtoImpl.this).root.pipelineMeta.consistencyChecks(this.globalMeta);
            for (MojoTransform mojoTransform : this.wiring.transformsFlattened) {
                if (!(mojoTransform instanceof a)) continue;
                log.trace("Steps are traceable in {}", (Object)mojoTransform);
                a a2 = (a)((Object)mojoTransform);
                a2.a(MojoPipelineProtoImpl.this.listener);
            }
        }
    }
}

