/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime.api;

import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MojoTransformationGroup {
    private static final Logger log = LoggerFactory.getLogger(MojoTransformationGroup.class);
    private final String id;
    private final String name;

    public MojoTransformationGroup(String id, String name) {
        this.id = id;
        this.name = name;
    }

    public static MojoTransformationGroup findGroup(Map<String, MojoTransformationGroup> groups, String groupId) {
        if (groupId == null) {
            return null;
        }
        MojoTransformationGroup mojoTransformationGroup = groups.get(groupId);
        if (mojoTransformationGroup == null) {
            log.warn("Undefined group ID: {}", (Object)groupId);
            mojoTransformationGroup = new MojoTransformationGroup(groupId, String.format("#undefined#%s", groupId));
            groups.put(groupId, mojoTransformationGroup);
        }
        return mojoTransformationGroup;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        MojoTransformationGroup mojoTransformationGroup = (MojoTransformationGroup)o2;
        return this.id == mojoTransformationGroup.id;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return String.format("G:%s{%s}", this.id, this.name);
    }
}

