/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime.frame;

import ai.h2o.mojos.runtime.api.MojoColumnMeta;
import ai.h2o.mojos.runtime.frame.MojoColumn;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class MojoFrameMeta
implements Serializable {
    private final List<MojoColumnMeta> columns;
    private final Map<String, Integer> columnNameToIndex = new LinkedHashMap<String, Integer>();
    private final Map<MojoColumnMeta, Integer> columnToIndex = new LinkedHashMap<MojoColumnMeta, Integer>();

    @Deprecated
    public MojoFrameMeta(String[] names, MojoColumn.Type[] types) {
        this(MojoColumnMeta.toColumns(names, types, MojoColumn.Kind.Output));
    }

    public MojoFrameMeta(List<MojoColumnMeta> columns) {
        this.columns = columns;
        int n2 = 0;
        for (MojoColumnMeta mojoColumnMeta : columns) {
            this.columnNameToIndex.put(mojoColumnMeta.getColumnName(), n2);
            this.columnToIndex.put(mojoColumnMeta, n2);
            ++n2;
        }
    }

    public MojoFrameMeta(List<MojoColumnMeta> columns, Collection<Integer> indices) {
        this.columns = columns;
        for (int n2 : indices) {
            this.columnNameToIndex.put(columns.get(n2).getColumnName(), n2);
        }
    }

    public MojoFrameMeta subFrame(int[] indices) {
        ArrayList<MojoColumnMeta> arrayList = new ArrayList<MojoColumnMeta>();
        int[] nArray = indices;
        int n2 = indices.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = nArray[i2];
            arrayList.add(this.getColumns().get(n3));
        }
        return new MojoFrameMeta(arrayList);
    }

    public static MojoFrameMeta getEmpty() {
        return new MojoFrameMeta(Collections.emptyList());
    }

    public int getColumnIndex(String columnName) {
        Integer n2 = this.columnNameToIndex.get(columnName);
        if (n2 == null) {
            throw new IllegalArgumentException(String.format("Column '%s' was not found in this frame with %d columns.", columnName, this.size()));
        }
        return n2;
    }

    @Deprecated
    public Integer indexOf(String columnName) {
        return this.columnNameToIndex.get(columnName);
    }

    public Integer indexOf(MojoColumnMeta column) {
        return this.columnToIndex.get(column);
    }

    public String getColumnName(int index) {
        return this.columns.get(index).getColumnName();
    }

    public MojoColumn.Type getColumnType(int index) {
        return this.columns.get(index).getColumnType();
    }

    public MojoColumn.Type getColumnType(String columnName) {
        MojoFrameMeta mojoFrameMeta = this;
        return mojoFrameMeta.getColumnType(mojoFrameMeta.getColumnIndex(columnName));
    }

    public boolean contains(String columnName) {
        return this.columnNameToIndex.containsKey(columnName);
    }

    public int size() {
        return this.columns.size();
    }

    protected Map<String, Integer> getColumnNamesMap() {
        return this.columnNameToIndex;
    }

    @Deprecated
    public String[] getColumnNames() {
        return this.columnNameToIndex.keySet().toArray(new String[0]);
    }

    @Deprecated
    public MojoColumn.Type[] getColumnTypes() {
        MojoColumn.Type[] typeArray = new MojoColumn.Type[this.columns.size()];
        for (int i2 = 0; i2 < typeArray.length; ++i2) {
            typeArray[i2] = this.columns.get(i2).getColumnType();
        }
        return typeArray;
    }

    public List<MojoColumnMeta> getColumns() {
        return this.columns;
    }

    public String toString() {
        return MojoFrameMeta.niceToString(this.columns);
    }

    static String niceToString(List<MojoColumnMeta> columns) {
        StringBuilder stringBuilder = new StringBuilder("MojoFrameMeta{cols:");
        stringBuilder.append(columns.size());
        LinkedHashMap<String, Integer> linkedHashMap = new LinkedHashMap<String, Integer>();
        for (MojoColumnMeta object : columns) {
            String string;
            Integer n2 = (Integer)linkedHashMap.get(string = object.getColumnType().toString());
            linkedHashMap.put(string, n2 == null ? 1 : n2 + 1);
        }
        int n3 = 59;
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            stringBuilder.append(String.format("%s%dx%s", Character.valueOf((char)n3), entry.getValue(), entry.getKey()));
            n3 = 44;
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public static String debugIndicesToNames(List<MojoColumnMeta> columns, int[] indices) {
        return Arrays.stream(indices).mapToObj(index -> {
            if (index < columns.size()) {
                return ((MojoColumnMeta)columns.get(index)).getColumnName();
            }
            return "IndexTooBig(" + index + ")";
        }).collect(Collectors.joining(","));
    }

    public static String debugIndicesToNames(List<MojoColumnMeta> columns, Collection<Integer> indices) {
        return indices.stream().map(index -> {
            if (index < columns.size()) {
                return ((MojoColumnMeta)columns.get((int)index)).getColumnName();
            }
            return "IndexTooBig(" + index + ")";
        }).collect(Collectors.joining(","));
    }

    public String debugIndicesToNames(int[] indices) {
        return MojoFrameMeta.debugIndicesToNames(this.columns, indices);
    }
}

