/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime.h2o3;

import ai.h2o.mojos.runtime.AbstractPipelineLoader;
import ai.h2o.mojos.runtime.MojoPipeline;
import ai.h2o.mojos.runtime.MojoPipelineMeta;
import ai.h2o.mojos.runtime.MojoPipelineProtoImpl;
import ai.h2o.mojos.runtime.api.MojoColumnMeta;
import ai.h2o.mojos.runtime.api.MojoTransformMeta;
import ai.h2o.mojos.runtime.api.backend.ReaderBackend;
import ai.h2o.mojos.runtime.frame.MojoColumn;
import ai.h2o.mojos.runtime.frame.MojoFrameMeta;
import ai.h2o.mojos.runtime.h2o3.H2O3BackendAdapter;
import ai.h2o.mojos.runtime.h2o3.H2O3Transform;
import ai.h2o.mojos.runtime.transforms.MojoTransformExecPipeBuilder;
import hex.genmodel.GenModel;
import hex.genmodel.MojoModel;
import hex.genmodel.easy.EasyPredictModelWrapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;

class H2O3PipelineLoader
extends AbstractPipelineLoader {
    private final List<MojoColumnMeta> globalColumns;
    private final MojoTransformExecPipeBuilder root;

    public H2O3PipelineLoader(ReaderBackend backend) throws IOException {
        super(backend);
        H2O3BackendAdapter h2O3BackendAdapter = new H2O3BackendAdapter(backend);
        MojoModel mojoModel = MojoModel.load(h2O3BackendAdapter);
        EasyPredictModelWrapper easyPredictModelWrapper = H2O3PipelineLoader.wrapModelForPrediction(mojoModel);
        String string = "h2o3:" + mojoModel.getModelCategory().toString();
        this.globalColumns = new ArrayList<MojoColumnMeta>();
        int[] nArray = H2O3PipelineLoader.readInputIndices(this.globalColumns, mojoModel);
        int[] nArray2 = H2O3PipelineLoader.readOutputIndices(this.globalColumns, mojoModel);
        MojoFrameMeta mojoFrameMeta = new MojoFrameMeta(this.globalColumns);
        H2O3Transform h2O3Transform = new H2O3Transform(mojoFrameMeta, nArray, nArray2, easyPredictModelWrapper);
        h2O3Transform.setId("h2o3-main");
        h2O3Transform.setName(string);
        DateTime dateTime = new DateTime(1970, 1, 1, 0, 0);
        MojoPipelineMeta mojoPipelineMeta = new MojoPipelineMeta(mojoModel.getUUID(), dateTime);
        new MojoPipelineMeta(mojoModel.getUUID(), dateTime).license = "H2O-3 Opensource";
        this.root = new MojoTransformExecPipeBuilder(mojoFrameMeta, nArray, nArray2, h2O3Transform, mojoPipelineMeta);
        this.root.transforms.add(h2O3Transform);
    }

    static int[] readInputIndices(List<MojoColumnMeta> columns, GenModel genModel) {
        int[] nArray = new int[genModel.getNumCols()];
        for (int i2 = 0; i2 < genModel.getNumCols(); ++i2) {
            String string = genModel.getNames()[i2];
            MojoColumn.Type type = genModel.getDomainValues(i2) == null ? MojoColumn.Type.Float64 : MojoColumn.Type.Str;
            nArray[i2] = columns.size();
            columns.add(MojoColumnMeta.create(string, type));
        }
        return nArray;
    }

    private static int[] readOutputIndices(List<MojoColumnMeta> columns, GenModel genModel) {
        switch (genModel.getModelCategory()) {
            case Binomial: 
            case Multinomial: {
                int[] nArray = new int[genModel.getNumResponseClasses()];
                for (int i2 = 0; i2 < genModel.getNumResponseClasses(); ++i2) {
                    GenModel genModel2 = genModel;
                    String string = genModel.getResponseName() + "." + genModel2.getDomainValues(genModel2.getResponseIdx())[i2];
                    nArray[i2] = columns.size();
                    columns.add(MojoColumnMeta.create(string, MojoColumn.Type.Float64));
                }
                return nArray;
            }
            case Regression: {
                MojoColumnMeta mojoColumnMeta = MojoColumnMeta.create(genModel.getResponseName(), MojoColumn.Type.Float64);
                int[] nArray = new int[]{columns.size()};
                columns.add(mojoColumnMeta);
                return nArray;
            }
        }
        throw new UnsupportedOperationException("Unsupported ModelCategory: " + genModel.getModelCategory().toString());
    }

    @Override
    public List<MojoColumnMeta> getColumns() {
        return this.globalColumns;
    }

    @Override
    public List<MojoTransformMeta> getTransformations() {
        return this.root.metaTransforms;
    }

    @Override
    protected final MojoPipeline internalLoad() {
        return new MojoPipelineProtoImpl(this.globalColumns, this.root);
    }

    static EasyPredictModelWrapper wrapModelForPrediction(MojoModel model) {
        EasyPredictModelWrapper.Config config = new EasyPredictModelWrapper.Config().setModel(model).setConvertUnknownCategoricalLevelsToNa(true).setConvertInvalidNumbersToNa(true);
        return new EasyPredictModelWrapper(config);
    }
}

