/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime.utils;

import ai.h2o.mojos.runtime.MojoPipeline;
import ai.h2o.mojos.runtime.api.MojoColumnMeta;
import ai.h2o.mojos.runtime.frame.MojoFrame;
import ai.h2o.mojos.runtime.frame.MojoFrameBuilder;
import ai.h2o.mojos.runtime.frame.MojoRowBuilder;
import ai.h2o.mojos.runtime.utils.BatchedCsvMojoProcessor;
import ai.h2o.mojos.runtime.utils.Consts;
import ai.h2o.mojos.runtime.utils.CsvProcessingConfig;
import com.opencsv.CSVReader;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchedCsvReader
implements Iterable<MojoFrame>,
Iterator<MojoFrame> {
    private static final Logger log = LoggerFactory.getLogger(BatchedCsvReader.class);
    private static final boolean STRIP_CR_FROM_LAST_COLUMN = Consts.getSysProp("parser.csv.stripCrFromLastColumn", true);
    private final Iterator<String[]> csvReaderIter;
    private final int batchSize;
    private final MojoPipeline pipeline;
    private final int[] csvIndexByMojoIndex;
    private final CsvProcessingConfig config;
    private int csvColumnCount = -1;
    private long totalDataRows = 0L;
    private boolean hasNext = true;
    private static final Pattern BY_CSV_INDEX = Pattern.compile("@(\\d+)");

    public BatchedCsvReader(MojoPipeline pipeline, CSVReader csvReader, int batchSize, CsvProcessingConfig config) {
        this.csvReaderIter = csvReader.iterator();
        this.batchSize = batchSize;
        this.pipeline = pipeline;
        this.config = config;
        List<MojoColumnMeta> list = pipeline.getInputMeta().getColumns();
        this.csvIndexByMojoIndex = new int[list.size()];
        if (config.headersMissing) {
            int n2 = 0;
            for (MojoColumnMeta mojoColumnMeta : list) {
                String string = mojoColumnMeta.getColumnName();
                String string2 = config.headersMap.get(string);
                int n3 = string2 == null ? n2 : this.csvParseColumnRef(string2);
                log.debug("Mojo column '{}':{} := CSV[{}]", new Object[]{string, mojoColumnMeta.getColumnType(), n3});
                this.csvIndexByMojoIndex[n2] = n3;
                ++n2;
            }
            return;
        }
        String[] stringArray = this.csvReaderIter.next();
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        Map<String, Integer> map = BatchedCsvReader.createCsvIndexLookup(config, stringArray, linkedHashSet);
        if (!linkedHashSet.isEmpty()) {
            log.warn("Duplicate CSV column names detected [{}]: {}", (Object)linkedHashSet.size(), (Object)linkedHashSet);
            log.warn("This is a serious error, however it might be tolerated - if these columns are unused. Still, you really SHOULD fix it.");
        }
        int n4 = 0;
        for (MojoColumnMeta mojoColumnMeta : list) {
            Integer n5;
            String string = mojoColumnMeta.getColumnName();
            if (linkedHashSet.contains(string)) {
                throw new UnsupportedOperationException(String.format("Model requires a CSV column that happens to be duplicate in your input: '%s'. Please check above log messages and fix the CSV file accordingly.", string));
            }
            String string3 = config.headersMap.get(string);
            if (string3 != null) {
                string3 = this.csvParseColumnRef(string3, stringArray);
            }
            if (string3 == null) {
                string3 = string;
                n5 = config.headersIgnoreCase ? map.get(string.toUpperCase()) : map.get(string);
            } else {
                n5 = map.get(string3);
            }
            if (n5 == null) {
                throw new IllegalArgumentException(String.format("CSV column named '%s' is required but it is not present in input data", string3 == null ? string : string3));
            }
            log.debug("Mojo column '{}':{} := CSV[{}]'{}'", new Object[]{string, mojoColumnMeta.getColumnType(), n5, stringArray[n5]});
            this.csvIndexByMojoIndex[n4] = n5;
            ++n4;
        }
        this.csvColumnCount = stringArray.length;
    }

    private static Map<String, Integer> createCsvIndexLookup(CsvProcessingConfig config, String[] csvHeaders, Set<String> duplicateColumns) {
        LinkedHashMap<String, Integer> linkedHashMap = new LinkedHashMap<String, Integer>();
        int n2 = 0;
        String[] stringArray = csvHeaders;
        int n3 = csvHeaders.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            String string = stringArray[i2];
            String string2 = string == null ? "" : string.trim();
            linkedHashMap.put("@" + n2, n2);
            Integer n4 = linkedHashMap.put(string2, n2);
            if (n4 != null) {
                log.error(String.format("CSV file has multiple columns named '%s' - check column #%d and #%d (zero based)", string2, n4, n2));
                duplicateColumns.add(string2);
            }
            if (config.headersIgnoreCase) {
                linkedHashMap.put(string2.toUpperCase(), n2);
            }
            ++n2;
        }
        return linkedHashMap;
    }

    private String csvParseColumnRef(String csvColumnRef, String[] csvHeaders) {
        Matcher matcher = BY_CSV_INDEX.matcher(csvColumnRef);
        if (!matcher.matches()) {
            return csvColumnRef;
        }
        String string = matcher.group(1);
        int n2 = Integer.parseInt(string);
        if (n2 >= csvHeaders.length) {
            throw new IllegalArgumentException(String.format("Column mapping references too high index(%s); there is only %d headers", csvColumnRef, csvHeaders.length));
        }
        return csvHeaders[n2];
    }

    private int csvParseColumnRef(String csvColumnRef) {
        Matcher matcher = BY_CSV_INDEX.matcher(csvColumnRef);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(String.format("Column must be referenced by index, because header row is not present: '%s'", csvColumnRef));
        }
        String string = matcher.group(1);
        return Integer.parseInt(string);
    }

    public long getTotalDataRows() {
        return this.totalDataRows;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public MojoFrame next() {
        if (!this.hasNext) {
            throw new NoSuchElementException(String.format("No more data after reading %d rows", this.totalDataRows));
        }
        MojoFrameBuilder mojoFrameBuilder = this.pipeline.getInputFrameBuilder();
        List<MojoColumnMeta> list = this.pipeline.getInputMeta().getColumns();
        int n2 = this.csvIndexByMojoIndex.length;
        int n3 = 0;
        MojoRowBuilder mojoRowBuilder = mojoFrameBuilder.getMojoRowBuilder();
        while (this.csvReaderIter.hasNext()) {
            String[] stringArray = this.csvReaderIter.next();
            if (stringArray.length != this.csvColumnCount) {
                if (this.csvColumnCount < 0) {
                    this.csvColumnCount = stringArray.length;
                } else {
                    throw new IllegalArgumentException(String.format("Invalid CSV data: row #%d (in current batch) has %d columns but we expect %d columns", this.totalDataRows, stringArray.length, this.csvColumnCount));
                }
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                int n4 = this.csvIndexByMojoIndex[i2];
                String string = STRIP_CR_FROM_LAST_COLUMN && n4 == n2 - 1 ? BatchedCsvMojoProcessor.stripCrFromEol(stringArray[n4]) : stringArray[n4];
                try {
                    log.trace("mojocol#{} ['{}'] := {}", i2, list.get(i2).getColumnName(), string);
                    mojoRowBuilder.setValue(i2, string);
                    continue;
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException(String.format("Data parsing problem at row=%d and column=%d (0-based indices, header skipped): %s", this.totalDataRows, i2, exception.getMessage()), exception);
                }
            }
            mojoRowBuilder = mojoFrameBuilder.addRow(mojoRowBuilder);
            ++this.totalDataRows;
            if (++n3 < this.batchSize) continue;
        }
        this.hasNext = this.csvReaderIter.hasNext();
        return mojoFrameBuilder.toMojoFrame();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    @Override
    public Iterator<MojoFrame> iterator() {
        return this;
    }
}

