/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime.utils;

import ai.h2o.mojos.runtime.utils.Consts;

public class ClassLoaderUtils {
    public static final String PROP_USE_CONTEXT_CLASSLOADER_FOR_SPI = "runtime.useContextClassloaderForSpi";
    public static final String PROP_USE_CONTEXT_CLASSLOADER_FOR_JAVASSIST = "runtime.useContextClassloaderForJavassist";
    public static final boolean DEFAULT_USE_CONTEXT_CLASSLOADER_FOR_SPI = false;
    public static final boolean DEFAULT_USE_CONTEXT_CLASSLOADER_FOR_JAVASSIST = false;

    static boolean getPropUseContextClassloaderForSpi() {
        return Consts.getSysProp(PROP_USE_CONTEXT_CLASSLOADER_FOR_SPI, false);
    }

    static boolean getPropUseContextClassloaderForJavassist() {
        return Consts.getSysProp(PROP_USE_CONTEXT_CLASSLOADER_FOR_JAVASSIST, false);
    }

    public static ClassLoader getPreferredSpiClassLoader(Class<?> usedClass) {
        ClassLoader classLoader = ClassLoaderUtils.getPropUseContextClassloaderForSpi() ? Thread.currentThread().getContextClassLoader() : usedClass.getClassLoader();
        return classLoader;
    }

    public static ClassLoader getPreferredJavassistClassLoader(Class<?> usedClass) {
        ClassLoader classLoader = ClassLoaderUtils.getPropUseContextClassloaderForJavassist() ? Thread.currentThread().getContextClassLoader() : usedClass.getClassLoader();
        return classLoader;
    }
}

