/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv;

import com.opencsv.ICSVParser;
import com.opencsv.enums.CSVReaderNullFieldIndicator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class CSVParser
implements ICSVParser {
    private static final int BEGINING_OF_LINE = 3;
    private final char separator;
    private final char quotechar;
    private final char escape;
    private final boolean strictQuotes;
    private final boolean ignoreLeadingWhiteSpace;
    private final boolean ignoreQuotations;
    private final CSVReaderNullFieldIndicator nullFieldIndicator;
    private String pending;
    private int tokensOnLastCompleteLine = -1;
    private boolean inField = false;
    private final Locale errorLocale;

    public CSVParser() {
        this(',', '\"', '\\');
    }

    @Deprecated
    public CSVParser(char separator) {
        this(separator, '\"', '\\');
    }

    @Deprecated
    public CSVParser(char separator, char quotechar) {
        this(separator, quotechar, '\\');
    }

    @Deprecated
    public CSVParser(char separator, char quotechar, char escape) {
        this(separator, quotechar, escape, false);
    }

    @Deprecated
    public CSVParser(char separator, char quotechar, char escape, boolean strictQuotes) {
        this(separator, quotechar, escape, strictQuotes, true);
    }

    @Deprecated
    public CSVParser(char separator, char quotechar, char escape, boolean strictQuotes, boolean ignoreLeadingWhiteSpace) {
        this(separator, quotechar, escape, strictQuotes, ignoreLeadingWhiteSpace, false);
    }

    @Deprecated
    public CSVParser(char separator, char quotechar, char escape, boolean strictQuotes, boolean ignoreLeadingWhiteSpace, boolean ignoreQuotations) {
        this(separator, quotechar, escape, strictQuotes, ignoreLeadingWhiteSpace, ignoreQuotations, DEFAULT_NULL_FIELD_INDICATOR);
    }

    @Deprecated
    CSVParser(char separator, char quotechar, char escape, boolean strictQuotes, boolean ignoreLeadingWhiteSpace, boolean ignoreQuotations, CSVReaderNullFieldIndicator nullFieldIndicator) {
        this(separator, quotechar, escape, strictQuotes, ignoreLeadingWhiteSpace, ignoreQuotations, nullFieldIndicator, Locale.getDefault());
    }

    CSVParser(char separator, char quotechar, char escape, boolean strictQuotes, boolean ignoreLeadingWhiteSpace, boolean ignoreQuotations, CSVReaderNullFieldIndicator nullFieldIndicator, Locale errorLocale) {
        this.errorLocale = ObjectUtils.defaultIfNull(errorLocale, Locale.getDefault());
        if (this.anyCharactersAreTheSame(separator, quotechar, escape)) {
            throw new UnsupportedOperationException(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("special.characters.must.differ"));
        }
        if (separator == '\u0000') {
            throw new UnsupportedOperationException(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("define.separator"));
        }
        this.separator = separator;
        this.quotechar = quotechar;
        this.escape = escape;
        this.strictQuotes = strictQuotes;
        this.ignoreLeadingWhiteSpace = ignoreLeadingWhiteSpace;
        this.ignoreQuotations = ignoreQuotations;
        this.nullFieldIndicator = nullFieldIndicator;
    }

    @Override
    public char getSeparator() {
        return this.separator;
    }

    @Override
    public char getQuotechar() {
        return this.quotechar;
    }

    public char getEscape() {
        return this.escape;
    }

    public boolean isStrictQuotes() {
        return this.strictQuotes;
    }

    public boolean isIgnoreLeadingWhiteSpace() {
        return this.ignoreLeadingWhiteSpace;
    }

    public boolean isIgnoreQuotations() {
        return this.ignoreQuotations;
    }

    private boolean anyCharactersAreTheSame(char separator, char quotechar, char escape) {
        return this.isSameCharacter(separator, quotechar) || this.isSameCharacter(separator, escape) || this.isSameCharacter(quotechar, escape);
    }

    private boolean isSameCharacter(char c1, char c2) {
        return c1 != '\u0000' && c1 == c2;
    }

    @Override
    public boolean isPending() {
        return this.pending != null;
    }

    @Override
    public String[] parseLineMulti(String nextLine) throws IOException {
        return this.parseLine(nextLine, true);
    }

    @Override
    public String[] parseLine(String nextLine) throws IOException {
        return this.parseLine(nextLine, false);
    }

    @Override
    public String parseToLine(String[] values) {
        StringBuilder stringBuilder = new StringBuilder(1024);
        for (int i2 = 0; i2 < values.length; ++i2) {
            stringBuilder.append(this.convertToCsvValue(values[i2]));
            if (i2 >= values.length - 1) continue;
            stringBuilder.append(this.getSeparator());
        }
        return stringBuilder.toString();
    }

    private String convertToCsvValue(String value) {
        String string = value == null && !this.nullFieldIndicator.equals((Object)CSVReaderNullFieldIndicator.NEITHER) ? "" : value;
        StringBuilder stringBuilder = new StringBuilder(string == null ? 16 : string.length() << 1);
        boolean bl = string != null && string.contains(Character.toString(this.getQuotechar()));
        boolean bl2 = string != null && string.contains(Character.toString(this.getEscape()));
        boolean bl3 = string != null && string.contains(Character.toString(this.getSeparator()));
        boolean bl4 = this.isSurroundWithQuotes(value, bl3);
        String string2 = !bl ? string : string.replaceAll(Character.toString(this.getQuotechar()), Character.toString(this.getQuotechar()) + Character.toString(this.getQuotechar()));
        String string3 = string2 = !bl2 ? string2 : string2.replace(Character.toString(this.getEscape()), Character.toString(this.getEscape()) + Character.toString(this.getEscape()));
        if (bl4) {
            stringBuilder.append(this.getQuotechar());
        }
        stringBuilder.append(string2);
        if (bl4) {
            stringBuilder.append(this.getQuotechar());
        }
        return stringBuilder.toString();
    }

    private boolean isSurroundWithQuotes(String value, boolean containsQuoteChar) {
        if (value == null) {
            return this.nullFieldIndicator.equals((Object)CSVReaderNullFieldIndicator.EMPTY_QUOTES);
        }
        return containsQuoteChar || value.contains(Character.toString(this.getSeparator())) || value.contains("\n");
    }

    /*
     * Unable to fully structure code
     */
    protected String[] parseLine(String nextLine, boolean multi) throws IOException {
        if (!multi && this.pending != null) {
            this.pending = null;
        }
        if (nextLine == null) {
            if (this.pending != null) {
                var3_3 = this.pending;
                this.pending = null;
                return new String[]{var3_3};
            }
            return null;
        }
        var3_4 = this.tokensOnLastCompleteLine <= 0 ? new ArrayList<String>() : new ArrayList<E>(this.tokensOnLastCompleteLine);
        var4_5 = new StringFragmentCopier(nextLine);
        var5_6 = false;
        var6_7 = false;
        if (this.pending != null) {
            var4_5.append(this.pending);
            this.pending = null;
            v0 = var5_6 = this.ignoreQuotations == false;
        }
        while (!var4_5.isEmptyInput()) {
            block13: {
                block15: {
                    block14: {
                        var7_8 = var4_5.takeInput();
                        if (var7_8 == this.escape) {
                            if (!this.isNextCharacterEscapable(nextLine, this.inQuotes(var5_6), StringFragmentCopier.access$000(var4_5) - 1)) continue;
                            var4_5.takeInput();
                            var4_5.appendPrev();
                            continue;
                        }
                        if (var7_8 != this.quotechar) break block13;
                        if (!this.isNextCharacterEscapedQuote(nextLine, this.inQuotes(var5_6), StringFragmentCopier.access$000(var4_5) - 1)) break block14;
                        var4_5.takeInput();
                        ** GOTO lbl-1000
                    }
                    v1 = var5_6 = var5_6 == false;
                    if (var4_5.isEmptyOutput()) {
                        var6_7 = true;
                    }
                    if (!this.strictQuotes && (var8_9 = StringFragmentCopier.access$000(var4_5)) > 3 && nextLine.charAt(var8_9 - 2) != this.separator && nextLine.length() > var8_9 && nextLine.charAt(var8_9) != this.separator) {
                        ** if (!this.ignoreLeadingWhiteSpace || var4_5.isEmptyOutput() || !StringUtils.isWhitespace((CharSequence)var4_5.peekOutput())) goto lbl-1000
lbl-1000:
                        // 1 sources

                        {
                            var4_5.clearOutput();
                            ** GOTO lbl40
                        }
                    }
                    break block15;
lbl-1000:
                    // 2 sources

                    {
                        var4_5.appendPrev();
                    }
                }
                this.inField = this.inField == false;
                continue;
            }
            if (var7_8 == this.separator && (!var5_6 || this.ignoreQuotations)) {
                var3_4.add(this.convertEmptyToNullIfNeeded(var4_5.takeOutput(), var6_7));
                var6_7 = false;
                this.inField = false;
                continue;
            }
            if (this.strictQuotes && (!var5_6 || this.ignoreQuotations)) continue;
            var4_5.appendPrev();
            this.inField = true;
            var6_7 = true;
        }
        if (!var5_6 || this.ignoreQuotations) ** GOTO lbl61
        if (multi) {
            var4_5.append('\n');
            this.pending = var4_5.peekOutput();
        } else {
            throw new IOException(String.format(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("unterminated.quote"), new Object[]{var4_5.peekOutput()}));
lbl61:
            // 1 sources

            this.inField = false;
            var3_4.add(this.convertEmptyToNullIfNeeded(var4_5.takeOutput(), var6_7));
        }
        this.tokensOnLastCompleteLine = var3_4.size();
        v2 = var3_4;
        return v2.toArray(new String[v2.size()]);
    }

    private String convertEmptyToNullIfNeeded(String s2, boolean fromQuotedField) {
        if (s2.isEmpty() && this.shouldConvertEmptyToNull(fromQuotedField)) {
            return null;
        }
        return s2;
    }

    private boolean shouldConvertEmptyToNull(boolean fromQuotedField) {
        switch (this.nullFieldIndicator) {
            case BOTH: {
                return true;
            }
            case EMPTY_SEPARATORS: {
                return !fromQuotedField;
            }
            case EMPTY_QUOTES: {
                return fromQuotedField;
            }
        }
        return false;
    }

    private boolean inQuotes(boolean inQuotes) {
        return inQuotes && !this.ignoreQuotations || this.inField;
    }

    private boolean isNextCharacterEscapedQuote(String nextLine, boolean inQuotes, int i2) {
        return inQuotes && nextLine.length() > i2 + 1 && this.isCharacterQuoteCharacter(nextLine.charAt(i2 + 1));
    }

    private boolean isCharacterQuoteCharacter(char c2) {
        return c2 == this.quotechar;
    }

    private boolean isCharacterEscapeCharacter(char c2) {
        return c2 == this.escape;
    }

    private boolean isCharacterEscapable(char c2) {
        return this.isCharacterQuoteCharacter(c2) || this.isCharacterEscapeCharacter(c2);
    }

    protected boolean isNextCharacterEscapable(String nextLine, boolean inQuotes, int i2) {
        return inQuotes && nextLine.length() > i2 + 1 && this.isCharacterEscapable(nextLine.charAt(i2 + 1));
    }

    @Override
    public CSVReaderNullFieldIndicator nullFieldIndicator() {
        return this.nullFieldIndicator;
    }

    @Override
    public String getPendingText() {
        return StringUtils.defaultString(this.pending);
    }

    private static class StringFragmentCopier {
        private final String input;
        private int i = 0;
        private StringBuilder sb;
        private int pendingSubstrFrom = 0;
        private int pendingSubstrTo = 0;

        public StringFragmentCopier(String input) {
            this.input = input;
        }

        public boolean isEmptyInput() {
            return this.i >= this.input.length();
        }

        public char takeInput() {
            return this.input.charAt(this.i++);
        }

        private StringBuilder materializeBuilder() {
            if (this.sb == null) {
                this.sb = new StringBuilder(this.input.length() + 128);
            }
            if (this.pendingSubstrFrom < this.pendingSubstrTo) {
                this.sb.append(this.input, this.pendingSubstrFrom, this.pendingSubstrTo);
                StringFragmentCopier stringFragmentCopier = this;
                stringFragmentCopier.pendingSubstrFrom = stringFragmentCopier.pendingSubstrTo = this.i;
            }
            return this.sb;
        }

        public void append(String pending) {
            this.materializeBuilder().append(pending);
        }

        public void append(char pending) {
            this.materializeBuilder().append(pending);
        }

        public void appendPrev() {
            if (this.pendingSubstrTo == this.pendingSubstrFrom) {
                this.pendingSubstrFrom = this.i - 1;
                this.pendingSubstrTo = this.i;
                return;
            }
            if (this.pendingSubstrTo == this.i - 1) {
                ++this.pendingSubstrTo;
                return;
            }
            this.materializeBuilder().append(this.input.charAt(this.i - 1));
        }

        public boolean isEmptyOutput() {
            return this.pendingSubstrFrom >= this.pendingSubstrTo && (this.sb == null || this.sb.length() == 0);
        }

        public void clearOutput() {
            if (this.sb != null) {
                this.sb.setLength(0);
            }
            StringFragmentCopier stringFragmentCopier = this;
            stringFragmentCopier.pendingSubstrFrom = stringFragmentCopier.pendingSubstrTo = this.i;
        }

        public String peekOutput() {
            if (this.sb == null || this.sb.length() == 0) {
                return this.input.substring(this.pendingSubstrFrom, this.pendingSubstrTo);
            }
            return this.materializeBuilder().toString();
        }

        public String takeOutput() {
            String string = this.peekOutput();
            this.clearOutput();
            return string;
        }

        static /* synthetic */ int access$000(StringFragmentCopier x0) {
            return x0.i;
        }
    }
}

