/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv;

import com.opencsv.CSVIterator;
import com.opencsv.CSVParser;
import com.opencsv.ICSVParser;
import com.opencsv.stream.reader.LineReader;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class CSVReader
implements Closeable,
Iterable<String[]> {
    public static final boolean DEFAULT_KEEP_CR = false;
    public static final boolean DEFAULT_VERIFY_READER = true;
    public static final int DEFAULT_SKIP_LINES = 0;
    public static final int DEFAULT_MULTILINE_LIMIT = 0;
    public static final int READ_AHEAD_LIMIT = 2;
    private static final int MAX_WIDTH = 100;
    protected ICSVParser parser;
    protected int skipLines;
    protected BufferedReader br;
    protected LineReader lineReader;
    protected boolean hasNext = true;
    protected boolean linesSkiped;
    protected boolean keepCR;
    protected boolean verifyReader;
    protected int multilineLimit = 0;
    protected final Locale errorLocale;
    protected long linesRead = 0L;
    protected long recordsRead = 0L;

    public CSVReader(Reader reader) {
        this(reader, ',', '\"', '\\');
    }

    @Deprecated
    public CSVReader(Reader reader, char separator) {
        this(reader, separator, '\"', '\\');
    }

    @Deprecated
    public CSVReader(Reader reader, char separator, char quotechar) {
        this(reader, separator, quotechar, '\\', 0, false);
    }

    @Deprecated
    public CSVReader(Reader reader, char separator, char quotechar, boolean strictQuotes) {
        this(reader, separator, quotechar, '\\', 0, strictQuotes);
    }

    @Deprecated
    public CSVReader(Reader reader, char separator, char quotechar, char escape) {
        this(reader, separator, quotechar, escape, 0, false);
    }

    @Deprecated
    public CSVReader(Reader reader, char separator, char quotechar, int line) {
        this(reader, separator, quotechar, '\\', line, false);
    }

    @Deprecated
    public CSVReader(Reader reader, char separator, char quotechar, char escape, int line) {
        this(reader, separator, quotechar, escape, line, false);
    }

    @Deprecated
    public CSVReader(Reader reader, char separator, char quotechar, char escape, int line, boolean strictQuotes) {
        this(reader, separator, quotechar, escape, line, strictQuotes, true);
    }

    @Deprecated
    public CSVReader(Reader reader, char separator, char quotechar, char escape, int line, boolean strictQuotes, boolean ignoreLeadingWhiteSpace) {
        this(reader, line, new CSVParser(separator, quotechar, escape, strictQuotes, ignoreLeadingWhiteSpace, false, ICSVParser.DEFAULT_NULL_FIELD_INDICATOR, Locale.getDefault()));
    }

    @Deprecated
    public CSVReader(Reader reader, char separator, char quotechar, char escape, int line, boolean strictQuotes, boolean ignoreLeadingWhiteSpace, boolean keepCR) {
        this(reader, line, new CSVParser(separator, quotechar, escape, strictQuotes, ignoreLeadingWhiteSpace, false, ICSVParser.DEFAULT_NULL_FIELD_INDICATOR, Locale.getDefault()), keepCR, true, 0, Locale.getDefault());
    }

    @Deprecated
    public CSVReader(Reader reader, int line, ICSVParser icsvParser) {
        this(reader, line, icsvParser, false, true, 0, Locale.getDefault());
    }

    CSVReader(Reader reader, int line, ICSVParser icsvParser, boolean keepCR, boolean verifyReader, int multilineLimit, Locale errorLocale) {
        this.br = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        this.lineReader = new LineReader(this.br, keepCR);
        this.skipLines = line;
        this.parser = icsvParser;
        this.keepCR = keepCR;
        this.verifyReader = verifyReader;
        this.multilineLimit = multilineLimit;
        this.errorLocale = ObjectUtils.defaultIfNull(errorLocale, Locale.getDefault());
    }

    public ICSVParser getParser() {
        return this.parser;
    }

    public int getSkipLines() {
        return this.skipLines;
    }

    public boolean keepCarriageReturns() {
        return this.keepCR;
    }

    public List<String[]> readAll() throws IOException {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        while (this.hasNext) {
            String[] stringArray = this.readNext();
            if (stringArray == null) continue;
            arrayList.add(stringArray);
        }
        return arrayList;
    }

    public String[] readNext() throws IOException {
        String[] stringArray = null;
        int n2 = 0;
        do {
            String string = this.getNextLine();
            ++n2;
            if (!this.hasNext) {
                if (this.parser.isPending()) {
                    throw new IOException(String.format(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("unterminated.quote"), StringUtils.abbreviate(this.parser.getPendingText(), 100)));
                }
                return this.validateResult(stringArray);
            }
            if (this.multilineLimit > 0 && n2 > this.multilineLimit) {
                throw new IOException(String.format(this.errorLocale, ResourceBundle.getBundle("opencsv", this.errorLocale).getString("multiline.limit.broken"), this.multilineLimit));
            }
            String[] stringArray2 = this.parser.parseLineMulti(string);
            if (stringArray2.length <= 0) continue;
            stringArray = stringArray == null ? stringArray2 : this.combineResultsFromMultipleReads(stringArray, stringArray2);
        } while (this.parser.isPending());
        return this.validateResult(stringArray);
    }

    protected String[] validateResult(String[] result) {
        if (result != null) {
            ++this.recordsRead;
        }
        return result;
    }

    protected String[] combineResultsFromMultipleReads(String[] buffer, String[] lastRead) {
        String[] stringArray = new String[buffer.length + lastRead.length];
        System.arraycopy(buffer, 0, stringArray, 0, buffer.length);
        System.arraycopy(lastRead, 0, stringArray, buffer.length, lastRead.length);
        return stringArray;
    }

    protected String getNextLine() throws IOException {
        String string;
        if (this.isClosed()) {
            this.hasNext = false;
            return null;
        }
        if (!this.linesSkiped) {
            for (int i2 = 0; i2 < this.skipLines; ++i2) {
                this.lineReader.readLine();
                ++this.linesRead;
            }
            this.linesSkiped = true;
        }
        if ((string = this.lineReader.readLine()) == null) {
            this.hasNext = false;
        } else {
            ++this.linesRead;
        }
        if (this.hasNext) {
            return string;
        }
        return null;
    }

    public int getMultilineLimit() {
        return this.multilineLimit;
    }

    @Deprecated
    public void setMultilineLimit(int multilineLimit) {
        this.multilineLimit = multilineLimit;
    }

    protected boolean isClosed() {
        if (!this.verifyReader) {
            return false;
        }
        try {
            this.br.mark(2);
            int n2 = this.br.read();
            this.br.reset();
            return n2 == -1;
        }
        catch (IOException iOException) {
            return true;
        }
    }

    @Override
    public void close() throws IOException {
        this.br.close();
    }

    @Override
    public Iterator<String[]> iterator() {
        try {
            CSVIterator cSVIterator = new CSVIterator(this);
            cSVIterator.setErrorLocale(this.errorLocale);
            return cSVIterator;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public boolean verifyReader() {
        return this.verifyReader;
    }

    public long getLinesRead() {
        return this.linesRead;
    }

    public long getRecordsRead() {
        return this.recordsRead;
    }
}

