/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv.bean;

import com.opencsv.CSVReader;
import com.opencsv.bean.AbstractBeanField;
import com.opencsv.bean.BeanField;
import com.opencsv.bean.BeanFieldDate;
import com.opencsv.bean.BeanFieldPrimitiveTypes;
import com.opencsv.bean.CsvBindByName;
import com.opencsv.bean.CsvCustomBindByName;
import com.opencsv.bean.CsvDate;
import com.opencsv.bean.MappingStrategy;
import com.opencsv.exceptions.CsvBadConverterException;
import com.opencsv.exceptions.CsvBeanIntrospectionException;
import com.opencsv.exceptions.CsvRequiredFieldEmptyException;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeSet;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.text.StrBuilder;

public class HeaderColumnNameMappingStrategy<T>
implements MappingStrategy<T> {
    private static final int INITIAL_CAPACITY = 256;
    protected String[] header;
    protected Map<String, Integer> indexLookup = new HashMap<String, Integer>();
    protected Map<String, PropertyDescriptor> descriptorMap = null;
    protected Map<String, BeanField> fieldMap = null;
    protected Class<? extends T> type;
    protected boolean annotationDriven;
    protected Locale errorLocale = Locale.getDefault();

    @Override
    public void captureHeader(CSVReader reader) throws IOException, CsvRequiredFieldEmptyException {
        if (this.type == null) {
            throw new IllegalStateException(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("type.unset"));
        }
        this.header = ObjectUtils.defaultIfNull(reader.readNext(), ArrayUtils.EMPTY_STRING_ARRAY);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map.Entry<String, BeanField> entry : this.fieldMap.entrySet()) {
            BeanField beanField = entry.getValue();
            if (!beanField.isRequired()) continue;
            arrayList.add(entry.getKey().toUpperCase());
        }
        if (arrayList.isEmpty()) {
            return;
        }
        for (int i2 = 0; i2 < this.header.length && !arrayList.isEmpty(); ++i2) {
            arrayList.remove(this.header[i2].toUpperCase());
        }
        if (!arrayList.isEmpty()) {
            Map.Entry<String, BeanField> entry;
            StrBuilder strBuilder = new StrBuilder(256);
            entry = strBuilder.appendWithSeparators(arrayList, ",").toString();
            throw new CsvRequiredFieldEmptyException(this.type, this.fieldMap.get(arrayList.get(0)).getField(), String.format(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("header.required.field.absent"), entry));
        }
    }

    @Override
    public void verifyLineLength(int numberOfFields) throws CsvRequiredFieldEmptyException {
        if (this.header != null) {
            StringBuilder stringBuilder = null;
            for (int i2 = numberOfFields; i2 < this.header.length && numberOfFields == this.header.length; ++i2) {
                BeanField beanField = this.findField(i2);
                if (!beanField.isRequired()) continue;
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("multiple.required.field.empty"));
                }
                stringBuilder.append(' ');
                stringBuilder.append(beanField.getField().getName());
            }
            if (numberOfFields != this.header.length) {
                stringBuilder = new StringBuilder(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("header.data.mismatch"));
            }
            if (stringBuilder != null) {
                throw new CsvRequiredFieldEmptyException(this.type, stringBuilder.toString());
            }
        }
    }

    @Override
    public String[] generateHeader() {
        if (this.type == null) {
            throw new IllegalStateException(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("type.before.header"));
        }
        if (this.header == null) {
            TreeSet<String> treeSet = new TreeSet<String>(this.fieldMap.keySet());
            this.header = treeSet.toArray(new String[this.fieldMap.size()]);
        }
        return ArrayUtils.clone(this.header);
    }

    protected void createIndexLookup(String[] values) {
        if (this.indexLookup.isEmpty()) {
            for (int i2 = 0; i2 < values.length; ++i2) {
                this.indexLookup.put(values[i2], i2);
            }
        }
    }

    protected void resetIndexMap() {
        this.indexLookup.clear();
    }

    @Override
    public Integer getColumnIndex(String name) {
        if (this.header == null) {
            throw new IllegalStateException(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("header.unread"));
        }
        HeaderColumnNameMappingStrategy headerColumnNameMappingStrategy = this;
        headerColumnNameMappingStrategy.createIndexLookup(headerColumnNameMappingStrategy.header);
        return this.indexLookup.get(name);
    }

    @Override
    @Deprecated
    public PropertyDescriptor findDescriptor(int col) {
        String string = this.getColumnName(col);
        BeanField beanField = null;
        if (StringUtils.isNotBlank(string)) {
            beanField = this.fieldMap.get(string.toUpperCase().trim());
        }
        if (beanField != null) {
            return this.findDescriptor(beanField.getField().getName());
        }
        if (StringUtils.isNotBlank(string)) {
            return this.findDescriptor(string);
        }
        return null;
    }

    @Override
    public BeanField findField(int col) throws CsvBadConverterException {
        BeanField beanField = null;
        String string = this.getColumnName(col);
        if (StringUtils.isNotBlank(string)) {
            beanField = this.fieldMap.get(string.toUpperCase().trim());
        }
        return beanField;
    }

    @Override
    public int findMaxFieldIndex() {
        if (this.header == null) {
            return -1;
        }
        return this.header.length - 1;
    }

    public String getColumnName(int col) {
        if (this.header != null && col < this.header.length) {
            return this.header[col];
        }
        return null;
    }

    @Deprecated
    protected PropertyDescriptor findDescriptor(String name) {
        return this.descriptorMap.get(name.toUpperCase().trim());
    }

    @Deprecated
    protected Map<String, PropertyDescriptor> loadDescriptorMap() throws IntrospectionException {
        PropertyDescriptor[] propertyDescriptorArray;
        HashMap<String, PropertyDescriptor> hashMap = new HashMap<String, PropertyDescriptor>();
        HeaderColumnNameMappingStrategy headerColumnNameMappingStrategy = this;
        PropertyDescriptor[] propertyDescriptorArray2 = propertyDescriptorArray = headerColumnNameMappingStrategy.loadDescriptors(headerColumnNameMappingStrategy.getType());
        int n2 = propertyDescriptorArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            PropertyDescriptor propertyDescriptor = propertyDescriptorArray2[i2];
            hashMap.put(propertyDescriptor.getName().toUpperCase(), propertyDescriptor);
        }
        return hashMap;
    }

    protected BeanField instantiateCustomConverter(Class<? extends AbstractBeanField> converter) throws CsvBadConverterException {
        try {
            BeanField beanField = converter.newInstance();
            beanField.setErrorLocale(this.errorLocale);
            return beanField;
        }
        catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
            CsvBadConverterException csvBadConverterException = new CsvBadConverterException(converter, String.format(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("custom.converter.invalid"), converter.getCanonicalName()));
            csvBadConverterException.initCause(reflectiveOperationException);
            throw csvBadConverterException;
        }
    }

    protected void loadFieldMap() throws CsvBadConverterException {
        this.fieldMap = new HashMap<String, BeanField>();
        HeaderColumnNameMappingStrategy headerColumnNameMappingStrategy = this;
        for (Field field : headerColumnNameMappingStrategy.loadFields(headerColumnNameMappingStrategy.getType())) {
            boolean bl;
            Object object;
            String string;
            Annotation annotation;
            if (field.isAnnotationPresent(CsvCustomBindByName.class)) {
                annotation = field.getAnnotation(CsvCustomBindByName.class);
                string = annotation.column().toUpperCase().trim();
                if (StringUtils.isEmpty(string)) {
                    string = field.getName().toUpperCase();
                }
                object = field.getAnnotation(CsvCustomBindByName.class).converter();
                BeanField beanField = this.instantiateCustomConverter((Class<? extends AbstractBeanField>)object);
                beanField.setField(field);
                bl = annotation.required();
                beanField.setRequired(bl);
                this.fieldMap.put(string, beanField);
                continue;
            }
            annotation = field.getAnnotation(CsvBindByName.class);
            bl = annotation.required();
            string = annotation.column().toUpperCase().trim();
            String string2 = annotation.locale();
            if (field.isAnnotationPresent(CsvDate.class)) {
                object = field.getAnnotation(CsvDate.class).value();
                if (StringUtils.isEmpty(string)) {
                    this.fieldMap.put(field.getName().toUpperCase(), new BeanFieldDate(field, bl, (String)object, string2, this.errorLocale));
                    continue;
                }
                this.fieldMap.put(string, new BeanFieldDate(field, bl, (String)object, string2, this.errorLocale));
                continue;
            }
            if (StringUtils.isEmpty(string)) {
                this.fieldMap.put(field.getName().toUpperCase(), new BeanFieldPrimitiveTypes(field, bl, string2, this.errorLocale));
                continue;
            }
            this.fieldMap.put(string, new BeanFieldPrimitiveTypes(field, bl, string2, this.errorLocale));
        }
    }

    private PropertyDescriptor[] loadDescriptors(Class<? extends T> cls) throws IntrospectionException {
        BeanInfo beanInfo = Introspector.getBeanInfo(cls);
        return beanInfo.getPropertyDescriptors();
    }

    private List<Field> loadFields(Class<? extends T> cls) {
        ArrayList<Field> arrayList = new ArrayList<Field>();
        for (Field field : FieldUtils.getAllFields(cls)) {
            if (!field.isAnnotationPresent(CsvBindByName.class) && !field.isAnnotationPresent(CsvCustomBindByName.class)) continue;
            arrayList.add(field);
        }
        this.annotationDriven = !arrayList.isEmpty();
        return arrayList;
    }

    @Override
    public T createBean() throws InstantiationException, IllegalAccessException, IllegalStateException {
        if (this.type == null) {
            throw new IllegalStateException(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("type.unset"));
        }
        return this.type.newInstance();
    }

    public Class<? extends T> getType() {
        return this.type;
    }

    @Override
    public void setType(Class<? extends T> type) throws CsvBadConverterException {
        this.type = type;
        this.loadFieldMap();
        try {
            this.descriptorMap = this.loadDescriptorMap();
            return;
        }
        catch (IntrospectionException introspectionException) {
            CsvBeanIntrospectionException csvBeanIntrospectionException = new CsvBeanIntrospectionException(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("bean.descriptors.uninitialized"));
            csvBeanIntrospectionException.initCause(introspectionException);
            throw csvBeanIntrospectionException;
        }
    }

    @Override
    public void setErrorLocale(Locale errorLocale) {
        this.errorLocale = ObjectUtils.defaultIfNull(errorLocale, Locale.getDefault());
        if (this.fieldMap != null) {
            for (BeanField beanField : this.fieldMap.values()) {
                beanField.setErrorLocale(errorLocale);
            }
        }
    }

    @Override
    public boolean isAnnotationDriven() {
        return this.annotationDriven;
    }
}

