/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv.bean.concurrent;

import com.opencsv.bean.AbstractCSVToBean;
import com.opencsv.bean.BeanField;
import com.opencsv.bean.CsvToBeanFilter;
import com.opencsv.bean.MappingStrategy;
import com.opencsv.bean.concurrent.OrderedObject;
import com.opencsv.bean.opencsvUtils;
import com.opencsv.exceptions.CsvBadConverterException;
import com.opencsv.exceptions.CsvConstraintViolationException;
import com.opencsv.exceptions.CsvDataTypeMismatchException;
import com.opencsv.exceptions.CsvException;
import com.opencsv.exceptions.CsvRequiredFieldEmptyException;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.BlockingQueue;

public class ProcessCsvLine<T>
extends AbstractCSVToBean
implements Runnable {
    private final long lineNumber;
    private final MappingStrategy<T> mapper;
    private final CsvToBeanFilter filter;
    private final String[] line;
    private final BlockingQueue<OrderedObject<T>> resultantBeanQueue;
    private final BlockingQueue<OrderedObject<CsvException>> thrownExceptionsQueue;
    private final boolean throwExceptions;
    T bean;

    public ProcessCsvLine(long lineNumber, MappingStrategy<T> mapper, CsvToBeanFilter filter, String[] line, BlockingQueue<OrderedObject<T>> resultantBeanQueue, BlockingQueue<OrderedObject<CsvException>> thrownExceptionsQueue, boolean throwExceptions) {
        this.lineNumber = lineNumber;
        this.mapper = mapper;
        this.filter = filter;
        this.line = line;
        this.resultantBeanQueue = resultantBeanQueue;
        this.thrownExceptionsQueue = thrownExceptionsQueue;
        this.throwExceptions = throwExceptions;
    }

    @Override
    public void run() {
        try {
            if (this.filter == null || this.filter.allowLine(this.line)) {
                T t2 = this.processLine();
                opencsvUtils.queueRefuseToAcceptDefeat(this.resultantBeanQueue, new OrderedObject<T>(this.lineNumber, t2));
            }
            return;
        }
        catch (CsvException csvException) {
            CsvException csvException2 = csvException;
            CsvException csvException3 = csvException;
            csvException.setLineNumber(this.lineNumber);
            if (this.throwExceptions) {
                throw new RuntimeException(csvException3);
            }
            opencsvUtils.queueRefuseToAcceptDefeat(this.thrownExceptionsQueue, new OrderedObject<CsvException>(this.lineNumber, csvException3));
            return;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private T processLine() throws IllegalAccessException, InvocationTargetException, InstantiationException, IntrospectionException, CsvBadConverterException, CsvDataTypeMismatchException, CsvRequiredFieldEmptyException, CsvConstraintViolationException {
        this.mapper.verifyLineLength(this.line.length);
        this.bean = this.mapper.createBean();
        for (int i2 = 0; i2 < this.line.length; ++i2) {
            if (this.mapper.isAnnotationDriven()) {
                this.processField(i2);
                continue;
            }
            this.processProperty(i2);
        }
        return this.bean;
    }

    private void processField(int col) throws CsvBadConverterException, CsvDataTypeMismatchException, CsvRequiredFieldEmptyException, CsvConstraintViolationException {
        BeanField beanField = this.mapper.findField(col);
        if (beanField != null) {
            String string = this.line[col];
            beanField.setFieldValue(this.bean, string);
        }
    }

    private void processProperty(int col) throws IntrospectionException, InstantiationException, IllegalAccessException, InvocationTargetException, CsvBadConverterException {
        PropertyDescriptor propertyDescriptor = this.mapper.findDescriptor(col);
        if (propertyDescriptor != null) {
            ProcessCsvLine processCsvLine = this;
            String string = processCsvLine.checkForTrim(processCsvLine.line[col], propertyDescriptor);
            Object object = this.convertValue(string, propertyDescriptor);
            propertyDescriptor.getWriteMethod().invoke(this.bean, object);
        }
    }

    @Override
    protected PropertyEditor getPropertyEditor(PropertyDescriptor desc) throws InstantiationException, IllegalAccessException {
        Class<?> clazz = desc.getPropertyEditorClass();
        if (clazz != null) {
            return (PropertyEditor)clazz.newInstance();
        }
        return this.getPropertyEditorValue(desc.getPropertyType());
    }
}

