/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv.bean.customconverter;

import com.opencsv.bean.AbstractBeanField;
import com.opencsv.exceptions.CsvDataTypeMismatchException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.commons.lang3.StringUtils;

public class ConvertSplitOnWhitespace<T>
extends AbstractBeanField<T> {
    @Override
    protected Object convert(String value) {
        ArrayList<String> arrayList = null;
        if (!StringUtils.isEmpty(value)) {
            arrayList = new ArrayList<String>(Arrays.asList(value.split("\\s+")));
        }
        return arrayList;
    }

    @Override
    protected String convertToWrite(Object value) throws CsvDataTypeMismatchException {
        String string = "";
        try {
            if (value != null) {
                List list = (List)value;
                string = StringUtils.join(list, ' ');
            }
        }
        catch (ClassCastException classCastException) {
            CsvDataTypeMismatchException csvDataTypeMismatchException = new CsvDataTypeMismatchException(ResourceBundle.getBundle("convertSplitOnWhitespace", this.errorLocale).getString("wrong.type"));
            csvDataTypeMismatchException.initCause(classCastException);
            throw csvDataTypeMismatchException;
        }
        return string;
    }
}

