/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.rulefit;

import hex.genmodel.algos.rulefit.MojoRule;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;

public class MojoRuleEnsemble
implements Serializable {
    MojoRule[][][] _orderedRules;

    public MojoRuleEnsemble(MojoRule[][][] orderedRules) {
        this._orderedRules = orderedRules;
    }

    public double[] transformRow(double[] row, int depth, int ntrees, String[] linearModelNames, String[][] linearModelDomains, String[] classes) {
        boolean bl = classes != null && classes.length > 2;
        double[] dArray = bl ? new double[depth * ntrees * classes.length] : new double[depth * ntrees];
        for (int i2 = 0; i2 < depth; ++i2) {
            for (int i3 = 0; i3 < ntrees; ++i3) {
                MojoRule[] mojoRuleArray = this._orderedRules[i2][i3];
                if (bl) {
                    int n2;
                    ArrayList[] arrayListArray = new ArrayList[classes.length];
                    for (n2 = 0; n2 < mojoRuleArray.length; ++n2) {
                        for (int i4 = 0; i4 < classes.length; ++i4) {
                            if (!mojoRuleArray[n2]._varName.endsWith(classes[i4])) continue;
                            if (arrayListArray[i4] == null) {
                                arrayListArray[i4] = new ArrayList();
                            }
                            arrayListArray[i4].add(mojoRuleArray[n2]);
                        }
                    }
                    for (n2 = 0; n2 < classes.length; ++n2) {
                        dArray[i2 * ntrees * classes.length + i3 * classes.length + n2] = MojoRuleEnsemble.decode(MojoRuleEnsemble.transform(row, arrayListArray[n2].toArray(new MojoRule[0])), arrayListArray[n2].toArray(new MojoRule[0]), linearModelNames, linearModelDomains, n2);
                    }
                    continue;
                }
                dArray[i2 * ntrees + i3] = MojoRuleEnsemble.decode(MojoRuleEnsemble.transform(row, this._orderedRules[i2][i3]), mojoRuleArray, linearModelNames, linearModelDomains, -1);
            }
        }
        return dArray;
    }

    static double decode(double[] cs, MojoRule[] rules, String[] linearModelNames, String[][] linearModelDomains, int classId) {
        int n2 = -1;
        for (int i2 = 0; i2 < cs.length; ++i2) {
            if (cs[i2] != 1.0) continue;
            n2 = MojoRuleEnsemble.getValueByVarName(rules[i2]._varName, linearModelNames, linearModelDomains, classId);
        }
        if (n2 >= 0) {
            return n2;
        }
        return Double.NaN;
    }

    static int getValueByVarName(String varname, String[] linearModelNames, String[][] linearModelDomains, int classId) {
        String string = varname.substring(0, varname.indexOf(78));
        if (classId != -1) {
            string = string + "C" + classId;
        }
        int n2 = Arrays.asList(linearModelNames).indexOf(string);
        return Arrays.asList(linearModelDomains[n2]).indexOf(varname);
    }

    static double[] transform(double[] row, MojoRule[] rules) {
        double[] dArray = new double[rules.length];
        byte[] byArray = new byte[]{1};
        for (int i2 = 0; i2 < rules.length; ++i2) {
            byArray[0] = 1;
            rules[i2].map(row, byArray);
            dArray[i2] = byArray[0];
        }
        return dArray;
    }
}

