/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.tree;

import hex.genmodel.CategoricalEncoding;
import hex.genmodel.MojoModel;
import hex.genmodel.algos.tree.ConvertTreeOptions;
import hex.genmodel.algos.tree.NaSplitDir;
import hex.genmodel.algos.tree.PlattScalingMojoHelper;
import hex.genmodel.algos.tree.ScoreTree;
import hex.genmodel.algos.tree.ScoreTree0;
import hex.genmodel.algos.tree.ScoreTree1;
import hex.genmodel.algos.tree.ScoreTree2;
import hex.genmodel.algos.tree.SharedTreeGraph;
import hex.genmodel.algos.tree.SharedTreeNode;
import hex.genmodel.algos.tree.SharedTreeSubgraph;
import hex.genmodel.algos.tree.TreeBackedMojoModel;
import hex.genmodel.utils.ByteBufferWrapper;
import hex.genmodel.utils.GenmodelBitSet;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import water.logging.Logger;
import water.logging.LoggerFactory;

public abstract class SharedTreeMojoModel
extends MojoModel
implements PlattScalingMojoHelper.MojoModelWithCalibration,
TreeBackedMojoModel {
    private static final int NsdNaVsRest = NaSplitDir.NAvsREST.value();
    private static final int NsdNaLeft = NaSplitDir.NALeft.value();
    private static final int NsdLeft = NaSplitDir.Left.value();
    private ScoreTree _scoreTree;
    private static Logger logger = LoggerFactory.getLogger(SharedTreeMojoModel.class);
    protected int _ntree_groups;
    protected int _ntrees_per_group;
    protected byte[][] _compressed_trees;
    protected byte[][] _compressed_trees_aux;
    protected double[] _calib_glm_beta;
    protected String _genmodel_encoding;
    protected String[] _orig_names;
    protected String[][] _orig_domain_values;
    protected double[] _orig_projection_array;
    public static final int __INTERNAL_MAX_TREE_DEPTH = 64;

    protected void postInit() {
        if (this._mojo_version == 1.0) {
            this._scoreTree = new ScoreTree0();
            return;
        }
        if (this._mojo_version == 1.1) {
            this._scoreTree = new ScoreTree1();
            return;
        }
        this._scoreTree = new ScoreTree2();
    }

    @Override
    public final int getNTreeGroups() {
        return this._ntree_groups;
    }

    @Override
    public final int getNTreesPerGroup() {
        return this._ntrees_per_group;
    }

    @Deprecated
    public static double scoreTree0(byte[] tree, double[] row, int nclasses, boolean computeLeafAssignment) {
        return SharedTreeMojoModel.scoreTree0(tree, row, computeLeafAssignment);
    }

    @Deprecated
    public static double scoreTree1(byte[] tree, double[] row, int nclasses, boolean computeLeafAssignment) {
        return SharedTreeMojoModel.scoreTree1(tree, row, computeLeafAssignment);
    }

    @Deprecated
    public static double scoreTree(byte[] tree, double[] row, int nclasses, boolean computeLeafAssignment, String[][] domains) {
        return SharedTreeMojoModel.scoreTree(tree, row, computeLeafAssignment, domains);
    }

    public static double scoreTree(byte[] tree, double[] row, boolean computeLeafAssignment, String[][] domains) {
        int n2;
        ByteBufferWrapper byteBufferWrapper = new ByteBufferWrapper(tree);
        GenmodelBitSet genmodelBitSet = null;
        long l2 = 0L;
        int n3 = 0;
        do {
            double d2;
            int n4 = byteBufferWrapper.get1U();
            char c2 = byteBufferWrapper.get2();
            if (c2 == '\uffff') {
                if (computeLeafAssignment) {
                    if (n3 >= 64) {
                        return Double.NaN;
                    }
                    return Double.longBitsToDouble(l2 |= 1L << n3);
                }
                return byteBufferWrapper.get4f();
            }
            int n5 = byteBufferWrapper.get1U();
            boolean bl = n5 == NsdNaVsRest;
            boolean bl2 = n5 == NsdNaLeft || n5 == NsdLeft;
            n2 = n4 & 0x33;
            int n6 = n4 & 0xC;
            assert (n6 != 4);
            float f2 = -1.0f;
            if (!bl) {
                if (n6 == 0) {
                    f2 = byteBufferWrapper.get4f();
                } else {
                    if (genmodelBitSet == null) {
                        genmodelBitSet = new GenmodelBitSet(0);
                    }
                    if (n6 == 8) {
                        genmodelBitSet.fill2(tree, byteBufferWrapper);
                    } else {
                        genmodelBitSet.fill3(tree, byteBufferWrapper);
                    }
                }
            }
            if (Double.isNaN(d2 = row[c2]) || n6 != 0 && genmodelBitSet != null && !genmodelBitSet.isInRange((int)d2) || domains != null && domains[c2] != null && domains[c2].length <= (int)d2 ? !bl2 : !bl && (n6 == 0 ? d2 >= (double)f2 : genmodelBitSet.contains((int)d2))) {
                switch (n2) {
                    case 0: {
                        ByteBufferWrapper byteBufferWrapper2 = byteBufferWrapper;
                        byteBufferWrapper2.skip(byteBufferWrapper2.get1U());
                        break;
                    }
                    case 1: {
                        ByteBufferWrapper byteBufferWrapper3 = byteBufferWrapper;
                        byteBufferWrapper3.skip(byteBufferWrapper3.get2());
                        break;
                    }
                    case 2: {
                        ByteBufferWrapper byteBufferWrapper4 = byteBufferWrapper;
                        byteBufferWrapper4.skip(byteBufferWrapper4.get3());
                        break;
                    }
                    case 3: {
                        ByteBufferWrapper byteBufferWrapper5 = byteBufferWrapper;
                        byteBufferWrapper5.skip(byteBufferWrapper5.get4());
                        break;
                    }
                    case 48: {
                        byteBufferWrapper.skip(4);
                        break;
                    }
                    default: {
                        assert (false) : "illegal lmask value " + n2 + " in tree " + Arrays.toString(tree);
                        break;
                    }
                }
                if (computeLeafAssignment) {
                    if (n3 >= 64) {
                        return Double.NaN;
                    }
                    l2 |= 1L << n3;
                }
                n2 = (n4 & 0xC0) >> 2;
            } else if (n2 <= 3) {
                byteBufferWrapper.skip(n2 + 1);
            }
            ++n3;
        } while ((n2 & 0x10) == 0);
        if (computeLeafAssignment) {
            if (n3 >= 64) {
                return Double.NaN;
            }
            return Double.longBitsToDouble(l2 |= 1L << n3);
        }
        return byteBufferWrapper.get4f();
    }

    @Override
    public CategoricalEncoding getCategoricalEncoding() {
        switch (this._genmodel_encoding) {
            case "AUTO": 
            case "Enum": 
            case "SortByResponse": {
                return CategoricalEncoding.AUTO;
            }
            case "OneHotExplicit": {
                return CategoricalEncoding.OneHotExplicit;
            }
            case "Binary": {
                return CategoricalEncoding.Binary;
            }
            case "EnumLimited": {
                return CategoricalEncoding.EnumLimited;
            }
            case "Eigen": {
                return CategoricalEncoding.Eigen;
            }
            case "LabelEncoder": {
                return CategoricalEncoding.LabelEncoder;
            }
        }
        return null;
    }

    @Override
    public String[] getOrigNames() {
        return this._orig_names;
    }

    @Override
    public double[] getOrigProjectionArray() {
        return this._orig_projection_array;
    }

    @Override
    public String[][] getOrigDomainValues() {
        return this._orig_domain_values;
    }

    public static <T> T getDecisionPath(double leafAssignment, DecisionPathTracker<T> tr) {
        if (Double.isNaN(leafAssignment)) {
            return tr.invalidPath();
        }
        long l2 = Double.doubleToRawLongBits(leafAssignment);
        for (int i2 = 0; i2 < 64; ++i2) {
            boolean bl;
            boolean bl2 = bl = (l2 >> i2 & 1L) == 1L;
            if (!tr.go(i2, bl)) break;
        }
        return tr.terminate();
    }

    public static String getDecisionPath(double leafAssignment) {
        return SharedTreeMojoModel.getDecisionPath(leafAssignment, new StringDecisionPathTracker());
    }

    public static int getLeafNodeId(double leafAssignment, byte[] auxTree) {
        LeafDecisionPathTracker leafDecisionPathTracker = new LeafDecisionPathTracker(auxTree);
        return SharedTreeMojoModel.getDecisionPath(leafAssignment, leafDecisionPathTracker).getLeafNodeId();
    }

    private static void computeTreeGraph(SharedTreeSubgraph sg, SharedTreeNode node, byte[] tree, ByteBufferWrapper ab, HashMap<Integer, AuxInfo> auxMap, String[] names, String[][] domains, ConvertTreeOptions options) {
        int n2 = ab.get1U();
        char c2 = ab.get2();
        if (c2 == '\uffff') {
            float f2 = ab.get4f();
            node.setPredValue(f2);
            return;
        }
        String string = names[c2];
        node.setCol(c2, string);
        int n3 = ab.get1U();
        boolean bl = n3 == NsdNaVsRest;
        boolean bl2 = n3 == NsdNaLeft || n3 == NsdLeft;
        node.setLeftward(bl2);
        node.setNaVsRest(bl);
        int n4 = n2 & 0x33;
        int n5 = n2 & 0xC;
        assert (n5 != 4);
        if (!bl) {
            if (n5 == 0) {
                float f3 = ab.get4f();
                if (domains[c2] != null) {
                    node.setDomainValues(domains[c2]);
                }
                node.setSplitValue(f3);
            } else {
                GenmodelBitSet genmodelBitSet = new GenmodelBitSet(0);
                if (n5 == 8) {
                    genmodelBitSet.fill2(tree, ab);
                } else {
                    genmodelBitSet.fill3(tree, ab);
                }
                node.setBitset(domains[c2], genmodelBitSet);
            }
        }
        AuxInfo auxInfo = auxMap.get(node.getNodeNumber());
        ByteBufferWrapper byteBufferWrapper = new ByteBufferWrapper(tree);
        byteBufferWrapper.skip(ab.position());
        switch (n4) {
            case 0: {
                ByteBufferWrapper byteBufferWrapper2 = byteBufferWrapper;
                byteBufferWrapper2.skip(byteBufferWrapper2.get1U());
                break;
            }
            case 1: {
                ByteBufferWrapper byteBufferWrapper3 = byteBufferWrapper;
                byteBufferWrapper3.skip(byteBufferWrapper3.get2());
                break;
            }
            case 2: {
                ByteBufferWrapper byteBufferWrapper4 = byteBufferWrapper;
                byteBufferWrapper4.skip(byteBufferWrapper4.get3());
                break;
            }
            case 3: {
                ByteBufferWrapper byteBufferWrapper5 = byteBufferWrapper;
                byteBufferWrapper5.skip(byteBufferWrapper5.get4());
                break;
            }
            case 48: {
                byteBufferWrapper.skip(4);
                break;
            }
            default: {
                assert (false) : "illegal lmask value " + n4 + " in tree " + Arrays.toString(tree);
                break;
            }
        }
        int n6 = (n2 & 0xC0) >> 2;
        SharedTreeNode sharedTreeNode = sg.makeRightChildNode(node);
        sharedTreeNode.setWeight(auxInfo.weightR);
        sharedTreeNode.setNodeNumber(auxInfo.nidR);
        sharedTreeNode.setPredValue(auxInfo.predR);
        sharedTreeNode.setSquaredError(auxInfo.sqErrR);
        if ((n6 & 0x10) != 0) {
            float f4 = byteBufferWrapper.get4f();
            sharedTreeNode.setPredValue(f4);
            auxInfo.predR = f4;
        } else {
            SharedTreeMojoModel.computeTreeGraph(sg, sharedTreeNode, tree, byteBufferWrapper, auxMap, names, domains, options);
        }
        byteBufferWrapper = new ByteBufferWrapper(tree);
        byteBufferWrapper.skip(ab.position());
        if (n4 <= 3) {
            byteBufferWrapper.skip(n4 + 1);
        }
        SharedTreeNode sharedTreeNode2 = sg.makeLeftChildNode(node);
        sharedTreeNode2.setWeight(auxInfo.weightL);
        sharedTreeNode2.setNodeNumber(auxInfo.nidL);
        sharedTreeNode2.setPredValue(auxInfo.predL);
        sharedTreeNode2.setSquaredError(auxInfo.sqErrL);
        if ((n4 & 0x10) != 0) {
            float f5 = byteBufferWrapper.get4f();
            sharedTreeNode2.setPredValue(f5);
            auxInfo.predL = f5;
        } else {
            SharedTreeMojoModel.computeTreeGraph(sg, sharedTreeNode2, tree, byteBufferWrapper, auxMap, names, domains, options);
        }
        if (node.getNodeNumber() == 0) {
            float f6;
            float f7 = (float)(((double)auxInfo.predL * (double)auxInfo.weightL + (double)auxInfo.predR * (double)auxInfo.weightR) / ((double)auxInfo.weightL + (double)auxInfo.weightR));
            if ((double)Math.abs(f6) < 1.0E-7) {
                f7 = 0.0f;
            }
            node.setPredValue(f7);
            node.setSquaredError(auxInfo.sqErrR + auxInfo.sqErrL);
            node.setWeight(auxInfo.weightL + auxInfo.weightR);
        }
        if (options._checkTreeConsistency) {
            SharedTreeMojoModel.checkConsistency(auxInfo, node);
        }
    }

    public SharedTreeGraph computeGraph(int treeToPrint, ConvertTreeOptions options) {
        SharedTreeGraph sharedTreeGraph = new SharedTreeGraph();
        if (treeToPrint >= this._ntree_groups) {
            throw new IllegalArgumentException("Tree " + treeToPrint + " does not exist (max " + this._ntree_groups + ")");
        }
        for (int i2 = treeToPrint >= 0 ? treeToPrint : 0; i2 < this._ntree_groups; ++i2) {
            for (int i3 = 0; i3 < this._ntrees_per_group; ++i3) {
                String[] stringArray;
                int n2 = this.treeIndex(i2, i3);
                if (this.isSupervised()) {
                    SharedTreeMojoModel sharedTreeMojoModel = this;
                    stringArray = sharedTreeMojoModel.getDomainValues(sharedTreeMojoModel.getResponseIdx());
                } else {
                    stringArray = null;
                }
                String[] stringArray2 = stringArray;
                String string = SharedTreeMojoModel.treeName(i2, i3, stringArray2);
                SharedTreeSubgraph sharedTreeSubgraph = sharedTreeGraph.makeSubgraph(string);
                SharedTreeMojoModel.computeTreeGraph(sharedTreeSubgraph, this._compressed_trees[n2], this._compressed_trees_aux[n2], this.getNames(), this.getDomainValues(), options);
            }
            if (treeToPrint >= 0) break;
        }
        return sharedTreeGraph;
    }

    public SharedTreeGraph computeGraph(int treeId) {
        return this.computeGraph(treeId, ConvertTreeOptions.DEFAULT);
    }

    @Deprecated
    public SharedTreeGraph _computeGraph(int treeId) {
        return this.computeGraph(treeId);
    }

    public static SharedTreeSubgraph computeTreeGraph(int treeNum, String treeName, byte[] tree, byte[] auxTreeInfo, String[] names, String[][] domains) {
        return SharedTreeMojoModel.computeTreeGraph(treeNum, treeName, tree, auxTreeInfo, names, domains, ConvertTreeOptions.DEFAULT);
    }

    public static SharedTreeSubgraph computeTreeGraph(int treeNum, String treeName, byte[] tree, byte[] auxTreeInfo, String[] names, String[][] domains, ConvertTreeOptions options) {
        SharedTreeSubgraph sharedTreeSubgraph = new SharedTreeSubgraph(treeNum, treeName);
        SharedTreeMojoModel.computeTreeGraph(sharedTreeSubgraph, tree, auxTreeInfo, names, domains, options);
        return sharedTreeSubgraph;
    }

    private static void computeTreeGraph(SharedTreeSubgraph sg, byte[] tree, byte[] auxTreeInfo, String[] names, String[][] domains, ConvertTreeOptions options) {
        SharedTreeNode sharedTreeNode = sg.makeRootNode();
        sharedTreeNode.setSquaredError(Float.NaN);
        sharedTreeNode.setPredValue(Float.NaN);
        ByteBufferWrapper byteBufferWrapper = new ByteBufferWrapper(tree);
        ByteBufferWrapper byteBufferWrapper2 = new ByteBufferWrapper(auxTreeInfo);
        HashMap<Integer, AuxInfo> hashMap = SharedTreeMojoModel.readAuxInfos(byteBufferWrapper2);
        SharedTreeMojoModel.computeTreeGraph(sg, sharedTreeNode, tree, byteBufferWrapper, hashMap, names, domains, options);
    }

    public static Map<Integer, AuxInfo> readAuxInfos(byte[] auxTreeInfo) {
        ByteBufferWrapper byteBufferWrapper = new ByteBufferWrapper(auxTreeInfo);
        return SharedTreeMojoModel.readAuxInfos(byteBufferWrapper);
    }

    public static int findMaxNodeId(byte[] auxTreeInfo) {
        int n2 = 0;
        AuxInfoLightReader auxInfoLightReader = new AuxInfoLightReader(auxTreeInfo);
        while (auxInfoLightReader.hasNext()) {
            int n3 = auxInfoLightReader.readMaxChildNodeIdAndSkip();
            if (n2 >= n3) continue;
            n2 = n3;
        }
        return n2;
    }

    private static HashMap<Integer, AuxInfo> readAuxInfos(ByteBufferWrapper abAux) {
        HashMap<Integer, AuxInfo> hashMap = new HashMap<Integer, AuxInfo>();
        HashMap<Integer, AuxInfo> hashMap2 = new HashMap<Integer, AuxInfo>();
        hashMap2.put(0, new AuxInfo());
        boolean bl = false;
        while (abAux.hasRemaining()) {
            AuxInfo auxInfo;
            AuxInfo auxInfo2 = new AuxInfo(abAux);
            if (hashMap.size() == 0) {
                boolean bl2 = bl = auxInfo2.reserved < 0;
            }
            if ((auxInfo = (AuxInfo)hashMap2.get(auxInfo2.nid)) == null) {
                throw new IllegalStateException("Parent for nodeId=" + auxInfo2.nid + " not found.");
            }
            assert (!bl || auxInfo.nid == auxInfo2.reserved) : "Corrupted Tree Info: parent nodes do not correspond (pid: " + auxInfo.nid + ", reserved: " + AuxInfo.access$1100(auxInfo2) + ")";
            auxInfo2.setPid(auxInfo.nid);
            hashMap2.put(auxInfo2.nidL, auxInfo2);
            hashMap2.put(auxInfo2.nidR, auxInfo2);
            hashMap.put(auxInfo2.nid, auxInfo2);
        }
        return hashMap;
    }

    public static void writeUpdatedAuxInfos(byte[] origAux, Map<Integer, AuxInfo> updatedAuxInfos, ByteBuffer bb) {
        AuxInfoLightReader auxInfoLightReader = new AuxInfoLightReader(origAux);
        int n2 = 0;
        while (auxInfoLightReader.hasNext()) {
            ++n2;
            int n3 = auxInfoLightReader.readNodeIdAndSkip();
            AuxInfo auxInfo = updatedAuxInfos.get(n3);
            if (auxInfo == null) {
                throw new IllegalStateException("Updated AuxInfo for nodeId=" + n3 + " doesn't exist. All AuxInfos need to be represented in the updated structure.");
            }
            auxInfo.writeTo(bb);
        }
        assert (n2 == updatedAuxInfos.size());
    }

    public static String treeName(int groupIndex, int classIndex, String[] domainValues) {
        String string = "";
        if (domainValues != null) {
            string = ", Class " + domainValues[classIndex];
        }
        return "Tree " + groupIndex + string;
    }

    static void checkConsistency(AuxInfo auxInfo, SharedTreeNode node) {
        boolean bl = true;
        boolean ok = true & auxInfo.nid == node.getNodeNumber();
        double d2 = 0.0;
        if (node.leftChild != null) {
            ok &= auxInfo.nidL == node.leftChild.getNodeNumber();
            ok &= auxInfo.weightL == node.leftChild.getWeight();
            ok &= auxInfo.predL == node.leftChild.predValue;
            ok &= auxInfo.sqErrL == node.leftChild.squaredError;
            d2 = 0.0 + (double)node.leftChild.getWeight();
        }
        if (node.rightChild != null) {
            ok &= auxInfo.nidR == node.rightChild.getNodeNumber();
            ok &= auxInfo.weightR == node.rightChild.getWeight();
            ok &= auxInfo.predR == node.rightChild.predValue;
            ok &= auxInfo.sqErrR == node.rightChild.squaredError;
            d2 += (double)node.rightChild.getWeight();
        }
        if (node.parent != null) {
            ok &= auxInfo.pid == node.parent.getNodeNumber();
            bl = Math.abs((double)node.getWeight() - d2) < 1.0E-5 * ((double)node.getWeight() + d2);
            ok &= bl;
        }
        if (!ok && logger.isErrorEnabled()) {
            logger.error("\nTree inconsistency found:");
            if (node.depth == 1 && !bl) {
                logger.error("Note: this is a known issue for DRF and Isolation Forest models, please refer to https://0xdata.atlassian.net/browse/PUBDEV-6140");
            }
            logger.error(node.getPrintString("parent"));
            logger.error(node.leftChild.getPrintString("left child"));
            logger.error(node.rightChild.getPrintString("right child"));
            logger.error("Auxiliary tree info:");
            logger.error(auxInfo.toString());
        }
    }

    protected SharedTreeMojoModel(String[] columns, String[][] domains, String responseColumn) {
        super(columns, domains, responseColumn);
    }

    protected void scoreAllTrees(double[] row, double[] preds) {
        Arrays.fill(preds, 0.0);
        this.scoreTreeRange(row, 0, this._ntree_groups, preds);
    }

    public abstract double[] unifyPreds(double[] var1, double var2, double[] var4);

    public final void scoreSingleTree(double[] row, int index, double[] preds) {
        int n2 = index;
        this.scoreTreeRange(row, n2, n2 + 1, preds);
    }

    public final void scoreTreeRange(double[] row, int fromIndex, int toIndex, double[] preds) {
        int n2 = this._nclasses == 1 ? 0 : 1;
        for (int i2 = 0; i2 < this._ntrees_per_group; ++i2) {
            int n3 = n2 + i2;
            int n4 = this.treeIndex(fromIndex, i2);
            for (int i3 = fromIndex; i3 < toIndex; ++i3) {
                if (this._compressed_trees[n4] != null) {
                    int n5 = n3;
                    preds[n5] = preds[n5] + this._scoreTree.scoreTree(this._compressed_trees[n4], row, false, this._domains);
                }
                ++n4;
            }
        }
    }

    public String[] getDecisionPathNames() {
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < this._ntrees_per_group; ++n2) {
            int n4 = this.treeIndex(0, n2);
            if (this._compressed_trees[n4] == null) continue;
            ++n3;
        }
        n2 = this._ntree_groups * n3;
        String[] stringArray = new String[n2];
        for (int i2 = 0; i2 < this._ntrees_per_group; ++i2) {
            for (int i3 = 0; i3 < this._ntree_groups; ++i3) {
                int n5 = this.treeIndex(i3, i2);
                if (this._compressed_trees[n5] == null) continue;
                stringArray[n5] = "T" + (i3 + 1) + ".C" + (i2 + 1);
            }
        }
        return stringArray;
    }

    @Override
    public LeafNodeAssignments getLeafNodeAssignments(double[] row) {
        LeafNodeAssignments leafNodeAssignments = new LeafNodeAssignments();
        new LeafNodeAssignments()._paths = new String[this._compressed_trees.length];
        if (this._mojo_version >= 1.3 && this._compressed_trees_aux != null) {
            leafNodeAssignments._nodeIds = new int[this._compressed_trees_aux.length];
        }
        this.traceDecisions(row, leafNodeAssignments._paths, leafNodeAssignments._nodeIds);
        return leafNodeAssignments;
    }

    @Override
    public String[] getDecisionPath(double[] row) {
        String[] stringArray = new String[this._compressed_trees.length];
        this.traceDecisions(row, stringArray, null);
        return stringArray;
    }

    private void traceDecisions(double[] row, String[] paths, int[] nodeIds) {
        if (this._mojo_version < 1.2) {
            throw new IllegalArgumentException("You can only obtain decision tree path with mojo versions 1.2 or higher");
        }
        for (int i2 = 0; i2 < this._ntree_groups; ++i2) {
            for (int i3 = 0; i3 < this._ntrees_per_group; ++i3) {
                int n2 = this.treeIndex(i2, i3);
                double d2 = SharedTreeMojoModel.scoreTree(this._compressed_trees[n2], row, true, this._domains);
                if (paths != null) {
                    paths[n2] = SharedTreeMojoModel.getDecisionPath(d2);
                }
                if (nodeIds == null) continue;
                assert (this._mojo_version >= 1.3);
                nodeIds[n2] = SharedTreeMojoModel.getLeafNodeId(d2, this._compressed_trees_aux[n2]);
            }
        }
    }

    final int treeIndex(int groupIndex, int classIndex) {
        return classIndex * this._ntree_groups + groupIndex;
    }

    public final byte[] treeBytes(int groupIndex, int classIndex) {
        return this._compressed_trees[this.treeIndex(groupIndex, classIndex)];
    }

    public static double scoreTree0(byte[] tree, double[] row, boolean computeLeafAssignment) {
        int n2;
        ByteBufferWrapper byteBufferWrapper = new ByteBufferWrapper(tree);
        GenmodelBitSet genmodelBitSet = null;
        long l2 = 0L;
        int n3 = 0;
        do {
            double d2;
            int n4 = byteBufferWrapper.get1U();
            char c2 = byteBufferWrapper.get2();
            if (c2 == '\uffff') {
                return byteBufferWrapper.get4f();
            }
            int n5 = byteBufferWrapper.get1U();
            boolean bl = n5 == NsdNaVsRest;
            boolean bl2 = n5 == NsdNaLeft || n5 == NsdLeft;
            n2 = n4 & 0x33;
            int n6 = n4 & 0xC;
            assert (n6 != 4);
            float f2 = -1.0f;
            if (!bl) {
                if (n6 == 0) {
                    f2 = byteBufferWrapper.get4f();
                } else {
                    if (genmodelBitSet == null) {
                        genmodelBitSet = new GenmodelBitSet(0);
                    }
                    if (n6 == 8) {
                        genmodelBitSet.fill2(tree, byteBufferWrapper);
                    } else {
                        genmodelBitSet.fill3_1(tree, byteBufferWrapper);
                    }
                }
            }
            if (Double.isNaN(d2 = row[c2]) ? !bl2 : !bl && (n6 == 0 ? d2 >= (double)f2 : genmodelBitSet.contains0((int)d2))) {
                switch (n2) {
                    case 0: {
                        ByteBufferWrapper byteBufferWrapper2 = byteBufferWrapper;
                        byteBufferWrapper2.skip(byteBufferWrapper2.get1U());
                        break;
                    }
                    case 1: {
                        ByteBufferWrapper byteBufferWrapper3 = byteBufferWrapper;
                        byteBufferWrapper3.skip(byteBufferWrapper3.get2());
                        break;
                    }
                    case 2: {
                        ByteBufferWrapper byteBufferWrapper4 = byteBufferWrapper;
                        byteBufferWrapper4.skip(byteBufferWrapper4.get3());
                        break;
                    }
                    case 3: {
                        ByteBufferWrapper byteBufferWrapper5 = byteBufferWrapper;
                        byteBufferWrapper5.skip(byteBufferWrapper5.get4());
                        break;
                    }
                    case 48: {
                        byteBufferWrapper.skip(4);
                        break;
                    }
                    default: {
                        assert (false) : "illegal lmask value " + n2 + " in tree " + Arrays.toString(tree);
                        break;
                    }
                }
                if (computeLeafAssignment && n3 < 64) {
                    l2 |= (long)(1 << n3);
                }
                n2 = (n4 & 0xC0) >> 2;
            } else if (n2 <= 3) {
                byteBufferWrapper.skip(n2 + 1);
            }
            ++n3;
        } while ((n2 & 0x10) == 0);
        if (computeLeafAssignment) {
            return Double.longBitsToDouble(l2 |= (long)(1 << n3));
        }
        return byteBufferWrapper.get4f();
    }

    public static double scoreTree1(byte[] tree, double[] row, boolean computeLeafAssignment) {
        int n2;
        ByteBufferWrapper byteBufferWrapper = new ByteBufferWrapper(tree);
        GenmodelBitSet genmodelBitSet = null;
        long l2 = 0L;
        int n3 = 0;
        do {
            double d2;
            int n4 = byteBufferWrapper.get1U();
            char c2 = byteBufferWrapper.get2();
            if (c2 == '\uffff') {
                return byteBufferWrapper.get4f();
            }
            int n5 = byteBufferWrapper.get1U();
            boolean bl = n5 == NsdNaVsRest;
            boolean bl2 = n5 == NsdNaLeft || n5 == NsdLeft;
            n2 = n4 & 0x33;
            int n6 = n4 & 0xC;
            assert (n6 != 4);
            float f2 = -1.0f;
            if (!bl) {
                if (n6 == 0) {
                    f2 = byteBufferWrapper.get4f();
                } else {
                    if (genmodelBitSet == null) {
                        genmodelBitSet = new GenmodelBitSet(0);
                    }
                    if (n6 == 8) {
                        genmodelBitSet.fill2(tree, byteBufferWrapper);
                    } else {
                        genmodelBitSet.fill3_1(tree, byteBufferWrapper);
                    }
                }
            }
            if (Double.isNaN(d2 = row[c2]) || n6 != 0 && genmodelBitSet != null && !genmodelBitSet.isInRange((int)d2) ? !bl2 : !bl && (n6 == 0 ? d2 >= (double)f2 : genmodelBitSet.contains((int)d2))) {
                switch (n2) {
                    case 0: {
                        ByteBufferWrapper byteBufferWrapper2 = byteBufferWrapper;
                        byteBufferWrapper2.skip(byteBufferWrapper2.get1U());
                        break;
                    }
                    case 1: {
                        ByteBufferWrapper byteBufferWrapper3 = byteBufferWrapper;
                        byteBufferWrapper3.skip(byteBufferWrapper3.get2());
                        break;
                    }
                    case 2: {
                        ByteBufferWrapper byteBufferWrapper4 = byteBufferWrapper;
                        byteBufferWrapper4.skip(byteBufferWrapper4.get3());
                        break;
                    }
                    case 3: {
                        ByteBufferWrapper byteBufferWrapper5 = byteBufferWrapper;
                        byteBufferWrapper5.skip(byteBufferWrapper5.get4());
                        break;
                    }
                    case 48: {
                        byteBufferWrapper.skip(4);
                        break;
                    }
                    default: {
                        assert (false) : "illegal lmask value " + n2 + " in tree " + Arrays.toString(tree);
                        break;
                    }
                }
                if (computeLeafAssignment && n3 < 64) {
                    l2 |= 1L << n3;
                }
                n2 = (n4 & 0xC0) >> 2;
            } else if (n2 <= 3) {
                byteBufferWrapper.skip(n2 + 1);
            }
            ++n3;
        } while ((n2 & 0x10) == 0);
        if (computeLeafAssignment) {
            return Double.longBitsToDouble(l2 |= 1L << n3);
        }
        return byteBufferWrapper.get4f();
    }

    @Override
    public boolean calibrateClassProbabilities(double[] preds) {
        return PlattScalingMojoHelper.calibrateClassProbabilities(this, preds);
    }

    @Override
    public double[] getCalibGlmBeta() {
        return this._calib_glm_beta;
    }

    @Override
    public SharedTreeGraph convert(int treeNumber, String treeClass) {
        return this.computeGraph(treeNumber);
    }

    @Override
    public SharedTreeGraph convert(int treeNumber, String treeClass, ConvertTreeOptions options) {
        return this.computeGraph(treeNumber, options);
    }

    public double[] scoreStagedPredictions(double[] row, int predsLength) {
        int n2 = this.nclasses() == 1 ? 0 : 1;
        double[] dArray = new double[this._ntree_groups * this._ntrees_per_group];
        for (int i2 = 0; i2 < this._ntree_groups; ++i2) {
            double[] dArray2 = new double[predsLength];
            this.scoreTreeRange(row, 0, i2 + 1, dArray2);
            this.unifyPreds(row, 0.0, dArray2);
            for (int i3 = 0; i3 < this._ntrees_per_group; ++i3) {
                int n3 = i2 * this._ntrees_per_group + i3;
                dArray[n3] = dArray2[n2 + i3];
            }
        }
        return dArray;
    }

    public static class LeafNodeAssignments {
        public String[] _paths;
        public int[] _nodeIds;
    }

    public static class AuxInfo {
        private static final int SIZE = 40;
        public int nid;
        public int pid;
        public int nidL;
        public int nidR;
        private final int reserved;
        public float weightL;
        public float weightR;
        public float predL;
        public float predR;
        public float sqErrL;
        public float sqErrR;

        private AuxInfo() {
            this.nid = -1;
            this.reserved = -1;
        }

        AuxInfo(ByteBufferWrapper abAux) {
            this.nid = abAux.get4();
            this.reserved = abAux.get4();
            this.weightL = abAux.get4f();
            this.weightR = abAux.get4f();
            this.predL = abAux.get4f();
            this.predR = abAux.get4f();
            this.sqErrL = abAux.get4f();
            this.sqErrR = abAux.get4f();
            this.nidL = abAux.get4();
            this.nidR = abAux.get4();
        }

        void writeTo(ByteBuffer bb) {
            bb.putInt(this.nid);
            bb.putInt(this.reserved);
            bb.putFloat(this.weightL);
            bb.putFloat(this.weightR);
            bb.putFloat(this.predL);
            bb.putFloat(this.predR);
            bb.putFloat(this.sqErrL);
            bb.putFloat(this.sqErrR);
            bb.putInt(this.nidL);
            bb.putInt(this.nidR);
        }

        final void setPid(int parentId) {
            this.pid = parentId;
        }

        public String toString() {
            return "nid: " + this.nid + "\npid: " + this.pid + "\nnidL: " + this.nidL + "\nnidR: " + this.nidR + "\nweightL: " + this.weightL + "\nweightR: " + this.weightR + "\npredL: " + this.predL + "\npredR: " + this.predR + "\nsqErrL: " + this.sqErrL + "\nsqErrR: " + this.sqErrR + "\nreserved: " + this.reserved + "\n";
        }
    }

    private static class AuxInfoLightReader {
        private final ByteBufferWrapper _abAux;
        int _nid;
        int _numLeftChildren;

        private AuxInfoLightReader(byte[] auxInfo) {
            this(new ByteBufferWrapper(auxInfo));
        }

        private AuxInfoLightReader(ByteBufferWrapper abAux) {
            this._abAux = abAux;
        }

        private void readNext() {
            this._nid = this._abAux.get4();
            this._numLeftChildren = this._abAux.get4();
        }

        private boolean hasNext() {
            return this._abAux.hasRemaining();
        }

        private int readMaxChildNodeIdAndSkip() {
            this._abAux.skip(32);
            int n2 = this._abAux.get4();
            int n3 = this._abAux.get4();
            return Math.max(n2, n3);
        }

        private int readNodeIdAndSkip() {
            this.readNext();
            this.skipNode();
            return this._nid;
        }

        private int getLeftNodeIdAndSkipNode() {
            this._abAux.skip(24);
            int n2 = this._abAux.get4();
            this._abAux.skip(4);
            return n2;
        }

        private int getRightNodeIdAndSkipNode() {
            this._abAux.skip(28);
            return this._abAux.get4();
        }

        private void skipNode() {
            this._abAux.skip(32);
        }

        private void skipNodes(int num) {
            this._abAux.skip(num * 40);
        }
    }

    public static class LeafDecisionPathTracker
    implements DecisionPathTracker<LeafDecisionPathTracker> {
        private final AuxInfoLightReader _auxInfo;
        private boolean _wentRight = false;
        private int _nodeId = 0;

        private LeafDecisionPathTracker(byte[] auxTree) {
            this._auxInfo = new AuxInfoLightReader(new ByteBufferWrapper(auxTree));
        }

        @Override
        public boolean go(int depth, boolean right) {
            if (!this._auxInfo.hasNext()) {
                assert (this._wentRight || depth == 0);
                return false;
            }
            this._auxInfo.readNext();
            if (right) {
                if (this._wentRight && this._nodeId != this._auxInfo._nid) {
                    return false;
                }
                this._nodeId = this._auxInfo.getRightNodeIdAndSkipNode();
                this._auxInfo.skipNodes(this._auxInfo._numLeftChildren);
                this._wentRight = true;
            } else {
                this._wentRight = false;
                if (this._auxInfo._numLeftChildren == 0) {
                    this._nodeId = this._auxInfo.getLeftNodeIdAndSkipNode();
                    return false;
                }
                this._auxInfo.skipNode();
            }
            return true;
        }

        @Override
        public LeafDecisionPathTracker terminate() {
            return this;
        }

        final int getLeafNodeId() {
            return this._nodeId;
        }

        @Override
        public LeafDecisionPathTracker invalidPath() {
            this._nodeId = -1;
            return this;
        }
    }

    public static class StringDecisionPathTracker
    implements DecisionPathTracker<String> {
        private final char[] _sb = new char[64];
        private int _pos = 0;

        @Override
        public boolean go(int depth, boolean right) {
            int n2 = this._sb[depth] = right ? 82 : 76;
            if (right) {
                this._pos = depth;
            }
            return true;
        }

        @Override
        public String terminate() {
            String string = new String(this._sb, 0, this._pos);
            this._pos = 0;
            return string;
        }

        @Override
        public String invalidPath() {
            return null;
        }
    }

    public static interface DecisionPathTracker<T> {
        public boolean go(int var1, boolean var2);

        public T terminate();

        public T invalidPath();
    }
}

