/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.tree;

import ai.h2o.a.a.a;
import hex.genmodel.PredictContributions;
import hex.genmodel.PredictContributionsFactory;
import hex.genmodel.algos.tree.ContributionsPredictor;
import hex.genmodel.algos.tree.SharedTreeGraph;
import hex.genmodel.algos.tree.SharedTreeMojoModel;
import hex.genmodel.algos.tree.SharedTreeSubgraph;
import hex.genmodel.algos.tree.TreeSHAP;
import hex.genmodel.algos.tree.TreeSHAPEnsemble;
import hex.genmodel.algos.tree.TreeSHAPPredictor;
import java.util.ArrayList;

public abstract class SharedTreeMojoModelWithContributions
extends SharedTreeMojoModel
implements PredictContributionsFactory {
    protected SharedTreeMojoModelWithContributions(String[] columns, String[][] domains, String responseColumn) {
        super(columns, domains, responseColumn);
    }

    @Override
    public PredictContributions makeContributionsPredictor() {
        if (this._nclasses > 2) {
            throw new UnsupportedOperationException("Predicting contributions for multinomial classification problems is not yet supported.");
        }
        SharedTreeGraph sharedTreeGraph = this.computeGraph(-1);
        ArrayList arrayList = new ArrayList(sharedTreeGraph.subgraphArray.size());
        for (SharedTreeSubgraph sharedTreeSubgraph : sharedTreeGraph.subgraphArray) {
            a[] aArray = sharedTreeSubgraph.getNodes();
            arrayList.add(new TreeSHAP(aArray));
        }
        TreeSHAPEnsemble treeSHAPEnsemble = new TreeSHAPEnsemble(arrayList, (float)this.getInitF());
        return this.getContributionsPredictor(treeSHAPEnsemble);
    }

    @Override
    public double getInitF() {
        return 0.0;
    }

    protected abstract PredictContributions getContributionsPredictor(TreeSHAPPredictor<double[]> var1);

    protected static class SharedTreeContributionsPredictor
    extends ContributionsPredictor<double[]> {
        public SharedTreeContributionsPredictor(SharedTreeMojoModel model, TreeSHAPPredictor<double[]> treeSHAPPredictor) {
            super(model._nfeatures + 1, model.features(), treeSHAPPredictor);
        }

        @Override
        protected final double[] toInputRow(double[] input) {
            return input;
        }
    }
}

