/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.attributes;

import com.b.a.e;
import com.b.a.f;
import com.b.a.h;
import com.b.a.k;
import com.b.a.m;
import com.b.a.n;
import com.b.a.p;
import hex.genmodel.MojoReaderBackend;
import hex.genmodel.attributes.SerializedName;
import hex.genmodel.attributes.Table;
import hex.genmodel.attributes.parameters.ColumnSpecifier;
import hex.genmodel.attributes.parameters.KeyValue;
import hex.genmodel.attributes.parameters.ParameterKey;
import java.io.BufferedReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import water.logging.Logger;
import water.logging.LoggerFactory;

public class ModelJsonReader {
    private static final Logger LOG = LoggerFactory.getLogger(ModelJsonReader.class);
    public static final String MODEL_DETAILS_FILE = "experimental/modelDetails.json";
    private static final Pattern ARRAY_PATTERN = Pattern.compile("\\[\\]");
    private static final Pattern JSON_PATH_PATTERN = Pattern.compile("\\.|\\[|\\]");

    public static n parseModelJson(MojoReaderBackend mojoReaderBackend) {
        n n2;
        block12: {
            BufferedReader bufferedReader = mojoReaderBackend.getTextFile(MODEL_DETAILS_FILE);
            Throwable throwable = null;
            try {
                e e2 = new f().b();
                n2 = e2.a((Reader)bufferedReader, n.class);
                if (bufferedReader == null) break block12;
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        Throwable throwable3 = throwable2;
                        throwable = throwable2;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (bufferedReader != null) {
                            if (throwable != null) {
                                try {
                                    bufferedReader.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                bufferedReader.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (Exception exception) {
                    return null;
                }
            }
            bufferedReader.close();
        }
        return n2;
    }

    public static Table[] readTableArray(n modelJson, String tablePath) {
        k k2;
        Objects.requireNonNull(modelJson);
        k k3 = k2 = ModelJsonReader.findInJson(modelJson, tablePath);
        if (k2 instanceof m) {
            return null;
        }
        h h2 = k2.j();
        Table[] tableArray = new Table[h2.a()];
        for (int i2 = 0; i2 < h2.a(); ++i2) {
            Table table;
            tableArray[i2] = table = ModelJsonReader.readTableJson(h2.a(i2).i());
        }
        return tableArray;
    }

    private static Table readTableJson(n tableJson) {
        int n2 = tableJson.a("rowcount").g();
        h h2 = ModelJsonReader.findInJson(tableJson, "columns").j();
        int n3 = h2.a();
        String[] stringArray = new String[n3];
        Table.ColumnType[] columnTypeArray = new Table.ColumnType[n3];
        String[] stringArray2 = new String[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            n n4 = h2.a(i2).i();
            stringArray[i2] = n4.a("description").c();
            columnTypeArray[i2] = Table.ColumnType.extractType(n4.a("type").c());
            stringArray2[i2] = n4.a("format").c();
        }
        h h3 = ModelJsonReader.findInJson(tableJson, "data").j();
        Object[][] objectArray = new Object[n3][n2];
        for (int i3 = 0; i3 < n3; ++i3) {
            h h4 = h3.a(i3).j();
            block9: for (int i4 = 0; i4 < n2; ++i4) {
                k k2;
                k k3 = h4.a(i4);
                if (k3 == null || !((k2 = k3) instanceof p)) {
                    objectArray[i3][i4] = null;
                    continue;
                }
                p p2 = k3.k();
                switch (columnTypeArray[i3]) {
                    case LONG: {
                        if (p2.l()) {
                            objectArray[i3][i4] = p2.f();
                            continue block9;
                        }
                        objectArray[i3][i4] = null;
                        continue block9;
                    }
                    case DOUBLE: {
                        k2 = p2;
                        if (!(k2 instanceof m)) {
                            objectArray[i3][i4] = p2.d();
                            continue block9;
                        }
                        objectArray[i3][i4] = null;
                        continue block9;
                    }
                    case FLOAT: {
                        k2 = p2;
                        objectArray[i3][i4] = !(k2 instanceof m) ? Float.valueOf(p2.e()) : null;
                    }
                    case INT: {
                        objectArray[i3][i4] = p2.l() ? Integer.valueOf(p2.g()) : null;
                    }
                    case STRING: {
                        objectArray[i3][i4] = p2.c();
                    }
                }
            }
        }
        return new Table(tableJson.a("name").c(), tableJson.a("description").c(), new String[n2], stringArray, columnTypeArray, null, stringArray2, objectArray);
    }

    public static Table readTable(n modelJson, String tablePath) {
        k k2;
        Objects.requireNonNull(modelJson);
        k k3 = k2 = ModelJsonReader.findInJson(modelJson, tablePath);
        if (k2 instanceof m) {
            LOG.debug(String.format("Table '%s' doesn't exist in MojoModel dump.", tablePath));
            return null;
        }
        return ModelJsonReader.readTableJson(k2.i());
    }

    public static <T> void fillObjects(List<T> objects, h from) {
        for (int i2 = 0; i2 < from.a(); ++i2) {
            k k2 = from.a(i2);
            ModelJsonReader.fillObject(objects.get(i2), k2, "");
        }
    }

    public static void fillObject(Object object, k from, String elementPath) {
        k k2;
        Objects.requireNonNull(object);
        Objects.requireNonNull(elementPath);
        k k3 = k2 = ModelJsonReader.findInJson(from, elementPath);
        if (k2 instanceof m) {
            LOG.warn(String.format("Element '%s' not found in JSON. Skipping. Object '%s' is not populated by values.", elementPath, object.getClass().getName()));
            return;
        }
        n n2 = k2.i();
        Class<?> clazz = object.getClass();
        Field[] fieldArray = clazz.getFields();
        for (int i2 = 0; i2 < fieldArray.length; ++i2) {
            Object object2;
            Field field = fieldArray[i2];
            if (Modifier.isTransient(field.getModifiers())) continue;
            Class<Object> clazz2 = field.getType();
            SerializedName serializedName = field.getAnnotation(SerializedName.class);
            Object object3 = serializedName == null ? (((String)(object2 = field.getName())).charAt(0) == '_' ? ((String)object2).substring(1) : object2) : serializedName.value();
            try {
                k k4;
                field.setAccessible(true);
                assert (field.isAccessible());
                object2 = null;
                if (clazz2.isAssignableFrom(Object.class)) {
                    k4 = n2.a((String)object3);
                    if (k4 != null) {
                        k k5;
                        k3 = k5 = n2.a("type");
                        TypeHint typeHint = !(k5 instanceof m) ? TypeHint.fromStringIgnoreCase(k5.c()) : null;
                        object2 = ModelJsonReader.convertBasedOnJsonType(k4, typeHint);
                    }
                } else if (clazz2.isAssignableFrom(Double.TYPE) || clazz2.isAssignableFrom(Double.class)) {
                    k4 = n2.a((String)object3);
                    if (k4 != null && !((k3 = k4) instanceof m)) {
                        object2 = k4.d();
                    }
                } else if (clazz2.isAssignableFrom(Integer.TYPE) || clazz2.isAssignableFrom(Integer.class)) {
                    k4 = n2.a((String)object3);
                    if (k4 != null && !((k3 = k4) instanceof m)) {
                        object2 = k4.g();
                    }
                } else if (clazz2.isAssignableFrom(Long.TYPE) || clazz2.isAssignableFrom(Long.class)) {
                    k4 = n2.a((String)object3);
                    if (k4 != null && !((k3 = k4) instanceof m)) {
                        object2 = k4.f();
                    }
                } else if (clazz2.isAssignableFrom(String.class)) {
                    k4 = n2.a((String)object3);
                    if (k4 != null && !((k3 = k4) instanceof m)) {
                        object2 = k4.c();
                    }
                } else if (clazz2.isAssignableFrom(Table.class) && (k4 = n2.a((String)object3)) != null && !((k3 = k4) instanceof m)) {
                    object2 = ModelJsonReader.readTable(k4.i(), serializedName != null ? serializedName.insideElementPath() : "");
                }
                if (object2 == null) continue;
                field.set(object, object2);
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                System.err.println(String.format("Field '%s' could not be accessed. Ignoring.", object3));
                continue;
            }
            catch (ClassCastException | UnsupportedOperationException runtimeException) {
                System.err.println(String.format("Field '%s' could not be casted to '%s'. Ignoring.", object3, clazz2.toString()));
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static Object convertBasedOnJsonType(k convertFrom, TypeHint typeHint) {
        void var2_30;
        k k2 = convertFrom;
        if (!(k2 instanceof m)) {
            k2 = convertFrom;
            if (k2 instanceof h) {
                h h2 = convertFrom.j();
                if (typeHint != null) {
                    switch (typeHint) {
                        case OBJECT_ARR: {
                            Object[] objectArray = new Object[h2.a()];
                            int n2 = 0;
                            while (true) {
                                k k3;
                                if (n2 >= h2.a()) {
                                    Object[] objectArray2 = objectArray;
                                    return var2_30;
                                }
                                k2 = k3 = h2.a(n2);
                                objectArray[n2] = k3 instanceof p ? ModelJsonReader.convertBasedOnJsonType(k3, null) : ModelJsonReader.convertJsonObject(k3.i());
                                ++n2;
                            }
                        }
                        case DOUBLE_ARR: {
                            double[] dArray = new double[h2.a()];
                            int n3 = 0;
                            while (true) {
                                if (n3 >= h2.a()) {
                                    double[] dArray2 = dArray;
                                    return var2_30;
                                }
                                dArray[n3] = h2.a(n3).d();
                                ++n3;
                            }
                        }
                        case FLOAT_ARR: {
                            double[] dArray = new double[h2.a()];
                            int n4 = 0;
                            while (true) {
                                if (n4 >= h2.a()) {
                                    double[] dArray3 = dArray;
                                    return var2_30;
                                }
                                dArray[n4] = h2.a(n4).d();
                                ++n4;
                            }
                        }
                        case STRING_ARR: {
                            String[] stringArray = new String[h2.a()];
                            int n5 = 0;
                            while (true) {
                                if (n5 >= h2.a()) {
                                    String[] stringArray2 = stringArray;
                                    return var2_30;
                                }
                                stringArray[n5] = h2.a(n5).c();
                                ++n5;
                            }
                        }
                        case STRING_ARR_ARR: {
                            String[][] stringArrayArray = new String[h2.a()][];
                            int n6 = 0;
                            while (true) {
                                if (n6 >= h2.a()) {
                                    String[][] stringArrayArray2 = stringArrayArray;
                                    return var2_30;
                                }
                                h h3 = h2.a(n6).j();
                                stringArrayArray[n6] = new String[h3.a()];
                                for (int i2 = 0; i2 < h3.a(); ++i2) {
                                    stringArrayArray[n6][i2] = h3.a(i2).c();
                                }
                                ++n6;
                            }
                        }
                        case INT_ARR: {
                            int[] nArray = new int[h2.a()];
                            int n7 = 0;
                            while (true) {
                                if (n7 >= h2.a()) {
                                    int[] nArray2 = nArray;
                                    return var2_30;
                                }
                                nArray[n7] = h2.a(n7).g();
                                ++n7;
                            }
                        }
                        case LONG_ARR: {
                            long[] lArray = new long[h2.a()];
                            int n8 = 0;
                            while (true) {
                                if (n8 >= h2.a()) {
                                    long[] lArray2 = lArray;
                                    return var2_30;
                                }
                                lArray[n8] = h2.a(n8).f();
                                ++n8;
                            }
                        }
                    }
                }
                Object var2_18 = null;
                return var2_30;
            }
            k2 = convertFrom;
            if (k2 instanceof p) {
                p p2 = convertFrom.k();
                if (p2.a()) {
                    Boolean bl = p2.h();
                    return var2_30;
                }
                if (p2.m()) {
                    String string = p2.c();
                    return var2_30;
                }
                if (!p2.l()) return var2_30;
                if (typeHint == null) {
                    Double d2 = p2.d();
                    return var2_30;
                }
                switch (typeHint) {
                    case INT: {
                        Integer n9 = p2.g();
                        return var2_30;
                    }
                    case FLOAT: {
                        Float f2 = Float.valueOf(p2.e());
                        return var2_30;
                    }
                    case DOUBLE: {
                        Double d3 = p2.d();
                        return var2_30;
                    }
                    case LONG: {
                        Long l2 = p2.f();
                        return var2_30;
                    }
                }
                Double d4 = p2.d();
                return var2_30;
            }
            k2 = convertFrom;
            if (k2 instanceof n) {
                Object object = ModelJsonReader.convertJsonObject(convertFrom.i());
                return var2_30;
            }
        }
        Object var2_29 = null;
        return var2_30;
    }

    private static Object convertJsonObject(n convertFrom) {
        k k2;
        k k3 = convertFrom.a("__meta");
        if (k3 == null || (k2 = k3) instanceof m) {
            return null;
        }
        String string = ModelJsonReader.findInJson(k3, "schema_name").c();
        if ("FrameKeyV3".equals(string) || "ModelKeyV3".equals(string)) {
            String string2 = convertFrom.a("name").c();
            String string3 = convertFrom.a("type").c();
            ParameterKey.Type type = ModelJsonReader.convertKeyType(string3);
            String string4 = convertFrom.a("URL").c();
            return new ParameterKey(string2, type, string4);
        }
        if ("ColSpecifierV3".equals(string)) {
            k k4;
            String string5 = convertFrom.a("column_name").c();
            k2 = k4 = convertFrom.a("is_member_of_frames");
            String[] stringArray = k4 instanceof h ? ModelJsonReader.convertStringJsonArray(convertFrom.a("is_member_of_frames").j()) : null;
            return new ColumnSpecifier(string5, stringArray);
        }
        if ("KeyValueV3".equals(string)) {
            return new KeyValue(convertFrom.a("key").c(), convertFrom.a("value").d());
        }
        LOG.error(String.format("Error reading MOJO JSON: Object not supported: \n %s ", convertFrom.toString()));
        return null;
    }

    private static String[] convertStringJsonArray(h jsonArray) {
        Objects.requireNonNull(jsonArray);
        k k2 = jsonArray;
        if (k2 instanceof m) {
            return null;
        }
        String[] stringArray = new String[jsonArray.a()];
        for (int i2 = 0; i2 < jsonArray.a(); ++i2) {
            k k3 = jsonArray.a(i2);
            k2 = k3;
            if (k3 instanceof m) continue;
            stringArray[i2] = jsonArray.a(i2).c();
        }
        return stringArray;
    }

    private static final ParameterKey.Type convertKeyType(String type) {
        if ("Key<Frame>".equals(type)) {
            return ParameterKey.Type.FRAME;
        }
        if ("Key<Model>".equals(type)) {
            return ParameterKey.Type.MODEL;
        }
        return ParameterKey.Type.GENERIC;
    }

    protected static k findInJson(k jsonElement, String jsonPath) {
        String[] stringArray = JSON_PATH_PATTERN.split(jsonPath);
        k k2 = jsonElement;
        String[] stringArray2 = stringArray;
        int n2 = stringArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = stringArray2[i2];
            if ((string = string.trim()).isEmpty()) continue;
            if (k2 == null) break;
            k k3 = k2;
            if (k3 instanceof n) {
                k2 = ((n)k2).a(string);
                continue;
            }
            k3 = k2;
            if (!(k3 instanceof h)) break;
            int n3 = Integer.valueOf(string) - 1;
            k2 = ((h)k2).a(n3);
        }
        if (k2 == null) {
            return m.a;
        }
        return k2;
    }

    public static boolean elementExists(k jsonElement, String jsonPath) {
        k k2 = ModelJsonReader.findInJson(jsonElement, jsonPath);
        boolean bl = k2 instanceof m;
        return !bl;
    }

    private static enum TypeHint {
        INT,
        FLOAT,
        DOUBLE,
        LONG,
        DOUBLE_ARR,
        FLOAT_ARR,
        STRING_ARR,
        STRING_ARR_ARR,
        INT_ARR,
        LONG_ARR,
        OBJECT_ARR;


        private static TypeHint fromStringIgnoreCase(String from) {
            Matcher matcher = ARRAY_PATTERN.matcher(from);
            boolean bl = matcher.find();
            String string = matcher.replaceAll("_ARR");
            try {
                return TypeHint.valueOf(string.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (bl) {
                    return OBJECT_ARR;
                }
                return null;
            }
        }
    }
}

