/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.attributes;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;

public class Table
implements Serializable {
    private String _tableHeader;
    private String _tableDescription;
    private String[] _rowHeaders;
    private String[] _colHeaders;
    private ColumnType[] _colTypes;
    private Object[][] _cellValues;
    private String _colHeaderForRowHeaders;
    private String[] _colFormats;

    public Table(String tableHeader, String tableDescription, String[] rowHeaders, String[] columnHeaders, ColumnType[] columnTypes, String colHeaderForRowHeaders, String[] colFormats, Object[][] cellValues) {
        int n2;
        Objects.requireNonNull(columnHeaders);
        Objects.requireNonNull(rowHeaders);
        Objects.requireNonNull(cellValues);
        if (tableHeader == null) {
            this._tableHeader = "";
        }
        if (tableDescription == null) {
            this._tableDescription = "";
        }
        this._colHeaderForRowHeaders = colHeaderForRowHeaders;
        for (n2 = 0; n2 < rowHeaders.length; ++n2) {
            if (rowHeaders[n2] != null) continue;
            rowHeaders[n2] = "";
        }
        for (n2 = 0; n2 < columnHeaders.length; ++n2) {
            if (columnHeaders[n2] != null) continue;
            columnHeaders[n2] = "";
        }
        if (columnTypes == null) {
            columnTypes = new ColumnType[columnHeaders.length];
            Arrays.fill((Object[])this._colTypes, (Object)ColumnType.STRING);
        }
        this._tableHeader = tableHeader;
        this._tableDescription = tableDescription;
        this._rowHeaders = rowHeaders;
        this._colHeaders = columnHeaders;
        this._colTypes = columnTypes;
        this._cellValues = cellValues;
        this._colFormats = colFormats;
    }

    public String getTableHeader() {
        return this._tableHeader;
    }

    public String getTableDescription() {
        return this._tableDescription;
    }

    public String[] getRowHeaders() {
        return this._rowHeaders;
    }

    public String[] getColHeaders() {
        return this._colHeaders;
    }

    public ColumnType[] getColTypes() {
        return this._colTypes;
    }

    public String[] getColTypesString() {
        String[] stringArray = new String[this._colTypes.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringArray[i2] = this._colTypes[i2].toString().toLowerCase();
        }
        return stringArray;
    }

    public Object[][] getCellValues() {
        return this._cellValues;
    }

    public String getColHeaderForRowHeaders() {
        return this._colHeaderForRowHeaders;
    }

    public int columns() {
        return this._cellValues.length;
    }

    public int rows() {
        if (this._cellValues[0] != null) {
            return this._cellValues[0].length;
        }
        return 0;
    }

    public Object getCell(int column, int row) {
        return this._cellValues[column][row];
    }

    public String[] getColumnFormats() {
        return this._colFormats;
    }

    public int findColumnIndex(String columnName) {
        for (int i2 = 0; i2 < this._colHeaders.length; ++i2) {
            if (!this._colHeaders[i2].equals(columnName)) continue;
            return i2;
        }
        return -1;
    }

    public static enum ColumnType {
        LONG,
        DOUBLE,
        FLOAT,
        INT,
        STRING;


        public static ColumnType extractType(String type) {
            if (type == null) {
                return STRING;
            }
            String string = type.trim().toUpperCase();
            try {
                return ColumnType.valueOf(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return STRING;
            }
        }
    }
}

