/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.tools;

import hex.genmodel.GenMunger;
import hex.genmodel.easy.RowData;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Serializable;
import java.util.HashMap;

public class MungeCsv {
    private static String assemblyClassName;
    private static String inputCSVFileName;
    private static String outputCSVFileName;
    private static int haveHeaders;

    private static void usage() {
        System.out.println("");
        System.out.println("usage:  java [...java args...] hex.genmodel.tools.MungeCsv --header --model modelClassName --input inputCSVFileName --output outputCSVFileName");
        System.out.println("");
        System.out.println("        assembly class name is something like AssemblyPojo_bleehbleehbleeh.");
        System.out.println("");
        System.out.println("        inputCSVFileName is the test data set.");
        System.out.println("        Specifying --header is required for h2o-3.");
        System.out.println("");
        System.out.println("        outputCSVFileName is the munged data set (one row per data set row).");
        System.out.println("");
        System.exit(1);
    }

    private static void parseArgs(String[] args) {
        block12: for (int i2 = 0; i2 < args.length; ++i2) {
            String string;
            switch (string = args[i2]) {
                case "--munger": {
                    if (++i2 >= args.length) {
                        MungeCsv.usage();
                    }
                    assemblyClassName = args[i2];
                    continue block12;
                }
                case "--input": {
                    if (++i2 >= args.length) {
                        MungeCsv.usage();
                    }
                    inputCSVFileName = args[i2];
                    continue block12;
                }
                case "--output": {
                    if (++i2 >= args.length) {
                        MungeCsv.usage();
                    }
                    outputCSVFileName = args[i2];
                    continue block12;
                }
                case "--header": {
                    haveHeaders = 1;
                    continue block12;
                }
                default: {
                    System.out.println("bad param... skipping.");
                }
            }
        }
        if (haveHeaders != 1) {
            System.out.println("ERROR: header not specified");
            MungeCsv.usage();
        }
        if (assemblyClassName == null) {
            System.out.println("ERROR: model not specified");
            MungeCsv.usage();
        }
        if (inputCSVFileName == null) {
            System.out.println("ERROR: input not specified");
            MungeCsv.usage();
        }
        if (outputCSVFileName == null) {
            System.out.println("ERROR: output not specified");
            MungeCsv.usage();
        }
    }

    private static RowData parseDataRow(String line, GenMunger munger) {
        if (line.isEmpty() || line.equals("")) {
            return null;
        }
        String[] stringArray = line.split(",(?=([^\"]*\"[^\"]*\")*[^\"]*$)|(,)", -1);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringArray[i2] = stringArray[i2] == null ? "" : stringArray[i2];
        }
        if (stringArray.length != munger.inNames().length) {
            return null;
        }
        return munger.fillDefault(stringArray);
    }

    public static void main(String[] args) throws Exception {
        int n2;
        MungeCsv.parseArgs(args);
        GenMunger genMunger = (GenMunger)Class.forName(assemblyClassName).newInstance();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(inputCSVFileName));
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(outputCSVFileName));
        String[] stringArray = genMunger.outNames();
        StringBuilder stringBuilder = new StringBuilder();
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            stringBuilder.append("\"").append(stringArray[n2]).append("\"");
            if (n2 >= stringArray.length - 1) continue;
            stringBuilder.append(",");
        }
        bufferedWriter.write(stringBuilder.toString());
        bufferedWriter.write("\n");
        n2 = 0;
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                Serializable serializable;
                RowData rowData;
                if (++n2 == 1) continue;
                try {
                    rowData = MungeCsv.parseDataRow(string, genMunger);
                }
                catch (NumberFormatException numberFormatException) {
                    serializable = numberFormatException;
                    numberFormatException.printStackTrace();
                    System.out.println("Failed to parse row: " + n2);
                    throw new RuntimeException();
                }
                serializable = genMunger.fit(rowData);
                for (int i2 = 0; i2 < genMunger.outNames().length; ++i2) {
                    Double d2 = serializable == null ? Double.valueOf(Double.NaN) : ((HashMap)serializable).get(genMunger.outNames()[i2]);
                    if (d2 instanceof Double) {
                        bufferedWriter.write(String.valueOf(d2));
                    } else {
                        bufferedWriter.write("\"" + d2 + "\"");
                    }
                    if (i2 >= genMunger.outNames().length - 1) continue;
                    bufferedWriter.write(",");
                }
                bufferedWriter.write("\n");
            }
        }
        catch (Exception exception) {
            System.out.println("Caught exception on line " + n2);
            System.out.println("");
            exception.printStackTrace();
            System.exit(1);
        }
        finally {
            bufferedWriter.close();
            bufferedReader.close();
        }
        System.exit(0);
    }

    static {
        haveHeaders = -1;
    }
}

