/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.keyvalue.AbstractMapEntry;

public class BeanMap
extends AbstractMap<Object, Object>
implements Cloneable {
    private transient Object bean;
    private transient HashMap<String, Method> readMethods = new HashMap();
    private transient HashMap<String, Method> writeMethods = new HashMap();
    private transient HashMap<String, Class<? extends Object>> types = new HashMap();
    public static final Object[] NULL_ARGUMENTS = new Object[0];
    private static final Map<Class<? extends Object>, Transformer> typeTransformers = Collections.unmodifiableMap(BeanMap.createTypeTransformers());
    @Deprecated
    public static HashMap defaultTransformers = new HashMap(){

        @Override
        public final void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean containsKey(Object key) {
            return typeTransformers.containsKey(key);
        }

        @Override
        public final boolean containsValue(Object value) {
            return typeTransformers.containsValue(value);
        }

        @Override
        public final Set entrySet() {
            return typeTransformers.entrySet();
        }

        @Override
        public final Object get(Object key) {
            return typeTransformers.get(key);
        }

        @Override
        public final boolean isEmpty() {
            return false;
        }

        @Override
        public final Set keySet() {
            return typeTransformers.keySet();
        }

        @Override
        public final Object put(Object key, Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void putAll(Map m2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final Object remove(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final int size() {
            return typeTransformers.size();
        }

        @Override
        public final Collection values() {
            return typeTransformers.values();
        }
    };

    private static Map<Class<? extends Object>, Transformer> createTypeTransformers() {
        HashMap<Class<? extends Object>, Transformer> hashMap = new HashMap<Class<? extends Object>, Transformer>();
        hashMap.put(Boolean.TYPE, new Transformer(){

            @Override
            public final Object transform(Object input) {
                return Boolean.valueOf(input.toString());
            }
        });
        hashMap.put(Character.TYPE, new Transformer(){

            @Override
            public final Object transform(Object input) {
                return new Character(input.toString().charAt(0));
            }
        });
        hashMap.put(Byte.TYPE, new Transformer(){

            @Override
            public final Object transform(Object input) {
                return Byte.valueOf(input.toString());
            }
        });
        hashMap.put(Short.TYPE, new Transformer(){

            @Override
            public final Object transform(Object input) {
                return Short.valueOf(input.toString());
            }
        });
        hashMap.put(Integer.TYPE, new Transformer(){

            @Override
            public final Object transform(Object input) {
                return Integer.valueOf(input.toString());
            }
        });
        hashMap.put(Long.TYPE, new Transformer(){

            @Override
            public final Object transform(Object input) {
                return Long.valueOf(input.toString());
            }
        });
        hashMap.put(Float.TYPE, new Transformer(){

            @Override
            public final Object transform(Object input) {
                return Float.valueOf(input.toString());
            }
        });
        hashMap.put(Double.TYPE, new Transformer(){

            @Override
            public final Object transform(Object input) {
                return Double.valueOf(input.toString());
            }
        });
        return hashMap;
    }

    public BeanMap() {
    }

    public BeanMap(Object bean) {
        this.bean = bean;
        this.initialise();
    }

    @Override
    public String toString() {
        return "BeanMap<" + String.valueOf(this.bean) + ">";
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        Object obj;
        BeanMap beanMap = (BeanMap)super.clone();
        if (this.bean == null) {
            return beanMap;
        }
        Class<?> clazz = this.bean.getClass();
        try {
            obj = clazz.newInstance();
        }
        catch (Exception exception) {
            CloneNotSupportedException cloneNotSupportedException = new CloneNotSupportedException("Unable to instantiate the underlying bean \"" + clazz.getName() + "\": " + exception);
            BeanUtils.initCause(cloneNotSupportedException, exception);
            throw cloneNotSupportedException;
        }
        try {
            beanMap.setBean(obj);
        }
        catch (Exception exception) {
            CloneNotSupportedException cloneNotSupportedException = new CloneNotSupportedException("Unable to set bean in the cloned bean map: " + exception);
            BeanUtils.initCause(cloneNotSupportedException, exception);
            throw cloneNotSupportedException;
        }
        try {
            for (String string : this.readMethods.keySet()) {
                if (this.getWriteMethod((Object)string) == null) continue;
                beanMap.put(string, this.get(string));
            }
        }
        catch (Exception exception) {
            CloneNotSupportedException cloneNotSupportedException = new CloneNotSupportedException("Unable to copy bean values to cloned bean map: " + exception);
            BeanUtils.initCause(cloneNotSupportedException, exception);
            throw cloneNotSupportedException;
        }
        return beanMap;
    }

    public void putAllWriteable(BeanMap map) {
        for (String string : map.readMethods.keySet()) {
            if (this.getWriteMethod((Object)string) == null) continue;
            this.put(string, map.get(string));
        }
    }

    @Override
    public void clear() {
        if (this.bean == null) {
            return;
        }
        Class<?> clazz = null;
        try {
            clazz = this.bean.getClass();
            this.bean = clazz.newInstance();
            return;
        }
        catch (Exception exception) {
            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException("Could not create new instance of class: " + clazz);
            BeanUtils.initCause(unsupportedOperationException, exception);
            throw unsupportedOperationException;
        }
    }

    @Override
    public boolean containsKey(Object name) {
        Method method = this.getReadMethod(name);
        return method != null;
    }

    @Override
    public boolean containsValue(Object value) {
        return super.containsValue(value);
    }

    @Override
    public Object get(Object name) {
        Method method;
        if (this.bean != null && (method = this.getReadMethod(name)) != null) {
            try {
                return method.invoke(this.bean, NULL_ARGUMENTS);
            }
            catch (IllegalAccessException illegalAccessException) {
                this.logWarn(illegalAccessException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.logWarn(illegalArgumentException);
            }
            catch (InvocationTargetException invocationTargetException) {
                this.logWarn(invocationTargetException);
            }
            catch (NullPointerException nullPointerException) {
                this.logWarn(nullPointerException);
            }
        }
        return null;
    }

    @Override
    public Object put(Object name, Object value) throws IllegalArgumentException, ClassCastException {
        if (this.bean != null) {
            Object object = this.get(name);
            Method method = this.getWriteMethod(name);
            if (method == null) {
                throw new IllegalArgumentException("The bean of type: " + this.bean.getClass().getName() + " has no property called: " + name);
            }
            try {
                Object[] objectArray = this.createWriteMethodArguments(method, value);
                method.invoke(this.bean, objectArray);
                Object object2 = this.get(name);
                this.firePropertyChange(name, object, object2);
            }
            catch (InvocationTargetException invocationTargetException) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException(invocationTargetException.getMessage());
                if (!BeanUtils.initCause(illegalArgumentException, invocationTargetException)) {
                    this.logInfo(invocationTargetException);
                }
                throw illegalArgumentException;
            }
            catch (IllegalAccessException illegalAccessException) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException(illegalAccessException.getMessage());
                if (!BeanUtils.initCause(illegalArgumentException, illegalAccessException)) {
                    this.logInfo(illegalAccessException);
                }
                throw illegalArgumentException;
            }
            return object;
        }
        return null;
    }

    @Override
    public int size() {
        return this.readMethods.size();
    }

    @Override
    public Set<Object> keySet() {
        return Collections.unmodifiableSet(this.readMethods.keySet());
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        return Collections.unmodifiableSet(new AbstractSet<Map.Entry<Object, Object>>(){

            @Override
            public Iterator<Map.Entry<Object, Object>> iterator() {
                return BeanMap.this.entryIterator();
            }

            @Override
            public int size() {
                return BeanMap.this.readMethods.size();
            }
        });
    }

    @Override
    public Collection<Object> values() {
        ArrayList<Object> arrayList = new ArrayList<Object>(this.readMethods.size());
        Iterator<Object> iterator = this.valueIterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return Collections.unmodifiableList(arrayList);
    }

    public Class<?> getType(String name) {
        return this.types.get(name);
    }

    public Iterator<String> keyIterator() {
        return this.readMethods.keySet().iterator();
    }

    public Iterator<Object> valueIterator() {
        final Iterator<String> iterator = this.keyIterator();
        return new Iterator<Object>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public Object next() {
                Object e2 = iterator.next();
                return BeanMap.this.get(e2);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove() not supported for BeanMap");
            }
        };
    }

    public Iterator<Map.Entry<Object, Object>> entryIterator() {
        final Iterator<String> iterator = this.keyIterator();
        return new Iterator<Map.Entry<Object, Object>>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public Map.Entry<Object, Object> next() {
                Object e2 = iterator.next();
                Object object = BeanMap.this.get(e2);
                Entry entry = new Entry(BeanMap.this, e2, object);
                return entry;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove() not supported for BeanMap");
            }
        };
    }

    public Object getBean() {
        return this.bean;
    }

    public void setBean(Object newBean) {
        this.bean = newBean;
        this.reinitialise();
    }

    public Method getReadMethod(String name) {
        return this.readMethods.get(name);
    }

    public Method getWriteMethod(String name) {
        return this.writeMethods.get(name);
    }

    protected Method getReadMethod(Object name) {
        return this.readMethods.get(name);
    }

    protected Method getWriteMethod(Object name) {
        return this.writeMethods.get(name);
    }

    protected void reinitialise() {
        this.readMethods.clear();
        this.writeMethods.clear();
        this.types.clear();
        this.initialise();
    }

    private void initialise() {
        if (this.getBean() == null) {
            return;
        }
        Class<?> clazz = this.getBean().getClass();
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            if (propertyDescriptorArray != null) {
                PropertyDescriptor[] propertyDescriptorArray2 = propertyDescriptorArray;
                int n2 = propertyDescriptorArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    PropertyDescriptor propertyDescriptor = propertyDescriptorArray2[i2];
                    if (propertyDescriptor == null) continue;
                    String string = propertyDescriptor.getName();
                    Method method = propertyDescriptor.getReadMethod();
                    Method method2 = propertyDescriptor.getWriteMethod();
                    Class<?> clazz2 = propertyDescriptor.getPropertyType();
                    if (method != null) {
                        this.readMethods.put(string, method);
                    }
                    if (method2 != null) {
                        this.writeMethods.put(string, method2);
                    }
                    this.types.put(string, clazz2);
                }
            }
            return;
        }
        catch (IntrospectionException introspectionException) {
            this.logWarn(introspectionException);
            return;
        }
    }

    protected void firePropertyChange(Object key, Object oldValue, Object newValue) {
    }

    protected Object[] createWriteMethodArguments(Method method, Object value) throws IllegalAccessException, ClassCastException {
        try {
            Object object;
            Object[] objectArray;
            if (value != null && (objectArray = method.getParameterTypes()) != null && objectArray.length > 0 && !((Class)(object = objectArray[0])).isAssignableFrom(value.getClass())) {
                value = this.convertType((Class<?>)object, value);
            }
            objectArray = new Object[]{value};
            return objectArray;
        }
        catch (InvocationTargetException invocationTargetException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(invocationTargetException.getMessage());
            if (!BeanUtils.initCause(illegalArgumentException, invocationTargetException)) {
                this.logInfo(invocationTargetException);
            }
            throw illegalArgumentException;
        }
        catch (InstantiationException instantiationException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(instantiationException.getMessage());
            if (!BeanUtils.initCause(illegalArgumentException, instantiationException)) {
                this.logInfo(instantiationException);
            }
            BeanUtils.initCause(illegalArgumentException, instantiationException);
            throw illegalArgumentException;
        }
    }

    protected Object convertType(Class<?> newType, Object value) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Class[] classArray = new Class[]{value.getClass()};
        try {
            Constructor<?> constructor = newType.getConstructor(classArray);
            Object[] objectArray = new Object[]{value};
            return constructor.newInstance(objectArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Transformer transformer = this.getTypeTransformer(newType);
            if (transformer != null) {
                return transformer.transform(value);
            }
            return value;
        }
    }

    protected Transformer getTypeTransformer(Class<?> aType) {
        return typeTransformers.get(aType);
    }

    protected void logInfo(Exception ex) {
        System.out.println("INFO: Exception: " + ex);
    }

    protected void logWarn(Exception ex) {
        System.out.println("WARN: Exception: " + ex);
        ex.printStackTrace();
    }

    protected static class Entry
    extends AbstractMapEntry {
        private final BeanMap owner;

        protected Entry(BeanMap owner, Object key, Object value) {
            super(key, value);
            this.owner = owner;
        }

        @Override
        public Object setValue(Object value) {
            Object object = this.getKey();
            Object object2 = this.owner.get(object);
            this.owner.put(object, value);
            Object object3 = this.owner.get(object);
            super.setValue(object3);
            return object2;
        }
    }
}

