/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.commons.beanutils.BeanIntrospector;
import org.apache.commons.beanutils.IntrospectionContext;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultBeanIntrospector
implements BeanIntrospector {
    public static final BeanIntrospector INSTANCE = new DefaultBeanIntrospector();
    private static final Class<?>[] EMPTY_CLASS_PARAMETERS = new Class[0];
    private static final Class<?>[] LIST_CLASS_PARAMETER = new Class[]{List.class};
    private final Log log = LogFactory.getLog(this.getClass());

    private DefaultBeanIntrospector() {
    }

    @Override
    public void introspect(IntrospectionContext icontext) {
        BeanInfo beanInfo;
        try {
            beanInfo = Introspector.getBeanInfo(icontext.getTargetClass());
        }
        catch (IntrospectionException introspectionException) {
            this.log.error("Error when inspecting class " + icontext.getTargetClass(), introspectionException);
            return;
        }
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        if (propertyDescriptorArray == null) {
            propertyDescriptorArray = new PropertyDescriptor[]{};
        }
        this.handleIndexedPropertyDescriptors(icontext.getTargetClass(), propertyDescriptorArray);
        icontext.addPropertyDescriptors(propertyDescriptorArray);
    }

    private void handleIndexedPropertyDescriptors(Class<?> beanClass, PropertyDescriptor[] descriptors) {
        PropertyDescriptor[] propertyDescriptorArray = descriptors;
        int n2 = descriptors.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string;
            Method method;
            PropertyDescriptor propertyDescriptor = propertyDescriptorArray[i2];
            if (!(propertyDescriptor instanceof IndexedPropertyDescriptor)) continue;
            IndexedPropertyDescriptor indexedPropertyDescriptor = (IndexedPropertyDescriptor)propertyDescriptor;
            String string2 = indexedPropertyDescriptor.getName().substring(0, 1).toUpperCase() + indexedPropertyDescriptor.getName().substring(1);
            if (indexedPropertyDescriptor.getReadMethod() == null && (method = MethodUtils.getMatchingAccessibleMethod(beanClass, string = indexedPropertyDescriptor.getIndexedReadMethod() != null ? indexedPropertyDescriptor.getIndexedReadMethod().getName() : "get" + string2, EMPTY_CLASS_PARAMETERS)) != null) {
                try {
                    indexedPropertyDescriptor.setReadMethod(method);
                }
                catch (Exception exception) {
                    this.log.error("Error setting indexed property read method", exception);
                }
            }
            if (indexedPropertyDescriptor.getWriteMethod() != null) continue;
            string = indexedPropertyDescriptor.getIndexedWriteMethod() != null ? indexedPropertyDescriptor.getIndexedWriteMethod().getName() : "set" + string2;
            method = MethodUtils.getMatchingAccessibleMethod(beanClass, string, LIST_CLASS_PARAMETER);
            if (method == null) {
                for (Method method2 : beanClass.getMethods()) {
                    Class<?>[] classArray;
                    if (!method2.getName().equals(string) || (classArray = method2.getParameterTypes()).length != 1 || !List.class.isAssignableFrom(classArray[0])) continue;
                    method = method2;
                    break;
                }
            }
            if (method == null) continue;
            try {
                indexedPropertyDescriptor.setWriteMethod(method);
                continue;
            }
            catch (Exception exception) {
                this.log.error("Error setting indexed property write method", exception);
            }
        }
    }
}

