/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.io.Serializable;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.beanutils.DynaProperty;

abstract class JDBCDynaClass
implements Serializable,
DynaClass {
    protected boolean lowerCase = true;
    private boolean useColumnLabel;
    protected DynaProperty[] properties = null;
    protected Map<String, DynaProperty> propertiesMap = new HashMap<String, DynaProperty>();
    private Map<String, String> columnNameXref;

    JDBCDynaClass() {
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public DynaProperty getDynaProperty(String name) {
        if (name == null) {
            throw new IllegalArgumentException("No property name specified");
        }
        return this.propertiesMap.get(name);
    }

    @Override
    public DynaProperty[] getDynaProperties() {
        return this.properties;
    }

    @Override
    public DynaBean newInstance() throws IllegalAccessException, InstantiationException {
        throw new UnsupportedOperationException("newInstance() not supported");
    }

    public void setUseColumnLabel(boolean useColumnLabel) {
        this.useColumnLabel = useColumnLabel;
    }

    protected Class<?> loadClass(String className) throws SQLException {
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                classLoader = this.getClass().getClassLoader();
            }
            return Class.forName(className, false, classLoader);
        }
        catch (Exception exception) {
            throw new SQLException("Cannot load column class '" + className + "': " + exception);
        }
    }

    protected DynaProperty createDynaProperty(ResultSetMetaData metadata, int i2) throws SQLException {
        String string;
        String string2 = null;
        if (this.useColumnLabel) {
            string2 = metadata.getColumnLabel(i2);
        }
        if (string2 == null || string2.trim().length() == 0) {
            string2 = metadata.getColumnName(i2);
        }
        if (!(string = this.lowerCase ? string2.toLowerCase() : string2).equals(string2)) {
            if (this.columnNameXref == null) {
                this.columnNameXref = new HashMap<String, String>();
            }
            this.columnNameXref.put(string, string2);
        }
        String string3 = null;
        try {
            int n2 = metadata.getColumnType(i2);
            switch (n2) {
                case 91: {
                    return new DynaProperty(string, Date.class);
                }
                case 93: {
                    return new DynaProperty(string, Timestamp.class);
                }
                case 92: {
                    return new DynaProperty(string, Time.class);
                }
            }
            string3 = metadata.getColumnClassName(i2);
        }
        catch (SQLException sQLException) {}
        Class clazz = Object.class;
        if (string3 != null) {
            clazz = this.loadClass(string3);
        }
        return new DynaProperty(string, clazz);
    }

    protected void introspect(ResultSet resultSet) throws SQLException {
        ArrayList<DynaProperty> arrayList = new ArrayList<DynaProperty>();
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n2 = resultSetMetaData.getColumnCount();
        for (int i2 = 1; i2 <= n2; ++i2) {
            DynaProperty dynaProperty = this.createDynaProperty(resultSetMetaData, i2);
            if (dynaProperty == null) continue;
            arrayList.add(dynaProperty);
        }
        ArrayList<DynaProperty> arrayList2 = arrayList;
        DynaProperty[] dynaPropertyArray = this.properties = arrayList2.toArray(new DynaProperty[arrayList2.size()]);
        int n3 = this.properties.length;
        for (int i3 = 0; i3 < n3; ++i3) {
            DynaProperty dynaProperty = dynaPropertyArray[i3];
            this.propertiesMap.put(dynaProperty.getName(), dynaProperty);
        }
    }

    protected Object getObject(ResultSet resultSet, String name) throws SQLException {
        DynaProperty dynaProperty = this.getDynaProperty(name);
        if (dynaProperty == null) {
            throw new IllegalArgumentException("Invalid name '" + name + "'");
        }
        String string = this.getColumnName(name);
        Class<?> clazz = dynaProperty.getType();
        if (clazz.equals(Date.class)) {
            return resultSet.getDate(string);
        }
        if (clazz.equals(Timestamp.class)) {
            return resultSet.getTimestamp(string);
        }
        if (clazz.equals(Time.class)) {
            return resultSet.getTime(string);
        }
        return resultSet.getObject(string);
    }

    protected String getColumnName(String name) {
        if (this.columnNameXref != null && this.columnNameXref.containsKey(name)) {
            return this.columnNameXref.get(name);
        }
        return name;
    }
}

