/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.beanutils.BasicDynaBean;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.JDBCDynaClass;

public class RowSetDynaClass
extends JDBCDynaClass
implements Serializable,
DynaClass {
    protected int limit = -1;
    protected List<DynaBean> rows = new ArrayList<DynaBean>();

    public RowSetDynaClass(ResultSet resultSet) throws SQLException {
        this(resultSet, true, -1);
    }

    public RowSetDynaClass(ResultSet resultSet, int limit) throws SQLException {
        this(resultSet, true, limit);
    }

    public RowSetDynaClass(ResultSet resultSet, boolean lowerCase) throws SQLException {
        this(resultSet, lowerCase, -1);
    }

    public RowSetDynaClass(ResultSet resultSet, boolean lowerCase, int limit) throws SQLException {
        this(resultSet, lowerCase, limit, false);
    }

    public RowSetDynaClass(ResultSet resultSet, boolean lowerCase, boolean useColumnLabel) throws SQLException {
        this(resultSet, lowerCase, -1, useColumnLabel);
    }

    public RowSetDynaClass(ResultSet resultSet, boolean lowerCase, int limit, boolean useColumnLabel) throws SQLException {
        if (resultSet == null) {
            throw new NullPointerException();
        }
        this.lowerCase = lowerCase;
        this.limit = limit;
        this.setUseColumnLabel(useColumnLabel);
        this.introspect(resultSet);
        this.copy(resultSet);
    }

    public List<DynaBean> getRows() {
        return this.rows;
    }

    protected void copy(ResultSet resultSet) throws SQLException {
        int n2 = 0;
        while (resultSet.next() && (this.limit < 0 || n2++ < this.limit)) {
            DynaBean dynaBean = this.createDynaBean();
            DynaProperty[] dynaPropertyArray = this.properties;
            int n3 = this.properties.length;
            for (int i2 = 0; i2 < n3; ++i2) {
                DynaProperty dynaProperty = dynaPropertyArray[i2];
                String string = dynaProperty.getName();
                Object object = this.getObject(resultSet, string);
                dynaBean.set(string, object);
            }
            this.rows.add(dynaBean);
        }
    }

    protected DynaBean createDynaBean() {
        return new BasicDynaBean(this);
    }
}

