/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.converters;

import org.apache.commons.beanutils.converters.AbstractConverter;

public final class BooleanConverter
extends AbstractConverter {
    @Deprecated
    public static final Object NO_DEFAULT = new Object();
    private String[] trueStrings = new String[]{"true", "yes", "y", "on", "1"};
    private String[] falseStrings = new String[]{"false", "no", "n", "off", "0"};

    public BooleanConverter() {
    }

    public BooleanConverter(Object defaultValue) {
        if (defaultValue != NO_DEFAULT) {
            this.setDefaultValue(defaultValue);
        }
    }

    public BooleanConverter(String[] trueStrings, String[] falseStrings) {
        this.trueStrings = BooleanConverter.copyStrings(trueStrings);
        this.falseStrings = BooleanConverter.copyStrings(falseStrings);
    }

    public BooleanConverter(String[] trueStrings, String[] falseStrings, Object defaultValue) {
        this.trueStrings = BooleanConverter.copyStrings(trueStrings);
        this.falseStrings = BooleanConverter.copyStrings(falseStrings);
        if (defaultValue != NO_DEFAULT) {
            this.setDefaultValue(defaultValue);
        }
    }

    protected final Class<Boolean> getDefaultType() {
        return Boolean.class;
    }

    @Override
    protected final <T> T convertToType(Class<T> type, Object value) throws Throwable {
        if (Boolean.class.equals(type) || Boolean.TYPE.equals(type)) {
            String string;
            int n2;
            String string2 = value.toString().toLowerCase();
            String[] stringArray = this.trueStrings;
            int n3 = this.trueStrings.length;
            for (n2 = 0; n2 < n3; ++n2) {
                string = stringArray[n2];
                if (!string.equals(string2)) continue;
                return type.cast(Boolean.TRUE);
            }
            stringArray = this.falseStrings;
            n3 = this.falseStrings.length;
            for (n2 = 0; n2 < n3; ++n2) {
                string = stringArray[n2];
                if (!string.equals(string2)) continue;
                return type.cast(Boolean.FALSE);
            }
        }
        throw this.conversionException(type, value);
    }

    private static String[] copyStrings(String[] src) {
        String[] stringArray = new String[src.length];
        for (int i2 = 0; i2 < src.length; ++i2) {
            stringArray[i2] = src[i2].toLowerCase();
        }
        return stringArray;
    }
}

