/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.locale.converters;

import java.text.ParseException;
import java.util.Locale;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.locale.converters.DecimalLocaleConverter;

public class FloatLocaleConverter
extends DecimalLocaleConverter {
    public FloatLocaleConverter() {
        this(false);
    }

    public FloatLocaleConverter(boolean locPattern) {
        this(Locale.getDefault(), locPattern);
    }

    public FloatLocaleConverter(Locale locale) {
        this(locale, false);
    }

    public FloatLocaleConverter(Locale locale, boolean locPattern) {
        this(locale, null, locPattern);
    }

    public FloatLocaleConverter(Locale locale, String pattern) {
        this(locale, pattern, false);
    }

    public FloatLocaleConverter(Locale locale, String pattern, boolean locPattern) {
        super(locale, pattern, locPattern);
    }

    public FloatLocaleConverter(Object defaultValue) {
        this(defaultValue, false);
    }

    public FloatLocaleConverter(Object defaultValue, boolean locPattern) {
        this(defaultValue, Locale.getDefault(), locPattern);
    }

    public FloatLocaleConverter(Object defaultValue, Locale locale) {
        this(defaultValue, locale, false);
    }

    public FloatLocaleConverter(Object defaultValue, Locale locale, boolean locPattern) {
        this(defaultValue, locale, null, locPattern);
    }

    public FloatLocaleConverter(Object defaultValue, Locale locale, String pattern) {
        this(defaultValue, locale, pattern, false);
    }

    public FloatLocaleConverter(Object defaultValue, Locale locale, String pattern, boolean locPattern) {
        super(defaultValue, locale, pattern, locPattern);
    }

    @Override
    protected Object parse(Object value, String pattern) throws ParseException {
        double d2;
        Number number = (Number)super.parse(value, pattern);
        double d3 = number.doubleValue();
        double d4 = d2 >= 0.0 ? d3 : -d3;
        if (d4 != 0.0 && (d4 < (double)1.4E-45f || d4 > 3.4028234663852886E38)) {
            throw new ConversionException("Supplied number is not of type Float: " + number);
        }
        return new Float(number.floatValue());
    }
}

