/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.collections.KeyValue;
import org.apache.commons.collections.list.UnmodifiableList;

public class SequencedHashMap
implements Externalizable,
Cloneable,
Map {
    private Entry sentinel = SequencedHashMap.createSentinel();
    private HashMap entries;
    private transient long modCount = 0L;
    private static final int KEY = 0;
    private static final int VALUE = 1;
    private static final int ENTRY = 2;
    private static final int REMOVED_MASK = Integer.MIN_VALUE;
    private static final long serialVersionUID = 3380552487888102930L;

    private static final Entry createSentinel() {
        Entry entry;
        new Entry(null, null).prev = entry = new Entry(null, null);
        entry.next = entry;
        return entry;
    }

    public SequencedHashMap() {
        this.entries = new HashMap();
    }

    public SequencedHashMap(int initialSize) {
        this.entries = new HashMap(initialSize);
    }

    public SequencedHashMap(int initialSize, float loadFactor) {
        this.entries = new HashMap(initialSize, loadFactor);
    }

    public SequencedHashMap(Map m2) {
        this();
        this.putAll(m2);
    }

    private void removeEntry(Entry entry) {
        entry.next.prev = entry.prev;
        entry.prev.next = entry.next;
    }

    private void insertEntry(Entry entry) {
        entry.next = this.sentinel;
        entry.prev = this.sentinel.prev;
        this.sentinel.prev.next = entry;
        this.sentinel.prev = entry;
    }

    public int size() {
        return this.entries.size();
    }

    public boolean isEmpty() {
        return this.sentinel.next == this.sentinel;
    }

    public boolean containsKey(Object key) {
        return this.entries.containsKey(key);
    }

    public boolean containsValue(Object value) {
        if (value == null) {
            Entry entry = this.sentinel.next;
            while (entry != this.sentinel) {
                if (entry.getValue() == null) {
                    return true;
                }
                entry = entry.next;
            }
        } else {
            Entry entry = this.sentinel.next;
            while (entry != this.sentinel) {
                if (value.equals(entry.getValue())) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    public Object get(Object o2) {
        Entry entry = (Entry)this.entries.get(o2);
        if (entry == null) {
            return null;
        }
        return entry.getValue();
    }

    public Map.Entry getFirst() {
        if (this.isEmpty()) {
            return null;
        }
        return this.sentinel.next;
    }

    public Object getFirstKey() {
        return this.sentinel.next.getKey();
    }

    public Object getFirstValue() {
        return this.sentinel.next.getValue();
    }

    public Map.Entry getLast() {
        if (this.isEmpty()) {
            return null;
        }
        return this.sentinel.prev;
    }

    public Object getLastKey() {
        return this.sentinel.prev.getKey();
    }

    public Object getLastValue() {
        return this.sentinel.prev.getValue();
    }

    public Object put(Object key, Object value) {
        ++this.modCount;
        Object object = null;
        Entry entry = (Entry)this.entries.get(key);
        if (entry != null) {
            this.removeEntry(entry);
            object = entry.setValue(value);
        } else {
            entry = new Entry(key, value);
            this.entries.put(key, entry);
        }
        this.insertEntry(entry);
        return object;
    }

    public Object remove(Object key) {
        Entry entry = this.removeImpl(key);
        if (entry == null) {
            return null;
        }
        return entry.getValue();
    }

    private Entry removeImpl(Object key) {
        Entry entry = (Entry)this.entries.remove(key);
        if (entry == null) {
            return null;
        }
        ++this.modCount;
        this.removeEntry(entry);
        return entry;
    }

    public void putAll(Map t2) {
        Iterator iterator = t2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void clear() {
        ++this.modCount;
        this.entries.clear();
        this.sentinel.next = this.sentinel;
        this.sentinel.prev = this.sentinel;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Map)) {
            return false;
        }
        return this.entrySet().equals(((Map)obj).entrySet());
    }

    public int hashCode() {
        return this.entrySet().hashCode();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        Entry entry = this.sentinel.next;
        while (entry != this.sentinel) {
            stringBuffer.append(entry.getKey());
            stringBuffer.append('=');
            stringBuffer.append(entry.getValue());
            if (entry.next != this.sentinel) {
                stringBuffer.append(',');
            }
            entry = entry.next;
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public Set keySet() {
        return new AbstractSet(this){
            private final SequencedHashMap this$0;
            {
                this.this$0 = sequencedHashMap;
            }

            public Iterator iterator() {
                return new OrderedIterator(this.this$0, 0);
            }

            public boolean remove(Object o2) {
                Entry entry = SequencedHashMap.access$000(this.this$0, o2);
                return entry != null;
            }

            public void clear() {
                this.this$0.clear();
            }

            public int size() {
                return this.this$0.size();
            }

            public boolean isEmpty() {
                return this.this$0.isEmpty();
            }

            public boolean contains(Object o2) {
                return this.this$0.containsKey(o2);
            }
        };
    }

    public Collection values() {
        return new AbstractCollection(this){
            private final SequencedHashMap this$0;
            {
                this.this$0 = sequencedHashMap;
            }

            public Iterator iterator() {
                return new OrderedIterator(this.this$0, 1);
            }

            public boolean remove(Object value) {
                if (value == null) {
                    Entry entry = SequencedHashMap.access$100((SequencedHashMap)this.this$0).next;
                    while (entry != SequencedHashMap.access$100(this.this$0)) {
                        if (entry.getValue() == null) {
                            SequencedHashMap.access$000(this.this$0, entry.getKey());
                            return true;
                        }
                        entry = entry.next;
                    }
                } else {
                    Entry entry = SequencedHashMap.access$100((SequencedHashMap)this.this$0).next;
                    while (entry != SequencedHashMap.access$100(this.this$0)) {
                        if (value.equals(entry.getValue())) {
                            SequencedHashMap.access$000(this.this$0, entry.getKey());
                            return true;
                        }
                        entry = entry.next;
                    }
                }
                return false;
            }

            public void clear() {
                this.this$0.clear();
            }

            public int size() {
                return this.this$0.size();
            }

            public boolean isEmpty() {
                return this.this$0.isEmpty();
            }

            public boolean contains(Object o2) {
                return this.this$0.containsValue(o2);
            }
        };
    }

    public Set entrySet() {
        return new AbstractSet(this){
            private final SequencedHashMap this$0;
            {
                this.this$0 = sequencedHashMap;
            }

            private Entry findEntry(Object o2) {
                if (o2 == null) {
                    return null;
                }
                if (!(o2 instanceof Map.Entry)) {
                    return null;
                }
                Map.Entry entry = (Map.Entry)o2;
                Entry entry2 = (Entry)SequencedHashMap.access$200(this.this$0).get(entry.getKey());
                if (entry2 != null && entry2.equals(entry)) {
                    return entry2;
                }
                return null;
            }

            public Iterator iterator() {
                return new OrderedIterator(this.this$0, 2);
            }

            public boolean remove(Object o2) {
                Entry entry = this.findEntry(o2);
                if (entry == null) {
                    return false;
                }
                return SequencedHashMap.access$000(this.this$0, entry.getKey()) != null;
            }

            public void clear() {
                this.this$0.clear();
            }

            public int size() {
                return this.this$0.size();
            }

            public boolean isEmpty() {
                return this.this$0.isEmpty();
            }

            public boolean contains(Object o2) {
                return this.findEntry(o2) != null;
            }
        };
    }

    public Object clone() throws CloneNotSupportedException {
        SequencedHashMap sequencedHashMap = (SequencedHashMap)super.clone();
        ((SequencedHashMap)super.clone()).sentinel = SequencedHashMap.createSentinel();
        sequencedHashMap.entries = new HashMap();
        sequencedHashMap.putAll((Map)this);
        return sequencedHashMap;
    }

    private Map.Entry getEntry(int index) {
        int n2;
        Entry entry = this.sentinel;
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException(index + " < 0");
        }
        for (n2 = -1; n2 < index - 1 && entry.next != this.sentinel; ++n2) {
            entry = entry.next;
        }
        if (entry.next == this.sentinel) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + (n2 + 1));
        }
        return entry.next;
    }

    public Object get(int index) {
        return this.getEntry(index).getKey();
    }

    public Object getValue(int index) {
        return this.getEntry(index).getValue();
    }

    public int indexOf(Object key) {
        Entry entry = (Entry)this.entries.get(key);
        if (entry == null) {
            return -1;
        }
        int n2 = 0;
        while (entry.prev != this.sentinel) {
            ++n2;
            entry = entry.prev;
        }
        return n2;
    }

    public Iterator iterator() {
        return this.keySet().iterator();
    }

    public int lastIndexOf(Object key) {
        return this.indexOf(key);
    }

    public List sequence() {
        ArrayList arrayList = new ArrayList(this.size());
        Iterator iterator = this.keySet().iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return UnmodifiableList.decorate(arrayList);
    }

    public Object remove(int index) {
        SequencedHashMap sequencedHashMap = this;
        return sequencedHashMap.remove(sequencedHashMap.get(index));
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int n2 = in.readInt();
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object = in.readObject();
            Object object2 = in.readObject();
            this.put(object, object2);
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        Entry entry = this.sentinel.next;
        while (entry != this.sentinel) {
            out.writeObject(entry.getKey());
            out.writeObject(entry.getValue());
            entry = entry.next;
        }
    }

    static Entry access$000(SequencedHashMap x0, Object x1) {
        return x0.removeImpl(x1);
    }

    static Entry access$100(SequencedHashMap x0) {
        return x0.sentinel;
    }

    static HashMap access$200(SequencedHashMap x0) {
        return x0.entries;
    }

    static long access$300(SequencedHashMap x0) {
        return x0.modCount;
    }

    private class OrderedIterator
    implements Iterator {
        private int returnType;
        private Entry pos;
        private transient long expectedModCount;
        private final SequencedHashMap this$0;

        public OrderedIterator(SequencedHashMap sequencedHashMap, int returnType) {
            this.this$0 = sequencedHashMap;
            this.pos = SequencedHashMap.access$100(this.this$0);
            this.expectedModCount = SequencedHashMap.access$300(this.this$0);
            this.returnType = returnType | Integer.MIN_VALUE;
        }

        public boolean hasNext() {
            return this.pos.next != SequencedHashMap.access$100(this.this$0);
        }

        public Object next() {
            if (SequencedHashMap.access$300(this.this$0) != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.pos.next == SequencedHashMap.access$100(this.this$0)) {
                throw new NoSuchElementException();
            }
            this.returnType &= Integer.MAX_VALUE;
            this.pos = this.pos.next;
            switch (this.returnType) {
                case 0: {
                    return this.pos.getKey();
                }
                case 1: {
                    return this.pos.getValue();
                }
                case 2: {
                    return this.pos;
                }
            }
            throw new Error("bad iterator type: " + this.returnType);
        }

        public void remove() {
            if ((this.returnType & Integer.MIN_VALUE) != 0) {
                throw new IllegalStateException("remove() must follow next()");
            }
            if (SequencedHashMap.access$300(this.this$0) != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            SequencedHashMap.access$000(this.this$0, this.pos.getKey());
            ++this.expectedModCount;
            this.returnType |= Integer.MIN_VALUE;
        }
    }

    private static class Entry
    implements Map.Entry,
    KeyValue {
        private final Object key;
        private Object value;
        Entry next = null;
        Entry prev = null;

        public Entry(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            Object object = this.value;
            this.value = value;
            return object;
        }

        public int hashCode() {
            return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)obj;
            return (this.getKey() == null ? entry.getKey() == null : this.getKey().equals(entry.getKey())) && (this.getValue() == null ? entry.getValue() == null : this.getValue().equals(entry.getValue()));
        }

        public String toString() {
            return "[" + this.getKey() + "=" + this.getValue() + "]";
        }
    }
}

