/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.collection;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.collections.iterators.EmptyIterator;
import org.apache.commons.collections.iterators.IteratorChain;
import org.apache.commons.collections.list.UnmodifiableList;

public class CompositeCollection
implements Collection {
    protected CollectionMutator mutator;
    protected Collection[] all = new Collection[0];

    public CompositeCollection() {
    }

    public CompositeCollection(Collection coll) {
        this();
        this.addComposited(coll);
    }

    public CompositeCollection(Collection[] colls) {
        this();
        this.addComposited(colls);
    }

    public int size() {
        int n2 = 0;
        for (int i2 = this.all.length - 1; i2 >= 0; --i2) {
            n2 += this.all[i2].size();
        }
        return n2;
    }

    public boolean isEmpty() {
        for (int i2 = this.all.length - 1; i2 >= 0; --i2) {
            if (this.all[i2].isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean contains(Object obj) {
        for (int i2 = this.all.length - 1; i2 >= 0; --i2) {
            if (!this.all[i2].contains(obj)) continue;
            return true;
        }
        return false;
    }

    public Iterator iterator() {
        if (this.all.length == 0) {
            return EmptyIterator.INSTANCE;
        }
        IteratorChain iteratorChain = new IteratorChain();
        for (int i2 = 0; i2 < this.all.length; ++i2) {
            iteratorChain.addIterator(this.all[i2].iterator());
        }
        return iteratorChain;
    }

    public Object[] toArray() {
        Object[] objectArray = new Object[this.size()];
        int n2 = 0;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            objectArray[n2] = iterator.next();
            ++n2;
        }
        return objectArray;
    }

    public Object[] toArray(Object[] array) {
        int n2 = this.size();
        Object[] objectArray = array.length >= n2 ? array : (Object[])Array.newInstance(array.getClass().getComponentType(), n2);
        int n3 = 0;
        for (int i2 = 0; i2 < this.all.length; ++i2) {
            Iterator iterator = this.all[i2].iterator();
            while (iterator.hasNext()) {
                objectArray[n3++] = iterator.next();
            }
        }
        if (objectArray.length > n2) {
            objectArray[n2] = null;
        }
        return objectArray;
    }

    public boolean add(Object obj) {
        if (this.mutator == null) {
            throw new UnsupportedOperationException("add() is not supported on CompositeCollection without a CollectionMutator strategy");
        }
        CompositeCollection compositeCollection = this;
        return this.mutator.add(compositeCollection, compositeCollection.all, obj);
    }

    public boolean remove(Object obj) {
        if (this.mutator == null) {
            throw new UnsupportedOperationException("remove() is not supported on CompositeCollection without a CollectionMutator strategy");
        }
        CompositeCollection compositeCollection = this;
        return this.mutator.remove(compositeCollection, compositeCollection.all, obj);
    }

    public boolean containsAll(Collection coll) {
        Iterator iterator = coll.iterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public boolean addAll(Collection coll) {
        if (this.mutator == null) {
            throw new UnsupportedOperationException("addAll() is not supported on CompositeCollection without a CollectionMutator strategy");
        }
        CompositeCollection compositeCollection = this;
        return this.mutator.addAll(compositeCollection, compositeCollection.all, coll);
    }

    public boolean removeAll(Collection coll) {
        if (coll.size() == 0) {
            return false;
        }
        boolean bl = false;
        for (int i2 = this.all.length - 1; i2 >= 0; --i2) {
            bl = this.all[i2].removeAll(coll) || bl;
        }
        return bl;
    }

    public boolean retainAll(Collection coll) {
        boolean bl = false;
        for (int i2 = this.all.length - 1; i2 >= 0; --i2) {
            bl = this.all[i2].retainAll(coll) || bl;
        }
        return bl;
    }

    public void clear() {
        for (int i2 = 0; i2 < this.all.length; ++i2) {
            this.all[i2].clear();
        }
    }

    public void setMutator(CollectionMutator mutator) {
        this.mutator = mutator;
    }

    public void addComposited(Collection[] comps) {
        ArrayList<Collection> arrayList = new ArrayList<Collection>(Arrays.asList(this.all));
        arrayList.addAll(Arrays.asList(comps));
        ArrayList<Collection> arrayList2 = arrayList;
        this.all = arrayList2.toArray(new Collection[arrayList2.size()]);
    }

    public void addComposited(Collection c2) {
        this.addComposited(new Collection[]{c2});
    }

    public void addComposited(Collection c2, Collection d2) {
        this.addComposited(new Collection[]{c2, d2});
    }

    public void removeComposited(Collection coll) {
        ArrayList<Collection> arrayList = new ArrayList<Collection>(this.all.length);
        arrayList.addAll(Arrays.asList(this.all));
        arrayList.remove(coll);
        ArrayList<Collection> arrayList2 = arrayList;
        this.all = arrayList2.toArray(new Collection[arrayList2.size()]);
    }

    public Collection toCollection() {
        return new ArrayList(this);
    }

    public Collection getCollections() {
        return UnmodifiableList.decorate(Arrays.asList(this.all));
    }

    public static interface CollectionMutator {
        public boolean add(CompositeCollection var1, Collection[] var2, Object var3);

        public boolean addAll(CompositeCollection var1, Collection[] var2, Collection var3);

        public boolean remove(CompositeCollection var1, Collection[] var2, Object var3);
    }
}

