/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.functors;

import java.io.Serializable;
import org.apache.commons.collections.FunctorException;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;

public final class TransformerPredicate
implements Serializable,
Predicate {
    private static final long serialVersionUID = -2407966402920578741L;
    private final Transformer iTransformer;

    public static Predicate getInstance(Transformer transformer) {
        if (transformer == null) {
            throw new IllegalArgumentException("The transformer to call must not be null");
        }
        return new TransformerPredicate(transformer);
    }

    public TransformerPredicate(Transformer transformer) {
        this.iTransformer = transformer;
    }

    public final boolean evaluate(Object object) {
        Object object2 = this.iTransformer.transform(object);
        if (!(object2 instanceof Boolean)) {
            throw new FunctorException("Transformer must return an instanceof Boolean, it was a " + (object2 == null ? "null object" : object2.getClass().getName()));
        }
        return (Boolean)object2;
    }

    public final Transformer getTransformer() {
        return this.iTransformer;
    }
}

