/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.map;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.apache.commons.collections.Unmodifiable;
import org.apache.commons.collections.collection.UnmodifiableCollection;
import org.apache.commons.collections.map.AbstractSortedMapDecorator;
import org.apache.commons.collections.map.UnmodifiableEntrySet;
import org.apache.commons.collections.set.UnmodifiableSet;

public final class UnmodifiableSortedMap
extends AbstractSortedMapDecorator
implements Serializable,
Unmodifiable {
    private static final long serialVersionUID = 5805344239827376360L;

    public static SortedMap decorate(SortedMap map) {
        if (map instanceof Unmodifiable) {
            return map;
        }
        return new UnmodifiableSortedMap(map);
    }

    private UnmodifiableSortedMap(SortedMap map) {
        super(map);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.map);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.map = (Map)in.readObject();
    }

    public final void clear() {
        throw new UnsupportedOperationException();
    }

    public final Object put(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    public final void putAll(Map mapToCopy) {
        throw new UnsupportedOperationException();
    }

    public final Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    public final Set entrySet() {
        Set set = super.entrySet();
        return UnmodifiableEntrySet.decorate(set);
    }

    public final Set keySet() {
        Set set = super.keySet();
        return UnmodifiableSet.decorate(set);
    }

    public final Collection values() {
        Collection collection = super.values();
        return UnmodifiableCollection.decorate(collection);
    }

    public final Object firstKey() {
        return this.getSortedMap().firstKey();
    }

    public final Object lastKey() {
        return this.getSortedMap().lastKey();
    }

    public final Comparator comparator() {
        return this.getSortedMap().comparator();
    }

    public final SortedMap subMap(Object fromKey, Object toKey) {
        SortedMap sortedMap = this.getSortedMap().subMap(fromKey, toKey);
        return new UnmodifiableSortedMap(sortedMap);
    }

    public final SortedMap headMap(Object toKey) {
        SortedMap sortedMap = this.getSortedMap().headMap(toKey);
        return new UnmodifiableSortedMap(sortedMap);
    }

    public final SortedMap tailMap(Object fromKey) {
        SortedMap sortedMap = this.getSortedMap().tailMap(fromKey);
        return new UnmodifiableSortedMap(sortedMap);
    }
}

